/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperRead;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.selectable.SrvcContrBillgReqItmPrcElmntSelectable;

/**
 * Fluent helper to fetch multiple
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.SrvcContrBillgReqItmPrcElmnt
 * SrvcContrBillgReqItmPrcElmnt} entities. This fluent helper allows methods which modify the underlying query to be
 * called before executing the query itself.
 *
 */
public class SrvcContrBillgReqItmPrcElmntFluentHelper
    extends
    FluentHelperRead<SrvcContrBillgReqItmPrcElmntFluentHelper, SrvcContrBillgReqItmPrcElmnt, SrvcContrBillgReqItmPrcElmntSelectable>
{

    /**
     * Creates a fluent helper using the specified service path and entity collection to send the read requests.
     *
     * @param entityCollection
     *            The entity collection to direct the requests to.
     * @param servicePath
     *            The service path to direct the read requests to.
     */
    public SrvcContrBillgReqItmPrcElmntFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection )
    {
        super(servicePath, entityCollection);
    }

    @Override
    @Nonnull
    protected Class<SrvcContrBillgReqItmPrcElmnt> getEntityClass()
    {
        return SrvcContrBillgReqItmPrcElmnt.class;
    }

}
