/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.field.SrvcContrItemProductField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.link.SrvcContrItemProductOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.selectable.SrvcContrItemProductSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Item Product List
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_SrvcContrItemProductType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SrvcContrItemProduct extends VdmEntity<SrvcContrItemProduct>
{

    /**
     * Selector for all available fields of SrvcContrItemProduct.
     *
     */
    public final static SrvcContrItemProductSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServiceContract</b>
     * </p>
     *
     * @return Transaction ID
     */
    @Key
    @SerializedName( "ServiceContract" )
    @JsonProperty( "ServiceContract" )
    @Nullable
    @ODataField( odataName = "ServiceContract" )
    private String serviceContract;
    /**
     * Use with available fluent helpers to apply the <b>ServiceContract</b> field to query operations.
     *
     */
    public final static SrvcContrItemProductField<String> SERVICE_CONTRACT =
        new SrvcContrItemProductField<String>("ServiceContract");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ServiceContractItem</b>
     * </p>
     *
     * @return Shortened Item Number in Document
     */
    @Key
    @SerializedName( "ServiceContractItem" )
    @JsonProperty( "ServiceContractItem" )
    @Nullable
    @ODataField( odataName = "ServiceContractItem" )
    private String serviceContractItem;
    /**
     * Use with available fluent helpers to apply the <b>ServiceContractItem</b> field to query operations.
     *
     */
    public final static SrvcContrItemProductField<String> SERVICE_CONTRACT_ITEM =
        new SrvcContrItemProductField<String>("ServiceContractItem");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ServiceProductListItem</b>
     * </p>
     *
     * @return Counter for CRMS4D_ORDPRP_I product list
     */
    @Key
    @SerializedName( "ServiceProductListItem" )
    @JsonProperty( "ServiceProductListItem" )
    @Nullable
    @ODataField( odataName = "ServiceProductListItem" )
    private String serviceProductListItem;
    /**
     * Use with available fluent helpers to apply the <b>ServiceProductListItem</b> field to query operations.
     *
     */
    public final static SrvcContrItemProductField<String> SERVICE_PRODUCT_LIST_ITEM =
        new SrvcContrItemProductField<String>("ServiceProductListItem");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>SrvcProductListProduct</b>
     * </p>
     *
     * @return Material Number
     */
    @SerializedName( "SrvcProductListProduct" )
    @JsonProperty( "SrvcProductListProduct" )
    @Nullable
    @ODataField( odataName = "SrvcProductListProduct" )
    private String srvcProductListProduct;
    /**
     * Use with available fluent helpers to apply the <b>SrvcProductListProduct</b> field to query operations.
     *
     */
    public final static SrvcContrItemProductField<String> SRVC_PRODUCT_LIST_PRODUCT =
        new SrvcContrItemProductField<String>("SrvcProductListProduct");
    /**
     * Navigation property <b>to_ServiceContractItem</b> for <b>SrvcContrItemProduct</b> to single
     * <b>ServiceContractItem</b>.
     *
     */
    @SerializedName( "to_ServiceContractItem" )
    @JsonProperty( "to_ServiceContractItem" )
    @ODataField( odataName = "to_ServiceContractItem" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private ServiceContractItem toServiceContractItem;
    /**
     * Use with available fluent helpers to apply the <b>to_ServiceContractItem</b> navigation property to query
     * operations.
     *
     */
    public final static SrvcContrItemProductOneToOneLink<ServiceContractItem> TO_SERVICE_CONTRACT_ITEM =
        new SrvcContrItemProductOneToOneLink<ServiceContractItem>("to_ServiceContractItem");

    @Nonnull
    @Override
    public Class<SrvcContrItemProduct> getType()
    {
        return SrvcContrItemProduct.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServiceContract</b>
     * </p>
     *
     * @param serviceContract
     *            Transaction ID
     */
    public void setServiceContract( @Nullable final String serviceContract )
    {
        rememberChangedField("ServiceContract", this.serviceContract);
        this.serviceContract = serviceContract;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ServiceContractItem</b>
     * </p>
     *
     * @param serviceContractItem
     *            Shortened Item Number in Document
     */
    public void setServiceContractItem( @Nullable final String serviceContractItem )
    {
        rememberChangedField("ServiceContractItem", this.serviceContractItem);
        this.serviceContractItem = serviceContractItem;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ServiceProductListItem</b>
     * </p>
     *
     * @param serviceProductListItem
     *            Counter for CRMS4D_ORDPRP_I product list
     */
    public void setServiceProductListItem( @Nullable final String serviceProductListItem )
    {
        rememberChangedField("ServiceProductListItem", this.serviceProductListItem);
        this.serviceProductListItem = serviceProductListItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>SrvcProductListProduct</b>
     * </p>
     *
     * @param srvcProductListProduct
     *            Material Number
     */
    public void setSrvcProductListProduct( @Nullable final String srvcProductListProduct )
    {
        rememberChangedField("SrvcProductListProduct", this.srvcProductListProduct);
        this.srvcProductListProduct = srvcProductListProduct;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_SrvcContrItemProduct";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ServiceContract", getServiceContract());
        result.put("ServiceContractItem", getServiceContractItem());
        result.put("ServiceProductListItem", getServiceProductListItem());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ServiceContract", getServiceContract());
        values.put("ServiceContractItem", getServiceContractItem());
        values.put("ServiceProductListItem", getServiceProductListItem());
        values.put("SrvcProductListProduct", getSrvcProductListProduct());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ServiceContract") ) {
                final Object value = values.remove("ServiceContract");
                if( (value == null) || (!value.equals(getServiceContract())) ) {
                    setServiceContract(((String) value));
                }
            }
            if( values.containsKey("ServiceContractItem") ) {
                final Object value = values.remove("ServiceContractItem");
                if( (value == null) || (!value.equals(getServiceContractItem())) ) {
                    setServiceContractItem(((String) value));
                }
            }
            if( values.containsKey("ServiceProductListItem") ) {
                final Object value = values.remove("ServiceProductListItem");
                if( (value == null) || (!value.equals(getServiceProductListItem())) ) {
                    setServiceProductListItem(((String) value));
                }
            }
            if( values.containsKey("SrvcProductListProduct") ) {
                final Object value = values.remove("SrvcProductListProduct");
                if( (value == null) || (!value.equals(getSrvcProductListProduct())) ) {
                    setSrvcProductListProduct(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_ServiceContractItem") ) {
                final Object value = (values).remove("to_ServiceContractItem");
                if( value instanceof Map ) {
                    if( toServiceContractItem == null ) {
                        toServiceContractItem = new ServiceContractItem();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toServiceContractItem.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> SrvcContrItemProductField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SrvcContrItemProductField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SrvcContrItemProductField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SrvcContrItemProductField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ServiceContractService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toServiceContractItem != null ) {
            (values).put("to_ServiceContractItem", toServiceContractItem);
        }
        return values;
    }

    /**
     * Fetches the <b>ServiceContractItem</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_ServiceContractItem</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>ServiceContractItem</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ServiceContractItem fetchServiceContractItem()
    {
        return fetchFieldAsSingle("to_ServiceContractItem", ServiceContractItem.class);
    }

    /**
     * Retrieval of associated <b>ServiceContractItem</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_ServiceContractItem</b>.
     * <p>
     * If the navigation property <b>to_ServiceContractItem</b> of a queried <b>SrvcContrItemProduct</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ServiceContractItem</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ServiceContractItem getServiceContractItemOrFetch()
    {
        if( toServiceContractItem == null ) {
            toServiceContractItem = fetchServiceContractItem();
        }
        return toServiceContractItem;
    }

    /**
     * Retrieval of associated <b>ServiceContractItem</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_ServiceContractItem</b>.
     * <p>
     * If the navigation property for an entity <b>SrvcContrItemProduct</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ServiceContractItem</b> is already loaded, the result
     *         will contain the <b>ServiceContractItem</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<ServiceContractItem> getServiceContractItemIfPresent()
    {
        return Option.of(toServiceContractItem);
    }

    /**
     * Overwrites the associated <b>ServiceContractItem</b> entity for the loaded navigation property
     * <b>to_ServiceContractItem</b>.
     *
     * @param value
     *            New <b>ServiceContractItem</b> entity.
     */
    public void setServiceContractItem( final ServiceContractItem value )
    {
        toServiceContractItem = value;
    }

    /**
     * Helper class to allow for fluent creation of SrvcContrItemProduct instances.
     *
     */
    public final static class SrvcContrItemProductBuilder
    {

        private ServiceContractItem toServiceContractItem;
        private String serviceContractItem = null;

        private SrvcContrItemProduct.SrvcContrItemProductBuilder toServiceContractItem(
            final ServiceContractItem value )
        {
            toServiceContractItem = value;
            return this;
        }

        /**
         * Navigation property <b>to_ServiceContractItem</b> for <b>SrvcContrItemProduct</b> to single
         * <b>ServiceContractItem</b>.
         *
         * @param value
         *            The ServiceContractItem to build this SrvcContrItemProduct with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SrvcContrItemProduct.SrvcContrItemProductBuilder serviceContractItem( final ServiceContractItem value )
        {
            return toServiceContractItem(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 6
         * <p>
         * Original property name from the Odata EDM: <b>ServiceContractItem</b>
         * </p>
         *
         * @param value
         *            The serviceContractItem to build this SrvcContrItemProduct with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SrvcContrItemProduct.SrvcContrItemProductBuilder serviceContractItem( final String value )
        {
            serviceContractItem = value;
            return this;
        }

    }

}
