/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.field.SrvcContrItmBillgReqItemField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.link.SrvcContrItmBillgReqItemLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.link.SrvcContrItmBillgReqItemOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.selectable.SrvcContrItmBillgReqItemSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Billing Request Line
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_SrvcContrItmBillgReqItemType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SrvcContrItmBillgReqItem extends VdmEntity<SrvcContrItmBillgReqItem>
{

    /**
     * Selector for all available fields of SrvcContrItmBillgReqItem.
     *
     */
    public final static SrvcContrItmBillgReqItemSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServiceContract</b>
     * </p>
     *
     * @return Transaction ID
     */
    @Key
    @SerializedName( "ServiceContract" )
    @JsonProperty( "ServiceContract" )
    @Nullable
    @ODataField( odataName = "ServiceContract" )
    private String serviceContract;
    /**
     * Use with available fluent helpers to apply the <b>ServiceContract</b> field to query operations.
     *
     */
    public final static SrvcContrItmBillgReqItemField<String> SERVICE_CONTRACT =
        new SrvcContrItmBillgReqItemField<String>("ServiceContract");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ServiceContractItem</b>
     * </p>
     *
     * @return Shortened Item Number in Document
     */
    @Key
    @SerializedName( "ServiceContractItem" )
    @JsonProperty( "ServiceContractItem" )
    @Nullable
    @ODataField( odataName = "ServiceContractItem" )
    private String serviceContractItem;
    /**
     * Use with available fluent helpers to apply the <b>ServiceContractItem</b> field to query operations.
     *
     */
    public final static SrvcContrItmBillgReqItemField<String> SERVICE_CONTRACT_ITEM =
        new SrvcContrItmBillgReqItemField<String>("ServiceContractItem");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>BillingRequestItem</b>
     * </p>
     *
     * @return Billing Request Item No
     */
    @Key
    @SerializedName( "BillingRequestItem" )
    @JsonProperty( "BillingRequestItem" )
    @Nullable
    @ODataField( odataName = "BillingRequestItem" )
    private String billingRequestItem;
    /**
     * Use with available fluent helpers to apply the <b>BillingRequestItem</b> field to query operations.
     *
     */
    public final static SrvcContrItmBillgReqItemField<String> BILLING_REQUEST_ITEM =
        new SrvcContrItmBillgReqItemField<String>("BillingRequestItem");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BillgReqItemDescription</b>
     * </p>
     *
     * @return Description
     */
    @SerializedName( "BillgReqItemDescription" )
    @JsonProperty( "BillgReqItemDescription" )
    @Nullable
    @ODataField( odataName = "BillgReqItemDescription" )
    private String billgReqItemDescription;
    /**
     * Use with available fluent helpers to apply the <b>BillgReqItemDescription</b> field to query operations.
     *
     */
    public final static SrvcContrItmBillgReqItemField<String> BILLG_REQ_ITEM_DESCRIPTION =
        new SrvcContrItmBillgReqItemField<String>("BillgReqItemDescription");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BillgReqItemBillingDateTime</b>
     * </p>
     *
     * @return Billing Date for Billing Index and Printout
     */
    @SerializedName( "BillgReqItemBillingDateTime" )
    @JsonProperty( "BillgReqItemBillingDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "BillgReqItemBillingDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime billgReqItemBillingDateTime;
    /**
     * Use with available fluent helpers to apply the <b>BillgReqItemBillingDateTime</b> field to query operations.
     *
     */
    public final static SrvcContrItmBillgReqItemField<ZonedDateTime> BILLG_REQ_ITEM_BILLING_DATE_TIME =
        new SrvcContrItmBillgReqItemField<ZonedDateTime>("BillgReqItemBillingDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BillgReqItemBillingStatus</b>
     * </p>
     *
     * @return Settlement Status of Billing Request Line
     */
    @SerializedName( "BillgReqItemBillingStatus" )
    @JsonProperty( "BillgReqItemBillingStatus" )
    @Nullable
    @ODataField( odataName = "BillgReqItemBillingStatus" )
    private String billgReqItemBillingStatus;
    /**
     * Use with available fluent helpers to apply the <b>BillgReqItemBillingStatus</b> field to query operations.
     *
     */
    public final static SrvcContrItmBillgReqItemField<String> BILLG_REQ_ITEM_BILLING_STATUS =
        new SrvcContrItmBillgReqItemField<String>("BillgReqItemBillingStatus");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>SettlementStartDateTime</b>
     * </p>
     *
     * @return Start of Settlement for Period
     */
    @SerializedName( "SettlementStartDateTime" )
    @JsonProperty( "SettlementStartDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "SettlementStartDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime settlementStartDateTime;
    /**
     * Use with available fluent helpers to apply the <b>SettlementStartDateTime</b> field to query operations.
     *
     */
    public final static SrvcContrItmBillgReqItemField<ZonedDateTime> SETTLEMENT_START_DATE_TIME =
        new SrvcContrItmBillgReqItemField<ZonedDateTime>("SettlementStartDateTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>SettlementEndDateTime</b>
     * </p>
     *
     * @return End of Settlement for Period
     */
    @SerializedName( "SettlementEndDateTime" )
    @JsonProperty( "SettlementEndDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "SettlementEndDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime settlementEndDateTime;
    /**
     * Use with available fluent helpers to apply the <b>SettlementEndDateTime</b> field to query operations.
     *
     */
    public final static SrvcContrItmBillgReqItemField<ZonedDateTime> SETTLEMENT_END_DATE_TIME =
        new SrvcContrItmBillgReqItemField<ZonedDateTime>("SettlementEndDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>BillingPlanTimeZone</b>
     * </p>
     *
     * @return Time Zone of Billing Plan Set
     */
    @SerializedName( "BillingPlanTimeZone" )
    @JsonProperty( "BillingPlanTimeZone" )
    @Nullable
    @ODataField( odataName = "BillingPlanTimeZone" )
    private String billingPlanTimeZone;
    /**
     * Use with available fluent helpers to apply the <b>BillingPlanTimeZone</b> field to query operations.
     *
     */
    public final static SrvcContrItmBillgReqItemField<String> BILLING_PLAN_TIME_ZONE =
        new SrvcContrItmBillgReqItemField<String>("BillingPlanTimeZone");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrency</b>
     * </p>
     *
     * @return Currency
     */
    @SerializedName( "TransactionCurrency" )
    @JsonProperty( "TransactionCurrency" )
    @Nullable
    @ODataField( odataName = "TransactionCurrency" )
    private String transactionCurrency;
    /**
     * Use with available fluent helpers to apply the <b>TransactionCurrency</b> field to query operations.
     *
     */
    public final static SrvcContrItmBillgReqItemField<String> TRANSACTION_CURRENCY =
        new SrvcContrItmBillgReqItemField<String>("TransactionCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BillingBlockReason</b>
     * </p>
     *
     * @return Business Partner: Billing Block Reason
     */
    @SerializedName( "BillingBlockReason" )
    @JsonProperty( "BillingBlockReason" )
    @Nullable
    @ODataField( odataName = "BillingBlockReason" )
    private String billingBlockReason;
    /**
     * Use with available fluent helpers to apply the <b>BillingBlockReason</b> field to query operations.
     *
     */
    public final static SrvcContrItmBillgReqItemField<String> BILLING_BLOCK_REASON =
        new SrvcContrItmBillgReqItemField<String>("BillingBlockReason");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ServicesRenderedDateTime</b>
     * </p>
     *
     * @return Services Rendered Date as Timestamp
     */
    @SerializedName( "ServicesRenderedDateTime" )
    @JsonProperty( "ServicesRenderedDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "ServicesRenderedDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime servicesRenderedDateTime;
    /**
     * Use with available fluent helpers to apply the <b>ServicesRenderedDateTime</b> field to query operations.
     *
     */
    public final static SrvcContrItmBillgReqItemField<ZonedDateTime> SERVICES_RENDERED_DATE_TIME =
        new SrvcContrItmBillgReqItemField<ZonedDateTime>("ServicesRenderedDateTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BillgReqItemPricingDate</b>
     * </p>
     *
     * @return Pricing Date
     */
    @SerializedName( "BillgReqItemPricingDate" )
    @JsonProperty( "BillgReqItemPricingDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "BillgReqItemPricingDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime billgReqItemPricingDate;
    /**
     * Use with available fluent helpers to apply the <b>BillgReqItemPricingDate</b> field to query operations.
     *
     */
    public final static SrvcContrItmBillgReqItemField<LocalDateTime> BILLG_REQ_ITEM_PRICING_DATE =
        new SrvcContrItmBillgReqItemField<LocalDateTime>("BillgReqItemPricingDate");
    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BillgReqItemNetAmount</b>
     * </p>
     *
     * @return Net Value
     */
    @SerializedName( "BillgReqItemNetAmount" )
    @JsonProperty( "BillgReqItemNetAmount" )
    @Nullable
    @ODataField( odataName = "BillgReqItemNetAmount" )
    private BigDecimal billgReqItemNetAmount;
    /**
     * Use with available fluent helpers to apply the <b>BillgReqItemNetAmount</b> field to query operations.
     *
     */
    public final static SrvcContrItmBillgReqItemField<BigDecimal> BILLG_REQ_ITEM_NET_AMOUNT =
        new SrvcContrItmBillgReqItemField<BigDecimal>("BillgReqItemNetAmount");
    /**
     * Navigation property <b>to_PricingElement</b> for <b>SrvcContrItmBillgReqItem</b> to multiple
     * <b>SrvcContrBillgReqItmPrcElmnt</b>.
     *
     */
    @SerializedName( "to_PricingElement" )
    @JsonProperty( "to_PricingElement" )
    @ODataField( odataName = "to_PricingElement" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SrvcContrBillgReqItmPrcElmnt> toPricingElement;
    /**
     * Navigation property <b>to_ServiceContractItem</b> for <b>SrvcContrItmBillgReqItem</b> to single
     * <b>ServiceContractItem</b>.
     *
     */
    @SerializedName( "to_ServiceContractItem" )
    @JsonProperty( "to_ServiceContractItem" )
    @ODataField( odataName = "to_ServiceContractItem" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private ServiceContractItem toServiceContractItem;
    /**
     * Use with available fluent helpers to apply the <b>to_PricingElement</b> navigation property to query operations.
     *
     */
    public final static SrvcContrItmBillgReqItemLink<SrvcContrBillgReqItmPrcElmnt> TO_PRICING_ELEMENT =
        new SrvcContrItmBillgReqItemLink<SrvcContrBillgReqItmPrcElmnt>("to_PricingElement");
    /**
     * Use with available fluent helpers to apply the <b>to_ServiceContractItem</b> navigation property to query
     * operations.
     *
     */
    public final static SrvcContrItmBillgReqItemOneToOneLink<ServiceContractItem> TO_SERVICE_CONTRACT_ITEM =
        new SrvcContrItmBillgReqItemOneToOneLink<ServiceContractItem>("to_ServiceContractItem");

    @Nonnull
    @Override
    public Class<SrvcContrItmBillgReqItem> getType()
    {
        return SrvcContrItmBillgReqItem.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServiceContract</b>
     * </p>
     *
     * @param serviceContract
     *            Transaction ID
     */
    public void setServiceContract( @Nullable final String serviceContract )
    {
        rememberChangedField("ServiceContract", this.serviceContract);
        this.serviceContract = serviceContract;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ServiceContractItem</b>
     * </p>
     *
     * @param serviceContractItem
     *            Shortened Item Number in Document
     */
    public void setServiceContractItem( @Nullable final String serviceContractItem )
    {
        rememberChangedField("ServiceContractItem", this.serviceContractItem);
        this.serviceContractItem = serviceContractItem;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>BillingRequestItem</b>
     * </p>
     *
     * @param billingRequestItem
     *            Billing Request Item No
     */
    public void setBillingRequestItem( @Nullable final String billingRequestItem )
    {
        rememberChangedField("BillingRequestItem", this.billingRequestItem);
        this.billingRequestItem = billingRequestItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BillgReqItemDescription</b>
     * </p>
     *
     * @param billgReqItemDescription
     *            Description
     */
    public void setBillgReqItemDescription( @Nullable final String billgReqItemDescription )
    {
        rememberChangedField("BillgReqItemDescription", this.billgReqItemDescription);
        this.billgReqItemDescription = billgReqItemDescription;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BillgReqItemBillingDateTime</b>
     * </p>
     *
     * @param billgReqItemBillingDateTime
     *            Billing Date for Billing Index and Printout
     */
    public void setBillgReqItemBillingDateTime( @Nullable final ZonedDateTime billgReqItemBillingDateTime )
    {
        rememberChangedField("BillgReqItemBillingDateTime", this.billgReqItemBillingDateTime);
        this.billgReqItemBillingDateTime = billgReqItemBillingDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BillgReqItemBillingStatus</b>
     * </p>
     *
     * @param billgReqItemBillingStatus
     *            Settlement Status of Billing Request Line
     */
    public void setBillgReqItemBillingStatus( @Nullable final String billgReqItemBillingStatus )
    {
        rememberChangedField("BillgReqItemBillingStatus", this.billgReqItemBillingStatus);
        this.billgReqItemBillingStatus = billgReqItemBillingStatus;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>SettlementStartDateTime</b>
     * </p>
     *
     * @param settlementStartDateTime
     *            Start of Settlement for Period
     */
    public void setSettlementStartDateTime( @Nullable final ZonedDateTime settlementStartDateTime )
    {
        rememberChangedField("SettlementStartDateTime", this.settlementStartDateTime);
        this.settlementStartDateTime = settlementStartDateTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>SettlementEndDateTime</b>
     * </p>
     *
     * @param settlementEndDateTime
     *            End of Settlement for Period
     */
    public void setSettlementEndDateTime( @Nullable final ZonedDateTime settlementEndDateTime )
    {
        rememberChangedField("SettlementEndDateTime", this.settlementEndDateTime);
        this.settlementEndDateTime = settlementEndDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>BillingPlanTimeZone</b>
     * </p>
     *
     * @param billingPlanTimeZone
     *            Time Zone of Billing Plan Set
     */
    public void setBillingPlanTimeZone( @Nullable final String billingPlanTimeZone )
    {
        rememberChangedField("BillingPlanTimeZone", this.billingPlanTimeZone);
        this.billingPlanTimeZone = billingPlanTimeZone;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrency</b>
     * </p>
     *
     * @param transactionCurrency
     *            Currency
     */
    public void setTransactionCurrency( @Nullable final String transactionCurrency )
    {
        rememberChangedField("TransactionCurrency", this.transactionCurrency);
        this.transactionCurrency = transactionCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BillingBlockReason</b>
     * </p>
     *
     * @param billingBlockReason
     *            Business Partner: Billing Block Reason
     */
    public void setBillingBlockReason( @Nullable final String billingBlockReason )
    {
        rememberChangedField("BillingBlockReason", this.billingBlockReason);
        this.billingBlockReason = billingBlockReason;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ServicesRenderedDateTime</b>
     * </p>
     *
     * @param servicesRenderedDateTime
     *            Services Rendered Date as Timestamp
     */
    public void setServicesRenderedDateTime( @Nullable final ZonedDateTime servicesRenderedDateTime )
    {
        rememberChangedField("ServicesRenderedDateTime", this.servicesRenderedDateTime);
        this.servicesRenderedDateTime = servicesRenderedDateTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BillgReqItemPricingDate</b>
     * </p>
     *
     * @param billgReqItemPricingDate
     *            Pricing Date
     */
    public void setBillgReqItemPricingDate( @Nullable final LocalDateTime billgReqItemPricingDate )
    {
        rememberChangedField("BillgReqItemPricingDate", this.billgReqItemPricingDate);
        this.billgReqItemPricingDate = billgReqItemPricingDate;
    }

    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BillgReqItemNetAmount</b>
     * </p>
     *
     * @param billgReqItemNetAmount
     *            Net Value
     */
    public void setBillgReqItemNetAmount( @Nullable final BigDecimal billgReqItemNetAmount )
    {
        rememberChangedField("BillgReqItemNetAmount", this.billgReqItemNetAmount);
        this.billgReqItemNetAmount = billgReqItemNetAmount;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_SrvcContrItmBillgReqItem";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ServiceContract", getServiceContract());
        result.put("ServiceContractItem", getServiceContractItem());
        result.put("BillingRequestItem", getBillingRequestItem());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ServiceContract", getServiceContract());
        values.put("ServiceContractItem", getServiceContractItem());
        values.put("BillingRequestItem", getBillingRequestItem());
        values.put("BillgReqItemDescription", getBillgReqItemDescription());
        values.put("BillgReqItemBillingDateTime", getBillgReqItemBillingDateTime());
        values.put("BillgReqItemBillingStatus", getBillgReqItemBillingStatus());
        values.put("SettlementStartDateTime", getSettlementStartDateTime());
        values.put("SettlementEndDateTime", getSettlementEndDateTime());
        values.put("BillingPlanTimeZone", getBillingPlanTimeZone());
        values.put("TransactionCurrency", getTransactionCurrency());
        values.put("BillingBlockReason", getBillingBlockReason());
        values.put("ServicesRenderedDateTime", getServicesRenderedDateTime());
        values.put("BillgReqItemPricingDate", getBillgReqItemPricingDate());
        values.put("BillgReqItemNetAmount", getBillgReqItemNetAmount());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ServiceContract") ) {
                final Object value = values.remove("ServiceContract");
                if( (value == null) || (!value.equals(getServiceContract())) ) {
                    setServiceContract(((String) value));
                }
            }
            if( values.containsKey("ServiceContractItem") ) {
                final Object value = values.remove("ServiceContractItem");
                if( (value == null) || (!value.equals(getServiceContractItem())) ) {
                    setServiceContractItem(((String) value));
                }
            }
            if( values.containsKey("BillingRequestItem") ) {
                final Object value = values.remove("BillingRequestItem");
                if( (value == null) || (!value.equals(getBillingRequestItem())) ) {
                    setBillingRequestItem(((String) value));
                }
            }
            if( values.containsKey("BillgReqItemDescription") ) {
                final Object value = values.remove("BillgReqItemDescription");
                if( (value == null) || (!value.equals(getBillgReqItemDescription())) ) {
                    setBillgReqItemDescription(((String) value));
                }
            }
            if( values.containsKey("BillgReqItemBillingDateTime") ) {
                final Object value = values.remove("BillgReqItemBillingDateTime");
                if( (value == null) || (!value.equals(getBillgReqItemBillingDateTime())) ) {
                    setBillgReqItemBillingDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("BillgReqItemBillingStatus") ) {
                final Object value = values.remove("BillgReqItemBillingStatus");
                if( (value == null) || (!value.equals(getBillgReqItemBillingStatus())) ) {
                    setBillgReqItemBillingStatus(((String) value));
                }
            }
            if( values.containsKey("SettlementStartDateTime") ) {
                final Object value = values.remove("SettlementStartDateTime");
                if( (value == null) || (!value.equals(getSettlementStartDateTime())) ) {
                    setSettlementStartDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("SettlementEndDateTime") ) {
                final Object value = values.remove("SettlementEndDateTime");
                if( (value == null) || (!value.equals(getSettlementEndDateTime())) ) {
                    setSettlementEndDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("BillingPlanTimeZone") ) {
                final Object value = values.remove("BillingPlanTimeZone");
                if( (value == null) || (!value.equals(getBillingPlanTimeZone())) ) {
                    setBillingPlanTimeZone(((String) value));
                }
            }
            if( values.containsKey("TransactionCurrency") ) {
                final Object value = values.remove("TransactionCurrency");
                if( (value == null) || (!value.equals(getTransactionCurrency())) ) {
                    setTransactionCurrency(((String) value));
                }
            }
            if( values.containsKey("BillingBlockReason") ) {
                final Object value = values.remove("BillingBlockReason");
                if( (value == null) || (!value.equals(getBillingBlockReason())) ) {
                    setBillingBlockReason(((String) value));
                }
            }
            if( values.containsKey("ServicesRenderedDateTime") ) {
                final Object value = values.remove("ServicesRenderedDateTime");
                if( (value == null) || (!value.equals(getServicesRenderedDateTime())) ) {
                    setServicesRenderedDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("BillgReqItemPricingDate") ) {
                final Object value = values.remove("BillgReqItemPricingDate");
                if( (value == null) || (!value.equals(getBillgReqItemPricingDate())) ) {
                    setBillgReqItemPricingDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("BillgReqItemNetAmount") ) {
                final Object value = values.remove("BillgReqItemNetAmount");
                if( (value == null) || (!value.equals(getBillgReqItemNetAmount())) ) {
                    setBillgReqItemNetAmount(((BigDecimal) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_PricingElement") ) {
                final Object value = (values).remove("to_PricingElement");
                if( value instanceof Iterable ) {
                    if( toPricingElement == null ) {
                        toPricingElement = Lists.newArrayList();
                    } else {
                        toPricingElement = Lists.newArrayList(toPricingElement);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SrvcContrBillgReqItmPrcElmnt entity;
                        if( toPricingElement.size() > i ) {
                            entity = toPricingElement.get(i);
                        } else {
                            entity = new SrvcContrBillgReqItmPrcElmnt();
                            toPricingElement.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_ServiceContractItem") ) {
                final Object value = (values).remove("to_ServiceContractItem");
                if( value instanceof Map ) {
                    if( toServiceContractItem == null ) {
                        toServiceContractItem = new ServiceContractItem();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toServiceContractItem.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> SrvcContrItmBillgReqItemField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SrvcContrItmBillgReqItemField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SrvcContrItmBillgReqItemField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SrvcContrItmBillgReqItemField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ServiceContractService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toPricingElement != null ) {
            (values).put("to_PricingElement", toPricingElement);
        }
        if( toServiceContractItem != null ) {
            (values).put("to_ServiceContractItem", toServiceContractItem);
        }
        return values;
    }

    /**
     * Fetches the <b>SrvcContrBillgReqItmPrcElmnt</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_PricingElement</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SrvcContrBillgReqItmPrcElmnt</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SrvcContrBillgReqItmPrcElmnt> fetchPricingElement()
    {
        return fetchFieldAsList("to_PricingElement", SrvcContrBillgReqItmPrcElmnt.class);
    }

    /**
     * Retrieval of associated <b>SrvcContrBillgReqItmPrcElmnt</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_PricingElement</b>.
     * <p>
     * If the navigation property <b>to_PricingElement</b> of a queried <b>SrvcContrItmBillgReqItem</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SrvcContrBillgReqItmPrcElmnt</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SrvcContrBillgReqItmPrcElmnt> getPricingElementOrFetch()
    {
        if( toPricingElement == null ) {
            toPricingElement = fetchPricingElement();
        }
        return toPricingElement;
    }

    /**
     * Retrieval of associated <b>SrvcContrBillgReqItmPrcElmnt</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_PricingElement</b>.
     * <p>
     * If the navigation property for an entity <b>SrvcContrItmBillgReqItem</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_PricingElement</b> is already loaded, the result will
     *         contain the <b>SrvcContrBillgReqItmPrcElmnt</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SrvcContrBillgReqItmPrcElmnt>> getPricingElementIfPresent()
    {
        return Option.of(toPricingElement);
    }

    /**
     * Overwrites the list of associated <b>SrvcContrBillgReqItmPrcElmnt</b> entities for the loaded navigation property
     * <b>to_PricingElement</b>.
     * <p>
     * If the navigation property <b>to_PricingElement</b> of a queried <b>SrvcContrItmBillgReqItem</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SrvcContrBillgReqItmPrcElmnt</b> entities.
     */
    public void setPricingElement( @Nonnull final List<SrvcContrBillgReqItmPrcElmnt> value )
    {
        if( toPricingElement == null ) {
            toPricingElement = Lists.newArrayList();
        }
        toPricingElement.clear();
        toPricingElement.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SrvcContrBillgReqItmPrcElmnt</b> entities. This corresponds to the
     * OData navigation property <b>to_PricingElement</b>.
     * <p>
     * If the navigation property <b>to_PricingElement</b> of a queried <b>SrvcContrItmBillgReqItem</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SrvcContrBillgReqItmPrcElmnt</b> entities.
     */
    public void addPricingElement( SrvcContrBillgReqItmPrcElmnt... entity )
    {
        if( toPricingElement == null ) {
            toPricingElement = Lists.newArrayList();
        }
        toPricingElement.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>ServiceContractItem</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_ServiceContractItem</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>ServiceContractItem</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ServiceContractItem fetchServiceContractItem()
    {
        return fetchFieldAsSingle("to_ServiceContractItem", ServiceContractItem.class);
    }

    /**
     * Retrieval of associated <b>ServiceContractItem</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_ServiceContractItem</b>.
     * <p>
     * If the navigation property <b>to_ServiceContractItem</b> of a queried <b>SrvcContrItmBillgReqItem</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ServiceContractItem</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ServiceContractItem getServiceContractItemOrFetch()
    {
        if( toServiceContractItem == null ) {
            toServiceContractItem = fetchServiceContractItem();
        }
        return toServiceContractItem;
    }

    /**
     * Retrieval of associated <b>ServiceContractItem</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_ServiceContractItem</b>.
     * <p>
     * If the navigation property for an entity <b>SrvcContrItmBillgReqItem</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ServiceContractItem</b> is already loaded, the result
     *         will contain the <b>ServiceContractItem</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<ServiceContractItem> getServiceContractItemIfPresent()
    {
        return Option.of(toServiceContractItem);
    }

    /**
     * Overwrites the associated <b>ServiceContractItem</b> entity for the loaded navigation property
     * <b>to_ServiceContractItem</b>.
     *
     * @param value
     *            New <b>ServiceContractItem</b> entity.
     */
    public void setServiceContractItem( final ServiceContractItem value )
    {
        toServiceContractItem = value;
    }

    /**
     * Helper class to allow for fluent creation of SrvcContrItmBillgReqItem instances.
     *
     */
    public final static class SrvcContrItmBillgReqItemBuilder
    {

        private List<SrvcContrBillgReqItmPrcElmnt> toPricingElement = Lists.newArrayList();
        private ServiceContractItem toServiceContractItem;
        private String serviceContractItem = null;

        private SrvcContrItmBillgReqItem.SrvcContrItmBillgReqItemBuilder toPricingElement(
            final List<SrvcContrBillgReqItmPrcElmnt> value )
        {
            toPricingElement.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_PricingElement</b> for <b>SrvcContrItmBillgReqItem</b> to multiple
         * <b>SrvcContrBillgReqItmPrcElmnt</b>.
         *
         * @param value
         *            The SrvcContrBillgReqItmPrcElmnts to build this SrvcContrItmBillgReqItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SrvcContrItmBillgReqItem.SrvcContrItmBillgReqItemBuilder pricingElement(
            SrvcContrBillgReqItmPrcElmnt... value )
        {
            return toPricingElement(Lists.newArrayList(value));
        }

        private SrvcContrItmBillgReqItem.SrvcContrItmBillgReqItemBuilder toServiceContractItem(
            final ServiceContractItem value )
        {
            toServiceContractItem = value;
            return this;
        }

        /**
         * Navigation property <b>to_ServiceContractItem</b> for <b>SrvcContrItmBillgReqItem</b> to single
         * <b>ServiceContractItem</b>.
         *
         * @param value
         *            The ServiceContractItem to build this SrvcContrItmBillgReqItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SrvcContrItmBillgReqItem.SrvcContrItmBillgReqItemBuilder serviceContractItem(
            final ServiceContractItem value )
        {
            return toServiceContractItem(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 6
         * <p>
         * Original property name from the Odata EDM: <b>ServiceContractItem</b>
         * </p>
         *
         * @param value
         *            The serviceContractItem to build this SrvcContrItmBillgReqItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SrvcContrItmBillgReqItem.SrvcContrItmBillgReqItemBuilder serviceContractItem( final String value )
        {
            serviceContractItem = value;
            return this;
        }

    }

}
