/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link ServiceContractServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.ServiceContractService ServiceContractService}, allowing you
 * to create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultServiceContractServiceBatch
    extends
    BatchFluentHelperBasic<ServiceContractServiceBatch, ServiceContractServiceBatchChangeSet>
    implements
    ServiceContractServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ServiceContractService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultServiceContractServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultServiceContractServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ServiceContractService service )
    {
        this(service, com.sap.cloud.sdk.s4hana.datamodel.odata.services.ServiceContractService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultServiceContractServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultServiceContractServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ServiceContractService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultServiceContractServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public ServiceContractServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultServiceContractServiceBatchChangeSet(this, service);
    }

}
