/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.ServiceContrItemPriceElement;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.ServiceContrItemPriceElement
 * ServiceContrItemPriceElement}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.field.ServiceContrItemPriceElementField
 * ServiceContrItemPriceElementField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.link.ServiceContrItemPriceElementLink
 * ServiceContrItemPriceElementLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.ServiceContrItemPriceElement#SERVICE_CONTRACT
 * SERVICE_CONTRACT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.ServiceContrItemPriceElement#SERVICE_CONTRACT_ITEM
 * SERVICE_CONTRACT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.ServiceContrItemPriceElement#PRICING_PROCEDURE_STEP
 * PRICING_PROCEDURE_STEP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.ServiceContrItemPriceElement#PRICING_PROCEDURE_COUNTER
 * PRICING_PROCEDURE_COUNTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.ServiceContrItemPriceElement#CONDITION_TYPE
 * CONDITION_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.ServiceContrItemPriceElement#CONDITION_RATE_VALUE
 * CONDITION_RATE_VALUE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.ServiceContrItemPriceElement#CONDITION_CURRENCY
 * CONDITION_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.ServiceContrItemPriceElement#CONDITION_QUANTITY
 * CONDITION_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.ServiceContrItemPriceElement#CONDITION_QUANTITY_UNIT
 * CONDITION_QUANTITY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.ServiceContrItemPriceElement#CONDITION_INACTIVE_REASON
 * CONDITION_INACTIVE_REASON}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.ServiceContrItemPriceElement#TO_SERVICE_CONTRACT_ITEM
 * TO_SERVICE_CONTRACT_ITEM}</li>
 * </ul>
 *
 */
public interface ServiceContrItemPriceElementSelectable extends EntitySelectable<ServiceContrItemPriceElement>
{

}
