/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.ServiceContractItemText;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.ServiceContractItemText
 * ServiceContractItemText}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.field.ServiceContractItemTextField
 * ServiceContractItemTextField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.link.ServiceContractItemTextLink
 * ServiceContractItemTextLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.ServiceContractItemText#SERVICE_CONTRACT
 * SERVICE_CONTRACT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.ServiceContractItemText#SERVICE_CONTRACT_ITEM
 * SERVICE_CONTRACT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.ServiceContractItemText#LANGUAGE
 * LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.ServiceContractItemText#LONG_TEXT_ID
 * LONG_TEXT_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.ServiceContractItemText#LONG_TEXT
 * LONG_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.ServiceContractItemText#TO_SERVICE_CONTRACT_ITEM
 * TO_SERVICE_CONTRACT_ITEM}</li>
 * </ul>
 *
 */
public interface ServiceContractItemTextSelectable extends EntitySelectable<ServiceContractItemText>
{

}
