/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.ServiceContractText;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.ServiceContractText ServiceContractText}.
 * This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.field.ServiceContractTextField
 * ServiceContractTextField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.link.ServiceContractTextLink
 * ServiceContractTextLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.ServiceContractText#SERVICE_CONTRACT
 * SERVICE_CONTRACT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.ServiceContractText#LANGUAGE
 * LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.ServiceContractText#LONG_TEXT_ID
 * LONG_TEXT_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.ServiceContractText#LONG_TEXT
 * LONG_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.ServiceContractText#TO_SERVICE_CONTRACT
 * TO_SERVICE_CONTRACT}</li>
 * </ul>
 *
 */
public interface ServiceContractTextSelectable extends EntitySelectable<ServiceContractText>
{

}
