/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.SrvcContrBillgReqItmPrcElmnt;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.SrvcContrBillgReqItmPrcElmnt
 * SrvcContrBillgReqItmPrcElmnt}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.field.SrvcContrBillgReqItmPrcElmntField
 * SrvcContrBillgReqItmPrcElmntField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.link.SrvcContrBillgReqItmPrcElmntLink
 * SrvcContrBillgReqItmPrcElmntLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.SrvcContrBillgReqItmPrcElmnt#SERVICE_CONTRACT
 * SERVICE_CONTRACT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.SrvcContrBillgReqItmPrcElmnt#BILLING_REQUEST_ITEM
 * BILLING_REQUEST_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.SrvcContrBillgReqItmPrcElmnt#PRICING_PROCEDURE_STEP
 * PRICING_PROCEDURE_STEP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.SrvcContrBillgReqItmPrcElmnt#PRICING_PROCEDURE_COUNTER
 * PRICING_PROCEDURE_COUNTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.SrvcContrBillgReqItmPrcElmnt#CONDITION_TYPE
 * CONDITION_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.SrvcContrBillgReqItmPrcElmnt#CONDITION_RATE_VALUE
 * CONDITION_RATE_VALUE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.SrvcContrBillgReqItmPrcElmnt#CONDITION_CURRENCY
 * CONDITION_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.SrvcContrBillgReqItmPrcElmnt#CONDITION_QUANTITY
 * CONDITION_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.SrvcContrBillgReqItmPrcElmnt#CONDITION_QUANTITY_UNIT
 * CONDITION_QUANTITY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.SrvcContrBillgReqItmPrcElmnt#CONDITION_INACTIVE_REASON
 * CONDITION_INACTIVE_REASON}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.SrvcContrBillgReqItmPrcElmnt#TO_BILLING_REQUEST_ITEM
 * TO_BILLING_REQUEST_ITEM}</li>
 * </ul>
 *
 */
public interface SrvcContrBillgReqItmPrcElmntSelectable extends EntitySelectable<SrvcContrBillgReqItmPrcElmnt>
{

}
