/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.SrvcContrItemProduct;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.SrvcContrItemProduct
 * SrvcContrItemProduct}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.field.SrvcContrItemProductField
 * SrvcContrItemProductField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.link.SrvcContrItemProductLink
 * SrvcContrItemProductLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.SrvcContrItemProduct#SERVICE_CONTRACT
 * SERVICE_CONTRACT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.SrvcContrItemProduct#SERVICE_CONTRACT_ITEM
 * SERVICE_CONTRACT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.SrvcContrItemProduct#SERVICE_PRODUCT_LIST_ITEM
 * SERVICE_PRODUCT_LIST_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.SrvcContrItemProduct#SRVC_PRODUCT_LIST_PRODUCT
 * SRVC_PRODUCT_LIST_PRODUCT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.SrvcContrItemProduct#TO_SERVICE_CONTRACT_ITEM
 * TO_SERVICE_CONTRACT_ITEM}</li>
 * </ul>
 *
 */
public interface SrvcContrItemProductSelectable extends EntitySelectable<SrvcContrItemProduct>
{

}
