/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.SrvcContrItmBillgReqItem;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.SrvcContrItmBillgReqItem
 * SrvcContrItmBillgReqItem}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.field.SrvcContrItmBillgReqItemField
 * SrvcContrItmBillgReqItemField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.link.SrvcContrItmBillgReqItemLink
 * SrvcContrItmBillgReqItemLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.SrvcContrItmBillgReqItem#SERVICE_CONTRACT
 * SERVICE_CONTRACT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.SrvcContrItmBillgReqItem#SERVICE_CONTRACT_ITEM
 * SERVICE_CONTRACT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.SrvcContrItmBillgReqItem#BILLING_REQUEST_ITEM
 * BILLING_REQUEST_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.SrvcContrItmBillgReqItem#BILLG_REQ_ITEM_DESCRIPTION
 * BILLG_REQ_ITEM_DESCRIPTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.SrvcContrItmBillgReqItem#BILLG_REQ_ITEM_BILLING_DATE_TIME
 * BILLG_REQ_ITEM_BILLING_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.SrvcContrItmBillgReqItem#BILLG_REQ_ITEM_BILLING_STATUS
 * BILLG_REQ_ITEM_BILLING_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.SrvcContrItmBillgReqItem#SETTLEMENT_START_DATE_TIME
 * SETTLEMENT_START_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.SrvcContrItmBillgReqItem#SETTLEMENT_END_DATE_TIME
 * SETTLEMENT_END_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.SrvcContrItmBillgReqItem#BILLING_PLAN_TIME_ZONE
 * BILLING_PLAN_TIME_ZONE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.SrvcContrItmBillgReqItem#TRANSACTION_CURRENCY
 * TRANSACTION_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.SrvcContrItmBillgReqItem#BILLING_BLOCK_REASON
 * BILLING_BLOCK_REASON}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.SrvcContrItmBillgReqItem#SERVICES_RENDERED_DATE_TIME
 * SERVICES_RENDERED_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.SrvcContrItmBillgReqItem#BILLG_REQ_ITEM_PRICING_DATE
 * BILLG_REQ_ITEM_PRICING_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.SrvcContrItmBillgReqItem#BILLG_REQ_ITEM_NET_AMOUNT
 * BILLG_REQ_ITEM_NET_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.SrvcContrItmBillgReqItem#TO_PRICING_ELEMENT
 * TO_PRICING_ELEMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.SrvcContrItmBillgReqItem#TO_SERVICE_CONTRACT_ITEM
 * TO_SERVICE_CONTRACT_ITEM}</li>
 * </ul>
 *
 */
public interface SrvcContrItmBillgReqItemSelectable extends EntitySelectable<SrvcContrItmBillgReqItem>
{

}
