/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet;

import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.field.ServiceEntrySheetField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.link.ServiceEntrySheetLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.selectable.ServiceEntrySheetSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Service Entry Sheet
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_ServiceEntrySheetType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ServiceEntrySheet extends VdmEntity<ServiceEntrySheet>
{

    /**
     * Selector for all available fields of ServiceEntrySheet.
     *
     */
    public final static ServiceEntrySheetSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServiceEntrySheet</b>
     * </p>
     *
     * @return Service Entry Sheet
     */
    @Key
    @SerializedName( "ServiceEntrySheet" )
    @JsonProperty( "ServiceEntrySheet" )
    @Nullable
    @ODataField( odataName = "ServiceEntrySheet" )
    private String serviceEntrySheet;
    /**
     * Use with available fluent helpers to apply the <b>ServiceEntrySheet</b> field to query operations.
     *
     */
    public final static ServiceEntrySheetField<String> SERVICE_ENTRY_SHEET =
        new ServiceEntrySheetField<String>("ServiceEntrySheet");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>ApprovalDateTime</b>
     * </p>
     *
     * @return Date and Time of SES Approval (UTC)
     */
    @SerializedName( "ApprovalDateTime" )
    @JsonProperty( "ApprovalDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "ApprovalDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime approvalDateTime;
    /**
     * Use with available fluent helpers to apply the <b>ApprovalDateTime</b> field to query operations.
     *
     */
    public final static ServiceEntrySheetField<ZonedDateTime> APPROVAL_DATE_TIME =
        new ServiceEntrySheetField<ZonedDateTime>("ApprovalDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ApprovalStatus</b>
     * </p>
     *
     * @return Document Status for Service Entry Sheet
     */
    @SerializedName( "ApprovalStatus" )
    @JsonProperty( "ApprovalStatus" )
    @Nullable
    @ODataField( odataName = "ApprovalStatus" )
    private String approvalStatus;
    /**
     * Use with available fluent helpers to apply the <b>ApprovalStatus</b> field to query operations.
     *
     */
    public final static ServiceEntrySheetField<String> APPROVAL_STATUS =
        new ServiceEntrySheetField<String>("ApprovalStatus");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SESWorkflowStatus</b>
     * </p>
     *
     * @return Approval Status for Service Entry Sheet
     */
    @SerializedName( "SESWorkflowStatus" )
    @JsonProperty( "SESWorkflowStatus" )
    @Nullable
    @ODataField( odataName = "SESWorkflowStatus" )
    private String sESWorkflowStatus;
    /**
     * Use with available fluent helpers to apply the <b>SESWorkflowStatus</b> field to query operations.
     *
     */
    public final static ServiceEntrySheetField<String> SES_WORKFLOW_STATUS =
        new ServiceEntrySheetField<String>("SESWorkflowStatus");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @return User Name
     */
    @SerializedName( "CreatedByUser" )
    @JsonProperty( "CreatedByUser" )
    @Nullable
    @ODataField( odataName = "CreatedByUser" )
    private String createdByUser;
    /**
     * Use with available fluent helpers to apply the <b>CreatedByUser</b> field to query operations.
     *
     */
    public final static ServiceEntrySheetField<String> CREATED_BY_USER =
        new ServiceEntrySheetField<String>("CreatedByUser");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>CreationDateTime</b>
     * </p>
     *
     * @return UTC Time Stamp in Long Form (YYYYMMDDhhmmssmmmuuun)
     */
    @SerializedName( "CreationDateTime" )
    @JsonProperty( "CreationDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "CreationDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime creationDateTime;
    /**
     * Use with available fluent helpers to apply the <b>CreationDateTime</b> field to query operations.
     *
     */
    public final static ServiceEntrySheetField<ZonedDateTime> CREATION_DATE_TIME =
        new ServiceEntrySheetField<ZonedDateTime>("CreationDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingOrganization</b>
     * </p>
     *
     * @return Purchasing Organization
     */
    @SerializedName( "PurchasingOrganization" )
    @JsonProperty( "PurchasingOrganization" )
    @Nullable
    @ODataField( odataName = "PurchasingOrganization" )
    private String purchasingOrganization;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingOrganization</b> field to query operations.
     *
     */
    public final static ServiceEntrySheetField<String> PURCHASING_ORGANIZATION =
        new ServiceEntrySheetField<String>("PurchasingOrganization");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingGroup</b>
     * </p>
     *
     * @return Purchasing Group
     */
    @SerializedName( "PurchasingGroup" )
    @JsonProperty( "PurchasingGroup" )
    @Nullable
    @ODataField( odataName = "PurchasingGroup" )
    private String purchasingGroup;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingGroup</b> field to query operations.
     *
     */
    public final static ServiceEntrySheetField<String> PURCHASING_GROUP =
        new ServiceEntrySheetField<String>("PurchasingGroup");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsEndOfPurposeBlocked</b>
     * </p>
     *
     * @return Business Purpose Completed
     */
    @SerializedName( "IsEndOfPurposeBlocked" )
    @JsonProperty( "IsEndOfPurposeBlocked" )
    @Nullable
    @ODataField( odataName = "IsEndOfPurposeBlocked" )
    private String isEndOfPurposeBlocked;
    /**
     * Use with available fluent helpers to apply the <b>IsEndOfPurposeBlocked</b> field to query operations.
     *
     */
    public final static ServiceEntrySheetField<String> IS_END_OF_PURPOSE_BLOCKED =
        new ServiceEntrySheetField<String>("IsEndOfPurposeBlocked");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>Currency</b>
     * </p>
     *
     * @return Currency Key
     */
    @SerializedName( "Currency" )
    @JsonProperty( "Currency" )
    @Nullable
    @ODataField( odataName = "Currency" )
    private String currency;
    /**
     * Use with available fluent helpers to apply the <b>Currency</b> field to query operations.
     *
     */
    public final static ServiceEntrySheetField<String> CURRENCY = new ServiceEntrySheetField<String>("Currency");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsDeleted</b>
     * </p>
     *
     * @return Deletion Indicator in Purchasing Document
     */
    @SerializedName( "IsDeleted" )
    @JsonProperty( "IsDeleted" )
    @Nullable
    @ODataField( odataName = "IsDeleted" )
    private String isDeleted;
    /**
     * Use with available fluent helpers to apply the <b>IsDeleted</b> field to query operations.
     *
     */
    public final static ServiceEntrySheetField<String> IS_DELETED = new ServiceEntrySheetField<String>("IsDeleted");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @return UTC Time Stamp in Long Form (YYYYMMDDhhmmssmmmuuun)
     */
    @SerializedName( "LastChangeDateTime" )
    @JsonProperty( "LastChangeDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime lastChangeDateTime;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDateTime</b> field to query operations.
     *
     */
    public final static ServiceEntrySheetField<ZonedDateTime> LAST_CHANGE_DATE_TIME =
        new ServiceEntrySheetField<ZonedDateTime>("LastChangeDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @return User Name
     */
    @SerializedName( "LastChangedByUser" )
    @JsonProperty( "LastChangedByUser" )
    @Nullable
    @ODataField( odataName = "LastChangedByUser" )
    private String lastChangedByUser;
    /**
     * Use with available fluent helpers to apply the <b>LastChangedByUser</b> field to query operations.
     *
     */
    public final static ServiceEntrySheetField<String> LAST_CHANGED_BY_USER =
        new ServiceEntrySheetField<String>("LastChangedByUser");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>MaterialDocument</b>
     * </p>
     *
     * @return Number of Material Document
     */
    @SerializedName( "MaterialDocument" )
    @JsonProperty( "MaterialDocument" )
    @Nullable
    @ODataField( odataName = "MaterialDocument" )
    private String materialDocument;
    /**
     * Use with available fluent helpers to apply the <b>MaterialDocument</b> field to query operations.
     *
     */
    public final static ServiceEntrySheetField<String> MATERIAL_DOCUMENT =
        new ServiceEntrySheetField<String>("MaterialDocument");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaterialDocumentYear</b>
     * </p>
     *
     * @return Material Document Year
     */
    @SerializedName( "MaterialDocumentYear" )
    @JsonProperty( "MaterialDocumentYear" )
    @Nullable
    @ODataField( odataName = "MaterialDocumentYear" )
    private String materialDocumentYear;
    /**
     * Use with available fluent helpers to apply the <b>MaterialDocumentYear</b> field to query operations.
     *
     */
    public final static ServiceEntrySheetField<String> MATERIAL_DOCUMENT_YEAR =
        new ServiceEntrySheetField<String>("MaterialDocumentYear");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>OriginObjectType</b>
     * </p>
     *
     * @return Origin of Service Entry Sheet
     */
    @SerializedName( "OriginObjectType" )
    @JsonProperty( "OriginObjectType" )
    @Nullable
    @ODataField( odataName = "OriginObjectType" )
    private String originObjectType;
    /**
     * Use with available fluent helpers to apply the <b>OriginObjectType</b> field to query operations.
     *
     */
    public final static ServiceEntrySheetField<String> ORIGIN_OBJECT_TYPE =
        new ServiceEntrySheetField<String>("OriginObjectType");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrder</b>
     * </p>
     *
     * @return Reference Purchase Order
     */
    @SerializedName( "PurchaseOrder" )
    @JsonProperty( "PurchaseOrder" )
    @Nullable
    @ODataField( odataName = "PurchaseOrder" )
    private String purchaseOrder;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseOrder</b> field to query operations.
     *
     */
    public final static ServiceEntrySheetField<String> PURCHASE_ORDER =
        new ServiceEntrySheetField<String>("PurchaseOrder");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>ResponsiblePerson</b>
     * </p>
     *
     * @return Personnel Number
     */
    @SerializedName( "ResponsiblePerson" )
    @JsonProperty( "ResponsiblePerson" )
    @Nullable
    @ODataField( odataName = "ResponsiblePerson" )
    private String responsiblePerson;
    /**
     * Use with available fluent helpers to apply the <b>ResponsiblePerson</b> field to query operations.
     *
     */
    public final static ServiceEntrySheetField<String> RESPONSIBLE_PERSON =
        new ServiceEntrySheetField<String>("ResponsiblePerson");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ServiceEntrySheetName</b>
     * </p>
     *
     * @return Name of Service Entry Sheet
     */
    @SerializedName( "ServiceEntrySheetName" )
    @JsonProperty( "ServiceEntrySheetName" )
    @Nullable
    @ODataField( odataName = "ServiceEntrySheetName" )
    private String serviceEntrySheetName;
    /**
     * Use with available fluent helpers to apply the <b>ServiceEntrySheetName</b> field to query operations.
     *
     */
    public final static ServiceEntrySheetField<String> SERVICE_ENTRY_SHEET_NAME =
        new ServiceEntrySheetField<String>("ServiceEntrySheetName");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ServiceEntrySheetUUID</b>
     * </p>
     *
     * @return UUID serving as key (parent key, root key)
     */
    @SerializedName( "ServiceEntrySheetUUID" )
    @JsonProperty( "ServiceEntrySheetUUID" )
    @Nullable
    @ODataField( odataName = "ServiceEntrySheetUUID" )
    private UUID serviceEntrySheetUUID;
    /**
     * Use with available fluent helpers to apply the <b>ServiceEntrySheetUUID</b> field to query operations.
     *
     */
    public final static ServiceEntrySheetField<UUID> SERVICE_ENTRY_SHEET_UUID =
        new ServiceEntrySheetField<UUID>("ServiceEntrySheetUUID");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Supplier</b>
     * </p>
     *
     * @return Account Number of Supplier
     */
    @SerializedName( "Supplier" )
    @JsonProperty( "Supplier" )
    @Nullable
    @ODataField( odataName = "Supplier" )
    private String supplier;
    /**
     * Use with available fluent helpers to apply the <b>Supplier</b> field to query operations.
     *
     */
    public final static ServiceEntrySheetField<String> SUPPLIER = new ServiceEntrySheetField<String>("Supplier");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>PurgDocExternalSystem</b>
     * </p>
     *
     * @return ID of External Reference System
     */
    @SerializedName( "PurgDocExternalSystem" )
    @JsonProperty( "PurgDocExternalSystem" )
    @Nullable
    @ODataField( odataName = "PurgDocExternalSystem" )
    private String purgDocExternalSystem;
    /**
     * Use with available fluent helpers to apply the <b>PurgDocExternalSystem</b> field to query operations.
     *
     */
    public final static ServiceEntrySheetField<String> PURG_DOC_EXTERNAL_SYSTEM =
        new ServiceEntrySheetField<String>("PurgDocExternalSystem");
    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>PurgDocExternalReference</b>
     * </p>
     *
     * @return External Reference ID
     */
    @SerializedName( "PurgDocExternalReference" )
    @JsonProperty( "PurgDocExternalReference" )
    @Nullable
    @ODataField( odataName = "PurgDocExternalReference" )
    private String purgDocExternalReference;
    /**
     * Use with available fluent helpers to apply the <b>PurgDocExternalReference</b> field to query operations.
     *
     */
    public final static ServiceEntrySheetField<String> PURG_DOC_EXTERNAL_REFERENCE =
        new ServiceEntrySheetField<String>("PurgDocExternalReference");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>ExternalRevisionDateTime</b>
     * </p>
     *
     * @return Timestamp for Revision of External Calls
     */
    @SerializedName( "ExternalRevisionDateTime" )
    @JsonProperty( "ExternalRevisionDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "ExternalRevisionDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime externalRevisionDateTime;
    /**
     * Use with available fluent helpers to apply the <b>ExternalRevisionDateTime</b> field to query operations.
     *
     */
    public final static ServiceEntrySheetField<ZonedDateTime> EXTERNAL_REVISION_DATE_TIME =
        new ServiceEntrySheetField<ZonedDateTime>("ExternalRevisionDateTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PostingDate</b>
     * </p>
     *
     * @return GR Posting Date
     */
    @SerializedName( "PostingDate" )
    @JsonProperty( "PostingDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "PostingDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime postingDate;
    /**
     * Use with available fluent helpers to apply the <b>PostingDate</b> field to query operations.
     *
     */
    public final static ServiceEntrySheetField<LocalDateTime> POSTING_DATE =
        new ServiceEntrySheetField<LocalDateTime>("PostingDate");
    /**
     * Navigation property <b>to_ServiceEntrySheetItem</b> for <b>ServiceEntrySheet</b> to multiple
     * <b>ServiceEntrySheetItem</b>.
     *
     */
    @SerializedName( "to_ServiceEntrySheetItem" )
    @JsonProperty( "to_ServiceEntrySheetItem" )
    @ODataField( odataName = "to_ServiceEntrySheetItem" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ServiceEntrySheetItem> toServiceEntrySheetItem;
    /**
     * Use with available fluent helpers to apply the <b>to_ServiceEntrySheetItem</b> navigation property to query
     * operations.
     *
     */
    public final static ServiceEntrySheetLink<ServiceEntrySheetItem> TO_SERVICE_ENTRY_SHEET_ITEM =
        new ServiceEntrySheetLink<ServiceEntrySheetItem>("to_ServiceEntrySheetItem");

    @Nonnull
    @Override
    public Class<ServiceEntrySheet> getType()
    {
        return ServiceEntrySheet.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServiceEntrySheet</b>
     * </p>
     *
     * @param serviceEntrySheet
     *            Service Entry Sheet
     */
    public void setServiceEntrySheet( @Nullable final String serviceEntrySheet )
    {
        rememberChangedField("ServiceEntrySheet", this.serviceEntrySheet);
        this.serviceEntrySheet = serviceEntrySheet;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>ApprovalDateTime</b>
     * </p>
     *
     * @param approvalDateTime
     *            Date and Time of SES Approval (UTC)
     */
    public void setApprovalDateTime( @Nullable final ZonedDateTime approvalDateTime )
    {
        rememberChangedField("ApprovalDateTime", this.approvalDateTime);
        this.approvalDateTime = approvalDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ApprovalStatus</b>
     * </p>
     *
     * @param approvalStatus
     *            Document Status for Service Entry Sheet
     */
    public void setApprovalStatus( @Nullable final String approvalStatus )
    {
        rememberChangedField("ApprovalStatus", this.approvalStatus);
        this.approvalStatus = approvalStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SESWorkflowStatus</b>
     * </p>
     *
     * @param sESWorkflowStatus
     *            Approval Status for Service Entry Sheet
     */
    public void setSESWorkflowStatus( @Nullable final String sESWorkflowStatus )
    {
        rememberChangedField("SESWorkflowStatus", this.sESWorkflowStatus);
        this.sESWorkflowStatus = sESWorkflowStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @param createdByUser
     *            User Name
     */
    public void setCreatedByUser( @Nullable final String createdByUser )
    {
        rememberChangedField("CreatedByUser", this.createdByUser);
        this.createdByUser = createdByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>CreationDateTime</b>
     * </p>
     *
     * @param creationDateTime
     *            UTC Time Stamp in Long Form (YYYYMMDDhhmmssmmmuuun)
     */
    public void setCreationDateTime( @Nullable final ZonedDateTime creationDateTime )
    {
        rememberChangedField("CreationDateTime", this.creationDateTime);
        this.creationDateTime = creationDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingOrganization</b>
     * </p>
     *
     * @param purchasingOrganization
     *            Purchasing Organization
     */
    public void setPurchasingOrganization( @Nullable final String purchasingOrganization )
    {
        rememberChangedField("PurchasingOrganization", this.purchasingOrganization);
        this.purchasingOrganization = purchasingOrganization;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingGroup</b>
     * </p>
     *
     * @param purchasingGroup
     *            Purchasing Group
     */
    public void setPurchasingGroup( @Nullable final String purchasingGroup )
    {
        rememberChangedField("PurchasingGroup", this.purchasingGroup);
        this.purchasingGroup = purchasingGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsEndOfPurposeBlocked</b>
     * </p>
     *
     * @param isEndOfPurposeBlocked
     *            Business Purpose Completed
     */
    public void setIsEndOfPurposeBlocked( @Nullable final String isEndOfPurposeBlocked )
    {
        rememberChangedField("IsEndOfPurposeBlocked", this.isEndOfPurposeBlocked);
        this.isEndOfPurposeBlocked = isEndOfPurposeBlocked;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>Currency</b>
     * </p>
     *
     * @param currency
     *            Currency Key
     */
    public void setCurrency( @Nullable final String currency )
    {
        rememberChangedField("Currency", this.currency);
        this.currency = currency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsDeleted</b>
     * </p>
     *
     * @param isDeleted
     *            Deletion Indicator in Purchasing Document
     */
    public void setIsDeleted( @Nullable final String isDeleted )
    {
        rememberChangedField("IsDeleted", this.isDeleted);
        this.isDeleted = isDeleted;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @param lastChangeDateTime
     *            UTC Time Stamp in Long Form (YYYYMMDDhhmmssmmmuuun)
     */
    public void setLastChangeDateTime( @Nullable final ZonedDateTime lastChangeDateTime )
    {
        rememberChangedField("LastChangeDateTime", this.lastChangeDateTime);
        this.lastChangeDateTime = lastChangeDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @param lastChangedByUser
     *            User Name
     */
    public void setLastChangedByUser( @Nullable final String lastChangedByUser )
    {
        rememberChangedField("LastChangedByUser", this.lastChangedByUser);
        this.lastChangedByUser = lastChangedByUser;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>MaterialDocument</b>
     * </p>
     *
     * @param materialDocument
     *            Number of Material Document
     */
    public void setMaterialDocument( @Nullable final String materialDocument )
    {
        rememberChangedField("MaterialDocument", this.materialDocument);
        this.materialDocument = materialDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaterialDocumentYear</b>
     * </p>
     *
     * @param materialDocumentYear
     *            Material Document Year
     */
    public void setMaterialDocumentYear( @Nullable final String materialDocumentYear )
    {
        rememberChangedField("MaterialDocumentYear", this.materialDocumentYear);
        this.materialDocumentYear = materialDocumentYear;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>OriginObjectType</b>
     * </p>
     *
     * @param originObjectType
     *            Origin of Service Entry Sheet
     */
    public void setOriginObjectType( @Nullable final String originObjectType )
    {
        rememberChangedField("OriginObjectType", this.originObjectType);
        this.originObjectType = originObjectType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrder</b>
     * </p>
     *
     * @param purchaseOrder
     *            Reference Purchase Order
     */
    public void setPurchaseOrder( @Nullable final String purchaseOrder )
    {
        rememberChangedField("PurchaseOrder", this.purchaseOrder);
        this.purchaseOrder = purchaseOrder;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>ResponsiblePerson</b>
     * </p>
     *
     * @param responsiblePerson
     *            Personnel Number
     */
    public void setResponsiblePerson( @Nullable final String responsiblePerson )
    {
        rememberChangedField("ResponsiblePerson", this.responsiblePerson);
        this.responsiblePerson = responsiblePerson;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ServiceEntrySheetName</b>
     * </p>
     *
     * @param serviceEntrySheetName
     *            Name of Service Entry Sheet
     */
    public void setServiceEntrySheetName( @Nullable final String serviceEntrySheetName )
    {
        rememberChangedField("ServiceEntrySheetName", this.serviceEntrySheetName);
        this.serviceEntrySheetName = serviceEntrySheetName;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ServiceEntrySheetUUID</b>
     * </p>
     *
     * @param serviceEntrySheetUUID
     *            UUID serving as key (parent key, root key)
     */
    public void setServiceEntrySheetUUID( @Nullable final UUID serviceEntrySheetUUID )
    {
        rememberChangedField("ServiceEntrySheetUUID", this.serviceEntrySheetUUID);
        this.serviceEntrySheetUUID = serviceEntrySheetUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Supplier</b>
     * </p>
     *
     * @param supplier
     *            Account Number of Supplier
     */
    public void setSupplier( @Nullable final String supplier )
    {
        rememberChangedField("Supplier", this.supplier);
        this.supplier = supplier;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>PurgDocExternalSystem</b>
     * </p>
     *
     * @param purgDocExternalSystem
     *            ID of External Reference System
     */
    public void setPurgDocExternalSystem( @Nullable final String purgDocExternalSystem )
    {
        rememberChangedField("PurgDocExternalSystem", this.purgDocExternalSystem);
        this.purgDocExternalSystem = purgDocExternalSystem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>PurgDocExternalReference</b>
     * </p>
     *
     * @param purgDocExternalReference
     *            External Reference ID
     */
    public void setPurgDocExternalReference( @Nullable final String purgDocExternalReference )
    {
        rememberChangedField("PurgDocExternalReference", this.purgDocExternalReference);
        this.purgDocExternalReference = purgDocExternalReference;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>ExternalRevisionDateTime</b>
     * </p>
     *
     * @param externalRevisionDateTime
     *            Timestamp for Revision of External Calls
     */
    public void setExternalRevisionDateTime( @Nullable final ZonedDateTime externalRevisionDateTime )
    {
        rememberChangedField("ExternalRevisionDateTime", this.externalRevisionDateTime);
        this.externalRevisionDateTime = externalRevisionDateTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PostingDate</b>
     * </p>
     *
     * @param postingDate
     *            GR Posting Date
     */
    public void setPostingDate( @Nullable final LocalDateTime postingDate )
    {
        rememberChangedField("PostingDate", this.postingDate);
        this.postingDate = postingDate;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_ServiceEntrySheet";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ServiceEntrySheet", getServiceEntrySheet());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ServiceEntrySheet", getServiceEntrySheet());
        values.put("ApprovalDateTime", getApprovalDateTime());
        values.put("ApprovalStatus", getApprovalStatus());
        values.put("SESWorkflowStatus", getSESWorkflowStatus());
        values.put("CreatedByUser", getCreatedByUser());
        values.put("CreationDateTime", getCreationDateTime());
        values.put("PurchasingOrganization", getPurchasingOrganization());
        values.put("PurchasingGroup", getPurchasingGroup());
        values.put("IsEndOfPurposeBlocked", getIsEndOfPurposeBlocked());
        values.put("Currency", getCurrency());
        values.put("IsDeleted", getIsDeleted());
        values.put("LastChangeDateTime", getLastChangeDateTime());
        values.put("LastChangedByUser", getLastChangedByUser());
        values.put("MaterialDocument", getMaterialDocument());
        values.put("MaterialDocumentYear", getMaterialDocumentYear());
        values.put("OriginObjectType", getOriginObjectType());
        values.put("PurchaseOrder", getPurchaseOrder());
        values.put("ResponsiblePerson", getResponsiblePerson());
        values.put("ServiceEntrySheetName", getServiceEntrySheetName());
        values.put("ServiceEntrySheetUUID", getServiceEntrySheetUUID());
        values.put("Supplier", getSupplier());
        values.put("PurgDocExternalSystem", getPurgDocExternalSystem());
        values.put("PurgDocExternalReference", getPurgDocExternalReference());
        values.put("ExternalRevisionDateTime", getExternalRevisionDateTime());
        values.put("PostingDate", getPostingDate());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ServiceEntrySheet") ) {
                final Object value = values.remove("ServiceEntrySheet");
                if( (value == null) || (!value.equals(getServiceEntrySheet())) ) {
                    setServiceEntrySheet(((String) value));
                }
            }
            if( values.containsKey("ApprovalDateTime") ) {
                final Object value = values.remove("ApprovalDateTime");
                if( (value == null) || (!value.equals(getApprovalDateTime())) ) {
                    setApprovalDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("ApprovalStatus") ) {
                final Object value = values.remove("ApprovalStatus");
                if( (value == null) || (!value.equals(getApprovalStatus())) ) {
                    setApprovalStatus(((String) value));
                }
            }
            if( values.containsKey("SESWorkflowStatus") ) {
                final Object value = values.remove("SESWorkflowStatus");
                if( (value == null) || (!value.equals(getSESWorkflowStatus())) ) {
                    setSESWorkflowStatus(((String) value));
                }
            }
            if( values.containsKey("CreatedByUser") ) {
                final Object value = values.remove("CreatedByUser");
                if( (value == null) || (!value.equals(getCreatedByUser())) ) {
                    setCreatedByUser(((String) value));
                }
            }
            if( values.containsKey("CreationDateTime") ) {
                final Object value = values.remove("CreationDateTime");
                if( (value == null) || (!value.equals(getCreationDateTime())) ) {
                    setCreationDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("PurchasingOrganization") ) {
                final Object value = values.remove("PurchasingOrganization");
                if( (value == null) || (!value.equals(getPurchasingOrganization())) ) {
                    setPurchasingOrganization(((String) value));
                }
            }
            if( values.containsKey("PurchasingGroup") ) {
                final Object value = values.remove("PurchasingGroup");
                if( (value == null) || (!value.equals(getPurchasingGroup())) ) {
                    setPurchasingGroup(((String) value));
                }
            }
            if( values.containsKey("IsEndOfPurposeBlocked") ) {
                final Object value = values.remove("IsEndOfPurposeBlocked");
                if( (value == null) || (!value.equals(getIsEndOfPurposeBlocked())) ) {
                    setIsEndOfPurposeBlocked(((String) value));
                }
            }
            if( values.containsKey("Currency") ) {
                final Object value = values.remove("Currency");
                if( (value == null) || (!value.equals(getCurrency())) ) {
                    setCurrency(((String) value));
                }
            }
            if( values.containsKey("IsDeleted") ) {
                final Object value = values.remove("IsDeleted");
                if( (value == null) || (!value.equals(getIsDeleted())) ) {
                    setIsDeleted(((String) value));
                }
            }
            if( values.containsKey("LastChangeDateTime") ) {
                final Object value = values.remove("LastChangeDateTime");
                if( (value == null) || (!value.equals(getLastChangeDateTime())) ) {
                    setLastChangeDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("LastChangedByUser") ) {
                final Object value = values.remove("LastChangedByUser");
                if( (value == null) || (!value.equals(getLastChangedByUser())) ) {
                    setLastChangedByUser(((String) value));
                }
            }
            if( values.containsKey("MaterialDocument") ) {
                final Object value = values.remove("MaterialDocument");
                if( (value == null) || (!value.equals(getMaterialDocument())) ) {
                    setMaterialDocument(((String) value));
                }
            }
            if( values.containsKey("MaterialDocumentYear") ) {
                final Object value = values.remove("MaterialDocumentYear");
                if( (value == null) || (!value.equals(getMaterialDocumentYear())) ) {
                    setMaterialDocumentYear(((String) value));
                }
            }
            if( values.containsKey("OriginObjectType") ) {
                final Object value = values.remove("OriginObjectType");
                if( (value == null) || (!value.equals(getOriginObjectType())) ) {
                    setOriginObjectType(((String) value));
                }
            }
            if( values.containsKey("PurchaseOrder") ) {
                final Object value = values.remove("PurchaseOrder");
                if( (value == null) || (!value.equals(getPurchaseOrder())) ) {
                    setPurchaseOrder(((String) value));
                }
            }
            if( values.containsKey("ResponsiblePerson") ) {
                final Object value = values.remove("ResponsiblePerson");
                if( (value == null) || (!value.equals(getResponsiblePerson())) ) {
                    setResponsiblePerson(((String) value));
                }
            }
            if( values.containsKey("ServiceEntrySheetName") ) {
                final Object value = values.remove("ServiceEntrySheetName");
                if( (value == null) || (!value.equals(getServiceEntrySheetName())) ) {
                    setServiceEntrySheetName(((String) value));
                }
            }
            if( values.containsKey("ServiceEntrySheetUUID") ) {
                final Object value = values.remove("ServiceEntrySheetUUID");
                if( (value == null) || (!value.equals(getServiceEntrySheetUUID())) ) {
                    setServiceEntrySheetUUID(((UUID) value));
                }
            }
            if( values.containsKey("Supplier") ) {
                final Object value = values.remove("Supplier");
                if( (value == null) || (!value.equals(getSupplier())) ) {
                    setSupplier(((String) value));
                }
            }
            if( values.containsKey("PurgDocExternalSystem") ) {
                final Object value = values.remove("PurgDocExternalSystem");
                if( (value == null) || (!value.equals(getPurgDocExternalSystem())) ) {
                    setPurgDocExternalSystem(((String) value));
                }
            }
            if( values.containsKey("PurgDocExternalReference") ) {
                final Object value = values.remove("PurgDocExternalReference");
                if( (value == null) || (!value.equals(getPurgDocExternalReference())) ) {
                    setPurgDocExternalReference(((String) value));
                }
            }
            if( values.containsKey("ExternalRevisionDateTime") ) {
                final Object value = values.remove("ExternalRevisionDateTime");
                if( (value == null) || (!value.equals(getExternalRevisionDateTime())) ) {
                    setExternalRevisionDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("PostingDate") ) {
                final Object value = values.remove("PostingDate");
                if( (value == null) || (!value.equals(getPostingDate())) ) {
                    setPostingDate(((LocalDateTime) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_ServiceEntrySheetItem") ) {
                final Object value = (values).remove("to_ServiceEntrySheetItem");
                if( value instanceof Iterable ) {
                    if( toServiceEntrySheetItem == null ) {
                        toServiceEntrySheetItem = Lists.newArrayList();
                    } else {
                        toServiceEntrySheetItem = Lists.newArrayList(toServiceEntrySheetItem);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ServiceEntrySheetItem entity;
                        if( toServiceEntrySheetItem.size() > i ) {
                            entity = toServiceEntrySheetItem.get(i);
                        } else {
                            entity = new ServiceEntrySheetItem();
                            toServiceEntrySheetItem.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> ServiceEntrySheetField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ServiceEntrySheetField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ServiceEntrySheetField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ServiceEntrySheetField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ServiceEntrySheetService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toServiceEntrySheetItem != null ) {
            (values).put("to_ServiceEntrySheetItem", toServiceEntrySheetItem);
        }
        return values;
    }

    /**
     * Fetches the <b>ServiceEntrySheetItem</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_ServiceEntrySheetItem</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ServiceEntrySheetItem</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ServiceEntrySheetItem> fetchServiceEntrySheetItem()
    {
        return fetchFieldAsList("to_ServiceEntrySheetItem", ServiceEntrySheetItem.class);
    }

    /**
     * Retrieval of associated <b>ServiceEntrySheetItem</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ServiceEntrySheetItem</b>.
     * <p>
     * If the navigation property <b>to_ServiceEntrySheetItem</b> of a queried <b>ServiceEntrySheet</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ServiceEntrySheetItem</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ServiceEntrySheetItem> getServiceEntrySheetItemOrFetch()
    {
        if( toServiceEntrySheetItem == null ) {
            toServiceEntrySheetItem = fetchServiceEntrySheetItem();
        }
        return toServiceEntrySheetItem;
    }

    /**
     * Retrieval of associated <b>ServiceEntrySheetItem</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ServiceEntrySheetItem</b>.
     * <p>
     * If the navigation property for an entity <b>ServiceEntrySheet</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ServiceEntrySheetItem</b> is already loaded, the result
     *         will contain the <b>ServiceEntrySheetItem</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ServiceEntrySheetItem>> getServiceEntrySheetItemIfPresent()
    {
        return Option.of(toServiceEntrySheetItem);
    }

    /**
     * Overwrites the list of associated <b>ServiceEntrySheetItem</b> entities for the loaded navigation property
     * <b>to_ServiceEntrySheetItem</b>.
     * <p>
     * If the navigation property <b>to_ServiceEntrySheetItem</b> of a queried <b>ServiceEntrySheet</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ServiceEntrySheetItem</b> entities.
     */
    public void setServiceEntrySheetItem( @Nonnull final List<ServiceEntrySheetItem> value )
    {
        if( toServiceEntrySheetItem == null ) {
            toServiceEntrySheetItem = Lists.newArrayList();
        }
        toServiceEntrySheetItem.clear();
        toServiceEntrySheetItem.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ServiceEntrySheetItem</b> entities. This corresponds to the OData
     * navigation property <b>to_ServiceEntrySheetItem</b>.
     * <p>
     * If the navigation property <b>to_ServiceEntrySheetItem</b> of a queried <b>ServiceEntrySheet</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ServiceEntrySheetItem</b> entities.
     */
    public void addServiceEntrySheetItem( ServiceEntrySheetItem... entity )
    {
        if( toServiceEntrySheetItem == null ) {
            toServiceEntrySheetItem = Lists.newArrayList();
        }
        toServiceEntrySheetItem.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of ServiceEntrySheet instances.
     *
     */
    public final static class ServiceEntrySheetBuilder
    {

        private List<ServiceEntrySheetItem> toServiceEntrySheetItem = Lists.newArrayList();

        private ServiceEntrySheet.ServiceEntrySheetBuilder toServiceEntrySheetItem(
            final List<ServiceEntrySheetItem> value )
        {
            toServiceEntrySheetItem.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_ServiceEntrySheetItem</b> for <b>ServiceEntrySheet</b> to multiple
         * <b>ServiceEntrySheetItem</b>.
         *
         * @param value
         *            The ServiceEntrySheetItems to build this ServiceEntrySheet with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ServiceEntrySheet.ServiceEntrySheetBuilder serviceEntrySheetItem( ServiceEntrySheetItem... value )
        {
            return toServiceEntrySheetItem(Lists.newArrayList(value));
        }

    }

}
