/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.selectable.ServiceEntrySheetSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.ServiceEntrySheet ServiceEntrySheet}
 * entity using key fields. This fluent helper allows methods which modify the underlying query to be called before
 * executing the query itself.
 *
 */
public class ServiceEntrySheetByKeyFluentHelper
    extends
    FluentHelperByKey<ServiceEntrySheetByKeyFluentHelper, ServiceEntrySheet, ServiceEntrySheetSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.ServiceEntrySheet ServiceEntrySheet}
     * entity with the provided key field values. To perform execution, call the {@link #executeRequest executeRequest}
     * method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code ServiceEntrySheet}
     * @param servicePath
     *            Service path to be used to fetch a single {@code ServiceEntrySheet}
     * @param serviceEntrySheet
     *            Service Entry Sheet
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     */
    public ServiceEntrySheetByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String serviceEntrySheet )
    {
        super(servicePath, entityCollection);
        this.key.put("ServiceEntrySheet", serviceEntrySheet);
    }

    @Override
    @Nonnull
    protected Class<ServiceEntrySheet> getEntityClass()
    {
        return ServiceEntrySheet.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
