/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.field.ServiceEntrySheetItemField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.link.ServiceEntrySheetItemLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.selectable.ServiceEntrySheetItemSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Item
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_ServiceEntrySheetItemType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ServiceEntrySheetItem extends VdmEntity<ServiceEntrySheetItem>
{

    /**
     * Selector for all available fields of ServiceEntrySheetItem.
     *
     */
    public final static ServiceEntrySheetItemSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServiceEntrySheet</b>
     * </p>
     *
     * @return Service Entry Sheet
     */
    @Key
    @SerializedName( "ServiceEntrySheet" )
    @JsonProperty( "ServiceEntrySheet" )
    @Nullable
    @ODataField( odataName = "ServiceEntrySheet" )
    private String serviceEntrySheet;
    /**
     * Use with available fluent helpers to apply the <b>ServiceEntrySheet</b> field to query operations.
     *
     */
    public final static ServiceEntrySheetItemField<String> SERVICE_ENTRY_SHEET =
        new ServiceEntrySheetItemField<String>("ServiceEntrySheet");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ServiceEntrySheetItem</b>
     * </p>
     *
     * @return Item Number of Service Entry Sheet
     */
    @Key
    @SerializedName( "ServiceEntrySheetItem" )
    @JsonProperty( "ServiceEntrySheetItem" )
    @Nullable
    @ODataField( odataName = "ServiceEntrySheetItem" )
    private String serviceEntrySheetItem;
    /**
     * Use with available fluent helpers to apply the <b>ServiceEntrySheetItem</b> field to query operations.
     *
     */
    public final static ServiceEntrySheetItemField<String> SERVICE_ENTRY_SHEET_ITEM =
        new ServiceEntrySheetItemField<String>("ServiceEntrySheetItem");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>AccountAssignmentCategory</b>
     * </p>
     *
     * @return Account Assignment Category
     */
    @SerializedName( "AccountAssignmentCategory" )
    @JsonProperty( "AccountAssignmentCategory" )
    @Nullable
    @ODataField( odataName = "AccountAssignmentCategory" )
    private String accountAssignmentCategory;
    /**
     * Use with available fluent helpers to apply the <b>AccountAssignmentCategory</b> field to query operations.
     *
     */
    public final static ServiceEntrySheetItemField<String> ACCOUNT_ASSIGNMENT_CATEGORY =
        new ServiceEntrySheetItemField<String>("AccountAssignmentCategory");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConfirmedQuantity</b>
     * </p>
     *
     * @return Stated Quantity
     */
    @SerializedName( "ConfirmedQuantity" )
    @JsonProperty( "ConfirmedQuantity" )
    @Nullable
    @ODataField( odataName = "ConfirmedQuantity" )
    private BigDecimal confirmedQuantity;
    /**
     * Use with available fluent helpers to apply the <b>ConfirmedQuantity</b> field to query operations.
     *
     */
    public final static ServiceEntrySheetItemField<BigDecimal> CONFIRMED_QUANTITY =
        new ServiceEntrySheetItemField<BigDecimal>("ConfirmedQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @return Created By (User Name) for Service Entry Sheet
     */
    @SerializedName( "CreatedByUser" )
    @JsonProperty( "CreatedByUser" )
    @Nullable
    @ODataField( odataName = "CreatedByUser" )
    private String createdByUser;
    /**
     * Use with available fluent helpers to apply the <b>CreatedByUser</b> field to query operations.
     *
     */
    public final static ServiceEntrySheetItemField<String> CREATED_BY_USER =
        new ServiceEntrySheetItemField<String>("CreatedByUser");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>CreationDateTime</b>
     * </p>
     *
     * @return UTC Time Stamp in Long Form (YYYYMMDDhhmmssmmmuuun)
     */
    @SerializedName( "CreationDateTime" )
    @JsonProperty( "CreationDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "CreationDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime creationDateTime;
    /**
     * Use with available fluent helpers to apply the <b>CreationDateTime</b> field to query operations.
     *
     */
    public final static ServiceEntrySheetItemField<ZonedDateTime> CREATION_DATE_TIME =
        new ServiceEntrySheetItemField<ZonedDateTime>("CreationDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingOrganization</b>
     * </p>
     *
     * @return Purchasing Organization
     */
    @SerializedName( "PurchasingOrganization" )
    @JsonProperty( "PurchasingOrganization" )
    @Nullable
    @ODataField( odataName = "PurchasingOrganization" )
    private String purchasingOrganization;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingOrganization</b> field to query operations.
     *
     */
    public final static ServiceEntrySheetItemField<String> PURCHASING_ORGANIZATION =
        new ServiceEntrySheetItemField<String>("PurchasingOrganization");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingGroup</b>
     * </p>
     *
     * @return Purchasing Group
     */
    @SerializedName( "PurchasingGroup" )
    @JsonProperty( "PurchasingGroup" )
    @Nullable
    @ODataField( odataName = "PurchasingGroup" )
    private String purchasingGroup;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingGroup</b> field to query operations.
     *
     */
    public final static ServiceEntrySheetItemField<String> PURCHASING_GROUP =
        new ServiceEntrySheetItemField<String>("PurchasingGroup");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Plant
     */
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static ServiceEntrySheetItemField<String> PLANT = new ServiceEntrySheetItemField<String>("Plant");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>Currency</b>
     * </p>
     *
     * @return Currency Key
     */
    @SerializedName( "Currency" )
    @JsonProperty( "Currency" )
    @Nullable
    @ODataField( odataName = "Currency" )
    private String currency;
    /**
     * Use with available fluent helpers to apply the <b>Currency</b> field to query operations.
     *
     */
    public final static ServiceEntrySheetItemField<String> CURRENCY =
        new ServiceEntrySheetItemField<String>("Currency");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsDeleted</b>
     * </p>
     *
     * @return Deletion Indicator in Purchasing Document
     */
    @SerializedName( "IsDeleted" )
    @JsonProperty( "IsDeleted" )
    @Nullable
    @ODataField( odataName = "IsDeleted" )
    private String isDeleted;
    /**
     * Use with available fluent helpers to apply the <b>IsDeleted</b> field to query operations.
     *
     */
    public final static ServiceEntrySheetItemField<String> IS_DELETED =
        new ServiceEntrySheetItemField<String>("IsDeleted");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @return UTC Time Stamp in Long Form (YYYYMMDDhhmmssmmmuuun)
     */
    @SerializedName( "LastChangeDateTime" )
    @JsonProperty( "LastChangeDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime lastChangeDateTime;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDateTime</b> field to query operations.
     *
     */
    public final static ServiceEntrySheetItemField<ZonedDateTime> LAST_CHANGE_DATE_TIME =
        new ServiceEntrySheetItemField<ZonedDateTime>("LastChangeDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @return Last Changed (User Name) for Service Entry Sheet
     */
    @SerializedName( "LastChangedByUser" )
    @JsonProperty( "LastChangedByUser" )
    @Nullable
    @ODataField( odataName = "LastChangedByUser" )
    private String lastChangedByUser;
    /**
     * Use with available fluent helpers to apply the <b>LastChangedByUser</b> field to query operations.
     *
     */
    public final static ServiceEntrySheetItemField<String> LAST_CHANGED_BY_USER =
        new ServiceEntrySheetItemField<String>("LastChangedByUser");
    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroup</b>
     * </p>
     *
     * @return Product Group
     */
    @SerializedName( "MaterialGroup" )
    @JsonProperty( "MaterialGroup" )
    @Nullable
    @ODataField( odataName = "MaterialGroup" )
    private String materialGroup;
    /**
     * Use with available fluent helpers to apply the <b>MaterialGroup</b> field to query operations.
     *
     */
    public final static ServiceEntrySheetItemField<String> MATERIAL_GROUP =
        new ServiceEntrySheetItemField<String>("MaterialGroup");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>MultipleAcctAssgmtDistribution</b>
     * </p>
     *
     * @return Distribution Indicator for Multiple Account Assignment
     */
    @SerializedName( "MultipleAcctAssgmtDistribution" )
    @JsonProperty( "MultipleAcctAssgmtDistribution" )
    @Nullable
    @ODataField( odataName = "MultipleAcctAssgmtDistribution" )
    private String multipleAcctAssgmtDistribution;
    /**
     * Use with available fluent helpers to apply the <b>MultipleAcctAssgmtDistribution</b> field to query operations.
     *
     */
    public final static ServiceEntrySheetItemField<String> MULTIPLE_ACCT_ASSGMT_DISTRIBUTION =
        new ServiceEntrySheetItemField<String>("MultipleAcctAssgmtDistribution");
    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>NetAmount</b>
     * </p>
     *
     * @return Stated Amount
     */
    @SerializedName( "NetAmount" )
    @JsonProperty( "NetAmount" )
    @Nullable
    @ODataField( odataName = "NetAmount" )
    private BigDecimal netAmount;
    /**
     * Use with available fluent helpers to apply the <b>NetAmount</b> field to query operations.
     *
     */
    public final static ServiceEntrySheetItemField<BigDecimal> NET_AMOUNT =
        new ServiceEntrySheetItemField<BigDecimal>("NetAmount");
    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>NetPriceAmount</b>
     * </p>
     *
     * @return Price per Unit for an SES Item
     */
    @SerializedName( "NetPriceAmount" )
    @JsonProperty( "NetPriceAmount" )
    @Nullable
    @ODataField( odataName = "NetPriceAmount" )
    private BigDecimal netPriceAmount;
    /**
     * Use with available fluent helpers to apply the <b>NetPriceAmount</b> field to query operations.
     *
     */
    public final static ServiceEntrySheetItemField<BigDecimal> NET_PRICE_AMOUNT =
        new ServiceEntrySheetItemField<BigDecimal>("NetPriceAmount");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>OriginObject</b>
     * </p>
     *
     * @return External Reference Document
     */
    @SerializedName( "OriginObject" )
    @JsonProperty( "OriginObject" )
    @Nullable
    @ODataField( odataName = "OriginObject" )
    private String originObject;
    /**
     * Use with available fluent helpers to apply the <b>OriginObject</b> field to query operations.
     *
     */
    public final static ServiceEntrySheetItemField<String> ORIGIN_OBJECT =
        new ServiceEntrySheetItemField<String>("OriginObject");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrder</b>
     * </p>
     *
     * @return Reference Purchase Order
     */
    @SerializedName( "PurchaseOrder" )
    @JsonProperty( "PurchaseOrder" )
    @Nullable
    @ODataField( odataName = "PurchaseOrder" )
    private String purchaseOrder;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseOrder</b> field to query operations.
     *
     */
    public final static ServiceEntrySheetItemField<String> PURCHASE_ORDER =
        new ServiceEntrySheetItemField<String>("PurchaseOrder");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrderItem</b>
     * </p>
     *
     * @return Referenced Purchase Order Item
     */
    @SerializedName( "PurchaseOrderItem" )
    @JsonProperty( "PurchaseOrderItem" )
    @Nullable
    @ODataField( odataName = "PurchaseOrderItem" )
    private String purchaseOrderItem;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseOrderItem</b> field to query operations.
     *
     */
    public final static ServiceEntrySheetItemField<String> PURCHASE_ORDER_ITEM =
        new ServiceEntrySheetItemField<String>("PurchaseOrderItem");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseContract</b>
     * </p>
     *
     * @return Purchase Contract for Enhanced Limit
     */
    @SerializedName( "PurchaseContract" )
    @JsonProperty( "PurchaseContract" )
    @Nullable
    @ODataField( odataName = "PurchaseContract" )
    private String purchaseContract;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseContract</b> field to query operations.
     *
     */
    public final static ServiceEntrySheetItemField<String> PURCHASE_CONTRACT =
        new ServiceEntrySheetItemField<String>("PurchaseContract");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseContractItem</b>
     * </p>
     *
     * @return Purchase Contract Item
     */
    @SerializedName( "PurchaseContractItem" )
    @JsonProperty( "PurchaseContractItem" )
    @Nullable
    @ODataField( odataName = "PurchaseContractItem" )
    private String purchaseContractItem;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseContractItem</b> field to query operations.
     *
     */
    public final static ServiceEntrySheetItemField<String> PURCHASE_CONTRACT_ITEM =
        new ServiceEntrySheetItemField<String>("PurchaseContractItem");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>QuantityUnit</b>
     * </p>
     *
     * @return Unit of Measure for Service Entry Statement
     */
    @SerializedName( "QuantityUnit" )
    @JsonProperty( "QuantityUnit" )
    @Nullable
    @ODataField( odataName = "QuantityUnit" )
    private String quantityUnit;
    /**
     * Use with available fluent helpers to apply the <b>QuantityUnit</b> field to query operations.
     *
     */
    public final static ServiceEntrySheetItemField<String> QUANTITY_UNIT =
        new ServiceEntrySheetItemField<String>("QuantityUnit");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Service</b>
     * </p>
     *
     * @return Product
     */
    @SerializedName( "Service" )
    @JsonProperty( "Service" )
    @Nullable
    @ODataField( odataName = "Service" )
    private String service;
    /**
     * Use with available fluent helpers to apply the <b>Service</b> field to query operations.
     *
     */
    public final static ServiceEntrySheetItemField<String> SERVICE = new ServiceEntrySheetItemField<String>("Service");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ServiceEntrySheetItemDesc</b>
     * </p>
     *
     * @return Item Description for Service Entry Sheet
     */
    @SerializedName( "ServiceEntrySheetItemDesc" )
    @JsonProperty( "ServiceEntrySheetItemDesc" )
    @Nullable
    @ODataField( odataName = "ServiceEntrySheetItemDesc" )
    private String serviceEntrySheetItemDesc;
    /**
     * Use with available fluent helpers to apply the <b>ServiceEntrySheetItemDesc</b> field to query operations.
     *
     */
    public final static ServiceEntrySheetItemField<String> SERVICE_ENTRY_SHEET_ITEM_DESC =
        new ServiceEntrySheetItemField<String>("ServiceEntrySheetItemDesc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ServiceEntrySheetItemUUID</b>
     * </p>
     *
     * @return UUID serving as key (parent key, root key)
     */
    @SerializedName( "ServiceEntrySheetItemUUID" )
    @JsonProperty( "ServiceEntrySheetItemUUID" )
    @Nullable
    @ODataField( odataName = "ServiceEntrySheetItemUUID" )
    private UUID serviceEntrySheetItemUUID;
    /**
     * Use with available fluent helpers to apply the <b>ServiceEntrySheetItemUUID</b> field to query operations.
     *
     */
    public final static ServiceEntrySheetItemField<UUID> SERVICE_ENTRY_SHEET_ITEM_UUID =
        new ServiceEntrySheetItemField<UUID>("ServiceEntrySheetItemUUID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ServiceEntrySheetUUID</b>
     * </p>
     *
     * @return UUID serving as key (parent key, root key)
     */
    @SerializedName( "ServiceEntrySheetUUID" )
    @JsonProperty( "ServiceEntrySheetUUID" )
    @Nullable
    @ODataField( odataName = "ServiceEntrySheetUUID" )
    private UUID serviceEntrySheetUUID;
    /**
     * Use with available fluent helpers to apply the <b>ServiceEntrySheetUUID</b> field to query operations.
     *
     */
    public final static ServiceEntrySheetItemField<UUID> SERVICE_ENTRY_SHEET_UUID =
        new ServiceEntrySheetItemField<UUID>("ServiceEntrySheetUUID");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ServicePerformanceDate</b>
     * </p>
     *
     * @return Date of Service Performance
     */
    @SerializedName( "ServicePerformanceDate" )
    @JsonProperty( "ServicePerformanceDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ServicePerformanceDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime servicePerformanceDate;
    /**
     * Use with available fluent helpers to apply the <b>ServicePerformanceDate</b> field to query operations.
     *
     */
    public final static ServiceEntrySheetItemField<LocalDateTime> SERVICE_PERFORMANCE_DATE =
        new ServiceEntrySheetItemField<LocalDateTime>("ServicePerformanceDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ServicePerformanceEndDate</b>
     * </p>
     *
     * @return End Date of Performance Period
     */
    @SerializedName( "ServicePerformanceEndDate" )
    @JsonProperty( "ServicePerformanceEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ServicePerformanceEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime servicePerformanceEndDate;
    /**
     * Use with available fluent helpers to apply the <b>ServicePerformanceEndDate</b> field to query operations.
     *
     */
    public final static ServiceEntrySheetItemField<LocalDateTime> SERVICE_PERFORMANCE_END_DATE =
        new ServiceEntrySheetItemField<LocalDateTime>("ServicePerformanceEndDate");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServicePerformer</b>
     * </p>
     *
     * @return Service Performer
     */
    @SerializedName( "ServicePerformer" )
    @JsonProperty( "ServicePerformer" )
    @Nullable
    @ODataField( odataName = "ServicePerformer" )
    private String servicePerformer;
    /**
     * Use with available fluent helpers to apply the <b>ServicePerformer</b> field to query operations.
     *
     */
    public final static ServiceEntrySheetItemField<String> SERVICE_PERFORMER =
        new ServiceEntrySheetItemField<String>("ServicePerformer");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>WorkItem</b>
     * </p>
     *
     * @return Work Item ID
     */
    @SerializedName( "WorkItem" )
    @JsonProperty( "WorkItem" )
    @Nullable
    @ODataField( odataName = "WorkItem" )
    private String workItem;
    /**
     * Use with available fluent helpers to apply the <b>WorkItem</b> field to query operations.
     *
     */
    public final static ServiceEntrySheetItemField<String> WORK_ITEM =
        new ServiceEntrySheetItemField<String>("WorkItem");
    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>PurgDocItemExternalReference</b>
     * </p>
     *
     * @return External Reference ID
     */
    @SerializedName( "PurgDocItemExternalReference" )
    @JsonProperty( "PurgDocItemExternalReference" )
    @Nullable
    @ODataField( odataName = "PurgDocItemExternalReference" )
    private String purgDocItemExternalReference;
    /**
     * Use with available fluent helpers to apply the <b>PurgDocItemExternalReference</b> field to query operations.
     *
     */
    public final static ServiceEntrySheetItemField<String> PURG_DOC_ITEM_EXTERNAL_REFERENCE =
        new ServiceEntrySheetItemField<String>("PurgDocItemExternalReference");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SESItemIsFinalEntry</b>
     * </p>
     *
     * @return Final Entry
     */
    @SerializedName( "SESItemIsFinalEntry" )
    @JsonProperty( "SESItemIsFinalEntry" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "SESItemIsFinalEntry" )
    private Boolean sESItemIsFinalEntry;
    /**
     * Use with available fluent helpers to apply the <b>SESItemIsFinalEntry</b> field to query operations.
     *
     */
    public final static ServiceEntrySheetItemField<Boolean> SES_ITEM_IS_FINAL_ENTRY =
        new ServiceEntrySheetItemField<Boolean>("SESItemIsFinalEntry");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>TaxCode</b>
     * </p>
     *
     * @return Tax on Sales/Purchases Code
     */
    @SerializedName( "TaxCode" )
    @JsonProperty( "TaxCode" )
    @Nullable
    @ODataField( odataName = "TaxCode" )
    private String taxCode;
    /**
     * Use with available fluent helpers to apply the <b>TaxCode</b> field to query operations.
     *
     */
    public final static ServiceEntrySheetItemField<String> TAX_CODE = new ServiceEntrySheetItemField<String>("TaxCode");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>TaxCountry</b>
     * </p>
     *
     * @return Tax Reporting Country/Region
     */
    @SerializedName( "TaxCountry" )
    @JsonProperty( "TaxCountry" )
    @Nullable
    @ODataField( odataName = "TaxCountry" )
    private String taxCountry;
    /**
     * Use with available fluent helpers to apply the <b>TaxCountry</b> field to query operations.
     *
     */
    public final static ServiceEntrySheetItemField<String> TAX_COUNTRY =
        new ServiceEntrySheetItemField<String>("TaxCountry");
    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>TaxJurisdiction</b>
     * </p>
     *
     * @return Tax Jurisdiction
     */
    @SerializedName( "TaxJurisdiction" )
    @JsonProperty( "TaxJurisdiction" )
    @Nullable
    @ODataField( odataName = "TaxJurisdiction" )
    private String taxJurisdiction;
    /**
     * Use with available fluent helpers to apply the <b>TaxJurisdiction</b> field to query operations.
     *
     */
    public final static ServiceEntrySheetItemField<String> TAX_JURISDICTION =
        new ServiceEntrySheetItemField<String>("TaxJurisdiction");
    /**
     * Navigation property <b>to_AccountAssignment</b> for <b>ServiceEntrySheetItem</b> to multiple
     * <b>SrvcEntrShtAcctAssignment</b>.
     *
     */
    @SerializedName( "to_AccountAssignment" )
    @JsonProperty( "to_AccountAssignment" )
    @ODataField( odataName = "to_AccountAssignment" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SrvcEntrShtAcctAssignment> toAccountAssignment;
    /**
     * Use with available fluent helpers to apply the <b>to_AccountAssignment</b> navigation property to query
     * operations.
     *
     */
    public final static ServiceEntrySheetItemLink<SrvcEntrShtAcctAssignment> TO_ACCOUNT_ASSIGNMENT =
        new ServiceEntrySheetItemLink<SrvcEntrShtAcctAssignment>("to_AccountAssignment");

    @Nonnull
    @Override
    public Class<ServiceEntrySheetItem> getType()
    {
        return ServiceEntrySheetItem.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServiceEntrySheet</b>
     * </p>
     *
     * @param serviceEntrySheet
     *            Service Entry Sheet
     */
    public void setServiceEntrySheet( @Nullable final String serviceEntrySheet )
    {
        rememberChangedField("ServiceEntrySheet", this.serviceEntrySheet);
        this.serviceEntrySheet = serviceEntrySheet;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ServiceEntrySheetItem</b>
     * </p>
     *
     * @param serviceEntrySheetItem
     *            Item Number of Service Entry Sheet
     */
    public void setServiceEntrySheetItem( @Nullable final String serviceEntrySheetItem )
    {
        rememberChangedField("ServiceEntrySheetItem", this.serviceEntrySheetItem);
        this.serviceEntrySheetItem = serviceEntrySheetItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>AccountAssignmentCategory</b>
     * </p>
     *
     * @param accountAssignmentCategory
     *            Account Assignment Category
     */
    public void setAccountAssignmentCategory( @Nullable final String accountAssignmentCategory )
    {
        rememberChangedField("AccountAssignmentCategory", this.accountAssignmentCategory);
        this.accountAssignmentCategory = accountAssignmentCategory;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConfirmedQuantity</b>
     * </p>
     *
     * @param confirmedQuantity
     *            Stated Quantity
     */
    public void setConfirmedQuantity( @Nullable final BigDecimal confirmedQuantity )
    {
        rememberChangedField("ConfirmedQuantity", this.confirmedQuantity);
        this.confirmedQuantity = confirmedQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @param createdByUser
     *            Created By (User Name) for Service Entry Sheet
     */
    public void setCreatedByUser( @Nullable final String createdByUser )
    {
        rememberChangedField("CreatedByUser", this.createdByUser);
        this.createdByUser = createdByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>CreationDateTime</b>
     * </p>
     *
     * @param creationDateTime
     *            UTC Time Stamp in Long Form (YYYYMMDDhhmmssmmmuuun)
     */
    public void setCreationDateTime( @Nullable final ZonedDateTime creationDateTime )
    {
        rememberChangedField("CreationDateTime", this.creationDateTime);
        this.creationDateTime = creationDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingOrganization</b>
     * </p>
     *
     * @param purchasingOrganization
     *            Purchasing Organization
     */
    public void setPurchasingOrganization( @Nullable final String purchasingOrganization )
    {
        rememberChangedField("PurchasingOrganization", this.purchasingOrganization);
        this.purchasingOrganization = purchasingOrganization;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingGroup</b>
     * </p>
     *
     * @param purchasingGroup
     *            Purchasing Group
     */
    public void setPurchasingGroup( @Nullable final String purchasingGroup )
    {
        rememberChangedField("PurchasingGroup", this.purchasingGroup);
        this.purchasingGroup = purchasingGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>Currency</b>
     * </p>
     *
     * @param currency
     *            Currency Key
     */
    public void setCurrency( @Nullable final String currency )
    {
        rememberChangedField("Currency", this.currency);
        this.currency = currency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsDeleted</b>
     * </p>
     *
     * @param isDeleted
     *            Deletion Indicator in Purchasing Document
     */
    public void setIsDeleted( @Nullable final String isDeleted )
    {
        rememberChangedField("IsDeleted", this.isDeleted);
        this.isDeleted = isDeleted;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @param lastChangeDateTime
     *            UTC Time Stamp in Long Form (YYYYMMDDhhmmssmmmuuun)
     */
    public void setLastChangeDateTime( @Nullable final ZonedDateTime lastChangeDateTime )
    {
        rememberChangedField("LastChangeDateTime", this.lastChangeDateTime);
        this.lastChangeDateTime = lastChangeDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @param lastChangedByUser
     *            Last Changed (User Name) for Service Entry Sheet
     */
    public void setLastChangedByUser( @Nullable final String lastChangedByUser )
    {
        rememberChangedField("LastChangedByUser", this.lastChangedByUser);
        this.lastChangedByUser = lastChangedByUser;
    }

    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroup</b>
     * </p>
     *
     * @param materialGroup
     *            Product Group
     */
    public void setMaterialGroup( @Nullable final String materialGroup )
    {
        rememberChangedField("MaterialGroup", this.materialGroup);
        this.materialGroup = materialGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>MultipleAcctAssgmtDistribution</b>
     * </p>
     *
     * @param multipleAcctAssgmtDistribution
     *            Distribution Indicator for Multiple Account Assignment
     */
    public void setMultipleAcctAssgmtDistribution( @Nullable final String multipleAcctAssgmtDistribution )
    {
        rememberChangedField("MultipleAcctAssgmtDistribution", this.multipleAcctAssgmtDistribution);
        this.multipleAcctAssgmtDistribution = multipleAcctAssgmtDistribution;
    }

    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>NetAmount</b>
     * </p>
     *
     * @param netAmount
     *            Stated Amount
     */
    public void setNetAmount( @Nullable final BigDecimal netAmount )
    {
        rememberChangedField("NetAmount", this.netAmount);
        this.netAmount = netAmount;
    }

    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>NetPriceAmount</b>
     * </p>
     *
     * @param netPriceAmount
     *            Price per Unit for an SES Item
     */
    public void setNetPriceAmount( @Nullable final BigDecimal netPriceAmount )
    {
        rememberChangedField("NetPriceAmount", this.netPriceAmount);
        this.netPriceAmount = netPriceAmount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>OriginObject</b>
     * </p>
     *
     * @param originObject
     *            External Reference Document
     */
    public void setOriginObject( @Nullable final String originObject )
    {
        rememberChangedField("OriginObject", this.originObject);
        this.originObject = originObject;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrder</b>
     * </p>
     *
     * @param purchaseOrder
     *            Reference Purchase Order
     */
    public void setPurchaseOrder( @Nullable final String purchaseOrder )
    {
        rememberChangedField("PurchaseOrder", this.purchaseOrder);
        this.purchaseOrder = purchaseOrder;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrderItem</b>
     * </p>
     *
     * @param purchaseOrderItem
     *            Referenced Purchase Order Item
     */
    public void setPurchaseOrderItem( @Nullable final String purchaseOrderItem )
    {
        rememberChangedField("PurchaseOrderItem", this.purchaseOrderItem);
        this.purchaseOrderItem = purchaseOrderItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseContract</b>
     * </p>
     *
     * @param purchaseContract
     *            Purchase Contract for Enhanced Limit
     */
    public void setPurchaseContract( @Nullable final String purchaseContract )
    {
        rememberChangedField("PurchaseContract", this.purchaseContract);
        this.purchaseContract = purchaseContract;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseContractItem</b>
     * </p>
     *
     * @param purchaseContractItem
     *            Purchase Contract Item
     */
    public void setPurchaseContractItem( @Nullable final String purchaseContractItem )
    {
        rememberChangedField("PurchaseContractItem", this.purchaseContractItem);
        this.purchaseContractItem = purchaseContractItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>QuantityUnit</b>
     * </p>
     *
     * @param quantityUnit
     *            Unit of Measure for Service Entry Statement
     */
    public void setQuantityUnit( @Nullable final String quantityUnit )
    {
        rememberChangedField("QuantityUnit", this.quantityUnit);
        this.quantityUnit = quantityUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Service</b>
     * </p>
     *
     * @param service
     *            Product
     */
    public void setService( @Nullable final String service )
    {
        rememberChangedField("Service", this.service);
        this.service = service;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ServiceEntrySheetItemDesc</b>
     * </p>
     *
     * @param serviceEntrySheetItemDesc
     *            Item Description for Service Entry Sheet
     */
    public void setServiceEntrySheetItemDesc( @Nullable final String serviceEntrySheetItemDesc )
    {
        rememberChangedField("ServiceEntrySheetItemDesc", this.serviceEntrySheetItemDesc);
        this.serviceEntrySheetItemDesc = serviceEntrySheetItemDesc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ServiceEntrySheetItemUUID</b>
     * </p>
     *
     * @param serviceEntrySheetItemUUID
     *            UUID serving as key (parent key, root key)
     */
    public void setServiceEntrySheetItemUUID( @Nullable final UUID serviceEntrySheetItemUUID )
    {
        rememberChangedField("ServiceEntrySheetItemUUID", this.serviceEntrySheetItemUUID);
        this.serviceEntrySheetItemUUID = serviceEntrySheetItemUUID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ServiceEntrySheetUUID</b>
     * </p>
     *
     * @param serviceEntrySheetUUID
     *            UUID serving as key (parent key, root key)
     */
    public void setServiceEntrySheetUUID( @Nullable final UUID serviceEntrySheetUUID )
    {
        rememberChangedField("ServiceEntrySheetUUID", this.serviceEntrySheetUUID);
        this.serviceEntrySheetUUID = serviceEntrySheetUUID;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ServicePerformanceDate</b>
     * </p>
     *
     * @param servicePerformanceDate
     *            Date of Service Performance
     */
    public void setServicePerformanceDate( @Nullable final LocalDateTime servicePerformanceDate )
    {
        rememberChangedField("ServicePerformanceDate", this.servicePerformanceDate);
        this.servicePerformanceDate = servicePerformanceDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ServicePerformanceEndDate</b>
     * </p>
     *
     * @param servicePerformanceEndDate
     *            End Date of Performance Period
     */
    public void setServicePerformanceEndDate( @Nullable final LocalDateTime servicePerformanceEndDate )
    {
        rememberChangedField("ServicePerformanceEndDate", this.servicePerformanceEndDate);
        this.servicePerformanceEndDate = servicePerformanceEndDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServicePerformer</b>
     * </p>
     *
     * @param servicePerformer
     *            Service Performer
     */
    public void setServicePerformer( @Nullable final String servicePerformer )
    {
        rememberChangedField("ServicePerformer", this.servicePerformer);
        this.servicePerformer = servicePerformer;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>WorkItem</b>
     * </p>
     *
     * @param workItem
     *            Work Item ID
     */
    public void setWorkItem( @Nullable final String workItem )
    {
        rememberChangedField("WorkItem", this.workItem);
        this.workItem = workItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>PurgDocItemExternalReference</b>
     * </p>
     *
     * @param purgDocItemExternalReference
     *            External Reference ID
     */
    public void setPurgDocItemExternalReference( @Nullable final String purgDocItemExternalReference )
    {
        rememberChangedField("PurgDocItemExternalReference", this.purgDocItemExternalReference);
        this.purgDocItemExternalReference = purgDocItemExternalReference;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SESItemIsFinalEntry</b>
     * </p>
     *
     * @param sESItemIsFinalEntry
     *            Final Entry
     */
    public void setSESItemIsFinalEntry( @Nullable final Boolean sESItemIsFinalEntry )
    {
        rememberChangedField("SESItemIsFinalEntry", this.sESItemIsFinalEntry);
        this.sESItemIsFinalEntry = sESItemIsFinalEntry;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>TaxCode</b>
     * </p>
     *
     * @param taxCode
     *            Tax on Sales/Purchases Code
     */
    public void setTaxCode( @Nullable final String taxCode )
    {
        rememberChangedField("TaxCode", this.taxCode);
        this.taxCode = taxCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>TaxCountry</b>
     * </p>
     *
     * @param taxCountry
     *            Tax Reporting Country/Region
     */
    public void setTaxCountry( @Nullable final String taxCountry )
    {
        rememberChangedField("TaxCountry", this.taxCountry);
        this.taxCountry = taxCountry;
    }

    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>TaxJurisdiction</b>
     * </p>
     *
     * @param taxJurisdiction
     *            Tax Jurisdiction
     */
    public void setTaxJurisdiction( @Nullable final String taxJurisdiction )
    {
        rememberChangedField("TaxJurisdiction", this.taxJurisdiction);
        this.taxJurisdiction = taxJurisdiction;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_ServiceEntrySheetItem";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ServiceEntrySheet", getServiceEntrySheet());
        result.put("ServiceEntrySheetItem", getServiceEntrySheetItem());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ServiceEntrySheet", getServiceEntrySheet());
        values.put("ServiceEntrySheetItem", getServiceEntrySheetItem());
        values.put("AccountAssignmentCategory", getAccountAssignmentCategory());
        values.put("ConfirmedQuantity", getConfirmedQuantity());
        values.put("CreatedByUser", getCreatedByUser());
        values.put("CreationDateTime", getCreationDateTime());
        values.put("PurchasingOrganization", getPurchasingOrganization());
        values.put("PurchasingGroup", getPurchasingGroup());
        values.put("Plant", getPlant());
        values.put("Currency", getCurrency());
        values.put("IsDeleted", getIsDeleted());
        values.put("LastChangeDateTime", getLastChangeDateTime());
        values.put("LastChangedByUser", getLastChangedByUser());
        values.put("MaterialGroup", getMaterialGroup());
        values.put("MultipleAcctAssgmtDistribution", getMultipleAcctAssgmtDistribution());
        values.put("NetAmount", getNetAmount());
        values.put("NetPriceAmount", getNetPriceAmount());
        values.put("OriginObject", getOriginObject());
        values.put("PurchaseOrder", getPurchaseOrder());
        values.put("PurchaseOrderItem", getPurchaseOrderItem());
        values.put("PurchaseContract", getPurchaseContract());
        values.put("PurchaseContractItem", getPurchaseContractItem());
        values.put("QuantityUnit", getQuantityUnit());
        values.put("Service", getService());
        values.put("ServiceEntrySheetItemDesc", getServiceEntrySheetItemDesc());
        values.put("ServiceEntrySheetItemUUID", getServiceEntrySheetItemUUID());
        values.put("ServiceEntrySheetUUID", getServiceEntrySheetUUID());
        values.put("ServicePerformanceDate", getServicePerformanceDate());
        values.put("ServicePerformanceEndDate", getServicePerformanceEndDate());
        values.put("ServicePerformer", getServicePerformer());
        values.put("WorkItem", getWorkItem());
        values.put("PurgDocItemExternalReference", getPurgDocItemExternalReference());
        values.put("SESItemIsFinalEntry", getSESItemIsFinalEntry());
        values.put("TaxCode", getTaxCode());
        values.put("TaxCountry", getTaxCountry());
        values.put("TaxJurisdiction", getTaxJurisdiction());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ServiceEntrySheet") ) {
                final Object value = values.remove("ServiceEntrySheet");
                if( (value == null) || (!value.equals(getServiceEntrySheet())) ) {
                    setServiceEntrySheet(((String) value));
                }
            }
            if( values.containsKey("ServiceEntrySheetItem") ) {
                final Object value = values.remove("ServiceEntrySheetItem");
                if( (value == null) || (!value.equals(getServiceEntrySheetItem())) ) {
                    setServiceEntrySheetItem(((String) value));
                }
            }
            if( values.containsKey("AccountAssignmentCategory") ) {
                final Object value = values.remove("AccountAssignmentCategory");
                if( (value == null) || (!value.equals(getAccountAssignmentCategory())) ) {
                    setAccountAssignmentCategory(((String) value));
                }
            }
            if( values.containsKey("ConfirmedQuantity") ) {
                final Object value = values.remove("ConfirmedQuantity");
                if( (value == null) || (!value.equals(getConfirmedQuantity())) ) {
                    setConfirmedQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("CreatedByUser") ) {
                final Object value = values.remove("CreatedByUser");
                if( (value == null) || (!value.equals(getCreatedByUser())) ) {
                    setCreatedByUser(((String) value));
                }
            }
            if( values.containsKey("CreationDateTime") ) {
                final Object value = values.remove("CreationDateTime");
                if( (value == null) || (!value.equals(getCreationDateTime())) ) {
                    setCreationDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("PurchasingOrganization") ) {
                final Object value = values.remove("PurchasingOrganization");
                if( (value == null) || (!value.equals(getPurchasingOrganization())) ) {
                    setPurchasingOrganization(((String) value));
                }
            }
            if( values.containsKey("PurchasingGroup") ) {
                final Object value = values.remove("PurchasingGroup");
                if( (value == null) || (!value.equals(getPurchasingGroup())) ) {
                    setPurchasingGroup(((String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("Currency") ) {
                final Object value = values.remove("Currency");
                if( (value == null) || (!value.equals(getCurrency())) ) {
                    setCurrency(((String) value));
                }
            }
            if( values.containsKey("IsDeleted") ) {
                final Object value = values.remove("IsDeleted");
                if( (value == null) || (!value.equals(getIsDeleted())) ) {
                    setIsDeleted(((String) value));
                }
            }
            if( values.containsKey("LastChangeDateTime") ) {
                final Object value = values.remove("LastChangeDateTime");
                if( (value == null) || (!value.equals(getLastChangeDateTime())) ) {
                    setLastChangeDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("LastChangedByUser") ) {
                final Object value = values.remove("LastChangedByUser");
                if( (value == null) || (!value.equals(getLastChangedByUser())) ) {
                    setLastChangedByUser(((String) value));
                }
            }
            if( values.containsKey("MaterialGroup") ) {
                final Object value = values.remove("MaterialGroup");
                if( (value == null) || (!value.equals(getMaterialGroup())) ) {
                    setMaterialGroup(((String) value));
                }
            }
            if( values.containsKey("MultipleAcctAssgmtDistribution") ) {
                final Object value = values.remove("MultipleAcctAssgmtDistribution");
                if( (value == null) || (!value.equals(getMultipleAcctAssgmtDistribution())) ) {
                    setMultipleAcctAssgmtDistribution(((String) value));
                }
            }
            if( values.containsKey("NetAmount") ) {
                final Object value = values.remove("NetAmount");
                if( (value == null) || (!value.equals(getNetAmount())) ) {
                    setNetAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("NetPriceAmount") ) {
                final Object value = values.remove("NetPriceAmount");
                if( (value == null) || (!value.equals(getNetPriceAmount())) ) {
                    setNetPriceAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("OriginObject") ) {
                final Object value = values.remove("OriginObject");
                if( (value == null) || (!value.equals(getOriginObject())) ) {
                    setOriginObject(((String) value));
                }
            }
            if( values.containsKey("PurchaseOrder") ) {
                final Object value = values.remove("PurchaseOrder");
                if( (value == null) || (!value.equals(getPurchaseOrder())) ) {
                    setPurchaseOrder(((String) value));
                }
            }
            if( values.containsKey("PurchaseOrderItem") ) {
                final Object value = values.remove("PurchaseOrderItem");
                if( (value == null) || (!value.equals(getPurchaseOrderItem())) ) {
                    setPurchaseOrderItem(((String) value));
                }
            }
            if( values.containsKey("PurchaseContract") ) {
                final Object value = values.remove("PurchaseContract");
                if( (value == null) || (!value.equals(getPurchaseContract())) ) {
                    setPurchaseContract(((String) value));
                }
            }
            if( values.containsKey("PurchaseContractItem") ) {
                final Object value = values.remove("PurchaseContractItem");
                if( (value == null) || (!value.equals(getPurchaseContractItem())) ) {
                    setPurchaseContractItem(((String) value));
                }
            }
            if( values.containsKey("QuantityUnit") ) {
                final Object value = values.remove("QuantityUnit");
                if( (value == null) || (!value.equals(getQuantityUnit())) ) {
                    setQuantityUnit(((String) value));
                }
            }
            if( values.containsKey("Service") ) {
                final Object value = values.remove("Service");
                if( (value == null) || (!value.equals(getService())) ) {
                    setService(((String) value));
                }
            }
            if( values.containsKey("ServiceEntrySheetItemDesc") ) {
                final Object value = values.remove("ServiceEntrySheetItemDesc");
                if( (value == null) || (!value.equals(getServiceEntrySheetItemDesc())) ) {
                    setServiceEntrySheetItemDesc(((String) value));
                }
            }
            if( values.containsKey("ServiceEntrySheetItemUUID") ) {
                final Object value = values.remove("ServiceEntrySheetItemUUID");
                if( (value == null) || (!value.equals(getServiceEntrySheetItemUUID())) ) {
                    setServiceEntrySheetItemUUID(((UUID) value));
                }
            }
            if( values.containsKey("ServiceEntrySheetUUID") ) {
                final Object value = values.remove("ServiceEntrySheetUUID");
                if( (value == null) || (!value.equals(getServiceEntrySheetUUID())) ) {
                    setServiceEntrySheetUUID(((UUID) value));
                }
            }
            if( values.containsKey("ServicePerformanceDate") ) {
                final Object value = values.remove("ServicePerformanceDate");
                if( (value == null) || (!value.equals(getServicePerformanceDate())) ) {
                    setServicePerformanceDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ServicePerformanceEndDate") ) {
                final Object value = values.remove("ServicePerformanceEndDate");
                if( (value == null) || (!value.equals(getServicePerformanceEndDate())) ) {
                    setServicePerformanceEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ServicePerformer") ) {
                final Object value = values.remove("ServicePerformer");
                if( (value == null) || (!value.equals(getServicePerformer())) ) {
                    setServicePerformer(((String) value));
                }
            }
            if( values.containsKey("WorkItem") ) {
                final Object value = values.remove("WorkItem");
                if( (value == null) || (!value.equals(getWorkItem())) ) {
                    setWorkItem(((String) value));
                }
            }
            if( values.containsKey("PurgDocItemExternalReference") ) {
                final Object value = values.remove("PurgDocItemExternalReference");
                if( (value == null) || (!value.equals(getPurgDocItemExternalReference())) ) {
                    setPurgDocItemExternalReference(((String) value));
                }
            }
            if( values.containsKey("SESItemIsFinalEntry") ) {
                final Object value = values.remove("SESItemIsFinalEntry");
                if( (value == null) || (!value.equals(getSESItemIsFinalEntry())) ) {
                    setSESItemIsFinalEntry(((Boolean) value));
                }
            }
            if( values.containsKey("TaxCode") ) {
                final Object value = values.remove("TaxCode");
                if( (value == null) || (!value.equals(getTaxCode())) ) {
                    setTaxCode(((String) value));
                }
            }
            if( values.containsKey("TaxCountry") ) {
                final Object value = values.remove("TaxCountry");
                if( (value == null) || (!value.equals(getTaxCountry())) ) {
                    setTaxCountry(((String) value));
                }
            }
            if( values.containsKey("TaxJurisdiction") ) {
                final Object value = values.remove("TaxJurisdiction");
                if( (value == null) || (!value.equals(getTaxJurisdiction())) ) {
                    setTaxJurisdiction(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_AccountAssignment") ) {
                final Object value = (values).remove("to_AccountAssignment");
                if( value instanceof Iterable ) {
                    if( toAccountAssignment == null ) {
                        toAccountAssignment = Lists.newArrayList();
                    } else {
                        toAccountAssignment = Lists.newArrayList(toAccountAssignment);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SrvcEntrShtAcctAssignment entity;
                        if( toAccountAssignment.size() > i ) {
                            entity = toAccountAssignment.get(i);
                        } else {
                            entity = new SrvcEntrShtAcctAssignment();
                            toAccountAssignment.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> ServiceEntrySheetItemField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ServiceEntrySheetItemField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ServiceEntrySheetItemField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ServiceEntrySheetItemField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ServiceEntrySheetService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toAccountAssignment != null ) {
            (values).put("to_AccountAssignment", toAccountAssignment);
        }
        return values;
    }

    /**
     * Fetches the <b>SrvcEntrShtAcctAssignment</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_AccountAssignment</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SrvcEntrShtAcctAssignment</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SrvcEntrShtAcctAssignment> fetchAccountAssignment()
    {
        return fetchFieldAsList("to_AccountAssignment", SrvcEntrShtAcctAssignment.class);
    }

    /**
     * Retrieval of associated <b>SrvcEntrShtAcctAssignment</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_AccountAssignment</b>.
     * <p>
     * If the navigation property <b>to_AccountAssignment</b> of a queried <b>ServiceEntrySheetItem</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SrvcEntrShtAcctAssignment</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SrvcEntrShtAcctAssignment> getAccountAssignmentOrFetch()
    {
        if( toAccountAssignment == null ) {
            toAccountAssignment = fetchAccountAssignment();
        }
        return toAccountAssignment;
    }

    /**
     * Retrieval of associated <b>SrvcEntrShtAcctAssignment</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_AccountAssignment</b>.
     * <p>
     * If the navigation property for an entity <b>ServiceEntrySheetItem</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_AccountAssignment</b> is already loaded, the result will
     *         contain the <b>SrvcEntrShtAcctAssignment</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SrvcEntrShtAcctAssignment>> getAccountAssignmentIfPresent()
    {
        return Option.of(toAccountAssignment);
    }

    /**
     * Overwrites the list of associated <b>SrvcEntrShtAcctAssignment</b> entities for the loaded navigation property
     * <b>to_AccountAssignment</b>.
     * <p>
     * If the navigation property <b>to_AccountAssignment</b> of a queried <b>ServiceEntrySheetItem</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SrvcEntrShtAcctAssignment</b> entities.
     */
    public void setAccountAssignment( @Nonnull final List<SrvcEntrShtAcctAssignment> value )
    {
        if( toAccountAssignment == null ) {
            toAccountAssignment = Lists.newArrayList();
        }
        toAccountAssignment.clear();
        toAccountAssignment.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SrvcEntrShtAcctAssignment</b> entities. This corresponds to the OData
     * navigation property <b>to_AccountAssignment</b>.
     * <p>
     * If the navigation property <b>to_AccountAssignment</b> of a queried <b>ServiceEntrySheetItem</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SrvcEntrShtAcctAssignment</b> entities.
     */
    public void addAccountAssignment( SrvcEntrShtAcctAssignment... entity )
    {
        if( toAccountAssignment == null ) {
            toAccountAssignment = Lists.newArrayList();
        }
        toAccountAssignment.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of ServiceEntrySheetItem instances.
     *
     */
    public final static class ServiceEntrySheetItemBuilder
    {

        private List<SrvcEntrShtAcctAssignment> toAccountAssignment = Lists.newArrayList();

        private ServiceEntrySheetItem.ServiceEntrySheetItemBuilder toAccountAssignment(
            final List<SrvcEntrShtAcctAssignment> value )
        {
            toAccountAssignment.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_AccountAssignment</b> for <b>ServiceEntrySheetItem</b> to multiple
         * <b>SrvcEntrShtAcctAssignment</b>.
         *
         * @param value
         *            The SrvcEntrShtAcctAssignments to build this ServiceEntrySheetItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ServiceEntrySheetItem.ServiceEntrySheetItemBuilder accountAssignment(
            SrvcEntrShtAcctAssignment... value )
        {
            return toAccountAssignment(Lists.newArrayList(value));
        }

    }

}
