/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet;

import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.field.SrvcEntrShtAcctAssignmentField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.selectable.SrvcEntrShtAcctAssignmentSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Account Assignment
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_SrvcEntrShtAcctAssignmentType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SrvcEntrShtAcctAssignment extends VdmEntity<SrvcEntrShtAcctAssignment>
{

    /**
     * Selector for all available fields of SrvcEntrShtAcctAssignment.
     *
     */
    public final static SrvcEntrShtAcctAssignmentSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServiceEntrySheet</b>
     * </p>
     *
     * @return Service Entry Sheet
     */
    @Key
    @SerializedName( "ServiceEntrySheet" )
    @JsonProperty( "ServiceEntrySheet" )
    @Nullable
    @ODataField( odataName = "ServiceEntrySheet" )
    private String serviceEntrySheet;
    /**
     * Use with available fluent helpers to apply the <b>ServiceEntrySheet</b> field to query operations.
     *
     */
    public final static SrvcEntrShtAcctAssignmentField<String> SERVICE_ENTRY_SHEET =
        new SrvcEntrShtAcctAssignmentField<String>("ServiceEntrySheet");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ServiceEntrySheetItem</b>
     * </p>
     *
     * @return Item Number of Service Entry Sheet
     */
    @Key
    @SerializedName( "ServiceEntrySheetItem" )
    @JsonProperty( "ServiceEntrySheetItem" )
    @Nullable
    @ODataField( odataName = "ServiceEntrySheetItem" )
    private String serviceEntrySheetItem;
    /**
     * Use with available fluent helpers to apply the <b>ServiceEntrySheetItem</b> field to query operations.
     *
     */
    public final static SrvcEntrShtAcctAssignmentField<String> SERVICE_ENTRY_SHEET_ITEM =
        new SrvcEntrShtAcctAssignmentField<String>("ServiceEntrySheetItem");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>AccountAssignment</b>
     * </p>
     *
     * @return Sequential Number of Account Assignment
     */
    @Key
    @SerializedName( "AccountAssignment" )
    @JsonProperty( "AccountAssignment" )
    @Nullable
    @ODataField( odataName = "AccountAssignment" )
    private String accountAssignment;
    /**
     * Use with available fluent helpers to apply the <b>AccountAssignment</b> field to query operations.
     *
     */
    public final static SrvcEntrShtAcctAssignmentField<String> ACCOUNT_ASSIGNMENT =
        new SrvcEntrShtAcctAssignmentField<String>("AccountAssignment");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>AccountAssignmentUUID</b>
     * </p>
     *
     * @return UUID serving as key (parent key, root key)
     */
    @SerializedName( "AccountAssignmentUUID" )
    @JsonProperty( "AccountAssignmentUUID" )
    @Nullable
    @ODataField( odataName = "AccountAssignmentUUID" )
    private UUID accountAssignmentUUID;
    /**
     * Use with available fluent helpers to apply the <b>AccountAssignmentUUID</b> field to query operations.
     *
     */
    public final static SrvcEntrShtAcctAssignmentField<UUID> ACCOUNT_ASSIGNMENT_UUID =
        new SrvcEntrShtAcctAssignmentField<UUID>("AccountAssignmentUUID");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingOrganization</b>
     * </p>
     *
     * @return Purchasing Organization
     */
    @SerializedName( "PurchasingOrganization" )
    @JsonProperty( "PurchasingOrganization" )
    @Nullable
    @ODataField( odataName = "PurchasingOrganization" )
    private String purchasingOrganization;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingOrganization</b> field to query operations.
     *
     */
    public final static SrvcEntrShtAcctAssignmentField<String> PURCHASING_ORGANIZATION =
        new SrvcEntrShtAcctAssignmentField<String>("PurchasingOrganization");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingGroup</b>
     * </p>
     *
     * @return Purchasing Group
     */
    @SerializedName( "PurchasingGroup" )
    @JsonProperty( "PurchasingGroup" )
    @Nullable
    @ODataField( odataName = "PurchasingGroup" )
    private String purchasingGroup;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingGroup</b> field to query operations.
     *
     */
    public final static SrvcEntrShtAcctAssignmentField<String> PURCHASING_GROUP =
        new SrvcEntrShtAcctAssignmentField<String>("PurchasingGroup");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Plant
     */
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static SrvcEntrShtAcctAssignmentField<String> PLANT =
        new SrvcEntrShtAcctAssignmentField<String>("Plant");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusinessArea</b>
     * </p>
     *
     * @return Business Area
     */
    @SerializedName( "BusinessArea" )
    @JsonProperty( "BusinessArea" )
    @Nullable
    @ODataField( odataName = "BusinessArea" )
    private String businessArea;
    /**
     * Use with available fluent helpers to apply the <b>BusinessArea</b> field to query operations.
     *
     */
    public final static SrvcEntrShtAcctAssignmentField<String> BUSINESS_AREA =
        new SrvcEntrShtAcctAssignmentField<String>("BusinessArea");
    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>CommitmentItem</b>
     * </p>
     *
     * @return Commitment Item
     */
    @SerializedName( "CommitmentItem" )
    @JsonProperty( "CommitmentItem" )
    @Nullable
    @ODataField( odataName = "CommitmentItem" )
    private String commitmentItem;
    /**
     * Use with available fluent helpers to apply the <b>CommitmentItem</b> field to query operations.
     *
     */
    public final static SrvcEntrShtAcctAssignmentField<String> COMMITMENT_ITEM =
        new SrvcEntrShtAcctAssignmentField<String>("CommitmentItem");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea</b>
     * </p>
     *
     * @return Controlling Area
     */
    @SerializedName( "ControllingArea" )
    @JsonProperty( "ControllingArea" )
    @Nullable
    @ODataField( odataName = "ControllingArea" )
    private String controllingArea;
    /**
     * Use with available fluent helpers to apply the <b>ControllingArea</b> field to query operations.
     *
     */
    public final static SrvcEntrShtAcctAssignmentField<String> CONTROLLING_AREA =
        new SrvcEntrShtAcctAssignmentField<String>("ControllingArea");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CostCenter</b>
     * </p>
     *
     * @return Cost Center
     */
    @SerializedName( "CostCenter" )
    @JsonProperty( "CostCenter" )
    @Nullable
    @ODataField( odataName = "CostCenter" )
    private String costCenter;
    /**
     * Use with available fluent helpers to apply the <b>CostCenter</b> field to query operations.
     *
     */
    public final static SrvcEntrShtAcctAssignmentField<String> COST_CENTER =
        new SrvcEntrShtAcctAssignmentField<String>("CostCenter");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CostObject</b>
     * </p>
     *
     * @return Cost Object
     */
    @SerializedName( "CostObject" )
    @JsonProperty( "CostObject" )
    @Nullable
    @ODataField( odataName = "CostObject" )
    private String costObject;
    /**
     * Use with available fluent helpers to apply the <b>CostObject</b> field to query operations.
     *
     */
    public final static SrvcEntrShtAcctAssignmentField<String> COST_OBJECT =
        new SrvcEntrShtAcctAssignmentField<String>("CostObject");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @return User Name
     */
    @SerializedName( "CreatedByUser" )
    @JsonProperty( "CreatedByUser" )
    @Nullable
    @ODataField( odataName = "CreatedByUser" )
    private String createdByUser;
    /**
     * Use with available fluent helpers to apply the <b>CreatedByUser</b> field to query operations.
     *
     */
    public final static SrvcEntrShtAcctAssignmentField<String> CREATED_BY_USER =
        new SrvcEntrShtAcctAssignmentField<String>("CreatedByUser");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>CreationDateTime</b>
     * </p>
     *
     * @return UTC Time Stamp in Long Form (YYYYMMDDhhmmssmmmuuun)
     */
    @SerializedName( "CreationDateTime" )
    @JsonProperty( "CreationDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "CreationDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime creationDateTime;
    /**
     * Use with available fluent helpers to apply the <b>CreationDateTime</b> field to query operations.
     *
     */
    public final static SrvcEntrShtAcctAssignmentField<ZonedDateTime> CREATION_DATE_TIME =
        new SrvcEntrShtAcctAssignmentField<ZonedDateTime>("CreationDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>EarmarkedFundsDocument</b>
     * </p>
     *
     * @return Document Number for Earmarked Funds
     */
    @SerializedName( "EarmarkedFundsDocument" )
    @JsonProperty( "EarmarkedFundsDocument" )
    @Nullable
    @ODataField( odataName = "EarmarkedFundsDocument" )
    private String earmarkedFundsDocument;
    /**
     * Use with available fluent helpers to apply the <b>EarmarkedFundsDocument</b> field to query operations.
     *
     */
    public final static SrvcEntrShtAcctAssignmentField<String> EARMARKED_FUNDS_DOCUMENT =
        new SrvcEntrShtAcctAssignmentField<String>("EarmarkedFundsDocument");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FixedAsset</b>
     * </p>
     *
     * @return Asset Subnumber
     */
    @SerializedName( "FixedAsset" )
    @JsonProperty( "FixedAsset" )
    @Nullable
    @ODataField( odataName = "FixedAsset" )
    private String fixedAsset;
    /**
     * Use with available fluent helpers to apply the <b>FixedAsset</b> field to query operations.
     *
     */
    public final static SrvcEntrShtAcctAssignmentField<String> FIXED_ASSET =
        new SrvcEntrShtAcctAssignmentField<String>("FixedAsset");
    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalArea</b>
     * </p>
     *
     * @return Functional Area
     */
    @SerializedName( "FunctionalArea" )
    @JsonProperty( "FunctionalArea" )
    @Nullable
    @ODataField( odataName = "FunctionalArea" )
    private String functionalArea;
    /**
     * Use with available fluent helpers to apply the <b>FunctionalArea</b> field to query operations.
     *
     */
    public final static SrvcEntrShtAcctAssignmentField<String> FUNCTIONAL_AREA =
        new SrvcEntrShtAcctAssignmentField<String>("FunctionalArea");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Fund</b>
     * </p>
     *
     * @return Fund
     */
    @SerializedName( "Fund" )
    @JsonProperty( "Fund" )
    @Nullable
    @ODataField( odataName = "Fund" )
    private String fund;
    /**
     * Use with available fluent helpers to apply the <b>Fund</b> field to query operations.
     *
     */
    public final static SrvcEntrShtAcctAssignmentField<String> FUND =
        new SrvcEntrShtAcctAssignmentField<String>("Fund");
    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>FundsCenter</b>
     * </p>
     *
     * @return Funds Center
     */
    @SerializedName( "FundsCenter" )
    @JsonProperty( "FundsCenter" )
    @Nullable
    @ODataField( odataName = "FundsCenter" )
    private String fundsCenter;
    /**
     * Use with available fluent helpers to apply the <b>FundsCenter</b> field to query operations.
     *
     */
    public final static SrvcEntrShtAcctAssignmentField<String> FUNDS_CENTER =
        new SrvcEntrShtAcctAssignmentField<String>("FundsCenter");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>GLAccount</b>
     * </p>
     *
     * @return G/L Account Number
     */
    @SerializedName( "GLAccount" )
    @JsonProperty( "GLAccount" )
    @Nullable
    @ODataField( odataName = "GLAccount" )
    private String gLAccount;
    /**
     * Use with available fluent helpers to apply the <b>GLAccount</b> field to query operations.
     *
     */
    public final static SrvcEntrShtAcctAssignmentField<String> GL_ACCOUNT =
        new SrvcEntrShtAcctAssignmentField<String>("GLAccount");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsDeleted</b>
     * </p>
     *
     * @return Deletion Indicator: Purchasing Document Account Assignment
     */
    @SerializedName( "IsDeleted" )
    @JsonProperty( "IsDeleted" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsDeleted" )
    private Boolean isDeleted;
    /**
     * Use with available fluent helpers to apply the <b>IsDeleted</b> field to query operations.
     *
     */
    public final static SrvcEntrShtAcctAssignmentField<Boolean> IS_DELETED =
        new SrvcEntrShtAcctAssignmentField<Boolean>("IsDeleted");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @return UTC Time Stamp in Long Form (YYYYMMDDhhmmssmmmuuun)
     */
    @SerializedName( "LastChangeDateTime" )
    @JsonProperty( "LastChangeDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime lastChangeDateTime;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDateTime</b> field to query operations.
     *
     */
    public final static SrvcEntrShtAcctAssignmentField<ZonedDateTime> LAST_CHANGE_DATE_TIME =
        new SrvcEntrShtAcctAssignmentField<ZonedDateTime>("LastChangeDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @return User Name
     */
    @SerializedName( "LastChangedByUser" )
    @JsonProperty( "LastChangedByUser" )
    @Nullable
    @ODataField( odataName = "LastChangedByUser" )
    private String lastChangedByUser;
    /**
     * Use with available fluent helpers to apply the <b>LastChangedByUser</b> field to query operations.
     *
     */
    public final static SrvcEntrShtAcctAssignmentField<String> LAST_CHANGED_BY_USER =
        new SrvcEntrShtAcctAssignmentField<String>("LastChangedByUser");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MasterFixedAsset</b>
     * </p>
     *
     * @return Main Asset Number
     */
    @SerializedName( "MasterFixedAsset" )
    @JsonProperty( "MasterFixedAsset" )
    @Nullable
    @ODataField( odataName = "MasterFixedAsset" )
    private String masterFixedAsset;
    /**
     * Use with available fluent helpers to apply the <b>MasterFixedAsset</b> field to query operations.
     *
     */
    public final static SrvcEntrShtAcctAssignmentField<String> MASTER_FIXED_ASSET =
        new SrvcEntrShtAcctAssignmentField<String>("MasterFixedAsset");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 1
     * <p>
     * Original property name from the Odata EDM: <b>MultipleAcctAssgmtDistrPercent</b>
     * </p>
     *
     * @return Distribution percentage in the case of multiple acct assgt
     */
    @SerializedName( "MultipleAcctAssgmtDistrPercent" )
    @JsonProperty( "MultipleAcctAssgmtDistrPercent" )
    @Nullable
    @ODataField( odataName = "MultipleAcctAssgmtDistrPercent" )
    private BigDecimal multipleAcctAssgmtDistrPercent;
    /**
     * Use with available fluent helpers to apply the <b>MultipleAcctAssgmtDistrPercent</b> field to query operations.
     *
     */
    public final static SrvcEntrShtAcctAssignmentField<BigDecimal> MULTIPLE_ACCT_ASSGMT_DISTR_PERCENT =
        new SrvcEntrShtAcctAssignmentField<BigDecimal>("MultipleAcctAssgmtDistrPercent");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>NetworkActivityInternalID</b>
     * </p>
     *
     * @return Internal counter
     */
    @SerializedName( "NetworkActivityInternalID" )
    @JsonProperty( "NetworkActivityInternalID" )
    @Nullable
    @ODataField( odataName = "NetworkActivityInternalID" )
    private String networkActivityInternalID;
    /**
     * Use with available fluent helpers to apply the <b>NetworkActivityInternalID</b> field to query operations.
     *
     */
    public final static SrvcEntrShtAcctAssignmentField<String> NETWORK_ACTIVITY_INTERNAL_ID =
        new SrvcEntrShtAcctAssignmentField<String>("NetworkActivityInternalID");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>OrderID</b>
     * </p>
     *
     * @return Order Number
     */
    @SerializedName( "OrderID" )
    @JsonProperty( "OrderID" )
    @Nullable
    @ODataField( odataName = "OrderID" )
    private String orderID;
    /**
     * Use with available fluent helpers to apply the <b>OrderID</b> field to query operations.
     *
     */
    public final static SrvcEntrShtAcctAssignmentField<String> ORDER_ID =
        new SrvcEntrShtAcctAssignmentField<String>("OrderID");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PartnerAccountNumber</b>
     * </p>
     *
     * @return Partner account number
     */
    @SerializedName( "PartnerAccountNumber" )
    @JsonProperty( "PartnerAccountNumber" )
    @Nullable
    @ODataField( odataName = "PartnerAccountNumber" )
    private String partnerAccountNumber;
    /**
     * Use with available fluent helpers to apply the <b>PartnerAccountNumber</b> field to query operations.
     *
     */
    public final static SrvcEntrShtAcctAssignmentField<String> PARTNER_ACCOUNT_NUMBER =
        new SrvcEntrShtAcctAssignmentField<String>("PartnerAccountNumber");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenter</b>
     * </p>
     *
     * @return Profit Center
     */
    @SerializedName( "ProfitCenter" )
    @JsonProperty( "ProfitCenter" )
    @Nullable
    @ODataField( odataName = "ProfitCenter" )
    private String profitCenter;
    /**
     * Use with available fluent helpers to apply the <b>ProfitCenter</b> field to query operations.
     *
     */
    public final static SrvcEntrShtAcctAssignmentField<String> PROFIT_CENTER =
        new SrvcEntrShtAcctAssignmentField<String>("ProfitCenter");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProfitabilitySegment</b>
     * </p>
     *
     * @return Profitability Segment Number (CO-PA)
     */
    @SerializedName( "ProfitabilitySegment" )
    @JsonProperty( "ProfitabilitySegment" )
    @Nullable
    @ODataField( odataName = "ProfitabilitySegment" )
    private String profitabilitySegment;
    /**
     * Use with available fluent helpers to apply the <b>ProfitabilitySegment</b> field to query operations.
     *
     */
    public final static SrvcEntrShtAcctAssignmentField<String> PROFITABILITY_SEGMENT =
        new SrvcEntrShtAcctAssignmentField<String>("ProfitabilitySegment");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ProjectNetwork</b>
     * </p>
     *
     * @return Network Number for Account Assignment
     */
    @SerializedName( "ProjectNetwork" )
    @JsonProperty( "ProjectNetwork" )
    @Nullable
    @ODataField( odataName = "ProjectNetwork" )
    private String projectNetwork;
    /**
     * Use with available fluent helpers to apply the <b>ProjectNetwork</b> field to query operations.
     *
     */
    public final static SrvcEntrShtAcctAssignmentField<String> PROJECT_NETWORK =
        new SrvcEntrShtAcctAssignmentField<String>("ProjectNetwork");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProjectNetworkInternalID</b>
     * </p>
     *
     * @return Routing number of operations in the order
     */
    @SerializedName( "ProjectNetworkInternalID" )
    @JsonProperty( "ProjectNetworkInternalID" )
    @Nullable
    @ODataField( odataName = "ProjectNetworkInternalID" )
    private String projectNetworkInternalID;
    /**
     * Use with available fluent helpers to apply the <b>ProjectNetworkInternalID</b> field to query operations.
     *
     */
    public final static SrvcEntrShtAcctAssignmentField<String> PROJECT_NETWORK_INTERNAL_ID =
        new SrvcEntrShtAcctAssignmentField<String>("ProjectNetworkInternalID");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>Quantity</b>
     * </p>
     *
     * @return Quantity
     */
    @SerializedName( "Quantity" )
    @JsonProperty( "Quantity" )
    @Nullable
    @ODataField( odataName = "Quantity" )
    private BigDecimal quantity;
    /**
     * Use with available fluent helpers to apply the <b>Quantity</b> field to query operations.
     *
     */
    public final static SrvcEntrShtAcctAssignmentField<BigDecimal> QUANTITY =
        new SrvcEntrShtAcctAssignmentField<BigDecimal>("Quantity");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>QuantityUnit</b>
     * </p>
     *
     * @return Unit of Measure for Service Entry Statement
     */
    @SerializedName( "QuantityUnit" )
    @JsonProperty( "QuantityUnit" )
    @Nullable
    @ODataField( odataName = "QuantityUnit" )
    private String quantityUnit;
    /**
     * Use with available fluent helpers to apply the <b>QuantityUnit</b> field to query operations.
     *
     */
    public final static SrvcEntrShtAcctAssignmentField<String> QUANTITY_UNIT =
        new SrvcEntrShtAcctAssignmentField<String>("QuantityUnit");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>RealEstateObject</b>
     * </p>
     *
     * @return Internal Key for Real Estate Object
     */
    @SerializedName( "RealEstateObject" )
    @JsonProperty( "RealEstateObject" )
    @Nullable
    @ODataField( odataName = "RealEstateObject" )
    private String realEstateObject;
    /**
     * Use with available fluent helpers to apply the <b>RealEstateObject</b> field to query operations.
     *
     */
    public final static SrvcEntrShtAcctAssignmentField<String> REAL_ESTATE_OBJECT =
        new SrvcEntrShtAcctAssignmentField<String>("RealEstateObject");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>RefDocAccountAssignment</b>
     * </p>
     *
     * @return Account Assignment Number of the Referenced PO Item
     */
    @SerializedName( "RefDocAccountAssignment" )
    @JsonProperty( "RefDocAccountAssignment" )
    @Nullable
    @ODataField( odataName = "RefDocAccountAssignment" )
    private String refDocAccountAssignment;
    /**
     * Use with available fluent helpers to apply the <b>RefDocAccountAssignment</b> field to query operations.
     *
     */
    public final static SrvcEntrShtAcctAssignmentField<String> REF_DOC_ACCOUNT_ASSIGNMENT =
        new SrvcEntrShtAcctAssignmentField<String>("RefDocAccountAssignment");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrder</b>
     * </p>
     *
     * @return Sales and Distribution Document Number
     */
    @SerializedName( "SalesOrder" )
    @JsonProperty( "SalesOrder" )
    @Nullable
    @ODataField( odataName = "SalesOrder" )
    private String salesOrder;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrder</b> field to query operations.
     *
     */
    public final static SrvcEntrShtAcctAssignmentField<String> SALES_ORDER =
        new SrvcEntrShtAcctAssignmentField<String>("SalesOrder");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderItem</b>
     * </p>
     *
     * @return Sales Document Item
     */
    @SerializedName( "SalesOrderItem" )
    @JsonProperty( "SalesOrderItem" )
    @Nullable
    @ODataField( odataName = "SalesOrderItem" )
    private String salesOrderItem;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrderItem</b> field to query operations.
     *
     */
    public final static SrvcEntrShtAcctAssignmentField<String> SALES_ORDER_ITEM =
        new SrvcEntrShtAcctAssignmentField<String>("SalesOrderItem");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderScheduleLine</b>
     * </p>
     *
     * @return Schedule Line Number
     */
    @SerializedName( "SalesOrderScheduleLine" )
    @JsonProperty( "SalesOrderScheduleLine" )
    @Nullable
    @ODataField( odataName = "SalesOrderScheduleLine" )
    private String salesOrderScheduleLine;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrderScheduleLine</b> field to query operations.
     *
     */
    public final static SrvcEntrShtAcctAssignmentField<String> SALES_ORDER_SCHEDULE_LINE =
        new SrvcEntrShtAcctAssignmentField<String>("SalesOrderScheduleLine");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ServiceEntrySheetItemUUID</b>
     * </p>
     *
     * @return UUID serving as key (parent key, root key)
     */
    @SerializedName( "ServiceEntrySheetItemUUID" )
    @JsonProperty( "ServiceEntrySheetItemUUID" )
    @Nullable
    @ODataField( odataName = "ServiceEntrySheetItemUUID" )
    private UUID serviceEntrySheetItemUUID;
    /**
     * Use with available fluent helpers to apply the <b>ServiceEntrySheetItemUUID</b> field to query operations.
     *
     */
    public final static SrvcEntrShtAcctAssignmentField<UUID> SERVICE_ENTRY_SHEET_ITEM_UUID =
        new SrvcEntrShtAcctAssignmentField<UUID>("ServiceEntrySheetItemUUID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ServiceEntrySheetUUID</b>
     * </p>
     *
     * @return UUID serving as key (parent key, root key)
     */
    @SerializedName( "ServiceEntrySheetUUID" )
    @JsonProperty( "ServiceEntrySheetUUID" )
    @Nullable
    @ODataField( odataName = "ServiceEntrySheetUUID" )
    private UUID serviceEntrySheetUUID;
    /**
     * Use with available fluent helpers to apply the <b>ServiceEntrySheetUUID</b> field to query operations.
     *
     */
    public final static SrvcEntrShtAcctAssignmentField<UUID> SERVICE_ENTRY_SHEET_UUID =
        new SrvcEntrShtAcctAssignmentField<UUID>("ServiceEntrySheetUUID");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>WBSElementInternalID</b>
     * </p>
     *
     * @return WBS Element
     */
    @SerializedName( "WBSElementInternalID" )
    @JsonProperty( "WBSElementInternalID" )
    @Nullable
    @ODataField( odataName = "WBSElementInternalID" )
    private String wBSElementInternalID;
    /**
     * Use with available fluent helpers to apply the <b>WBSElementInternalID</b> field to query operations.
     *
     */
    public final static SrvcEntrShtAcctAssignmentField<String> WBS_ELEMENT_INTERNAL_ID =
        new SrvcEntrShtAcctAssignmentField<String>("WBSElementInternalID");
    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>WBSElement</b>
     * </p>
     *
     * @return Work Breakdown Structure Element (WBS Element)
     */
    @SerializedName( "WBSElement" )
    @JsonProperty( "WBSElement" )
    @Nullable
    @ODataField( odataName = "WBSElement" )
    private String wBSElement;
    /**
     * Use with available fluent helpers to apply the <b>WBSElement</b> field to query operations.
     *
     */
    public final static SrvcEntrShtAcctAssignmentField<String> WBS_ELEMENT =
        new SrvcEntrShtAcctAssignmentField<String>("WBSElement");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocumentType</b>
     * </p>
     *
     * @return Service Document Type
     */
    @SerializedName( "ServiceDocumentType" )
    @JsonProperty( "ServiceDocumentType" )
    @Nullable
    @ODataField( odataName = "ServiceDocumentType" )
    private String serviceDocumentType;
    /**
     * Use with available fluent helpers to apply the <b>ServiceDocumentType</b> field to query operations.
     *
     */
    public final static SrvcEntrShtAcctAssignmentField<String> SERVICE_DOCUMENT_TYPE =
        new SrvcEntrShtAcctAssignmentField<String>("ServiceDocumentType");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocument</b>
     * </p>
     *
     * @return Service Document ID
     */
    @SerializedName( "ServiceDocument" )
    @JsonProperty( "ServiceDocument" )
    @Nullable
    @ODataField( odataName = "ServiceDocument" )
    private String serviceDocument;
    /**
     * Use with available fluent helpers to apply the <b>ServiceDocument</b> field to query operations.
     *
     */
    public final static SrvcEntrShtAcctAssignmentField<String> SERVICE_DOCUMENT =
        new SrvcEntrShtAcctAssignmentField<String>("ServiceDocument");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocumentItem</b>
     * </p>
     *
     * @return Service Document Item ID
     */
    @SerializedName( "ServiceDocumentItem" )
    @JsonProperty( "ServiceDocumentItem" )
    @Nullable
    @ODataField( odataName = "ServiceDocumentItem" )
    private String serviceDocumentItem;
    /**
     * Use with available fluent helpers to apply the <b>ServiceDocumentItem</b> field to query operations.
     *
     */
    public final static SrvcEntrShtAcctAssignmentField<String> SERVICE_DOCUMENT_ITEM =
        new SrvcEntrShtAcctAssignmentField<String>("ServiceDocumentItem");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>Currency</b>
     * </p>
     *
     * @return Currency Key
     */
    @SerializedName( "Currency" )
    @JsonProperty( "Currency" )
    @Nullable
    @ODataField( odataName = "Currency" )
    private String currency;
    /**
     * Use with available fluent helpers to apply the <b>Currency</b> field to query operations.
     *
     */
    public final static SrvcEntrShtAcctAssignmentField<String> CURRENCY =
        new SrvcEntrShtAcctAssignmentField<String>("Currency");
    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>NetAmount</b>
     * </p>
     *
     * @return Net Amount in Transaction Currency
     */
    @SerializedName( "NetAmount" )
    @JsonProperty( "NetAmount" )
    @Nullable
    @ODataField( odataName = "NetAmount" )
    private BigDecimal netAmount;
    /**
     * Use with available fluent helpers to apply the <b>NetAmount</b> field to query operations.
     *
     */
    public final static SrvcEntrShtAcctAssignmentField<BigDecimal> NET_AMOUNT =
        new SrvcEntrShtAcctAssignmentField<BigDecimal>("NetAmount");

    @Nonnull
    @Override
    public Class<SrvcEntrShtAcctAssignment> getType()
    {
        return SrvcEntrShtAcctAssignment.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServiceEntrySheet</b>
     * </p>
     *
     * @param serviceEntrySheet
     *            Service Entry Sheet
     */
    public void setServiceEntrySheet( @Nullable final String serviceEntrySheet )
    {
        rememberChangedField("ServiceEntrySheet", this.serviceEntrySheet);
        this.serviceEntrySheet = serviceEntrySheet;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ServiceEntrySheetItem</b>
     * </p>
     *
     * @param serviceEntrySheetItem
     *            Item Number of Service Entry Sheet
     */
    public void setServiceEntrySheetItem( @Nullable final String serviceEntrySheetItem )
    {
        rememberChangedField("ServiceEntrySheetItem", this.serviceEntrySheetItem);
        this.serviceEntrySheetItem = serviceEntrySheetItem;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>AccountAssignment</b>
     * </p>
     *
     * @param accountAssignment
     *            Sequential Number of Account Assignment
     */
    public void setAccountAssignment( @Nullable final String accountAssignment )
    {
        rememberChangedField("AccountAssignment", this.accountAssignment);
        this.accountAssignment = accountAssignment;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>AccountAssignmentUUID</b>
     * </p>
     *
     * @param accountAssignmentUUID
     *            UUID serving as key (parent key, root key)
     */
    public void setAccountAssignmentUUID( @Nullable final UUID accountAssignmentUUID )
    {
        rememberChangedField("AccountAssignmentUUID", this.accountAssignmentUUID);
        this.accountAssignmentUUID = accountAssignmentUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingOrganization</b>
     * </p>
     *
     * @param purchasingOrganization
     *            Purchasing Organization
     */
    public void setPurchasingOrganization( @Nullable final String purchasingOrganization )
    {
        rememberChangedField("PurchasingOrganization", this.purchasingOrganization);
        this.purchasingOrganization = purchasingOrganization;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingGroup</b>
     * </p>
     *
     * @param purchasingGroup
     *            Purchasing Group
     */
    public void setPurchasingGroup( @Nullable final String purchasingGroup )
    {
        rememberChangedField("PurchasingGroup", this.purchasingGroup);
        this.purchasingGroup = purchasingGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusinessArea</b>
     * </p>
     *
     * @param businessArea
     *            Business Area
     */
    public void setBusinessArea( @Nullable final String businessArea )
    {
        rememberChangedField("BusinessArea", this.businessArea);
        this.businessArea = businessArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>CommitmentItem</b>
     * </p>
     *
     * @param commitmentItem
     *            Commitment Item
     */
    public void setCommitmentItem( @Nullable final String commitmentItem )
    {
        rememberChangedField("CommitmentItem", this.commitmentItem);
        this.commitmentItem = commitmentItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea</b>
     * </p>
     *
     * @param controllingArea
     *            Controlling Area
     */
    public void setControllingArea( @Nullable final String controllingArea )
    {
        rememberChangedField("ControllingArea", this.controllingArea);
        this.controllingArea = controllingArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CostCenter</b>
     * </p>
     *
     * @param costCenter
     *            Cost Center
     */
    public void setCostCenter( @Nullable final String costCenter )
    {
        rememberChangedField("CostCenter", this.costCenter);
        this.costCenter = costCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CostObject</b>
     * </p>
     *
     * @param costObject
     *            Cost Object
     */
    public void setCostObject( @Nullable final String costObject )
    {
        rememberChangedField("CostObject", this.costObject);
        this.costObject = costObject;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @param createdByUser
     *            User Name
     */
    public void setCreatedByUser( @Nullable final String createdByUser )
    {
        rememberChangedField("CreatedByUser", this.createdByUser);
        this.createdByUser = createdByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>CreationDateTime</b>
     * </p>
     *
     * @param creationDateTime
     *            UTC Time Stamp in Long Form (YYYYMMDDhhmmssmmmuuun)
     */
    public void setCreationDateTime( @Nullable final ZonedDateTime creationDateTime )
    {
        rememberChangedField("CreationDateTime", this.creationDateTime);
        this.creationDateTime = creationDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>EarmarkedFundsDocument</b>
     * </p>
     *
     * @param earmarkedFundsDocument
     *            Document Number for Earmarked Funds
     */
    public void setEarmarkedFundsDocument( @Nullable final String earmarkedFundsDocument )
    {
        rememberChangedField("EarmarkedFundsDocument", this.earmarkedFundsDocument);
        this.earmarkedFundsDocument = earmarkedFundsDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FixedAsset</b>
     * </p>
     *
     * @param fixedAsset
     *            Asset Subnumber
     */
    public void setFixedAsset( @Nullable final String fixedAsset )
    {
        rememberChangedField("FixedAsset", this.fixedAsset);
        this.fixedAsset = fixedAsset;
    }

    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalArea</b>
     * </p>
     *
     * @param functionalArea
     *            Functional Area
     */
    public void setFunctionalArea( @Nullable final String functionalArea )
    {
        rememberChangedField("FunctionalArea", this.functionalArea);
        this.functionalArea = functionalArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Fund</b>
     * </p>
     *
     * @param fund
     *            Fund
     */
    public void setFund( @Nullable final String fund )
    {
        rememberChangedField("Fund", this.fund);
        this.fund = fund;
    }

    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>FundsCenter</b>
     * </p>
     *
     * @param fundsCenter
     *            Funds Center
     */
    public void setFundsCenter( @Nullable final String fundsCenter )
    {
        rememberChangedField("FundsCenter", this.fundsCenter);
        this.fundsCenter = fundsCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>GLAccount</b>
     * </p>
     *
     * @param gLAccount
     *            G/L Account Number
     */
    public void setGLAccount( @Nullable final String gLAccount )
    {
        rememberChangedField("GLAccount", this.gLAccount);
        this.gLAccount = gLAccount;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsDeleted</b>
     * </p>
     *
     * @param isDeleted
     *            Deletion Indicator: Purchasing Document Account Assignment
     */
    public void setIsDeleted( @Nullable final Boolean isDeleted )
    {
        rememberChangedField("IsDeleted", this.isDeleted);
        this.isDeleted = isDeleted;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @param lastChangeDateTime
     *            UTC Time Stamp in Long Form (YYYYMMDDhhmmssmmmuuun)
     */
    public void setLastChangeDateTime( @Nullable final ZonedDateTime lastChangeDateTime )
    {
        rememberChangedField("LastChangeDateTime", this.lastChangeDateTime);
        this.lastChangeDateTime = lastChangeDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @param lastChangedByUser
     *            User Name
     */
    public void setLastChangedByUser( @Nullable final String lastChangedByUser )
    {
        rememberChangedField("LastChangedByUser", this.lastChangedByUser);
        this.lastChangedByUser = lastChangedByUser;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MasterFixedAsset</b>
     * </p>
     *
     * @param masterFixedAsset
     *            Main Asset Number
     */
    public void setMasterFixedAsset( @Nullable final String masterFixedAsset )
    {
        rememberChangedField("MasterFixedAsset", this.masterFixedAsset);
        this.masterFixedAsset = masterFixedAsset;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 1
     * <p>
     * Original property name from the Odata EDM: <b>MultipleAcctAssgmtDistrPercent</b>
     * </p>
     *
     * @param multipleAcctAssgmtDistrPercent
     *            Distribution percentage in the case of multiple acct assgt
     */
    public void setMultipleAcctAssgmtDistrPercent( @Nullable final BigDecimal multipleAcctAssgmtDistrPercent )
    {
        rememberChangedField("MultipleAcctAssgmtDistrPercent", this.multipleAcctAssgmtDistrPercent);
        this.multipleAcctAssgmtDistrPercent = multipleAcctAssgmtDistrPercent;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>NetworkActivityInternalID</b>
     * </p>
     *
     * @param networkActivityInternalID
     *            Internal counter
     */
    public void setNetworkActivityInternalID( @Nullable final String networkActivityInternalID )
    {
        rememberChangedField("NetworkActivityInternalID", this.networkActivityInternalID);
        this.networkActivityInternalID = networkActivityInternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>OrderID</b>
     * </p>
     *
     * @param orderID
     *            Order Number
     */
    public void setOrderID( @Nullable final String orderID )
    {
        rememberChangedField("OrderID", this.orderID);
        this.orderID = orderID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PartnerAccountNumber</b>
     * </p>
     *
     * @param partnerAccountNumber
     *            Partner account number
     */
    public void setPartnerAccountNumber( @Nullable final String partnerAccountNumber )
    {
        rememberChangedField("PartnerAccountNumber", this.partnerAccountNumber);
        this.partnerAccountNumber = partnerAccountNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenter</b>
     * </p>
     *
     * @param profitCenter
     *            Profit Center
     */
    public void setProfitCenter( @Nullable final String profitCenter )
    {
        rememberChangedField("ProfitCenter", this.profitCenter);
        this.profitCenter = profitCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProfitabilitySegment</b>
     * </p>
     *
     * @param profitabilitySegment
     *            Profitability Segment Number (CO-PA)
     */
    public void setProfitabilitySegment( @Nullable final String profitabilitySegment )
    {
        rememberChangedField("ProfitabilitySegment", this.profitabilitySegment);
        this.profitabilitySegment = profitabilitySegment;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ProjectNetwork</b>
     * </p>
     *
     * @param projectNetwork
     *            Network Number for Account Assignment
     */
    public void setProjectNetwork( @Nullable final String projectNetwork )
    {
        rememberChangedField("ProjectNetwork", this.projectNetwork);
        this.projectNetwork = projectNetwork;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProjectNetworkInternalID</b>
     * </p>
     *
     * @param projectNetworkInternalID
     *            Routing number of operations in the order
     */
    public void setProjectNetworkInternalID( @Nullable final String projectNetworkInternalID )
    {
        rememberChangedField("ProjectNetworkInternalID", this.projectNetworkInternalID);
        this.projectNetworkInternalID = projectNetworkInternalID;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>Quantity</b>
     * </p>
     *
     * @param quantity
     *            Quantity
     */
    public void setQuantity( @Nullable final BigDecimal quantity )
    {
        rememberChangedField("Quantity", this.quantity);
        this.quantity = quantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>QuantityUnit</b>
     * </p>
     *
     * @param quantityUnit
     *            Unit of Measure for Service Entry Statement
     */
    public void setQuantityUnit( @Nullable final String quantityUnit )
    {
        rememberChangedField("QuantityUnit", this.quantityUnit);
        this.quantityUnit = quantityUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>RealEstateObject</b>
     * </p>
     *
     * @param realEstateObject
     *            Internal Key for Real Estate Object
     */
    public void setRealEstateObject( @Nullable final String realEstateObject )
    {
        rememberChangedField("RealEstateObject", this.realEstateObject);
        this.realEstateObject = realEstateObject;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>RefDocAccountAssignment</b>
     * </p>
     *
     * @param refDocAccountAssignment
     *            Account Assignment Number of the Referenced PO Item
     */
    public void setRefDocAccountAssignment( @Nullable final String refDocAccountAssignment )
    {
        rememberChangedField("RefDocAccountAssignment", this.refDocAccountAssignment);
        this.refDocAccountAssignment = refDocAccountAssignment;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrder</b>
     * </p>
     *
     * @param salesOrder
     *            Sales and Distribution Document Number
     */
    public void setSalesOrder( @Nullable final String salesOrder )
    {
        rememberChangedField("SalesOrder", this.salesOrder);
        this.salesOrder = salesOrder;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderItem</b>
     * </p>
     *
     * @param salesOrderItem
     *            Sales Document Item
     */
    public void setSalesOrderItem( @Nullable final String salesOrderItem )
    {
        rememberChangedField("SalesOrderItem", this.salesOrderItem);
        this.salesOrderItem = salesOrderItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderScheduleLine</b>
     * </p>
     *
     * @param salesOrderScheduleLine
     *            Schedule Line Number
     */
    public void setSalesOrderScheduleLine( @Nullable final String salesOrderScheduleLine )
    {
        rememberChangedField("SalesOrderScheduleLine", this.salesOrderScheduleLine);
        this.salesOrderScheduleLine = salesOrderScheduleLine;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ServiceEntrySheetItemUUID</b>
     * </p>
     *
     * @param serviceEntrySheetItemUUID
     *            UUID serving as key (parent key, root key)
     */
    public void setServiceEntrySheetItemUUID( @Nullable final UUID serviceEntrySheetItemUUID )
    {
        rememberChangedField("ServiceEntrySheetItemUUID", this.serviceEntrySheetItemUUID);
        this.serviceEntrySheetItemUUID = serviceEntrySheetItemUUID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ServiceEntrySheetUUID</b>
     * </p>
     *
     * @param serviceEntrySheetUUID
     *            UUID serving as key (parent key, root key)
     */
    public void setServiceEntrySheetUUID( @Nullable final UUID serviceEntrySheetUUID )
    {
        rememberChangedField("ServiceEntrySheetUUID", this.serviceEntrySheetUUID);
        this.serviceEntrySheetUUID = serviceEntrySheetUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>WBSElementInternalID</b>
     * </p>
     *
     * @param wBSElementInternalID
     *            WBS Element
     */
    public void setWBSElementInternalID( @Nullable final String wBSElementInternalID )
    {
        rememberChangedField("WBSElementInternalID", this.wBSElementInternalID);
        this.wBSElementInternalID = wBSElementInternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>WBSElement</b>
     * </p>
     *
     * @param wBSElement
     *            Work Breakdown Structure Element (WBS Element)
     */
    public void setWBSElement( @Nullable final String wBSElement )
    {
        rememberChangedField("WBSElement", this.wBSElement);
        this.wBSElement = wBSElement;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocumentType</b>
     * </p>
     *
     * @param serviceDocumentType
     *            Service Document Type
     */
    public void setServiceDocumentType( @Nullable final String serviceDocumentType )
    {
        rememberChangedField("ServiceDocumentType", this.serviceDocumentType);
        this.serviceDocumentType = serviceDocumentType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocument</b>
     * </p>
     *
     * @param serviceDocument
     *            Service Document ID
     */
    public void setServiceDocument( @Nullable final String serviceDocument )
    {
        rememberChangedField("ServiceDocument", this.serviceDocument);
        this.serviceDocument = serviceDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocumentItem</b>
     * </p>
     *
     * @param serviceDocumentItem
     *            Service Document Item ID
     */
    public void setServiceDocumentItem( @Nullable final String serviceDocumentItem )
    {
        rememberChangedField("ServiceDocumentItem", this.serviceDocumentItem);
        this.serviceDocumentItem = serviceDocumentItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>Currency</b>
     * </p>
     *
     * @param currency
     *            Currency Key
     */
    public void setCurrency( @Nullable final String currency )
    {
        rememberChangedField("Currency", this.currency);
        this.currency = currency;
    }

    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>NetAmount</b>
     * </p>
     *
     * @param netAmount
     *            Net Amount in Transaction Currency
     */
    public void setNetAmount( @Nullable final BigDecimal netAmount )
    {
        rememberChangedField("NetAmount", this.netAmount);
        this.netAmount = netAmount;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_SrvcEntrShtAcctAssignment";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ServiceEntrySheet", getServiceEntrySheet());
        result.put("ServiceEntrySheetItem", getServiceEntrySheetItem());
        result.put("AccountAssignment", getAccountAssignment());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ServiceEntrySheet", getServiceEntrySheet());
        values.put("ServiceEntrySheetItem", getServiceEntrySheetItem());
        values.put("AccountAssignment", getAccountAssignment());
        values.put("AccountAssignmentUUID", getAccountAssignmentUUID());
        values.put("PurchasingOrganization", getPurchasingOrganization());
        values.put("PurchasingGroup", getPurchasingGroup());
        values.put("Plant", getPlant());
        values.put("BusinessArea", getBusinessArea());
        values.put("CommitmentItem", getCommitmentItem());
        values.put("ControllingArea", getControllingArea());
        values.put("CostCenter", getCostCenter());
        values.put("CostObject", getCostObject());
        values.put("CreatedByUser", getCreatedByUser());
        values.put("CreationDateTime", getCreationDateTime());
        values.put("EarmarkedFundsDocument", getEarmarkedFundsDocument());
        values.put("FixedAsset", getFixedAsset());
        values.put("FunctionalArea", getFunctionalArea());
        values.put("Fund", getFund());
        values.put("FundsCenter", getFundsCenter());
        values.put("GLAccount", getGLAccount());
        values.put("IsDeleted", getIsDeleted());
        values.put("LastChangeDateTime", getLastChangeDateTime());
        values.put("LastChangedByUser", getLastChangedByUser());
        values.put("MasterFixedAsset", getMasterFixedAsset());
        values.put("MultipleAcctAssgmtDistrPercent", getMultipleAcctAssgmtDistrPercent());
        values.put("NetworkActivityInternalID", getNetworkActivityInternalID());
        values.put("OrderID", getOrderID());
        values.put("PartnerAccountNumber", getPartnerAccountNumber());
        values.put("ProfitCenter", getProfitCenter());
        values.put("ProfitabilitySegment", getProfitabilitySegment());
        values.put("ProjectNetwork", getProjectNetwork());
        values.put("ProjectNetworkInternalID", getProjectNetworkInternalID());
        values.put("Quantity", getQuantity());
        values.put("QuantityUnit", getQuantityUnit());
        values.put("RealEstateObject", getRealEstateObject());
        values.put("RefDocAccountAssignment", getRefDocAccountAssignment());
        values.put("SalesOrder", getSalesOrder());
        values.put("SalesOrderItem", getSalesOrderItem());
        values.put("SalesOrderScheduleLine", getSalesOrderScheduleLine());
        values.put("ServiceEntrySheetItemUUID", getServiceEntrySheetItemUUID());
        values.put("ServiceEntrySheetUUID", getServiceEntrySheetUUID());
        values.put("WBSElementInternalID", getWBSElementInternalID());
        values.put("WBSElement", getWBSElement());
        values.put("ServiceDocumentType", getServiceDocumentType());
        values.put("ServiceDocument", getServiceDocument());
        values.put("ServiceDocumentItem", getServiceDocumentItem());
        values.put("Currency", getCurrency());
        values.put("NetAmount", getNetAmount());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ServiceEntrySheet") ) {
                final Object value = values.remove("ServiceEntrySheet");
                if( (value == null) || (!value.equals(getServiceEntrySheet())) ) {
                    setServiceEntrySheet(((String) value));
                }
            }
            if( values.containsKey("ServiceEntrySheetItem") ) {
                final Object value = values.remove("ServiceEntrySheetItem");
                if( (value == null) || (!value.equals(getServiceEntrySheetItem())) ) {
                    setServiceEntrySheetItem(((String) value));
                }
            }
            if( values.containsKey("AccountAssignment") ) {
                final Object value = values.remove("AccountAssignment");
                if( (value == null) || (!value.equals(getAccountAssignment())) ) {
                    setAccountAssignment(((String) value));
                }
            }
            if( values.containsKey("AccountAssignmentUUID") ) {
                final Object value = values.remove("AccountAssignmentUUID");
                if( (value == null) || (!value.equals(getAccountAssignmentUUID())) ) {
                    setAccountAssignmentUUID(((UUID) value));
                }
            }
            if( values.containsKey("PurchasingOrganization") ) {
                final Object value = values.remove("PurchasingOrganization");
                if( (value == null) || (!value.equals(getPurchasingOrganization())) ) {
                    setPurchasingOrganization(((String) value));
                }
            }
            if( values.containsKey("PurchasingGroup") ) {
                final Object value = values.remove("PurchasingGroup");
                if( (value == null) || (!value.equals(getPurchasingGroup())) ) {
                    setPurchasingGroup(((String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("BusinessArea") ) {
                final Object value = values.remove("BusinessArea");
                if( (value == null) || (!value.equals(getBusinessArea())) ) {
                    setBusinessArea(((String) value));
                }
            }
            if( values.containsKey("CommitmentItem") ) {
                final Object value = values.remove("CommitmentItem");
                if( (value == null) || (!value.equals(getCommitmentItem())) ) {
                    setCommitmentItem(((String) value));
                }
            }
            if( values.containsKey("ControllingArea") ) {
                final Object value = values.remove("ControllingArea");
                if( (value == null) || (!value.equals(getControllingArea())) ) {
                    setControllingArea(((String) value));
                }
            }
            if( values.containsKey("CostCenter") ) {
                final Object value = values.remove("CostCenter");
                if( (value == null) || (!value.equals(getCostCenter())) ) {
                    setCostCenter(((String) value));
                }
            }
            if( values.containsKey("CostObject") ) {
                final Object value = values.remove("CostObject");
                if( (value == null) || (!value.equals(getCostObject())) ) {
                    setCostObject(((String) value));
                }
            }
            if( values.containsKey("CreatedByUser") ) {
                final Object value = values.remove("CreatedByUser");
                if( (value == null) || (!value.equals(getCreatedByUser())) ) {
                    setCreatedByUser(((String) value));
                }
            }
            if( values.containsKey("CreationDateTime") ) {
                final Object value = values.remove("CreationDateTime");
                if( (value == null) || (!value.equals(getCreationDateTime())) ) {
                    setCreationDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("EarmarkedFundsDocument") ) {
                final Object value = values.remove("EarmarkedFundsDocument");
                if( (value == null) || (!value.equals(getEarmarkedFundsDocument())) ) {
                    setEarmarkedFundsDocument(((String) value));
                }
            }
            if( values.containsKey("FixedAsset") ) {
                final Object value = values.remove("FixedAsset");
                if( (value == null) || (!value.equals(getFixedAsset())) ) {
                    setFixedAsset(((String) value));
                }
            }
            if( values.containsKey("FunctionalArea") ) {
                final Object value = values.remove("FunctionalArea");
                if( (value == null) || (!value.equals(getFunctionalArea())) ) {
                    setFunctionalArea(((String) value));
                }
            }
            if( values.containsKey("Fund") ) {
                final Object value = values.remove("Fund");
                if( (value == null) || (!value.equals(getFund())) ) {
                    setFund(((String) value));
                }
            }
            if( values.containsKey("FundsCenter") ) {
                final Object value = values.remove("FundsCenter");
                if( (value == null) || (!value.equals(getFundsCenter())) ) {
                    setFundsCenter(((String) value));
                }
            }
            if( values.containsKey("GLAccount") ) {
                final Object value = values.remove("GLAccount");
                if( (value == null) || (!value.equals(getGLAccount())) ) {
                    setGLAccount(((String) value));
                }
            }
            if( values.containsKey("IsDeleted") ) {
                final Object value = values.remove("IsDeleted");
                if( (value == null) || (!value.equals(getIsDeleted())) ) {
                    setIsDeleted(((Boolean) value));
                }
            }
            if( values.containsKey("LastChangeDateTime") ) {
                final Object value = values.remove("LastChangeDateTime");
                if( (value == null) || (!value.equals(getLastChangeDateTime())) ) {
                    setLastChangeDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("LastChangedByUser") ) {
                final Object value = values.remove("LastChangedByUser");
                if( (value == null) || (!value.equals(getLastChangedByUser())) ) {
                    setLastChangedByUser(((String) value));
                }
            }
            if( values.containsKey("MasterFixedAsset") ) {
                final Object value = values.remove("MasterFixedAsset");
                if( (value == null) || (!value.equals(getMasterFixedAsset())) ) {
                    setMasterFixedAsset(((String) value));
                }
            }
            if( values.containsKey("MultipleAcctAssgmtDistrPercent") ) {
                final Object value = values.remove("MultipleAcctAssgmtDistrPercent");
                if( (value == null) || (!value.equals(getMultipleAcctAssgmtDistrPercent())) ) {
                    setMultipleAcctAssgmtDistrPercent(((BigDecimal) value));
                }
            }
            if( values.containsKey("NetworkActivityInternalID") ) {
                final Object value = values.remove("NetworkActivityInternalID");
                if( (value == null) || (!value.equals(getNetworkActivityInternalID())) ) {
                    setNetworkActivityInternalID(((String) value));
                }
            }
            if( values.containsKey("OrderID") ) {
                final Object value = values.remove("OrderID");
                if( (value == null) || (!value.equals(getOrderID())) ) {
                    setOrderID(((String) value));
                }
            }
            if( values.containsKey("PartnerAccountNumber") ) {
                final Object value = values.remove("PartnerAccountNumber");
                if( (value == null) || (!value.equals(getPartnerAccountNumber())) ) {
                    setPartnerAccountNumber(((String) value));
                }
            }
            if( values.containsKey("ProfitCenter") ) {
                final Object value = values.remove("ProfitCenter");
                if( (value == null) || (!value.equals(getProfitCenter())) ) {
                    setProfitCenter(((String) value));
                }
            }
            if( values.containsKey("ProfitabilitySegment") ) {
                final Object value = values.remove("ProfitabilitySegment");
                if( (value == null) || (!value.equals(getProfitabilitySegment())) ) {
                    setProfitabilitySegment(((String) value));
                }
            }
            if( values.containsKey("ProjectNetwork") ) {
                final Object value = values.remove("ProjectNetwork");
                if( (value == null) || (!value.equals(getProjectNetwork())) ) {
                    setProjectNetwork(((String) value));
                }
            }
            if( values.containsKey("ProjectNetworkInternalID") ) {
                final Object value = values.remove("ProjectNetworkInternalID");
                if( (value == null) || (!value.equals(getProjectNetworkInternalID())) ) {
                    setProjectNetworkInternalID(((String) value));
                }
            }
            if( values.containsKey("Quantity") ) {
                final Object value = values.remove("Quantity");
                if( (value == null) || (!value.equals(getQuantity())) ) {
                    setQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("QuantityUnit") ) {
                final Object value = values.remove("QuantityUnit");
                if( (value == null) || (!value.equals(getQuantityUnit())) ) {
                    setQuantityUnit(((String) value));
                }
            }
            if( values.containsKey("RealEstateObject") ) {
                final Object value = values.remove("RealEstateObject");
                if( (value == null) || (!value.equals(getRealEstateObject())) ) {
                    setRealEstateObject(((String) value));
                }
            }
            if( values.containsKey("RefDocAccountAssignment") ) {
                final Object value = values.remove("RefDocAccountAssignment");
                if( (value == null) || (!value.equals(getRefDocAccountAssignment())) ) {
                    setRefDocAccountAssignment(((String) value));
                }
            }
            if( values.containsKey("SalesOrder") ) {
                final Object value = values.remove("SalesOrder");
                if( (value == null) || (!value.equals(getSalesOrder())) ) {
                    setSalesOrder(((String) value));
                }
            }
            if( values.containsKey("SalesOrderItem") ) {
                final Object value = values.remove("SalesOrderItem");
                if( (value == null) || (!value.equals(getSalesOrderItem())) ) {
                    setSalesOrderItem(((String) value));
                }
            }
            if( values.containsKey("SalesOrderScheduleLine") ) {
                final Object value = values.remove("SalesOrderScheduleLine");
                if( (value == null) || (!value.equals(getSalesOrderScheduleLine())) ) {
                    setSalesOrderScheduleLine(((String) value));
                }
            }
            if( values.containsKey("ServiceEntrySheetItemUUID") ) {
                final Object value = values.remove("ServiceEntrySheetItemUUID");
                if( (value == null) || (!value.equals(getServiceEntrySheetItemUUID())) ) {
                    setServiceEntrySheetItemUUID(((UUID) value));
                }
            }
            if( values.containsKey("ServiceEntrySheetUUID") ) {
                final Object value = values.remove("ServiceEntrySheetUUID");
                if( (value == null) || (!value.equals(getServiceEntrySheetUUID())) ) {
                    setServiceEntrySheetUUID(((UUID) value));
                }
            }
            if( values.containsKey("WBSElementInternalID") ) {
                final Object value = values.remove("WBSElementInternalID");
                if( (value == null) || (!value.equals(getWBSElementInternalID())) ) {
                    setWBSElementInternalID(((String) value));
                }
            }
            if( values.containsKey("WBSElement") ) {
                final Object value = values.remove("WBSElement");
                if( (value == null) || (!value.equals(getWBSElement())) ) {
                    setWBSElement(((String) value));
                }
            }
            if( values.containsKey("ServiceDocumentType") ) {
                final Object value = values.remove("ServiceDocumentType");
                if( (value == null) || (!value.equals(getServiceDocumentType())) ) {
                    setServiceDocumentType(((String) value));
                }
            }
            if( values.containsKey("ServiceDocument") ) {
                final Object value = values.remove("ServiceDocument");
                if( (value == null) || (!value.equals(getServiceDocument())) ) {
                    setServiceDocument(((String) value));
                }
            }
            if( values.containsKey("ServiceDocumentItem") ) {
                final Object value = values.remove("ServiceDocumentItem");
                if( (value == null) || (!value.equals(getServiceDocumentItem())) ) {
                    setServiceDocumentItem(((String) value));
                }
            }
            if( values.containsKey("Currency") ) {
                final Object value = values.remove("Currency");
                if( (value == null) || (!value.equals(getCurrency())) ) {
                    setCurrency(((String) value));
                }
            }
            if( values.containsKey("NetAmount") ) {
                final Object value = values.remove("NetAmount");
                if( (value == null) || (!value.equals(getNetAmount())) ) {
                    setNetAmount(((BigDecimal) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> SrvcEntrShtAcctAssignmentField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SrvcEntrShtAcctAssignmentField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SrvcEntrShtAcctAssignmentField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SrvcEntrShtAcctAssignmentField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ServiceEntrySheetService.DEFAULT_SERVICE_PATH);
    }

}
