/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.selectable.SrvcEntrShtAcctAssignmentSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.SrvcEntrShtAcctAssignment
 * SrvcEntrShtAcctAssignment} entity using key fields. This fluent helper allows methods which modify the underlying
 * query to be called before executing the query itself.
 *
 */
public class SrvcEntrShtAcctAssignmentByKeyFluentHelper
    extends
    FluentHelperByKey<SrvcEntrShtAcctAssignmentByKeyFluentHelper, SrvcEntrShtAcctAssignment, SrvcEntrShtAcctAssignmentSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.SrvcEntrShtAcctAssignment
     * SrvcEntrShtAcctAssignment} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code SrvcEntrShtAcctAssignment}
     * @param accountAssignment
     *            Sequential Number of Account Assignment
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param serviceEntrySheetItem
     *            Item Number of Service Entry Sheet
     *            <p>
     *            Constraints: Not nullable, Maximum length: 5
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code SrvcEntrShtAcctAssignment}
     * @param serviceEntrySheet
     *            Service Entry Sheet
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     */
    public SrvcEntrShtAcctAssignmentByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String serviceEntrySheet,
        final String serviceEntrySheetItem,
        final String accountAssignment )
    {
        super(servicePath, entityCollection);
        this.key.put("ServiceEntrySheet", serviceEntrySheet);
        this.key.put("ServiceEntrySheetItem", serviceEntrySheetItem);
        this.key.put("AccountAssignment", accountAssignment);
    }

    @Override
    @Nonnull
    protected Class<SrvcEntrShtAcctAssignment> getEntityClass()
    {
        return SrvcEntrShtAcctAssignment.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
