/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.ServiceEntrySheet;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.ServiceEntrySheetItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.SrvcEntrShtAcctAssignment;

/**
 * Implementation of the {@link ServiceEntrySheetServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.ServiceEntrySheetService ServiceEntrySheetService}.
 *
 */
public class DefaultServiceEntrySheetServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<ServiceEntrySheetServiceBatch, ServiceEntrySheetServiceBatchChangeSet>
    implements
    ServiceEntrySheetServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ServiceEntrySheetService service;

    @SuppressWarnings( "deprecation" )
    DefaultServiceEntrySheetServiceBatchChangeSet(
        @Nonnull final DefaultServiceEntrySheetServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ServiceEntrySheetService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultServiceEntrySheetServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public ServiceEntrySheetServiceBatchChangeSet createServiceEntrySheet(
        @Nonnull final ServiceEntrySheet serviceEntrySheet )
    {
        return addRequestCreate(service::createServiceEntrySheet, serviceEntrySheet);
    }

    @Nonnull
    @Override
    public ServiceEntrySheetServiceBatchChangeSet updateServiceEntrySheet(
        @Nonnull final ServiceEntrySheet serviceEntrySheet )
    {
        return addRequestUpdate(service::updateServiceEntrySheet, serviceEntrySheet);
    }

    @Nonnull
    @Override
    public ServiceEntrySheetServiceBatchChangeSet updateServiceEntrySheetItem(
        @Nonnull final ServiceEntrySheetItem serviceEntrySheetItem )
    {
        return addRequestUpdate(service::updateServiceEntrySheetItem, serviceEntrySheetItem);
    }

    @Nonnull
    @Override
    public ServiceEntrySheetServiceBatchChangeSet updateSrvcEntrShtAcctAssignment(
        @Nonnull final SrvcEntrShtAcctAssignment srvcEntrShtAcctAssignment )
    {
        return addRequestUpdate(service::updateSrvcEntrShtAcctAssignment, srvcEntrShtAcctAssignment);
    }

}
