/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchChangeSet;
import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchEndChangeSet;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.ServiceEntrySheet;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.ServiceEntrySheetItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.SrvcEntrShtAcctAssignment;

/**
 * This interface enables you to combine multiple operations into one change set. For further information have a look
 * into the {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.ServiceEntrySheetService ServiceEntrySheetService}.
 *
 */
public interface ServiceEntrySheetServiceBatchChangeSet
    extends
    FluentHelperBatchChangeSet<ServiceEntrySheetServiceBatchChangeSet>,
    FluentHelperBatchEndChangeSet<ServiceEntrySheetServiceBatch>
{

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.ServiceEntrySheet
     * ServiceEntrySheet} entity and save it to the S/4HANA system.
     *
     * @param serviceEntrySheet
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.ServiceEntrySheet
     *            ServiceEntrySheet} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceEntrySheetServiceBatchChangeSet
        createServiceEntrySheet( @Nonnull final ServiceEntrySheet serviceEntrySheet );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.ServiceEntrySheet
     * ServiceEntrySheet} entity and save it to the S/4HANA system.
     *
     * @param serviceEntrySheet
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.ServiceEntrySheet
     *            ServiceEntrySheet} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceEntrySheetServiceBatchChangeSet
        updateServiceEntrySheet( @Nonnull final ServiceEntrySheet serviceEntrySheet );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.ServiceEntrySheetItem
     * ServiceEntrySheetItem} entity and save it to the S/4HANA system.
     *
     * @param serviceEntrySheetItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.ServiceEntrySheetItem
     *            ServiceEntrySheetItem} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceEntrySheetServiceBatchChangeSet
        updateServiceEntrySheetItem( @Nonnull final ServiceEntrySheetItem serviceEntrySheetItem );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.SrvcEntrShtAcctAssignment
     * SrvcEntrShtAcctAssignment} entity and save it to the S/4HANA system.
     *
     * @param srvcEntrShtAcctAssignment
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.SrvcEntrShtAcctAssignment
     *            SrvcEntrShtAcctAssignment} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceEntrySheetServiceBatchChangeSet
        updateSrvcEntrShtAcctAssignment( @Nonnull final SrvcEntrShtAcctAssignment srvcEntrShtAcctAssignment );

}
