/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.ServiceEntrySheet;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.ServiceEntrySheet ServiceEntrySheet}.
 * This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.field.ServiceEntrySheetField
 * ServiceEntrySheetField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.link.ServiceEntrySheetLink
 * ServiceEntrySheetLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.ServiceEntrySheet#SERVICE_ENTRY_SHEET
 * SERVICE_ENTRY_SHEET}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.ServiceEntrySheet#APPROVAL_DATE_TIME
 * APPROVAL_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.ServiceEntrySheet#APPROVAL_STATUS
 * APPROVAL_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.ServiceEntrySheet#SES_WORKFLOW_STATUS
 * SES_WORKFLOW_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.ServiceEntrySheet#CREATED_BY_USER
 * CREATED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.ServiceEntrySheet#CREATION_DATE_TIME
 * CREATION_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.ServiceEntrySheet#PURCHASING_ORGANIZATION
 * PURCHASING_ORGANIZATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.ServiceEntrySheet#PURCHASING_GROUP
 * PURCHASING_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.ServiceEntrySheet#IS_END_OF_PURPOSE_BLOCKED
 * IS_END_OF_PURPOSE_BLOCKED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.ServiceEntrySheet#CURRENCY
 * CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.ServiceEntrySheet#IS_DELETED
 * IS_DELETED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.ServiceEntrySheet#LAST_CHANGE_DATE_TIME
 * LAST_CHANGE_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.ServiceEntrySheet#LAST_CHANGED_BY_USER
 * LAST_CHANGED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.ServiceEntrySheet#MATERIAL_DOCUMENT
 * MATERIAL_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.ServiceEntrySheet#MATERIAL_DOCUMENT_YEAR
 * MATERIAL_DOCUMENT_YEAR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.ServiceEntrySheet#ORIGIN_OBJECT_TYPE
 * ORIGIN_OBJECT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.ServiceEntrySheet#PURCHASE_ORDER
 * PURCHASE_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.ServiceEntrySheet#RESPONSIBLE_PERSON
 * RESPONSIBLE_PERSON}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.ServiceEntrySheet#SERVICE_ENTRY_SHEET_NAME
 * SERVICE_ENTRY_SHEET_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.ServiceEntrySheet#SERVICE_ENTRY_SHEET_UUID
 * SERVICE_ENTRY_SHEET_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.ServiceEntrySheet#SUPPLIER
 * SUPPLIER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.ServiceEntrySheet#PURG_DOC_EXTERNAL_SYSTEM
 * PURG_DOC_EXTERNAL_SYSTEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.ServiceEntrySheet#PURG_DOC_EXTERNAL_REFERENCE
 * PURG_DOC_EXTERNAL_REFERENCE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.ServiceEntrySheet#EXTERNAL_REVISION_DATE_TIME
 * EXTERNAL_REVISION_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.ServiceEntrySheet#POSTING_DATE
 * POSTING_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.ServiceEntrySheet#TO_SERVICE_ENTRY_SHEET_ITEM
 * TO_SERVICE_ENTRY_SHEET_ITEM}</li>
 * </ul>
 *
 */
public interface ServiceEntrySheetSelectable extends EntitySelectable<ServiceEntrySheet>
{

}
