/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.SrvcEntrShtAcctAssignment;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.SrvcEntrShtAcctAssignment
 * SrvcEntrShtAcctAssignment}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.field.SrvcEntrShtAcctAssignmentField
 * SrvcEntrShtAcctAssignmentField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.link.SrvcEntrShtAcctAssignmentLink
 * SrvcEntrShtAcctAssignmentLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.SrvcEntrShtAcctAssignment#SERVICE_ENTRY_SHEET
 * SERVICE_ENTRY_SHEET}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.SrvcEntrShtAcctAssignment#SERVICE_ENTRY_SHEET_ITEM
 * SERVICE_ENTRY_SHEET_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.SrvcEntrShtAcctAssignment#ACCOUNT_ASSIGNMENT
 * ACCOUNT_ASSIGNMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.SrvcEntrShtAcctAssignment#ACCOUNT_ASSIGNMENT_UUID
 * ACCOUNT_ASSIGNMENT_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.SrvcEntrShtAcctAssignment#PURCHASING_ORGANIZATION
 * PURCHASING_ORGANIZATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.SrvcEntrShtAcctAssignment#PURCHASING_GROUP
 * PURCHASING_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.SrvcEntrShtAcctAssignment#PLANT
 * PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.SrvcEntrShtAcctAssignment#BUSINESS_AREA
 * BUSINESS_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.SrvcEntrShtAcctAssignment#COMMITMENT_ITEM
 * COMMITMENT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.SrvcEntrShtAcctAssignment#CONTROLLING_AREA
 * CONTROLLING_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.SrvcEntrShtAcctAssignment#COST_CENTER
 * COST_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.SrvcEntrShtAcctAssignment#COST_OBJECT
 * COST_OBJECT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.SrvcEntrShtAcctAssignment#CREATED_BY_USER
 * CREATED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.SrvcEntrShtAcctAssignment#CREATION_DATE_TIME
 * CREATION_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.SrvcEntrShtAcctAssignment#EARMARKED_FUNDS_DOCUMENT
 * EARMARKED_FUNDS_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.SrvcEntrShtAcctAssignment#FIXED_ASSET
 * FIXED_ASSET}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.SrvcEntrShtAcctAssignment#FUNCTIONAL_AREA
 * FUNCTIONAL_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.SrvcEntrShtAcctAssignment#FUND
 * FUND}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.SrvcEntrShtAcctAssignment#FUNDS_CENTER
 * FUNDS_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.SrvcEntrShtAcctAssignment#GL_ACCOUNT
 * GL_ACCOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.SrvcEntrShtAcctAssignment#IS_DELETED
 * IS_DELETED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.SrvcEntrShtAcctAssignment#LAST_CHANGE_DATE_TIME
 * LAST_CHANGE_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.SrvcEntrShtAcctAssignment#LAST_CHANGED_BY_USER
 * LAST_CHANGED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.SrvcEntrShtAcctAssignment#MASTER_FIXED_ASSET
 * MASTER_FIXED_ASSET}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.SrvcEntrShtAcctAssignment#MULTIPLE_ACCT_ASSGMT_DISTR_PERCENT
 * MULTIPLE_ACCT_ASSGMT_DISTR_PERCENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.SrvcEntrShtAcctAssignment#NETWORK_ACTIVITY_INTERNAL_ID
 * NETWORK_ACTIVITY_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.SrvcEntrShtAcctAssignment#ORDER_ID
 * ORDER_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.SrvcEntrShtAcctAssignment#PARTNER_ACCOUNT_NUMBER
 * PARTNER_ACCOUNT_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.SrvcEntrShtAcctAssignment#PROFIT_CENTER
 * PROFIT_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.SrvcEntrShtAcctAssignment#PROFITABILITY_SEGMENT
 * PROFITABILITY_SEGMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.SrvcEntrShtAcctAssignment#PROJECT_NETWORK
 * PROJECT_NETWORK}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.SrvcEntrShtAcctAssignment#PROJECT_NETWORK_INTERNAL_ID
 * PROJECT_NETWORK_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.SrvcEntrShtAcctAssignment#QUANTITY
 * QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.SrvcEntrShtAcctAssignment#QUANTITY_UNIT
 * QUANTITY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.SrvcEntrShtAcctAssignment#REAL_ESTATE_OBJECT
 * REAL_ESTATE_OBJECT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.SrvcEntrShtAcctAssignment#REF_DOC_ACCOUNT_ASSIGNMENT
 * REF_DOC_ACCOUNT_ASSIGNMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.SrvcEntrShtAcctAssignment#SALES_ORDER
 * SALES_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.SrvcEntrShtAcctAssignment#SALES_ORDER_ITEM
 * SALES_ORDER_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.SrvcEntrShtAcctAssignment#SALES_ORDER_SCHEDULE_LINE
 * SALES_ORDER_SCHEDULE_LINE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.SrvcEntrShtAcctAssignment#SERVICE_ENTRY_SHEET_ITEM_UUID
 * SERVICE_ENTRY_SHEET_ITEM_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.SrvcEntrShtAcctAssignment#SERVICE_ENTRY_SHEET_UUID
 * SERVICE_ENTRY_SHEET_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.SrvcEntrShtAcctAssignment#WBS_ELEMENT_INTERNAL_ID
 * WBS_ELEMENT_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.SrvcEntrShtAcctAssignment#WBS_ELEMENT
 * WBS_ELEMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.SrvcEntrShtAcctAssignment#SERVICE_DOCUMENT_TYPE
 * SERVICE_DOCUMENT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.SrvcEntrShtAcctAssignment#SERVICE_DOCUMENT
 * SERVICE_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.SrvcEntrShtAcctAssignment#SERVICE_DOCUMENT_ITEM
 * SERVICE_DOCUMENT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.SrvcEntrShtAcctAssignment#CURRENCY
 * CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceentrysheet.SrvcEntrShtAcctAssignment#NET_AMOUNT
 * NET_AMOUNT}</li>
 * </ul>
 *
 */
public interface SrvcEntrShtAcctAssignmentSelectable extends EntitySelectable<SrvcEntrShtAcctAssignment>
{

}
