/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.field.ServiceOrdItemUserStatusField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.selectable.ServiceOrdItemUserStatusSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Service Order Item User Status
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_ServiceOrdItemUserStatusType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ServiceOrdItemUserStatus extends VdmEntity<ServiceOrdItemUserStatus>
{

    /**
     * Selector for all available fields of ServiceOrdItemUserStatus.
     *
     */
    public final static ServiceOrdItemUserStatusSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServiceOrder</b>
     * </p>
     *
     * @return Transaction ID
     */
    @Key
    @SerializedName( "ServiceOrder" )
    @JsonProperty( "ServiceOrder" )
    @Nullable
    @ODataField( odataName = "ServiceOrder" )
    private String serviceOrder;
    /**
     * Use with available fluent helpers to apply the <b>ServiceOrder</b> field to query operations.
     *
     */
    public final static ServiceOrdItemUserStatusField<String> SERVICE_ORDER =
        new ServiceOrdItemUserStatusField<String>("ServiceOrder");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ServiceOrderItem</b>
     * </p>
     *
     * @return Shortened Item Number in Document
     */
    @Key
    @SerializedName( "ServiceOrderItem" )
    @JsonProperty( "ServiceOrderItem" )
    @Nullable
    @ODataField( odataName = "ServiceOrderItem" )
    private String serviceOrderItem;
    /**
     * Use with available fluent helpers to apply the <b>ServiceOrderItem</b> field to query operations.
     *
     */
    public final static ServiceOrdItemUserStatusField<String> SERVICE_ORDER_ITEM =
        new ServiceOrdItemUserStatusField<String>("ServiceOrderItem");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>SrvcOrdItemUserStatus</b>
     * </p>
     *
     * @return Object Status
     */
    @Key
    @SerializedName( "SrvcOrdItemUserStatus" )
    @JsonProperty( "SrvcOrdItemUserStatus" )
    @Nullable
    @ODataField( odataName = "SrvcOrdItemUserStatus" )
    private String srvcOrdItemUserStatus;
    /**
     * Use with available fluent helpers to apply the <b>SrvcOrdItemUserStatus</b> field to query operations.
     *
     */
    public final static ServiceOrdItemUserStatusField<String> SRVC_ORD_ITEM_USER_STATUS =
        new ServiceOrdItemUserStatusField<String>("SrvcOrdItemUserStatus");

    @Nonnull
    @Override
    public Class<ServiceOrdItemUserStatus> getType()
    {
        return ServiceOrdItemUserStatus.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServiceOrder</b>
     * </p>
     *
     * @param serviceOrder
     *            Transaction ID
     */
    public void setServiceOrder( @Nullable final String serviceOrder )
    {
        rememberChangedField("ServiceOrder", this.serviceOrder);
        this.serviceOrder = serviceOrder;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ServiceOrderItem</b>
     * </p>
     *
     * @param serviceOrderItem
     *            Shortened Item Number in Document
     */
    public void setServiceOrderItem( @Nullable final String serviceOrderItem )
    {
        rememberChangedField("ServiceOrderItem", this.serviceOrderItem);
        this.serviceOrderItem = serviceOrderItem;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>SrvcOrdItemUserStatus</b>
     * </p>
     *
     * @param srvcOrdItemUserStatus
     *            Object Status
     */
    public void setSrvcOrdItemUserStatus( @Nullable final String srvcOrdItemUserStatus )
    {
        rememberChangedField("SrvcOrdItemUserStatus", this.srvcOrdItemUserStatus);
        this.srvcOrdItemUserStatus = srvcOrdItemUserStatus;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_ServiceOrdItemUserStatus";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ServiceOrder", getServiceOrder());
        result.put("ServiceOrderItem", getServiceOrderItem());
        result.put("SrvcOrdItemUserStatus", getSrvcOrdItemUserStatus());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ServiceOrder", getServiceOrder());
        values.put("ServiceOrderItem", getServiceOrderItem());
        values.put("SrvcOrdItemUserStatus", getSrvcOrdItemUserStatus());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ServiceOrder") ) {
                final Object value = values.remove("ServiceOrder");
                if( (value == null) || (!value.equals(getServiceOrder())) ) {
                    setServiceOrder(((String) value));
                }
            }
            if( values.containsKey("ServiceOrderItem") ) {
                final Object value = values.remove("ServiceOrderItem");
                if( (value == null) || (!value.equals(getServiceOrderItem())) ) {
                    setServiceOrderItem(((String) value));
                }
            }
            if( values.containsKey("SrvcOrdItemUserStatus") ) {
                final Object value = values.remove("SrvcOrdItemUserStatus");
                if( (value == null) || (!value.equals(getSrvcOrdItemUserStatus())) ) {
                    setSrvcOrdItemUserStatus(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> ServiceOrdItemUserStatusField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ServiceOrdItemUserStatusField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ServiceOrdItemUserStatusField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ServiceOrdItemUserStatusField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ServiceOrderService.DEFAULT_SERVICE_PATH);
    }

}
