/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.selectable.ServiceOrdUserStatusSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrdUserStatus ServiceOrdUserStatus}
 * entity using key fields. This fluent helper allows methods which modify the underlying query to be called before
 * executing the query itself.
 *
 */
public class ServiceOrdUserStatusByKeyFluentHelper
    extends
    FluentHelperByKey<ServiceOrdUserStatusByKeyFluentHelper, ServiceOrdUserStatus, ServiceOrdUserStatusSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrdUserStatus
     * ServiceOrdUserStatus} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code ServiceOrdUserStatus}
     * @param servicePath
     *            Service path to be used to fetch a single {@code ServiceOrdUserStatus}
     * @param serviceOrder
     *            Transaction ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param srvcOrdUserStatus
     *            Object Status
     *            <p>
     *            Constraints: Not nullable, Maximum length: 5
     *            </p>
     */
    public ServiceOrdUserStatusByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String serviceOrder,
        final String srvcOrdUserStatus )
    {
        super(servicePath, entityCollection);
        this.key.put("ServiceOrder", serviceOrder);
        this.key.put("SrvcOrdUserStatus", srvcOrdUserStatus);
    }

    @Override
    @Nonnull
    protected Class<ServiceOrdUserStatus> getEntityClass()
    {
        return ServiceOrdUserStatus.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
