/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.field.ServiceOrderField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.link.ServiceOrderLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.selectable.ServiceOrderSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Service Order
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_ServiceOrderType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ServiceOrder extends VdmEntity<ServiceOrder>
{

    /**
     * Selector for all available fields of ServiceOrder.
     *
     */
    public final static ServiceOrderSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServiceOrder</b>
     * </p>
     *
     * @return Transaction ID
     */
    @Key
    @SerializedName( "ServiceOrder" )
    @JsonProperty( "ServiceOrder" )
    @Nullable
    @ODataField( odataName = "ServiceOrder" )
    private String serviceOrder;
    /**
     * Use with available fluent helpers to apply the <b>ServiceOrder</b> field to query operations.
     *
     */
    public final static ServiceOrderField<String> SERVICE_ORDER = new ServiceOrderField<String>("ServiceOrder");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ServiceOrderType</b>
     * </p>
     *
     * @return Business Transaction Type
     */
    @SerializedName( "ServiceOrderType" )
    @JsonProperty( "ServiceOrderType" )
    @Nullable
    @ODataField( odataName = "ServiceOrderType" )
    private String serviceOrderType;
    /**
     * Use with available fluent helpers to apply the <b>ServiceOrderType</b> field to query operations.
     *
     */
    public final static ServiceOrderField<String> SERVICE_ORDER_TYPE =
        new ServiceOrderField<String>("ServiceOrderType");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ServiceOrderUUID</b>
     * </p>
     *
     * @return GUID of a CRM Order Object
     */
    @SerializedName( "ServiceOrderUUID" )
    @JsonProperty( "ServiceOrderUUID" )
    @Nullable
    @ODataField( odataName = "ServiceOrderUUID" )
    private UUID serviceOrderUUID;
    /**
     * Use with available fluent helpers to apply the <b>ServiceOrderUUID</b> field to query operations.
     *
     */
    public final static ServiceOrderField<UUID> SERVICE_ORDER_UUID = new ServiceOrderField<UUID>("ServiceOrderUUID");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ServiceOrderDescription</b>
     * </p>
     *
     * @return Transaction Description
     */
    @SerializedName( "ServiceOrderDescription" )
    @JsonProperty( "ServiceOrderDescription" )
    @Nullable
    @ODataField( odataName = "ServiceOrderDescription" )
    private String serviceOrderDescription;
    /**
     * Use with available fluent helpers to apply the <b>ServiceOrderDescription</b> field to query operations.
     *
     */
    public final static ServiceOrderField<String> SERVICE_ORDER_DESCRIPTION =
        new ServiceOrderField<String>("ServiceOrderDescription");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServiceObjectType</b>
     * </p>
     *
     * @return Business Trans. Cat.
     */
    @SerializedName( "ServiceObjectType" )
    @JsonProperty( "ServiceObjectType" )
    @Nullable
    @ODataField( odataName = "ServiceObjectType" )
    private String serviceObjectType;
    /**
     * Use with available fluent helpers to apply the <b>ServiceObjectType</b> field to query operations.
     *
     */
    public final static ServiceOrderField<String> SERVICE_OBJECT_TYPE =
        new ServiceOrderField<String>("ServiceObjectType");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key of Description
     */
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static ServiceOrderField<String> LANGUAGE = new ServiceOrderField<String>("Language");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocumentPriority</b>
     * </p>
     *
     * @return Activity Priority
     */
    @SerializedName( "ServiceDocumentPriority" )
    @JsonProperty( "ServiceDocumentPriority" )
    @Nullable
    @ODataField( odataName = "ServiceDocumentPriority" )
    private String serviceDocumentPriority;
    /**
     * Use with available fluent helpers to apply the <b>ServiceDocumentPriority</b> field to query operations.
     *
     */
    public final static ServiceOrderField<String> SERVICE_DOCUMENT_PRIORITY =
        new ServiceOrderField<String>("ServiceDocumentPriority");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>RequestedServiceStartDateTime</b>
     * </p>
     *
     * @return Service Request Start Date
     */
    @SerializedName( "RequestedServiceStartDateTime" )
    @JsonProperty( "RequestedServiceStartDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "RequestedServiceStartDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime requestedServiceStartDateTime;
    /**
     * Use with available fluent helpers to apply the <b>RequestedServiceStartDateTime</b> field to query operations.
     *
     */
    public final static ServiceOrderField<ZonedDateTime> REQUESTED_SERVICE_START_DATE_TIME =
        new ServiceOrderField<ZonedDateTime>("RequestedServiceStartDateTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>RequestedServiceEndDateTime</b>
     * </p>
     *
     * @return Service Request Due Date
     */
    @SerializedName( "RequestedServiceEndDateTime" )
    @JsonProperty( "RequestedServiceEndDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "RequestedServiceEndDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime requestedServiceEndDateTime;
    /**
     * Use with available fluent helpers to apply the <b>RequestedServiceEndDateTime</b> field to query operations.
     *
     */
    public final static ServiceOrderField<ZonedDateTime> REQUESTED_SERVICE_END_DATE_TIME =
        new ServiceOrderField<ZonedDateTime>("RequestedServiceEndDateTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocChangedDateTime</b>
     * </p>
     *
     * @return Changed At
     */
    @SerializedName( "ServiceDocChangedDateTime" )
    @JsonProperty( "ServiceDocChangedDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "ServiceDocChangedDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime serviceDocChangedDateTime;
    /**
     * Use with available fluent helpers to apply the <b>ServiceDocChangedDateTime</b> field to query operations.
     *
     */
    public final static ServiceOrderField<ZonedDateTime> SERVICE_DOC_CHANGED_DATE_TIME =
        new ServiceOrderField<ZonedDateTime>("ServiceDocChangedDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocumentTemplateType</b>
     * </p>
     *
     * @return Template Type of CRM Transaction
     */
    @SerializedName( "ServiceDocumentTemplateType" )
    @JsonProperty( "ServiceDocumentTemplateType" )
    @Nullable
    @ODataField( odataName = "ServiceDocumentTemplateType" )
    private String serviceDocumentTemplateType;
    /**
     * Use with available fluent helpers to apply the <b>ServiceDocumentTemplateType</b> field to query operations.
     *
     */
    public final static ServiceOrderField<String> SERVICE_DOCUMENT_TEMPLATE_TYPE =
        new ServiceOrderField<String>("ServiceDocumentTemplateType");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrderByCustomer</b>
     * </p>
     *
     * @return Sold-To Party's External Reference Number
     */
    @SerializedName( "PurchaseOrderByCustomer" )
    @JsonProperty( "PurchaseOrderByCustomer" )
    @Nullable
    @ODataField( odataName = "PurchaseOrderByCustomer" )
    private String purchaseOrderByCustomer;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseOrderByCustomer</b> field to query operations.
     *
     */
    public final static ServiceOrderField<String> PURCHASE_ORDER_BY_CUSTOMER =
        new ServiceOrderField<String>("PurchaseOrderByCustomer");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CustomerPurchaseOrderDate</b>
     * </p>
     *
     * @return Reference Document Date
     */
    @SerializedName( "CustomerPurchaseOrderDate" )
    @JsonProperty( "CustomerPurchaseOrderDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CustomerPurchaseOrderDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime customerPurchaseOrderDate;
    /**
     * Use with available fluent helpers to apply the <b>CustomerPurchaseOrderDate</b> field to query operations.
     *
     */
    public final static ServiceOrderField<LocalDateTime> CUSTOMER_PURCHASE_ORDER_DATE =
        new ServiceOrderField<LocalDateTime>("CustomerPurchaseOrderDate");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ServiceOrderIsReleased</b>
     * </p>
     *
     * @return Release Status
     */
    @SerializedName( "ServiceOrderIsReleased" )
    @JsonProperty( "ServiceOrderIsReleased" )
    @Nullable
    @ODataField( odataName = "ServiceOrderIsReleased" )
    private String serviceOrderIsReleased;
    /**
     * Use with available fluent helpers to apply the <b>ServiceOrderIsReleased</b> field to query operations.
     *
     */
    public final static ServiceOrderField<String> SERVICE_ORDER_IS_RELEASED =
        new ServiceOrderField<String>("ServiceOrderIsReleased");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ServiceOrderIsCompleted</b>
     * </p>
     *
     * @return The serviceOrderIsCompleted contained in this entity.
     */
    @SerializedName( "ServiceOrderIsCompleted" )
    @JsonProperty( "ServiceOrderIsCompleted" )
    @Nullable
    @ODataField( odataName = "ServiceOrderIsCompleted" )
    private String serviceOrderIsCompleted;
    /**
     * Use with available fluent helpers to apply the <b>ServiceOrderIsCompleted</b> field to query operations.
     *
     */
    public final static ServiceOrderField<String> SERVICE_ORDER_IS_COMPLETED =
        new ServiceOrderField<String>("ServiceOrderIsCompleted");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ServiceOrderIsRejected</b>
     * </p>
     *
     * @return Cancellation Status
     */
    @SerializedName( "ServiceOrderIsRejected" )
    @JsonProperty( "ServiceOrderIsRejected" )
    @Nullable
    @ODataField( odataName = "ServiceOrderIsRejected" )
    private String serviceOrderIsRejected;
    /**
     * Use with available fluent helpers to apply the <b>ServiceOrderIsRejected</b> field to query operations.
     *
     */
    public final static ServiceOrderField<String> SERVICE_ORDER_IS_REJECTED =
        new ServiceOrderField<String>("ServiceOrderIsRejected");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrganization</b>
     * </p>
     *
     * @return Sales Organization
     */
    @SerializedName( "SalesOrganization" )
    @JsonProperty( "SalesOrganization" )
    @Nullable
    @ODataField( odataName = "SalesOrganization" )
    private String salesOrganization;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrganization</b> field to query operations.
     *
     */
    public final static ServiceOrderField<String> SALES_ORGANIZATION =
        new ServiceOrderField<String>("SalesOrganization");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DistributionChannel</b>
     * </p>
     *
     * @return Distribution Channel
     */
    @SerializedName( "DistributionChannel" )
    @JsonProperty( "DistributionChannel" )
    @Nullable
    @ODataField( odataName = "DistributionChannel" )
    private String distributionChannel;
    /**
     * Use with available fluent helpers to apply the <b>DistributionChannel</b> field to query operations.
     *
     */
    public final static ServiceOrderField<String> DISTRIBUTION_CHANNEL =
        new ServiceOrderField<String>("DistributionChannel");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Division</b>
     * </p>
     *
     * @return Division
     */
    @SerializedName( "Division" )
    @JsonProperty( "Division" )
    @Nullable
    @ODataField( odataName = "Division" )
    private String division;
    /**
     * Use with available fluent helpers to apply the <b>Division</b> field to query operations.
     *
     */
    public final static ServiceOrderField<String> DIVISION = new ServiceOrderField<String>("Division");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOffice</b>
     * </p>
     *
     * @return Sales Office
     */
    @SerializedName( "SalesOffice" )
    @JsonProperty( "SalesOffice" )
    @Nullable
    @ODataField( odataName = "SalesOffice" )
    private String salesOffice;
    /**
     * Use with available fluent helpers to apply the <b>SalesOffice</b> field to query operations.
     *
     */
    public final static ServiceOrderField<String> SALES_OFFICE = new ServiceOrderField<String>("SalesOffice");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SalesGroup</b>
     * </p>
     *
     * @return Sales Group
     */
    @SerializedName( "SalesGroup" )
    @JsonProperty( "SalesGroup" )
    @Nullable
    @ODataField( odataName = "SalesGroup" )
    private String salesGroup;
    /**
     * Use with available fluent helpers to apply the <b>SalesGroup</b> field to query operations.
     *
     */
    public final static ServiceOrderField<String> SALES_GROUP = new ServiceOrderField<String>("SalesGroup");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SoldToParty</b>
     * </p>
     *
     * @return Sold-To Party
     */
    @SerializedName( "SoldToParty" )
    @JsonProperty( "SoldToParty" )
    @Nullable
    @ODataField( odataName = "SoldToParty" )
    private String soldToParty;
    /**
     * Use with available fluent helpers to apply the <b>SoldToParty</b> field to query operations.
     *
     */
    public final static ServiceOrderField<String> SOLD_TO_PARTY = new ServiceOrderField<String>("SoldToParty");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ShipToParty</b>
     * </p>
     *
     * @return Ship-To Party
     */
    @SerializedName( "ShipToParty" )
    @JsonProperty( "ShipToParty" )
    @Nullable
    @ODataField( odataName = "ShipToParty" )
    private String shipToParty;
    /**
     * Use with available fluent helpers to apply the <b>ShipToParty</b> field to query operations.
     *
     */
    public final static ServiceOrderField<String> SHIP_TO_PARTY = new ServiceOrderField<String>("ShipToParty");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BillToParty</b>
     * </p>
     *
     * @return Bill-To Party
     */
    @SerializedName( "BillToParty" )
    @JsonProperty( "BillToParty" )
    @Nullable
    @ODataField( odataName = "BillToParty" )
    private String billToParty;
    /**
     * Use with available fluent helpers to apply the <b>BillToParty</b> field to query operations.
     *
     */
    public final static ServiceOrderField<String> BILL_TO_PARTY = new ServiceOrderField<String>("BillToParty");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PayerParty</b>
     * </p>
     *
     * @return Payer
     */
    @SerializedName( "PayerParty" )
    @JsonProperty( "PayerParty" )
    @Nullable
    @ODataField( odataName = "PayerParty" )
    private String payerParty;
    /**
     * Use with available fluent helpers to apply the <b>PayerParty</b> field to query operations.
     *
     */
    public final static ServiceOrderField<String> PAYER_PARTY = new ServiceOrderField<String>("PayerParty");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ContactPerson</b>
     * </p>
     *
     * @return Customer Contact Person
     */
    @SerializedName( "ContactPerson" )
    @JsonProperty( "ContactPerson" )
    @Nullable
    @ODataField( odataName = "ContactPerson" )
    private String contactPerson;
    /**
     * Use with available fluent helpers to apply the <b>ContactPerson</b> field to query operations.
     *
     */
    public final static ServiceOrderField<String> CONTACT_PERSON = new ServiceOrderField<String>("ContactPerson");
    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocGrossAmount</b>
     * </p>
     *
     * @return Total Gross Value of Document in Document Currency
     */
    @SerializedName( "ServiceDocGrossAmount" )
    @JsonProperty( "ServiceDocGrossAmount" )
    @Nullable
    @ODataField( odataName = "ServiceDocGrossAmount" )
    private BigDecimal serviceDocGrossAmount;
    /**
     * Use with available fluent helpers to apply the <b>ServiceDocGrossAmount</b> field to query operations.
     *
     */
    public final static ServiceOrderField<BigDecimal> SERVICE_DOC_GROSS_AMOUNT =
        new ServiceOrderField<BigDecimal>("ServiceDocGrossAmount");
    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocNetAmount</b>
     * </p>
     *
     * @return Total Net Value of Document in Document Currency
     */
    @SerializedName( "ServiceDocNetAmount" )
    @JsonProperty( "ServiceDocNetAmount" )
    @Nullable
    @ODataField( odataName = "ServiceDocNetAmount" )
    private BigDecimal serviceDocNetAmount;
    /**
     * Use with available fluent helpers to apply the <b>ServiceDocNetAmount</b> field to query operations.
     *
     */
    public final static ServiceOrderField<BigDecimal> SERVICE_DOC_NET_AMOUNT =
        new ServiceOrderField<BigDecimal>("ServiceDocNetAmount");
    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocTaxAmount</b>
     * </p>
     *
     * @return Total Tax Amount in Document Currency
     */
    @SerializedName( "ServiceDocTaxAmount" )
    @JsonProperty( "ServiceDocTaxAmount" )
    @Nullable
    @ODataField( odataName = "ServiceDocTaxAmount" )
    private BigDecimal serviceDocTaxAmount;
    /**
     * Use with available fluent helpers to apply the <b>ServiceDocTaxAmount</b> field to query operations.
     *
     */
    public final static ServiceOrderField<BigDecimal> SERVICE_DOC_TAX_AMOUNT =
        new ServiceOrderField<BigDecimal>("ServiceDocTaxAmount");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrency</b>
     * </p>
     *
     * @return Currency
     */
    @SerializedName( "TransactionCurrency" )
    @JsonProperty( "TransactionCurrency" )
    @Nullable
    @ODataField( odataName = "TransactionCurrency" )
    private String transactionCurrency;
    /**
     * Use with available fluent helpers to apply the <b>TransactionCurrency</b> field to query operations.
     *
     */
    public final static ServiceOrderField<String> TRANSACTION_CURRENCY =
        new ServiceOrderField<String>("TransactionCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceServiceRequest</b>
     * </p>
     *
     * @return Transaction ID
     */
    @SerializedName( "ReferenceServiceRequest" )
    @JsonProperty( "ReferenceServiceRequest" )
    @Nullable
    @ODataField( odataName = "ReferenceServiceRequest" )
    private String referenceServiceRequest;
    /**
     * Use with available fluent helpers to apply the <b>ReferenceServiceRequest</b> field to query operations.
     *
     */
    public final static ServiceOrderField<String> REFERENCE_SERVICE_REQUEST =
        new ServiceOrderField<String>("ReferenceServiceRequest");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceServiceContract</b>
     * </p>
     *
     * @return Transaction ID
     */
    @SerializedName( "ReferenceServiceContract" )
    @JsonProperty( "ReferenceServiceContract" )
    @Nullable
    @ODataField( odataName = "ReferenceServiceContract" )
    private String referenceServiceContract;
    /**
     * Use with available fluent helpers to apply the <b>ReferenceServiceContract</b> field to query operations.
     *
     */
    public final static ServiceOrderField<String> REFERENCE_SERVICE_CONTRACT =
        new ServiceOrderField<String>("ReferenceServiceContract");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RefServiceOrderTemplate</b>
     * </p>
     *
     * @return Transaction ID
     */
    @SerializedName( "RefServiceOrderTemplate" )
    @JsonProperty( "RefServiceOrderTemplate" )
    @Nullable
    @ODataField( odataName = "RefServiceOrderTemplate" )
    private String refServiceOrderTemplate;
    /**
     * Use with available fluent helpers to apply the <b>RefServiceOrderTemplate</b> field to query operations.
     *
     */
    public final static ServiceOrderField<String> REF_SERVICE_ORDER_TEMPLATE =
        new ServiceOrderField<String>("RefServiceOrderTemplate");
    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceServiceOrder</b>
     * </p>
     *
     * @return External Reference Number
     */
    @SerializedName( "ReferenceServiceOrder" )
    @JsonProperty( "ReferenceServiceOrder" )
    @Nullable
    @ODataField( odataName = "ReferenceServiceOrder" )
    private String referenceServiceOrder;
    /**
     * Use with available fluent helpers to apply the <b>ReferenceServiceOrder</b> field to query operations.
     *
     */
    public final static ServiceOrderField<String> REFERENCE_SERVICE_ORDER =
        new ServiceOrderField<String>("ReferenceServiceOrder");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ShippingCondition</b>
     * </p>
     *
     * @return Shipping Conditions
     */
    @SerializedName( "ShippingCondition" )
    @JsonProperty( "ShippingCondition" )
    @Nullable
    @ODataField( odataName = "ShippingCondition" )
    private String shippingCondition;
    /**
     * Use with available fluent helpers to apply the <b>ShippingCondition</b> field to query operations.
     *
     */
    public final static ServiceOrderField<String> SHIPPING_CONDITION =
        new ServiceOrderField<String>("ShippingCondition");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>RespyMgmtServiceTeam</b>
     * </p>
     *
     * @return Service Team (Responsibility Management)
     */
    @SerializedName( "RespyMgmtServiceTeam" )
    @JsonProperty( "RespyMgmtServiceTeam" )
    @Nullable
    @ODataField( odataName = "RespyMgmtServiceTeam" )
    private String respyMgmtServiceTeam;
    /**
     * Use with available fluent helpers to apply the <b>RespyMgmtServiceTeam</b> field to query operations.
     *
     */
    public final static ServiceOrderField<String> RESPY_MGMT_SERVICE_TEAM =
        new ServiceOrderField<String>("RespyMgmtServiceTeam");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>RespyMgmtServiceTeamName</b>
     * </p>
     *
     * @return Name
     */
    @SerializedName( "RespyMgmtServiceTeamName" )
    @JsonProperty( "RespyMgmtServiceTeamName" )
    @Nullable
    @ODataField( odataName = "RespyMgmtServiceTeamName" )
    private String respyMgmtServiceTeamName;
    /**
     * Use with available fluent helpers to apply the <b>RespyMgmtServiceTeamName</b> field to query operations.
     *
     */
    public final static ServiceOrderField<String> RESPY_MGMT_SERVICE_TEAM_NAME =
        new ServiceOrderField<String>("RespyMgmtServiceTeamName");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>RespyMgmtGlobalTeamID</b>
     * </p>
     *
     * @return Global Team ID in Responsibility Mgmt.
     */
    @SerializedName( "RespyMgmtGlobalTeamID" )
    @JsonProperty( "RespyMgmtGlobalTeamID" )
    @Nullable
    @ODataField( odataName = "RespyMgmtGlobalTeamID" )
    private String respyMgmtGlobalTeamID;
    /**
     * Use with available fluent helpers to apply the <b>RespyMgmtGlobalTeamID</b> field to query operations.
     *
     */
    public final static ServiceOrderField<String> RESPY_MGMT_GLOBAL_TEAM_ID =
        new ServiceOrderField<String>("RespyMgmtGlobalTeamID");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SrvcOrdCreditStatus</b>
     * </p>
     *
     * @return Credit Status of Header
     */
    @SerializedName( "SrvcOrdCreditStatus" )
    @JsonProperty( "SrvcOrdCreditStatus" )
    @Nullable
    @ODataField( odataName = "SrvcOrdCreditStatus" )
    private String srvcOrdCreditStatus;
    /**
     * Use with available fluent helpers to apply the <b>SrvcOrdCreditStatus</b> field to query operations.
     *
     */
    public final static ServiceOrderField<String> SRVC_ORD_CREDIT_STATUS =
        new ServiceOrderField<String>("SrvcOrdCreditStatus");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SrvcOrdExecutionStatus</b>
     * </p>
     *
     * @return Execution Status
     */
    @SerializedName( "SrvcOrdExecutionStatus" )
    @JsonProperty( "SrvcOrdExecutionStatus" )
    @Nullable
    @ODataField( odataName = "SrvcOrdExecutionStatus" )
    private String srvcOrdExecutionStatus;
    /**
     * Use with available fluent helpers to apply the <b>SrvcOrdExecutionStatus</b> field to query operations.
     *
     */
    public final static ServiceOrderField<String> SRVC_ORD_EXECUTION_STATUS =
        new ServiceOrderField<String>("SrvcOrdExecutionStatus");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PaymentTerms</b>
     * </p>
     *
     * @return Terms of Payment
     */
    @SerializedName( "PaymentTerms" )
    @JsonProperty( "PaymentTerms" )
    @Nullable
    @ODataField( odataName = "PaymentTerms" )
    private String paymentTerms;
    /**
     * Use with available fluent helpers to apply the <b>PaymentTerms</b> field to query operations.
     *
     */
    public final static ServiceOrderField<String> PAYMENT_TERMS = new ServiceOrderField<String>("PaymentTerms");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PaymentMethod</b>
     * </p>
     *
     * @return Payment Method
     */
    @SerializedName( "PaymentMethod" )
    @JsonProperty( "PaymentMethod" )
    @Nullable
    @ODataField( odataName = "PaymentMethod" )
    private String paymentMethod;
    /**
     * Use with available fluent helpers to apply the <b>PaymentMethod</b> field to query operations.
     *
     */
    public final static ServiceOrderField<String> PAYMENT_METHOD = new ServiceOrderField<String>("PaymentMethod");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>SEPAMandate</b>
     * </p>
     *
     * @return Unique Reference to Mandate per Payment Recipient
     */
    @SerializedName( "SEPAMandate" )
    @JsonProperty( "SEPAMandate" )
    @Nullable
    @ODataField( odataName = "SEPAMandate" )
    private String sEPAMandate;
    /**
     * Use with available fluent helpers to apply the <b>SEPAMandate</b> field to query operations.
     *
     */
    public final static ServiceOrderField<String> SEPA_MANDATE = new ServiceOrderField<String>("SEPAMandate");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SrvcSEPAMandateRelevance</b>
     * </p>
     *
     * @return Indicator for SEPA-Relevant Transactions
     */
    @SerializedName( "SrvcSEPAMandateRelevance" )
    @JsonProperty( "SrvcSEPAMandateRelevance" )
    @Nullable
    @ODataField( odataName = "SrvcSEPAMandateRelevance" )
    private String srvcSEPAMandateRelevance;
    /**
     * Use with available fluent helpers to apply the <b>SrvcSEPAMandateRelevance</b> field to query operations.
     *
     */
    public final static ServiceOrderField<String> SRVC_SEPA_MANDATE_RELEVANCE =
        new ServiceOrderField<String>("SrvcSEPAMandateRelevance");
    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>WBSElementExternalID</b>
     * </p>
     *
     * @return Work Breakdown Structure Element (WBS Element) Edited
     */
    @SerializedName( "WBSElementExternalID" )
    @JsonProperty( "WBSElementExternalID" )
    @Nullable
    @ODataField( odataName = "WBSElementExternalID" )
    private String wBSElementExternalID;
    /**
     * Use with available fluent helpers to apply the <b>WBSElementExternalID</b> field to query operations.
     *
     */
    public final static ServiceOrderField<String> WBS_ELEMENT_EXTERNAL_ID =
        new ServiceOrderField<String>("WBSElementExternalID");
    /**
     * Constraints: Not nullable, Maximum length: 14
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrganizationOrgUnitID</b>
     * </p>
     *
     * @return Sales Organization ID
     */
    @SerializedName( "SalesOrganizationOrgUnitID" )
    @JsonProperty( "SalesOrganizationOrgUnitID" )
    @Nullable
    @ODataField( odataName = "SalesOrganizationOrgUnitID" )
    private String salesOrganizationOrgUnitID;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrganizationOrgUnitID</b> field to query operations.
     *
     */
    public final static ServiceOrderField<String> SALES_ORGANIZATION_ORG_UNIT_ID =
        new ServiceOrderField<String>("SalesOrganizationOrgUnitID");
    /**
     * Constraints: Not nullable, Maximum length: 14
     * <p>
     * Original property name from the Odata EDM: <b>ServiceOrganization</b>
     * </p>
     *
     * @return Service Organization
     */
    @SerializedName( "ServiceOrganization" )
    @JsonProperty( "ServiceOrganization" )
    @Nullable
    @ODataField( odataName = "ServiceOrganization" )
    private String serviceOrganization;
    /**
     * Use with available fluent helpers to apply the <b>ServiceOrganization</b> field to query operations.
     *
     */
    public final static ServiceOrderField<String> SERVICE_ORGANIZATION =
        new ServiceOrderField<String>("ServiceOrganization");
    /**
     * Constraints: Not nullable, Maximum length: 14
     * <p>
     * Original property name from the Odata EDM: <b>SalesOfficeOrgUnitID</b>
     * </p>
     *
     * @return Sales Office
     */
    @SerializedName( "SalesOfficeOrgUnitID" )
    @JsonProperty( "SalesOfficeOrgUnitID" )
    @Nullable
    @ODataField( odataName = "SalesOfficeOrgUnitID" )
    private String salesOfficeOrgUnitID;
    /**
     * Use with available fluent helpers to apply the <b>SalesOfficeOrgUnitID</b> field to query operations.
     *
     */
    public final static ServiceOrderField<String> SALES_OFFICE_ORG_UNIT_ID =
        new ServiceOrderField<String>("SalesOfficeOrgUnitID");
    /**
     * Constraints: Not nullable, Maximum length: 14
     * <p>
     * Original property name from the Odata EDM: <b>SalesGroupOrgUnitID</b>
     * </p>
     *
     * @return Sales Group
     */
    @SerializedName( "SalesGroupOrgUnitID" )
    @JsonProperty( "SalesGroupOrgUnitID" )
    @Nullable
    @ODataField( odataName = "SalesGroupOrgUnitID" )
    private String salesGroupOrgUnitID;
    /**
     * Use with available fluent helpers to apply the <b>SalesGroupOrgUnitID</b> field to query operations.
     *
     */
    public final static ServiceOrderField<String> SALES_GROUP_ORG_UNIT_ID =
        new ServiceOrderField<String>("SalesGroupOrgUnitID");
    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>FSMServiceCall</b>
     * </p>
     *
     * @return Object key
     */
    @SerializedName( "FSMServiceCall" )
    @JsonProperty( "FSMServiceCall" )
    @Nullable
    @ODataField( odataName = "FSMServiceCall" )
    private String fSMServiceCall;
    /**
     * Use with available fluent helpers to apply the <b>FSMServiceCall</b> field to query operations.
     *
     */
    public final static ServiceOrderField<String> FSM_SERVICE_CALL = new ServiceOrderField<String>("FSMServiceCall");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ServiceOrderRejectionReason</b>
     * </p>
     *
     * @return Cancellation Reason Code
     */
    @SerializedName( "ServiceOrderRejectionReason" )
    @JsonProperty( "ServiceOrderRejectionReason" )
    @Nullable
    @ODataField( odataName = "ServiceOrderRejectionReason" )
    private String serviceOrderRejectionReason;
    /**
     * Use with available fluent helpers to apply the <b>ServiceOrderRejectionReason</b> field to query operations.
     *
     */
    public final static ServiceOrderField<String> SERVICE_ORDER_REJECTION_REASON =
        new ServiceOrderField<String>("ServiceOrderRejectionReason");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceInHouseRepair</b>
     * </p>
     *
     * @return Reference In-House Repair
     */
    @SerializedName( "ReferenceInHouseRepair" )
    @JsonProperty( "ReferenceInHouseRepair" )
    @Nullable
    @ODataField( odataName = "ReferenceInHouseRepair" )
    private String referenceInHouseRepair;
    /**
     * Use with available fluent helpers to apply the <b>ReferenceInHouseRepair</b> field to query operations.
     *
     */
    public final static ServiceOrderField<String> REFERENCE_IN_HOUSE_REPAIR =
        new ServiceOrderField<String>("ReferenceInHouseRepair");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceInHouseRepairItem</b>
     * </p>
     *
     * @return Reference In-House Repair Item
     */
    @SerializedName( "ReferenceInHouseRepairItem" )
    @JsonProperty( "ReferenceInHouseRepairItem" )
    @Nullable
    @ODataField( odataName = "ReferenceInHouseRepairItem" )
    private String referenceInHouseRepairItem;
    /**
     * Use with available fluent helpers to apply the <b>ReferenceInHouseRepairItem</b> field to query operations.
     *
     */
    public final static ServiceOrderField<String> REFERENCE_IN_HOUSE_REPAIR_ITEM =
        new ServiceOrderField<String>("ReferenceInHouseRepairItem");
    /**
     * Navigation property <b>to_Appointment</b> for <b>ServiceOrder</b> to multiple <b>SrvcOrdAppointment</b>.
     *
     */
    @SerializedName( "to_Appointment" )
    @JsonProperty( "to_Appointment" )
    @ODataField( odataName = "to_Appointment" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SrvcOrdAppointment> toAppointment;
    /**
     * Navigation property <b>to_Confirmation</b> for <b>ServiceOrder</b> to multiple <b>ServiceOrderConfirmation</b>.
     *
     */
    @SerializedName( "to_Confirmation" )
    @JsonProperty( "to_Confirmation" )
    @ODataField( odataName = "to_Confirmation" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ServiceOrderConfirmation> toConfirmation;
    /**
     * Navigation property <b>to_Defect</b> for <b>ServiceOrder</b> to multiple <b>ServiceOrderDefect</b>.
     *
     */
    @SerializedName( "to_Defect" )
    @JsonProperty( "to_Defect" )
    @ODataField( odataName = "to_Defect" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ServiceOrderDefect> toDefect;
    /**
     * Navigation property <b>to_Duration</b> for <b>ServiceOrder</b> to multiple <b>SrvcOrdDuration</b>.
     *
     */
    @SerializedName( "to_Duration" )
    @JsonProperty( "to_Duration" )
    @ODataField( odataName = "to_Duration" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SrvcOrdDuration> toDuration;
    /**
     * Navigation property <b>to_Item</b> for <b>ServiceOrder</b> to multiple <b>ServiceOrderItem</b>.
     *
     */
    @SerializedName( "to_Item" )
    @JsonProperty( "to_Item" )
    @ODataField( odataName = "to_Item" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ServiceOrderItem> toItem;
    /**
     * Navigation property <b>to_Partner</b> for <b>ServiceOrder</b> to multiple <b>SrvcOrdPartner</b>.
     *
     */
    @SerializedName( "to_Partner" )
    @JsonProperty( "to_Partner" )
    @ODataField( odataName = "to_Partner" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SrvcOrdPartner> toPartner;
    /**
     * Navigation property <b>to_PersonResponsible</b> for <b>ServiceOrder</b> to multiple
     * <b>ServiceOrderPersonResp</b>.
     *
     */
    @SerializedName( "to_PersonResponsible" )
    @JsonProperty( "to_PersonResponsible" )
    @ODataField( odataName = "to_PersonResponsible" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ServiceOrderPersonResp> toPersonResponsible;
    /**
     * Navigation property <b>to_PricingElement</b> for <b>ServiceOrder</b> to multiple <b>ServiceOrderPriceElement</b>.
     *
     */
    @SerializedName( "to_PricingElement" )
    @JsonProperty( "to_PricingElement" )
    @ODataField( odataName = "to_PricingElement" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ServiceOrderPriceElement> toPricingElement;
    /**
     * Navigation property <b>to_ProductReferenceObject</b> for <b>ServiceOrder</b> to multiple
     * <b>SrvcOrdProdRefObject</b>.
     *
     */
    @SerializedName( "to_ProductReferenceObject" )
    @JsonProperty( "to_ProductReferenceObject" )
    @ODataField( odataName = "to_ProductReferenceObject" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SrvcOrdProdRefObject> toProductReferenceObject;
    /**
     * Navigation property <b>to_ReferenceObject</b> for <b>ServiceOrder</b> to multiple <b>ServiceOrderRefObject</b>.
     *
     */
    @SerializedName( "to_ReferenceObject" )
    @JsonProperty( "to_ReferenceObject" )
    @ODataField( odataName = "to_ReferenceObject" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ServiceOrderRefObject> toReferenceObject;
    /**
     * Navigation property <b>to_ReferenceServiceContract</b> for <b>ServiceOrder</b> to multiple
     * <b>SrvcOrdRefServiceContract</b>.
     *
     */
    @SerializedName( "to_ReferenceServiceContract" )
    @JsonProperty( "to_ReferenceServiceContract" )
    @ODataField( odataName = "to_ReferenceServiceContract" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SrvcOrdRefServiceContract> toReferenceServiceContract;
    /**
     * Navigation property <b>to_ServiceOrdUserStatus</b> for <b>ServiceOrder</b> to multiple
     * <b>ServiceOrdUserStatus</b>.
     *
     */
    @SerializedName( "to_ServiceOrdUserStatus" )
    @JsonProperty( "to_ServiceOrdUserStatus" )
    @ODataField( odataName = "to_ServiceOrdUserStatus" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ServiceOrdUserStatus> toServiceOrdUserStatus;
    /**
     * Navigation property <b>to_Text</b> for <b>ServiceOrder</b> to multiple <b>ServiceOrderText</b>.
     *
     */
    @SerializedName( "to_Text" )
    @JsonProperty( "to_Text" )
    @ODataField( odataName = "to_Text" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ServiceOrderText> toText;
    /**
     * Use with available fluent helpers to apply the <b>to_Appointment</b> navigation property to query operations.
     *
     */
    public final static ServiceOrderLink<SrvcOrdAppointment> TO_APPOINTMENT =
        new ServiceOrderLink<SrvcOrdAppointment>("to_Appointment");
    /**
     * Use with available fluent helpers to apply the <b>to_Confirmation</b> navigation property to query operations.
     *
     */
    public final static ServiceOrderLink<ServiceOrderConfirmation> TO_CONFIRMATION =
        new ServiceOrderLink<ServiceOrderConfirmation>("to_Confirmation");
    /**
     * Use with available fluent helpers to apply the <b>to_Defect</b> navigation property to query operations.
     *
     */
    public final static ServiceOrderLink<ServiceOrderDefect> TO_DEFECT =
        new ServiceOrderLink<ServiceOrderDefect>("to_Defect");
    /**
     * Use with available fluent helpers to apply the <b>to_Duration</b> navigation property to query operations.
     *
     */
    public final static ServiceOrderLink<SrvcOrdDuration> TO_DURATION =
        new ServiceOrderLink<SrvcOrdDuration>("to_Duration");
    /**
     * Use with available fluent helpers to apply the <b>to_Item</b> navigation property to query operations.
     *
     */
    public final static ServiceOrderLink<ServiceOrderItem> TO_ITEM = new ServiceOrderLink<ServiceOrderItem>("to_Item");
    /**
     * Use with available fluent helpers to apply the <b>to_Partner</b> navigation property to query operations.
     *
     */
    public final static ServiceOrderLink<SrvcOrdPartner> TO_PARTNER =
        new ServiceOrderLink<SrvcOrdPartner>("to_Partner");
    /**
     * Use with available fluent helpers to apply the <b>to_PersonResponsible</b> navigation property to query
     * operations.
     *
     */
    public final static ServiceOrderLink<ServiceOrderPersonResp> TO_PERSON_RESPONSIBLE =
        new ServiceOrderLink<ServiceOrderPersonResp>("to_PersonResponsible");
    /**
     * Use with available fluent helpers to apply the <b>to_PricingElement</b> navigation property to query operations.
     *
     */
    public final static ServiceOrderLink<ServiceOrderPriceElement> TO_PRICING_ELEMENT =
        new ServiceOrderLink<ServiceOrderPriceElement>("to_PricingElement");
    /**
     * Use with available fluent helpers to apply the <b>to_ProductReferenceObject</b> navigation property to query
     * operations.
     *
     */
    public final static ServiceOrderLink<SrvcOrdProdRefObject> TO_PRODUCT_REFERENCE_OBJECT =
        new ServiceOrderLink<SrvcOrdProdRefObject>("to_ProductReferenceObject");
    /**
     * Use with available fluent helpers to apply the <b>to_ReferenceObject</b> navigation property to query operations.
     *
     */
    public final static ServiceOrderLink<ServiceOrderRefObject> TO_REFERENCE_OBJECT =
        new ServiceOrderLink<ServiceOrderRefObject>("to_ReferenceObject");
    /**
     * Use with available fluent helpers to apply the <b>to_ReferenceServiceContract</b> navigation property to query
     * operations.
     *
     */
    public final static ServiceOrderLink<SrvcOrdRefServiceContract> TO_REFERENCE_SERVICE_CONTRACT =
        new ServiceOrderLink<SrvcOrdRefServiceContract>("to_ReferenceServiceContract");
    /**
     * Use with available fluent helpers to apply the <b>to_ServiceOrdUserStatus</b> navigation property to query
     * operations.
     *
     */
    public final static ServiceOrderLink<ServiceOrdUserStatus> TO_SERVICE_ORD_USER_STATUS =
        new ServiceOrderLink<ServiceOrdUserStatus>("to_ServiceOrdUserStatus");
    /**
     * Use with available fluent helpers to apply the <b>to_Text</b> navigation property to query operations.
     *
     */
    public final static ServiceOrderLink<ServiceOrderText> TO_TEXT = new ServiceOrderLink<ServiceOrderText>("to_Text");

    @Nonnull
    @Override
    public Class<ServiceOrder> getType()
    {
        return ServiceOrder.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServiceOrder</b>
     * </p>
     *
     * @param serviceOrder
     *            Transaction ID
     */
    public void setServiceOrder( @Nullable final String serviceOrder )
    {
        rememberChangedField("ServiceOrder", this.serviceOrder);
        this.serviceOrder = serviceOrder;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ServiceOrderType</b>
     * </p>
     *
     * @param serviceOrderType
     *            Business Transaction Type
     */
    public void setServiceOrderType( @Nullable final String serviceOrderType )
    {
        rememberChangedField("ServiceOrderType", this.serviceOrderType);
        this.serviceOrderType = serviceOrderType;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ServiceOrderUUID</b>
     * </p>
     *
     * @param serviceOrderUUID
     *            GUID of a CRM Order Object
     */
    public void setServiceOrderUUID( @Nullable final UUID serviceOrderUUID )
    {
        rememberChangedField("ServiceOrderUUID", this.serviceOrderUUID);
        this.serviceOrderUUID = serviceOrderUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ServiceOrderDescription</b>
     * </p>
     *
     * @param serviceOrderDescription
     *            Transaction Description
     */
    public void setServiceOrderDescription( @Nullable final String serviceOrderDescription )
    {
        rememberChangedField("ServiceOrderDescription", this.serviceOrderDescription);
        this.serviceOrderDescription = serviceOrderDescription;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServiceObjectType</b>
     * </p>
     *
     * @param serviceObjectType
     *            Business Trans. Cat.
     */
    public void setServiceObjectType( @Nullable final String serviceObjectType )
    {
        rememberChangedField("ServiceObjectType", this.serviceObjectType);
        this.serviceObjectType = serviceObjectType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key of Description
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocumentPriority</b>
     * </p>
     *
     * @param serviceDocumentPriority
     *            Activity Priority
     */
    public void setServiceDocumentPriority( @Nullable final String serviceDocumentPriority )
    {
        rememberChangedField("ServiceDocumentPriority", this.serviceDocumentPriority);
        this.serviceDocumentPriority = serviceDocumentPriority;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>RequestedServiceStartDateTime</b>
     * </p>
     *
     * @param requestedServiceStartDateTime
     *            Service Request Start Date
     */
    public void setRequestedServiceStartDateTime( @Nullable final ZonedDateTime requestedServiceStartDateTime )
    {
        rememberChangedField("RequestedServiceStartDateTime", this.requestedServiceStartDateTime);
        this.requestedServiceStartDateTime = requestedServiceStartDateTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>RequestedServiceEndDateTime</b>
     * </p>
     *
     * @param requestedServiceEndDateTime
     *            Service Request Due Date
     */
    public void setRequestedServiceEndDateTime( @Nullable final ZonedDateTime requestedServiceEndDateTime )
    {
        rememberChangedField("RequestedServiceEndDateTime", this.requestedServiceEndDateTime);
        this.requestedServiceEndDateTime = requestedServiceEndDateTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocChangedDateTime</b>
     * </p>
     *
     * @param serviceDocChangedDateTime
     *            Changed At
     */
    public void setServiceDocChangedDateTime( @Nullable final ZonedDateTime serviceDocChangedDateTime )
    {
        rememberChangedField("ServiceDocChangedDateTime", this.serviceDocChangedDateTime);
        this.serviceDocChangedDateTime = serviceDocChangedDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocumentTemplateType</b>
     * </p>
     *
     * @param serviceDocumentTemplateType
     *            Template Type of CRM Transaction
     */
    public void setServiceDocumentTemplateType( @Nullable final String serviceDocumentTemplateType )
    {
        rememberChangedField("ServiceDocumentTemplateType", this.serviceDocumentTemplateType);
        this.serviceDocumentTemplateType = serviceDocumentTemplateType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrderByCustomer</b>
     * </p>
     *
     * @param purchaseOrderByCustomer
     *            Sold-To Party's External Reference Number
     */
    public void setPurchaseOrderByCustomer( @Nullable final String purchaseOrderByCustomer )
    {
        rememberChangedField("PurchaseOrderByCustomer", this.purchaseOrderByCustomer);
        this.purchaseOrderByCustomer = purchaseOrderByCustomer;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CustomerPurchaseOrderDate</b>
     * </p>
     *
     * @param customerPurchaseOrderDate
     *            Reference Document Date
     */
    public void setCustomerPurchaseOrderDate( @Nullable final LocalDateTime customerPurchaseOrderDate )
    {
        rememberChangedField("CustomerPurchaseOrderDate", this.customerPurchaseOrderDate);
        this.customerPurchaseOrderDate = customerPurchaseOrderDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ServiceOrderIsReleased</b>
     * </p>
     *
     * @param serviceOrderIsReleased
     *            Release Status
     */
    public void setServiceOrderIsReleased( @Nullable final String serviceOrderIsReleased )
    {
        rememberChangedField("ServiceOrderIsReleased", this.serviceOrderIsReleased);
        this.serviceOrderIsReleased = serviceOrderIsReleased;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ServiceOrderIsCompleted</b>
     * </p>
     *
     * @param serviceOrderIsCompleted
     *            The serviceOrderIsCompleted to set.
     */
    public void setServiceOrderIsCompleted( @Nullable final String serviceOrderIsCompleted )
    {
        rememberChangedField("ServiceOrderIsCompleted", this.serviceOrderIsCompleted);
        this.serviceOrderIsCompleted = serviceOrderIsCompleted;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ServiceOrderIsRejected</b>
     * </p>
     *
     * @param serviceOrderIsRejected
     *            Cancellation Status
     */
    public void setServiceOrderIsRejected( @Nullable final String serviceOrderIsRejected )
    {
        rememberChangedField("ServiceOrderIsRejected", this.serviceOrderIsRejected);
        this.serviceOrderIsRejected = serviceOrderIsRejected;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrganization</b>
     * </p>
     *
     * @param salesOrganization
     *            Sales Organization
     */
    public void setSalesOrganization( @Nullable final String salesOrganization )
    {
        rememberChangedField("SalesOrganization", this.salesOrganization);
        this.salesOrganization = salesOrganization;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DistributionChannel</b>
     * </p>
     *
     * @param distributionChannel
     *            Distribution Channel
     */
    public void setDistributionChannel( @Nullable final String distributionChannel )
    {
        rememberChangedField("DistributionChannel", this.distributionChannel);
        this.distributionChannel = distributionChannel;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Division</b>
     * </p>
     *
     * @param division
     *            Division
     */
    public void setDivision( @Nullable final String division )
    {
        rememberChangedField("Division", this.division);
        this.division = division;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOffice</b>
     * </p>
     *
     * @param salesOffice
     *            Sales Office
     */
    public void setSalesOffice( @Nullable final String salesOffice )
    {
        rememberChangedField("SalesOffice", this.salesOffice);
        this.salesOffice = salesOffice;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SalesGroup</b>
     * </p>
     *
     * @param salesGroup
     *            Sales Group
     */
    public void setSalesGroup( @Nullable final String salesGroup )
    {
        rememberChangedField("SalesGroup", this.salesGroup);
        this.salesGroup = salesGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SoldToParty</b>
     * </p>
     *
     * @param soldToParty
     *            Sold-To Party
     */
    public void setSoldToParty( @Nullable final String soldToParty )
    {
        rememberChangedField("SoldToParty", this.soldToParty);
        this.soldToParty = soldToParty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ShipToParty</b>
     * </p>
     *
     * @param shipToParty
     *            Ship-To Party
     */
    public void setShipToParty( @Nullable final String shipToParty )
    {
        rememberChangedField("ShipToParty", this.shipToParty);
        this.shipToParty = shipToParty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BillToParty</b>
     * </p>
     *
     * @param billToParty
     *            Bill-To Party
     */
    public void setBillToParty( @Nullable final String billToParty )
    {
        rememberChangedField("BillToParty", this.billToParty);
        this.billToParty = billToParty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PayerParty</b>
     * </p>
     *
     * @param payerParty
     *            Payer
     */
    public void setPayerParty( @Nullable final String payerParty )
    {
        rememberChangedField("PayerParty", this.payerParty);
        this.payerParty = payerParty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ContactPerson</b>
     * </p>
     *
     * @param contactPerson
     *            Customer Contact Person
     */
    public void setContactPerson( @Nullable final String contactPerson )
    {
        rememberChangedField("ContactPerson", this.contactPerson);
        this.contactPerson = contactPerson;
    }

    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocGrossAmount</b>
     * </p>
     *
     * @param serviceDocGrossAmount
     *            Total Gross Value of Document in Document Currency
     */
    public void setServiceDocGrossAmount( @Nullable final BigDecimal serviceDocGrossAmount )
    {
        rememberChangedField("ServiceDocGrossAmount", this.serviceDocGrossAmount);
        this.serviceDocGrossAmount = serviceDocGrossAmount;
    }

    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocNetAmount</b>
     * </p>
     *
     * @param serviceDocNetAmount
     *            Total Net Value of Document in Document Currency
     */
    public void setServiceDocNetAmount( @Nullable final BigDecimal serviceDocNetAmount )
    {
        rememberChangedField("ServiceDocNetAmount", this.serviceDocNetAmount);
        this.serviceDocNetAmount = serviceDocNetAmount;
    }

    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocTaxAmount</b>
     * </p>
     *
     * @param serviceDocTaxAmount
     *            Total Tax Amount in Document Currency
     */
    public void setServiceDocTaxAmount( @Nullable final BigDecimal serviceDocTaxAmount )
    {
        rememberChangedField("ServiceDocTaxAmount", this.serviceDocTaxAmount);
        this.serviceDocTaxAmount = serviceDocTaxAmount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrency</b>
     * </p>
     *
     * @param transactionCurrency
     *            Currency
     */
    public void setTransactionCurrency( @Nullable final String transactionCurrency )
    {
        rememberChangedField("TransactionCurrency", this.transactionCurrency);
        this.transactionCurrency = transactionCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceServiceRequest</b>
     * </p>
     *
     * @param referenceServiceRequest
     *            Transaction ID
     */
    public void setReferenceServiceRequest( @Nullable final String referenceServiceRequest )
    {
        rememberChangedField("ReferenceServiceRequest", this.referenceServiceRequest);
        this.referenceServiceRequest = referenceServiceRequest;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceServiceContract</b>
     * </p>
     *
     * @param referenceServiceContract
     *            Transaction ID
     */
    public void setReferenceServiceContract( @Nullable final String referenceServiceContract )
    {
        rememberChangedField("ReferenceServiceContract", this.referenceServiceContract);
        this.referenceServiceContract = referenceServiceContract;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RefServiceOrderTemplate</b>
     * </p>
     *
     * @param refServiceOrderTemplate
     *            Transaction ID
     */
    public void setRefServiceOrderTemplate( @Nullable final String refServiceOrderTemplate )
    {
        rememberChangedField("RefServiceOrderTemplate", this.refServiceOrderTemplate);
        this.refServiceOrderTemplate = refServiceOrderTemplate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceServiceOrder</b>
     * </p>
     *
     * @param referenceServiceOrder
     *            External Reference Number
     */
    public void setReferenceServiceOrder( @Nullable final String referenceServiceOrder )
    {
        rememberChangedField("ReferenceServiceOrder", this.referenceServiceOrder);
        this.referenceServiceOrder = referenceServiceOrder;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ShippingCondition</b>
     * </p>
     *
     * @param shippingCondition
     *            Shipping Conditions
     */
    public void setShippingCondition( @Nullable final String shippingCondition )
    {
        rememberChangedField("ShippingCondition", this.shippingCondition);
        this.shippingCondition = shippingCondition;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>RespyMgmtServiceTeam</b>
     * </p>
     *
     * @param respyMgmtServiceTeam
     *            Service Team (Responsibility Management)
     */
    public void setRespyMgmtServiceTeam( @Nullable final String respyMgmtServiceTeam )
    {
        rememberChangedField("RespyMgmtServiceTeam", this.respyMgmtServiceTeam);
        this.respyMgmtServiceTeam = respyMgmtServiceTeam;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>RespyMgmtServiceTeamName</b>
     * </p>
     *
     * @param respyMgmtServiceTeamName
     *            Name
     */
    public void setRespyMgmtServiceTeamName( @Nullable final String respyMgmtServiceTeamName )
    {
        rememberChangedField("RespyMgmtServiceTeamName", this.respyMgmtServiceTeamName);
        this.respyMgmtServiceTeamName = respyMgmtServiceTeamName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>RespyMgmtGlobalTeamID</b>
     * </p>
     *
     * @param respyMgmtGlobalTeamID
     *            Global Team ID in Responsibility Mgmt.
     */
    public void setRespyMgmtGlobalTeamID( @Nullable final String respyMgmtGlobalTeamID )
    {
        rememberChangedField("RespyMgmtGlobalTeamID", this.respyMgmtGlobalTeamID);
        this.respyMgmtGlobalTeamID = respyMgmtGlobalTeamID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SrvcOrdCreditStatus</b>
     * </p>
     *
     * @param srvcOrdCreditStatus
     *            Credit Status of Header
     */
    public void setSrvcOrdCreditStatus( @Nullable final String srvcOrdCreditStatus )
    {
        rememberChangedField("SrvcOrdCreditStatus", this.srvcOrdCreditStatus);
        this.srvcOrdCreditStatus = srvcOrdCreditStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SrvcOrdExecutionStatus</b>
     * </p>
     *
     * @param srvcOrdExecutionStatus
     *            Execution Status
     */
    public void setSrvcOrdExecutionStatus( @Nullable final String srvcOrdExecutionStatus )
    {
        rememberChangedField("SrvcOrdExecutionStatus", this.srvcOrdExecutionStatus);
        this.srvcOrdExecutionStatus = srvcOrdExecutionStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PaymentTerms</b>
     * </p>
     *
     * @param paymentTerms
     *            Terms of Payment
     */
    public void setPaymentTerms( @Nullable final String paymentTerms )
    {
        rememberChangedField("PaymentTerms", this.paymentTerms);
        this.paymentTerms = paymentTerms;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PaymentMethod</b>
     * </p>
     *
     * @param paymentMethod
     *            Payment Method
     */
    public void setPaymentMethod( @Nullable final String paymentMethod )
    {
        rememberChangedField("PaymentMethod", this.paymentMethod);
        this.paymentMethod = paymentMethod;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>SEPAMandate</b>
     * </p>
     *
     * @param sEPAMandate
     *            Unique Reference to Mandate per Payment Recipient
     */
    public void setSEPAMandate( @Nullable final String sEPAMandate )
    {
        rememberChangedField("SEPAMandate", this.sEPAMandate);
        this.sEPAMandate = sEPAMandate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SrvcSEPAMandateRelevance</b>
     * </p>
     *
     * @param srvcSEPAMandateRelevance
     *            Indicator for SEPA-Relevant Transactions
     */
    public void setSrvcSEPAMandateRelevance( @Nullable final String srvcSEPAMandateRelevance )
    {
        rememberChangedField("SrvcSEPAMandateRelevance", this.srvcSEPAMandateRelevance);
        this.srvcSEPAMandateRelevance = srvcSEPAMandateRelevance;
    }

    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>WBSElementExternalID</b>
     * </p>
     *
     * @param wBSElementExternalID
     *            Work Breakdown Structure Element (WBS Element) Edited
     */
    public void setWBSElementExternalID( @Nullable final String wBSElementExternalID )
    {
        rememberChangedField("WBSElementExternalID", this.wBSElementExternalID);
        this.wBSElementExternalID = wBSElementExternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 14
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrganizationOrgUnitID</b>
     * </p>
     *
     * @param salesOrganizationOrgUnitID
     *            Sales Organization ID
     */
    public void setSalesOrganizationOrgUnitID( @Nullable final String salesOrganizationOrgUnitID )
    {
        rememberChangedField("SalesOrganizationOrgUnitID", this.salesOrganizationOrgUnitID);
        this.salesOrganizationOrgUnitID = salesOrganizationOrgUnitID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 14
     * <p>
     * Original property name from the Odata EDM: <b>ServiceOrganization</b>
     * </p>
     *
     * @param serviceOrganization
     *            Service Organization
     */
    public void setServiceOrganization( @Nullable final String serviceOrganization )
    {
        rememberChangedField("ServiceOrganization", this.serviceOrganization);
        this.serviceOrganization = serviceOrganization;
    }

    /**
     * Constraints: Not nullable, Maximum length: 14
     * <p>
     * Original property name from the Odata EDM: <b>SalesOfficeOrgUnitID</b>
     * </p>
     *
     * @param salesOfficeOrgUnitID
     *            Sales Office
     */
    public void setSalesOfficeOrgUnitID( @Nullable final String salesOfficeOrgUnitID )
    {
        rememberChangedField("SalesOfficeOrgUnitID", this.salesOfficeOrgUnitID);
        this.salesOfficeOrgUnitID = salesOfficeOrgUnitID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 14
     * <p>
     * Original property name from the Odata EDM: <b>SalesGroupOrgUnitID</b>
     * </p>
     *
     * @param salesGroupOrgUnitID
     *            Sales Group
     */
    public void setSalesGroupOrgUnitID( @Nullable final String salesGroupOrgUnitID )
    {
        rememberChangedField("SalesGroupOrgUnitID", this.salesGroupOrgUnitID);
        this.salesGroupOrgUnitID = salesGroupOrgUnitID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>FSMServiceCall</b>
     * </p>
     *
     * @param fSMServiceCall
     *            Object key
     */
    public void setFSMServiceCall( @Nullable final String fSMServiceCall )
    {
        rememberChangedField("FSMServiceCall", this.fSMServiceCall);
        this.fSMServiceCall = fSMServiceCall;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ServiceOrderRejectionReason</b>
     * </p>
     *
     * @param serviceOrderRejectionReason
     *            Cancellation Reason Code
     */
    public void setServiceOrderRejectionReason( @Nullable final String serviceOrderRejectionReason )
    {
        rememberChangedField("ServiceOrderRejectionReason", this.serviceOrderRejectionReason);
        this.serviceOrderRejectionReason = serviceOrderRejectionReason;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceInHouseRepair</b>
     * </p>
     *
     * @param referenceInHouseRepair
     *            Reference In-House Repair
     */
    public void setReferenceInHouseRepair( @Nullable final String referenceInHouseRepair )
    {
        rememberChangedField("ReferenceInHouseRepair", this.referenceInHouseRepair);
        this.referenceInHouseRepair = referenceInHouseRepair;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceInHouseRepairItem</b>
     * </p>
     *
     * @param referenceInHouseRepairItem
     *            Reference In-House Repair Item
     */
    public void setReferenceInHouseRepairItem( @Nullable final String referenceInHouseRepairItem )
    {
        rememberChangedField("ReferenceInHouseRepairItem", this.referenceInHouseRepairItem);
        this.referenceInHouseRepairItem = referenceInHouseRepairItem;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_ServiceOrder";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ServiceOrder", getServiceOrder());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ServiceOrder", getServiceOrder());
        values.put("ServiceOrderType", getServiceOrderType());
        values.put("ServiceOrderUUID", getServiceOrderUUID());
        values.put("ServiceOrderDescription", getServiceOrderDescription());
        values.put("ServiceObjectType", getServiceObjectType());
        values.put("Language", getLanguage());
        values.put("ServiceDocumentPriority", getServiceDocumentPriority());
        values.put("RequestedServiceStartDateTime", getRequestedServiceStartDateTime());
        values.put("RequestedServiceEndDateTime", getRequestedServiceEndDateTime());
        values.put("ServiceDocChangedDateTime", getServiceDocChangedDateTime());
        values.put("ServiceDocumentTemplateType", getServiceDocumentTemplateType());
        values.put("PurchaseOrderByCustomer", getPurchaseOrderByCustomer());
        values.put("CustomerPurchaseOrderDate", getCustomerPurchaseOrderDate());
        values.put("ServiceOrderIsReleased", getServiceOrderIsReleased());
        values.put("ServiceOrderIsCompleted", getServiceOrderIsCompleted());
        values.put("ServiceOrderIsRejected", getServiceOrderIsRejected());
        values.put("SalesOrganization", getSalesOrganization());
        values.put("DistributionChannel", getDistributionChannel());
        values.put("Division", getDivision());
        values.put("SalesOffice", getSalesOffice());
        values.put("SalesGroup", getSalesGroup());
        values.put("SoldToParty", getSoldToParty());
        values.put("ShipToParty", getShipToParty());
        values.put("BillToParty", getBillToParty());
        values.put("PayerParty", getPayerParty());
        values.put("ContactPerson", getContactPerson());
        values.put("ServiceDocGrossAmount", getServiceDocGrossAmount());
        values.put("ServiceDocNetAmount", getServiceDocNetAmount());
        values.put("ServiceDocTaxAmount", getServiceDocTaxAmount());
        values.put("TransactionCurrency", getTransactionCurrency());
        values.put("ReferenceServiceRequest", getReferenceServiceRequest());
        values.put("ReferenceServiceContract", getReferenceServiceContract());
        values.put("RefServiceOrderTemplate", getRefServiceOrderTemplate());
        values.put("ReferenceServiceOrder", getReferenceServiceOrder());
        values.put("ShippingCondition", getShippingCondition());
        values.put("RespyMgmtServiceTeam", getRespyMgmtServiceTeam());
        values.put("RespyMgmtServiceTeamName", getRespyMgmtServiceTeamName());
        values.put("RespyMgmtGlobalTeamID", getRespyMgmtGlobalTeamID());
        values.put("SrvcOrdCreditStatus", getSrvcOrdCreditStatus());
        values.put("SrvcOrdExecutionStatus", getSrvcOrdExecutionStatus());
        values.put("PaymentTerms", getPaymentTerms());
        values.put("PaymentMethod", getPaymentMethod());
        values.put("SEPAMandate", getSEPAMandate());
        values.put("SrvcSEPAMandateRelevance", getSrvcSEPAMandateRelevance());
        values.put("WBSElementExternalID", getWBSElementExternalID());
        values.put("SalesOrganizationOrgUnitID", getSalesOrganizationOrgUnitID());
        values.put("ServiceOrganization", getServiceOrganization());
        values.put("SalesOfficeOrgUnitID", getSalesOfficeOrgUnitID());
        values.put("SalesGroupOrgUnitID", getSalesGroupOrgUnitID());
        values.put("FSMServiceCall", getFSMServiceCall());
        values.put("ServiceOrderRejectionReason", getServiceOrderRejectionReason());
        values.put("ReferenceInHouseRepair", getReferenceInHouseRepair());
        values.put("ReferenceInHouseRepairItem", getReferenceInHouseRepairItem());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ServiceOrder") ) {
                final Object value = values.remove("ServiceOrder");
                if( (value == null) || (!value.equals(getServiceOrder())) ) {
                    setServiceOrder(((String) value));
                }
            }
            if( values.containsKey("ServiceOrderType") ) {
                final Object value = values.remove("ServiceOrderType");
                if( (value == null) || (!value.equals(getServiceOrderType())) ) {
                    setServiceOrderType(((String) value));
                }
            }
            if( values.containsKey("ServiceOrderUUID") ) {
                final Object value = values.remove("ServiceOrderUUID");
                if( (value == null) || (!value.equals(getServiceOrderUUID())) ) {
                    setServiceOrderUUID(((UUID) value));
                }
            }
            if( values.containsKey("ServiceOrderDescription") ) {
                final Object value = values.remove("ServiceOrderDescription");
                if( (value == null) || (!value.equals(getServiceOrderDescription())) ) {
                    setServiceOrderDescription(((String) value));
                }
            }
            if( values.containsKey("ServiceObjectType") ) {
                final Object value = values.remove("ServiceObjectType");
                if( (value == null) || (!value.equals(getServiceObjectType())) ) {
                    setServiceObjectType(((String) value));
                }
            }
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("ServiceDocumentPriority") ) {
                final Object value = values.remove("ServiceDocumentPriority");
                if( (value == null) || (!value.equals(getServiceDocumentPriority())) ) {
                    setServiceDocumentPriority(((String) value));
                }
            }
            if( values.containsKey("RequestedServiceStartDateTime") ) {
                final Object value = values.remove("RequestedServiceStartDateTime");
                if( (value == null) || (!value.equals(getRequestedServiceStartDateTime())) ) {
                    setRequestedServiceStartDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("RequestedServiceEndDateTime") ) {
                final Object value = values.remove("RequestedServiceEndDateTime");
                if( (value == null) || (!value.equals(getRequestedServiceEndDateTime())) ) {
                    setRequestedServiceEndDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("ServiceDocChangedDateTime") ) {
                final Object value = values.remove("ServiceDocChangedDateTime");
                if( (value == null) || (!value.equals(getServiceDocChangedDateTime())) ) {
                    setServiceDocChangedDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("ServiceDocumentTemplateType") ) {
                final Object value = values.remove("ServiceDocumentTemplateType");
                if( (value == null) || (!value.equals(getServiceDocumentTemplateType())) ) {
                    setServiceDocumentTemplateType(((String) value));
                }
            }
            if( values.containsKey("PurchaseOrderByCustomer") ) {
                final Object value = values.remove("PurchaseOrderByCustomer");
                if( (value == null) || (!value.equals(getPurchaseOrderByCustomer())) ) {
                    setPurchaseOrderByCustomer(((String) value));
                }
            }
            if( values.containsKey("CustomerPurchaseOrderDate") ) {
                final Object value = values.remove("CustomerPurchaseOrderDate");
                if( (value == null) || (!value.equals(getCustomerPurchaseOrderDate())) ) {
                    setCustomerPurchaseOrderDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ServiceOrderIsReleased") ) {
                final Object value = values.remove("ServiceOrderIsReleased");
                if( (value == null) || (!value.equals(getServiceOrderIsReleased())) ) {
                    setServiceOrderIsReleased(((String) value));
                }
            }
            if( values.containsKey("ServiceOrderIsCompleted") ) {
                final Object value = values.remove("ServiceOrderIsCompleted");
                if( (value == null) || (!value.equals(getServiceOrderIsCompleted())) ) {
                    setServiceOrderIsCompleted(((String) value));
                }
            }
            if( values.containsKey("ServiceOrderIsRejected") ) {
                final Object value = values.remove("ServiceOrderIsRejected");
                if( (value == null) || (!value.equals(getServiceOrderIsRejected())) ) {
                    setServiceOrderIsRejected(((String) value));
                }
            }
            if( values.containsKey("SalesOrganization") ) {
                final Object value = values.remove("SalesOrganization");
                if( (value == null) || (!value.equals(getSalesOrganization())) ) {
                    setSalesOrganization(((String) value));
                }
            }
            if( values.containsKey("DistributionChannel") ) {
                final Object value = values.remove("DistributionChannel");
                if( (value == null) || (!value.equals(getDistributionChannel())) ) {
                    setDistributionChannel(((String) value));
                }
            }
            if( values.containsKey("Division") ) {
                final Object value = values.remove("Division");
                if( (value == null) || (!value.equals(getDivision())) ) {
                    setDivision(((String) value));
                }
            }
            if( values.containsKey("SalesOffice") ) {
                final Object value = values.remove("SalesOffice");
                if( (value == null) || (!value.equals(getSalesOffice())) ) {
                    setSalesOffice(((String) value));
                }
            }
            if( values.containsKey("SalesGroup") ) {
                final Object value = values.remove("SalesGroup");
                if( (value == null) || (!value.equals(getSalesGroup())) ) {
                    setSalesGroup(((String) value));
                }
            }
            if( values.containsKey("SoldToParty") ) {
                final Object value = values.remove("SoldToParty");
                if( (value == null) || (!value.equals(getSoldToParty())) ) {
                    setSoldToParty(((String) value));
                }
            }
            if( values.containsKey("ShipToParty") ) {
                final Object value = values.remove("ShipToParty");
                if( (value == null) || (!value.equals(getShipToParty())) ) {
                    setShipToParty(((String) value));
                }
            }
            if( values.containsKey("BillToParty") ) {
                final Object value = values.remove("BillToParty");
                if( (value == null) || (!value.equals(getBillToParty())) ) {
                    setBillToParty(((String) value));
                }
            }
            if( values.containsKey("PayerParty") ) {
                final Object value = values.remove("PayerParty");
                if( (value == null) || (!value.equals(getPayerParty())) ) {
                    setPayerParty(((String) value));
                }
            }
            if( values.containsKey("ContactPerson") ) {
                final Object value = values.remove("ContactPerson");
                if( (value == null) || (!value.equals(getContactPerson())) ) {
                    setContactPerson(((String) value));
                }
            }
            if( values.containsKey("ServiceDocGrossAmount") ) {
                final Object value = values.remove("ServiceDocGrossAmount");
                if( (value == null) || (!value.equals(getServiceDocGrossAmount())) ) {
                    setServiceDocGrossAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("ServiceDocNetAmount") ) {
                final Object value = values.remove("ServiceDocNetAmount");
                if( (value == null) || (!value.equals(getServiceDocNetAmount())) ) {
                    setServiceDocNetAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("ServiceDocTaxAmount") ) {
                final Object value = values.remove("ServiceDocTaxAmount");
                if( (value == null) || (!value.equals(getServiceDocTaxAmount())) ) {
                    setServiceDocTaxAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("TransactionCurrency") ) {
                final Object value = values.remove("TransactionCurrency");
                if( (value == null) || (!value.equals(getTransactionCurrency())) ) {
                    setTransactionCurrency(((String) value));
                }
            }
            if( values.containsKey("ReferenceServiceRequest") ) {
                final Object value = values.remove("ReferenceServiceRequest");
                if( (value == null) || (!value.equals(getReferenceServiceRequest())) ) {
                    setReferenceServiceRequest(((String) value));
                }
            }
            if( values.containsKey("ReferenceServiceContract") ) {
                final Object value = values.remove("ReferenceServiceContract");
                if( (value == null) || (!value.equals(getReferenceServiceContract())) ) {
                    setReferenceServiceContract(((String) value));
                }
            }
            if( values.containsKey("RefServiceOrderTemplate") ) {
                final Object value = values.remove("RefServiceOrderTemplate");
                if( (value == null) || (!value.equals(getRefServiceOrderTemplate())) ) {
                    setRefServiceOrderTemplate(((String) value));
                }
            }
            if( values.containsKey("ReferenceServiceOrder") ) {
                final Object value = values.remove("ReferenceServiceOrder");
                if( (value == null) || (!value.equals(getReferenceServiceOrder())) ) {
                    setReferenceServiceOrder(((String) value));
                }
            }
            if( values.containsKey("ShippingCondition") ) {
                final Object value = values.remove("ShippingCondition");
                if( (value == null) || (!value.equals(getShippingCondition())) ) {
                    setShippingCondition(((String) value));
                }
            }
            if( values.containsKey("RespyMgmtServiceTeam") ) {
                final Object value = values.remove("RespyMgmtServiceTeam");
                if( (value == null) || (!value.equals(getRespyMgmtServiceTeam())) ) {
                    setRespyMgmtServiceTeam(((String) value));
                }
            }
            if( values.containsKey("RespyMgmtServiceTeamName") ) {
                final Object value = values.remove("RespyMgmtServiceTeamName");
                if( (value == null) || (!value.equals(getRespyMgmtServiceTeamName())) ) {
                    setRespyMgmtServiceTeamName(((String) value));
                }
            }
            if( values.containsKey("RespyMgmtGlobalTeamID") ) {
                final Object value = values.remove("RespyMgmtGlobalTeamID");
                if( (value == null) || (!value.equals(getRespyMgmtGlobalTeamID())) ) {
                    setRespyMgmtGlobalTeamID(((String) value));
                }
            }
            if( values.containsKey("SrvcOrdCreditStatus") ) {
                final Object value = values.remove("SrvcOrdCreditStatus");
                if( (value == null) || (!value.equals(getSrvcOrdCreditStatus())) ) {
                    setSrvcOrdCreditStatus(((String) value));
                }
            }
            if( values.containsKey("SrvcOrdExecutionStatus") ) {
                final Object value = values.remove("SrvcOrdExecutionStatus");
                if( (value == null) || (!value.equals(getSrvcOrdExecutionStatus())) ) {
                    setSrvcOrdExecutionStatus(((String) value));
                }
            }
            if( values.containsKey("PaymentTerms") ) {
                final Object value = values.remove("PaymentTerms");
                if( (value == null) || (!value.equals(getPaymentTerms())) ) {
                    setPaymentTerms(((String) value));
                }
            }
            if( values.containsKey("PaymentMethod") ) {
                final Object value = values.remove("PaymentMethod");
                if( (value == null) || (!value.equals(getPaymentMethod())) ) {
                    setPaymentMethod(((String) value));
                }
            }
            if( values.containsKey("SEPAMandate") ) {
                final Object value = values.remove("SEPAMandate");
                if( (value == null) || (!value.equals(getSEPAMandate())) ) {
                    setSEPAMandate(((String) value));
                }
            }
            if( values.containsKey("SrvcSEPAMandateRelevance") ) {
                final Object value = values.remove("SrvcSEPAMandateRelevance");
                if( (value == null) || (!value.equals(getSrvcSEPAMandateRelevance())) ) {
                    setSrvcSEPAMandateRelevance(((String) value));
                }
            }
            if( values.containsKey("WBSElementExternalID") ) {
                final Object value = values.remove("WBSElementExternalID");
                if( (value == null) || (!value.equals(getWBSElementExternalID())) ) {
                    setWBSElementExternalID(((String) value));
                }
            }
            if( values.containsKey("SalesOrganizationOrgUnitID") ) {
                final Object value = values.remove("SalesOrganizationOrgUnitID");
                if( (value == null) || (!value.equals(getSalesOrganizationOrgUnitID())) ) {
                    setSalesOrganizationOrgUnitID(((String) value));
                }
            }
            if( values.containsKey("ServiceOrganization") ) {
                final Object value = values.remove("ServiceOrganization");
                if( (value == null) || (!value.equals(getServiceOrganization())) ) {
                    setServiceOrganization(((String) value));
                }
            }
            if( values.containsKey("SalesOfficeOrgUnitID") ) {
                final Object value = values.remove("SalesOfficeOrgUnitID");
                if( (value == null) || (!value.equals(getSalesOfficeOrgUnitID())) ) {
                    setSalesOfficeOrgUnitID(((String) value));
                }
            }
            if( values.containsKey("SalesGroupOrgUnitID") ) {
                final Object value = values.remove("SalesGroupOrgUnitID");
                if( (value == null) || (!value.equals(getSalesGroupOrgUnitID())) ) {
                    setSalesGroupOrgUnitID(((String) value));
                }
            }
            if( values.containsKey("FSMServiceCall") ) {
                final Object value = values.remove("FSMServiceCall");
                if( (value == null) || (!value.equals(getFSMServiceCall())) ) {
                    setFSMServiceCall(((String) value));
                }
            }
            if( values.containsKey("ServiceOrderRejectionReason") ) {
                final Object value = values.remove("ServiceOrderRejectionReason");
                if( (value == null) || (!value.equals(getServiceOrderRejectionReason())) ) {
                    setServiceOrderRejectionReason(((String) value));
                }
            }
            if( values.containsKey("ReferenceInHouseRepair") ) {
                final Object value = values.remove("ReferenceInHouseRepair");
                if( (value == null) || (!value.equals(getReferenceInHouseRepair())) ) {
                    setReferenceInHouseRepair(((String) value));
                }
            }
            if( values.containsKey("ReferenceInHouseRepairItem") ) {
                final Object value = values.remove("ReferenceInHouseRepairItem");
                if( (value == null) || (!value.equals(getReferenceInHouseRepairItem())) ) {
                    setReferenceInHouseRepairItem(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_Appointment") ) {
                final Object value = (values).remove("to_Appointment");
                if( value instanceof Iterable ) {
                    if( toAppointment == null ) {
                        toAppointment = Lists.newArrayList();
                    } else {
                        toAppointment = Lists.newArrayList(toAppointment);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SrvcOrdAppointment entity;
                        if( toAppointment.size() > i ) {
                            entity = toAppointment.get(i);
                        } else {
                            entity = new SrvcOrdAppointment();
                            toAppointment.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_Confirmation") ) {
                final Object value = (values).remove("to_Confirmation");
                if( value instanceof Iterable ) {
                    if( toConfirmation == null ) {
                        toConfirmation = Lists.newArrayList();
                    } else {
                        toConfirmation = Lists.newArrayList(toConfirmation);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ServiceOrderConfirmation entity;
                        if( toConfirmation.size() > i ) {
                            entity = toConfirmation.get(i);
                        } else {
                            entity = new ServiceOrderConfirmation();
                            toConfirmation.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_Defect") ) {
                final Object value = (values).remove("to_Defect");
                if( value instanceof Iterable ) {
                    if( toDefect == null ) {
                        toDefect = Lists.newArrayList();
                    } else {
                        toDefect = Lists.newArrayList(toDefect);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ServiceOrderDefect entity;
                        if( toDefect.size() > i ) {
                            entity = toDefect.get(i);
                        } else {
                            entity = new ServiceOrderDefect();
                            toDefect.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_Duration") ) {
                final Object value = (values).remove("to_Duration");
                if( value instanceof Iterable ) {
                    if( toDuration == null ) {
                        toDuration = Lists.newArrayList();
                    } else {
                        toDuration = Lists.newArrayList(toDuration);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SrvcOrdDuration entity;
                        if( toDuration.size() > i ) {
                            entity = toDuration.get(i);
                        } else {
                            entity = new SrvcOrdDuration();
                            toDuration.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_Item") ) {
                final Object value = (values).remove("to_Item");
                if( value instanceof Iterable ) {
                    if( toItem == null ) {
                        toItem = Lists.newArrayList();
                    } else {
                        toItem = Lists.newArrayList(toItem);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ServiceOrderItem entity;
                        if( toItem.size() > i ) {
                            entity = toItem.get(i);
                        } else {
                            entity = new ServiceOrderItem();
                            toItem.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_Partner") ) {
                final Object value = (values).remove("to_Partner");
                if( value instanceof Iterable ) {
                    if( toPartner == null ) {
                        toPartner = Lists.newArrayList();
                    } else {
                        toPartner = Lists.newArrayList(toPartner);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SrvcOrdPartner entity;
                        if( toPartner.size() > i ) {
                            entity = toPartner.get(i);
                        } else {
                            entity = new SrvcOrdPartner();
                            toPartner.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_PersonResponsible") ) {
                final Object value = (values).remove("to_PersonResponsible");
                if( value instanceof Iterable ) {
                    if( toPersonResponsible == null ) {
                        toPersonResponsible = Lists.newArrayList();
                    } else {
                        toPersonResponsible = Lists.newArrayList(toPersonResponsible);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ServiceOrderPersonResp entity;
                        if( toPersonResponsible.size() > i ) {
                            entity = toPersonResponsible.get(i);
                        } else {
                            entity = new ServiceOrderPersonResp();
                            toPersonResponsible.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_PricingElement") ) {
                final Object value = (values).remove("to_PricingElement");
                if( value instanceof Iterable ) {
                    if( toPricingElement == null ) {
                        toPricingElement = Lists.newArrayList();
                    } else {
                        toPricingElement = Lists.newArrayList(toPricingElement);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ServiceOrderPriceElement entity;
                        if( toPricingElement.size() > i ) {
                            entity = toPricingElement.get(i);
                        } else {
                            entity = new ServiceOrderPriceElement();
                            toPricingElement.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_ProductReferenceObject") ) {
                final Object value = (values).remove("to_ProductReferenceObject");
                if( value instanceof Iterable ) {
                    if( toProductReferenceObject == null ) {
                        toProductReferenceObject = Lists.newArrayList();
                    } else {
                        toProductReferenceObject = Lists.newArrayList(toProductReferenceObject);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SrvcOrdProdRefObject entity;
                        if( toProductReferenceObject.size() > i ) {
                            entity = toProductReferenceObject.get(i);
                        } else {
                            entity = new SrvcOrdProdRefObject();
                            toProductReferenceObject.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_ReferenceObject") ) {
                final Object value = (values).remove("to_ReferenceObject");
                if( value instanceof Iterable ) {
                    if( toReferenceObject == null ) {
                        toReferenceObject = Lists.newArrayList();
                    } else {
                        toReferenceObject = Lists.newArrayList(toReferenceObject);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ServiceOrderRefObject entity;
                        if( toReferenceObject.size() > i ) {
                            entity = toReferenceObject.get(i);
                        } else {
                            entity = new ServiceOrderRefObject();
                            toReferenceObject.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_ReferenceServiceContract") ) {
                final Object value = (values).remove("to_ReferenceServiceContract");
                if( value instanceof Iterable ) {
                    if( toReferenceServiceContract == null ) {
                        toReferenceServiceContract = Lists.newArrayList();
                    } else {
                        toReferenceServiceContract = Lists.newArrayList(toReferenceServiceContract);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SrvcOrdRefServiceContract entity;
                        if( toReferenceServiceContract.size() > i ) {
                            entity = toReferenceServiceContract.get(i);
                        } else {
                            entity = new SrvcOrdRefServiceContract();
                            toReferenceServiceContract.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_ServiceOrdUserStatus") ) {
                final Object value = (values).remove("to_ServiceOrdUserStatus");
                if( value instanceof Iterable ) {
                    if( toServiceOrdUserStatus == null ) {
                        toServiceOrdUserStatus = Lists.newArrayList();
                    } else {
                        toServiceOrdUserStatus = Lists.newArrayList(toServiceOrdUserStatus);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ServiceOrdUserStatus entity;
                        if( toServiceOrdUserStatus.size() > i ) {
                            entity = toServiceOrdUserStatus.get(i);
                        } else {
                            entity = new ServiceOrdUserStatus();
                            toServiceOrdUserStatus.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_Text") ) {
                final Object value = (values).remove("to_Text");
                if( value instanceof Iterable ) {
                    if( toText == null ) {
                        toText = Lists.newArrayList();
                    } else {
                        toText = Lists.newArrayList(toText);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ServiceOrderText entity;
                        if( toText.size() > i ) {
                            entity = toText.get(i);
                        } else {
                            entity = new ServiceOrderText();
                            toText.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> ServiceOrderField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ServiceOrderField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ServiceOrderField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ServiceOrderField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ServiceOrderService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toAppointment != null ) {
            (values).put("to_Appointment", toAppointment);
        }
        if( toConfirmation != null ) {
            (values).put("to_Confirmation", toConfirmation);
        }
        if( toDefect != null ) {
            (values).put("to_Defect", toDefect);
        }
        if( toDuration != null ) {
            (values).put("to_Duration", toDuration);
        }
        if( toItem != null ) {
            (values).put("to_Item", toItem);
        }
        if( toPartner != null ) {
            (values).put("to_Partner", toPartner);
        }
        if( toPersonResponsible != null ) {
            (values).put("to_PersonResponsible", toPersonResponsible);
        }
        if( toPricingElement != null ) {
            (values).put("to_PricingElement", toPricingElement);
        }
        if( toProductReferenceObject != null ) {
            (values).put("to_ProductReferenceObject", toProductReferenceObject);
        }
        if( toReferenceObject != null ) {
            (values).put("to_ReferenceObject", toReferenceObject);
        }
        if( toReferenceServiceContract != null ) {
            (values).put("to_ReferenceServiceContract", toReferenceServiceContract);
        }
        if( toServiceOrdUserStatus != null ) {
            (values).put("to_ServiceOrdUserStatus", toServiceOrdUserStatus);
        }
        if( toText != null ) {
            (values).put("to_Text", toText);
        }
        return values;
    }

    /**
     * Fetches the <b>SrvcOrdAppointment</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_Appointment</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SrvcOrdAppointment</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SrvcOrdAppointment> fetchAppointment()
    {
        return fetchFieldAsList("to_Appointment", SrvcOrdAppointment.class);
    }

    /**
     * Retrieval of associated <b>SrvcOrdAppointment</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Appointment</b>.
     * <p>
     * If the navigation property <b>to_Appointment</b> of a queried <b>ServiceOrder</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SrvcOrdAppointment</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SrvcOrdAppointment> getAppointmentOrFetch()
    {
        if( toAppointment == null ) {
            toAppointment = fetchAppointment();
        }
        return toAppointment;
    }

    /**
     * Retrieval of associated <b>SrvcOrdAppointment</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Appointment</b>.
     * <p>
     * If the navigation property for an entity <b>ServiceOrder</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Appointment</b> is already loaded, the result will
     *         contain the <b>SrvcOrdAppointment</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SrvcOrdAppointment>> getAppointmentIfPresent()
    {
        return Option.of(toAppointment);
    }

    /**
     * Overwrites the list of associated <b>SrvcOrdAppointment</b> entities for the loaded navigation property
     * <b>to_Appointment</b>.
     * <p>
     * If the navigation property <b>to_Appointment</b> of a queried <b>ServiceOrder</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SrvcOrdAppointment</b> entities.
     */
    public void setAppointment( @Nonnull final List<SrvcOrdAppointment> value )
    {
        if( toAppointment == null ) {
            toAppointment = Lists.newArrayList();
        }
        toAppointment.clear();
        toAppointment.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SrvcOrdAppointment</b> entities. This corresponds to the OData
     * navigation property <b>to_Appointment</b>.
     * <p>
     * If the navigation property <b>to_Appointment</b> of a queried <b>ServiceOrder</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SrvcOrdAppointment</b> entities.
     */
    public void addAppointment( SrvcOrdAppointment... entity )
    {
        if( toAppointment == null ) {
            toAppointment = Lists.newArrayList();
        }
        toAppointment.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>ServiceOrderConfirmation</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_Confirmation</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ServiceOrderConfirmation</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ServiceOrderConfirmation> fetchConfirmation()
    {
        return fetchFieldAsList("to_Confirmation", ServiceOrderConfirmation.class);
    }

    /**
     * Retrieval of associated <b>ServiceOrderConfirmation</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Confirmation</b>.
     * <p>
     * If the navigation property <b>to_Confirmation</b> of a queried <b>ServiceOrder</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ServiceOrderConfirmation</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ServiceOrderConfirmation> getConfirmationOrFetch()
    {
        if( toConfirmation == null ) {
            toConfirmation = fetchConfirmation();
        }
        return toConfirmation;
    }

    /**
     * Retrieval of associated <b>ServiceOrderConfirmation</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Confirmation</b>.
     * <p>
     * If the navigation property for an entity <b>ServiceOrder</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Confirmation</b> is already loaded, the result will
     *         contain the <b>ServiceOrderConfirmation</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ServiceOrderConfirmation>> getConfirmationIfPresent()
    {
        return Option.of(toConfirmation);
    }

    /**
     * Overwrites the list of associated <b>ServiceOrderConfirmation</b> entities for the loaded navigation property
     * <b>to_Confirmation</b>.
     * <p>
     * If the navigation property <b>to_Confirmation</b> of a queried <b>ServiceOrder</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ServiceOrderConfirmation</b> entities.
     */
    public void setConfirmation( @Nonnull final List<ServiceOrderConfirmation> value )
    {
        if( toConfirmation == null ) {
            toConfirmation = Lists.newArrayList();
        }
        toConfirmation.clear();
        toConfirmation.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ServiceOrderConfirmation</b> entities. This corresponds to the OData
     * navigation property <b>to_Confirmation</b>.
     * <p>
     * If the navigation property <b>to_Confirmation</b> of a queried <b>ServiceOrder</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ServiceOrderConfirmation</b> entities.
     */
    public void addConfirmation( ServiceOrderConfirmation... entity )
    {
        if( toConfirmation == null ) {
            toConfirmation = Lists.newArrayList();
        }
        toConfirmation.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>ServiceOrderDefect</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_Defect</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ServiceOrderDefect</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ServiceOrderDefect> fetchDefect()
    {
        return fetchFieldAsList("to_Defect", ServiceOrderDefect.class);
    }

    /**
     * Retrieval of associated <b>ServiceOrderDefect</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Defect</b>.
     * <p>
     * If the navigation property <b>to_Defect</b> of a queried <b>ServiceOrder</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ServiceOrderDefect</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ServiceOrderDefect> getDefectOrFetch()
    {
        if( toDefect == null ) {
            toDefect = fetchDefect();
        }
        return toDefect;
    }

    /**
     * Retrieval of associated <b>ServiceOrderDefect</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Defect</b>.
     * <p>
     * If the navigation property for an entity <b>ServiceOrder</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Defect</b> is already loaded, the result will contain
     *         the <b>ServiceOrderDefect</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ServiceOrderDefect>> getDefectIfPresent()
    {
        return Option.of(toDefect);
    }

    /**
     * Overwrites the list of associated <b>ServiceOrderDefect</b> entities for the loaded navigation property
     * <b>to_Defect</b>.
     * <p>
     * If the navigation property <b>to_Defect</b> of a queried <b>ServiceOrder</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ServiceOrderDefect</b> entities.
     */
    public void setDefect( @Nonnull final List<ServiceOrderDefect> value )
    {
        if( toDefect == null ) {
            toDefect = Lists.newArrayList();
        }
        toDefect.clear();
        toDefect.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ServiceOrderDefect</b> entities. This corresponds to the OData
     * navigation property <b>to_Defect</b>.
     * <p>
     * If the navigation property <b>to_Defect</b> of a queried <b>ServiceOrder</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ServiceOrderDefect</b> entities.
     */
    public void addDefect( ServiceOrderDefect... entity )
    {
        if( toDefect == null ) {
            toDefect = Lists.newArrayList();
        }
        toDefect.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>SrvcOrdDuration</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_Duration</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SrvcOrdDuration</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SrvcOrdDuration> fetchDuration()
    {
        return fetchFieldAsList("to_Duration", SrvcOrdDuration.class);
    }

    /**
     * Retrieval of associated <b>SrvcOrdDuration</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_Duration</b>.
     * <p>
     * If the navigation property <b>to_Duration</b> of a queried <b>ServiceOrder</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SrvcOrdDuration</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SrvcOrdDuration> getDurationOrFetch()
    {
        if( toDuration == null ) {
            toDuration = fetchDuration();
        }
        return toDuration;
    }

    /**
     * Retrieval of associated <b>SrvcOrdDuration</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_Duration</b>.
     * <p>
     * If the navigation property for an entity <b>ServiceOrder</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Duration</b> is already loaded, the result will contain
     *         the <b>SrvcOrdDuration</b> entities. If not, an <code>Option</code> with result state <code>empty</code>
     *         is returned.
     */
    @Nonnull
    public Option<List<SrvcOrdDuration>> getDurationIfPresent()
    {
        return Option.of(toDuration);
    }

    /**
     * Overwrites the list of associated <b>SrvcOrdDuration</b> entities for the loaded navigation property
     * <b>to_Duration</b>.
     * <p>
     * If the navigation property <b>to_Duration</b> of a queried <b>ServiceOrder</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SrvcOrdDuration</b> entities.
     */
    public void setDuration( @Nonnull final List<SrvcOrdDuration> value )
    {
        if( toDuration == null ) {
            toDuration = Lists.newArrayList();
        }
        toDuration.clear();
        toDuration.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SrvcOrdDuration</b> entities. This corresponds to the OData navigation
     * property <b>to_Duration</b>.
     * <p>
     * If the navigation property <b>to_Duration</b> of a queried <b>ServiceOrder</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SrvcOrdDuration</b> entities.
     */
    public void addDuration( SrvcOrdDuration... entity )
    {
        if( toDuration == null ) {
            toDuration = Lists.newArrayList();
        }
        toDuration.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>ServiceOrderItem</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_Item</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ServiceOrderItem</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ServiceOrderItem> fetchItem()
    {
        return fetchFieldAsList("to_Item", ServiceOrderItem.class);
    }

    /**
     * Retrieval of associated <b>ServiceOrderItem</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_Item</b>.
     * <p>
     * If the navigation property <b>to_Item</b> of a queried <b>ServiceOrder</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ServiceOrderItem</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ServiceOrderItem> getItemOrFetch()
    {
        if( toItem == null ) {
            toItem = fetchItem();
        }
        return toItem;
    }

    /**
     * Retrieval of associated <b>ServiceOrderItem</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_Item</b>.
     * <p>
     * If the navigation property for an entity <b>ServiceOrder</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Item</b> is already loaded, the result will contain the
     *         <b>ServiceOrderItem</b> entities. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<List<ServiceOrderItem>> getItemIfPresent()
    {
        return Option.of(toItem);
    }

    /**
     * Overwrites the list of associated <b>ServiceOrderItem</b> entities for the loaded navigation property
     * <b>to_Item</b>.
     * <p>
     * If the navigation property <b>to_Item</b> of a queried <b>ServiceOrder</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ServiceOrderItem</b> entities.
     */
    public void setItem( @Nonnull final List<ServiceOrderItem> value )
    {
        if( toItem == null ) {
            toItem = Lists.newArrayList();
        }
        toItem.clear();
        toItem.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ServiceOrderItem</b> entities. This corresponds to the OData
     * navigation property <b>to_Item</b>.
     * <p>
     * If the navigation property <b>to_Item</b> of a queried <b>ServiceOrder</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ServiceOrderItem</b> entities.
     */
    public void addItem( ServiceOrderItem... entity )
    {
        if( toItem == null ) {
            toItem = Lists.newArrayList();
        }
        toItem.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>SrvcOrdPartner</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_Partner</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SrvcOrdPartner</b> entities. If no entities are associated then
     *         an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SrvcOrdPartner> fetchPartner()
    {
        return fetchFieldAsList("to_Partner", SrvcOrdPartner.class);
    }

    /**
     * Retrieval of associated <b>SrvcOrdPartner</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_Partner</b>.
     * <p>
     * If the navigation property <b>to_Partner</b> of a queried <b>ServiceOrder</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SrvcOrdPartner</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SrvcOrdPartner> getPartnerOrFetch()
    {
        if( toPartner == null ) {
            toPartner = fetchPartner();
        }
        return toPartner;
    }

    /**
     * Retrieval of associated <b>SrvcOrdPartner</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_Partner</b>.
     * <p>
     * If the navigation property for an entity <b>ServiceOrder</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Partner</b> is already loaded, the result will contain
     *         the <b>SrvcOrdPartner</b> entities. If not, an <code>Option</code> with result state <code>empty</code>
     *         is returned.
     */
    @Nonnull
    public Option<List<SrvcOrdPartner>> getPartnerIfPresent()
    {
        return Option.of(toPartner);
    }

    /**
     * Overwrites the list of associated <b>SrvcOrdPartner</b> entities for the loaded navigation property
     * <b>to_Partner</b>.
     * <p>
     * If the navigation property <b>to_Partner</b> of a queried <b>ServiceOrder</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SrvcOrdPartner</b> entities.
     */
    public void setPartner( @Nonnull final List<SrvcOrdPartner> value )
    {
        if( toPartner == null ) {
            toPartner = Lists.newArrayList();
        }
        toPartner.clear();
        toPartner.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SrvcOrdPartner</b> entities. This corresponds to the OData navigation
     * property <b>to_Partner</b>.
     * <p>
     * If the navigation property <b>to_Partner</b> of a queried <b>ServiceOrder</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SrvcOrdPartner</b> entities.
     */
    public void addPartner( SrvcOrdPartner... entity )
    {
        if( toPartner == null ) {
            toPartner = Lists.newArrayList();
        }
        toPartner.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>ServiceOrderPersonResp</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_PersonResponsible</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ServiceOrderPersonResp</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ServiceOrderPersonResp> fetchPersonResponsible()
    {
        return fetchFieldAsList("to_PersonResponsible", ServiceOrderPersonResp.class);
    }

    /**
     * Retrieval of associated <b>ServiceOrderPersonResp</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_PersonResponsible</b>.
     * <p>
     * If the navigation property <b>to_PersonResponsible</b> of a queried <b>ServiceOrder</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ServiceOrderPersonResp</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ServiceOrderPersonResp> getPersonResponsibleOrFetch()
    {
        if( toPersonResponsible == null ) {
            toPersonResponsible = fetchPersonResponsible();
        }
        return toPersonResponsible;
    }

    /**
     * Retrieval of associated <b>ServiceOrderPersonResp</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_PersonResponsible</b>.
     * <p>
     * If the navigation property for an entity <b>ServiceOrder</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_PersonResponsible</b> is already loaded, the result will
     *         contain the <b>ServiceOrderPersonResp</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ServiceOrderPersonResp>> getPersonResponsibleIfPresent()
    {
        return Option.of(toPersonResponsible);
    }

    /**
     * Overwrites the list of associated <b>ServiceOrderPersonResp</b> entities for the loaded navigation property
     * <b>to_PersonResponsible</b>.
     * <p>
     * If the navigation property <b>to_PersonResponsible</b> of a queried <b>ServiceOrder</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ServiceOrderPersonResp</b> entities.
     */
    public void setPersonResponsible( @Nonnull final List<ServiceOrderPersonResp> value )
    {
        if( toPersonResponsible == null ) {
            toPersonResponsible = Lists.newArrayList();
        }
        toPersonResponsible.clear();
        toPersonResponsible.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ServiceOrderPersonResp</b> entities. This corresponds to the OData
     * navigation property <b>to_PersonResponsible</b>.
     * <p>
     * If the navigation property <b>to_PersonResponsible</b> of a queried <b>ServiceOrder</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ServiceOrderPersonResp</b> entities.
     */
    public void addPersonResponsible( ServiceOrderPersonResp... entity )
    {
        if( toPersonResponsible == null ) {
            toPersonResponsible = Lists.newArrayList();
        }
        toPersonResponsible.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>ServiceOrderPriceElement</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_PricingElement</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ServiceOrderPriceElement</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ServiceOrderPriceElement> fetchPricingElement()
    {
        return fetchFieldAsList("to_PricingElement", ServiceOrderPriceElement.class);
    }

    /**
     * Retrieval of associated <b>ServiceOrderPriceElement</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_PricingElement</b>.
     * <p>
     * If the navigation property <b>to_PricingElement</b> of a queried <b>ServiceOrder</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ServiceOrderPriceElement</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ServiceOrderPriceElement> getPricingElementOrFetch()
    {
        if( toPricingElement == null ) {
            toPricingElement = fetchPricingElement();
        }
        return toPricingElement;
    }

    /**
     * Retrieval of associated <b>ServiceOrderPriceElement</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_PricingElement</b>.
     * <p>
     * If the navigation property for an entity <b>ServiceOrder</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_PricingElement</b> is already loaded, the result will
     *         contain the <b>ServiceOrderPriceElement</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ServiceOrderPriceElement>> getPricingElementIfPresent()
    {
        return Option.of(toPricingElement);
    }

    /**
     * Overwrites the list of associated <b>ServiceOrderPriceElement</b> entities for the loaded navigation property
     * <b>to_PricingElement</b>.
     * <p>
     * If the navigation property <b>to_PricingElement</b> of a queried <b>ServiceOrder</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ServiceOrderPriceElement</b> entities.
     */
    public void setPricingElement( @Nonnull final List<ServiceOrderPriceElement> value )
    {
        if( toPricingElement == null ) {
            toPricingElement = Lists.newArrayList();
        }
        toPricingElement.clear();
        toPricingElement.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ServiceOrderPriceElement</b> entities. This corresponds to the OData
     * navigation property <b>to_PricingElement</b>.
     * <p>
     * If the navigation property <b>to_PricingElement</b> of a queried <b>ServiceOrder</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ServiceOrderPriceElement</b> entities.
     */
    public void addPricingElement( ServiceOrderPriceElement... entity )
    {
        if( toPricingElement == null ) {
            toPricingElement = Lists.newArrayList();
        }
        toPricingElement.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>SrvcOrdProdRefObject</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_ProductReferenceObject</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SrvcOrdProdRefObject</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SrvcOrdProdRefObject> fetchProductReferenceObject()
    {
        return fetchFieldAsList("to_ProductReferenceObject", SrvcOrdProdRefObject.class);
    }

    /**
     * Retrieval of associated <b>SrvcOrdProdRefObject</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ProductReferenceObject</b>.
     * <p>
     * If the navigation property <b>to_ProductReferenceObject</b> of a queried <b>ServiceOrder</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SrvcOrdProdRefObject</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SrvcOrdProdRefObject> getProductReferenceObjectOrFetch()
    {
        if( toProductReferenceObject == null ) {
            toProductReferenceObject = fetchProductReferenceObject();
        }
        return toProductReferenceObject;
    }

    /**
     * Retrieval of associated <b>SrvcOrdProdRefObject</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ProductReferenceObject</b>.
     * <p>
     * If the navigation property for an entity <b>ServiceOrder</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ProductReferenceObject</b> is already loaded, the result
     *         will contain the <b>SrvcOrdProdRefObject</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SrvcOrdProdRefObject>> getProductReferenceObjectIfPresent()
    {
        return Option.of(toProductReferenceObject);
    }

    /**
     * Overwrites the list of associated <b>SrvcOrdProdRefObject</b> entities for the loaded navigation property
     * <b>to_ProductReferenceObject</b>.
     * <p>
     * If the navigation property <b>to_ProductReferenceObject</b> of a queried <b>ServiceOrder</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SrvcOrdProdRefObject</b> entities.
     */
    public void setProductReferenceObject( @Nonnull final List<SrvcOrdProdRefObject> value )
    {
        if( toProductReferenceObject == null ) {
            toProductReferenceObject = Lists.newArrayList();
        }
        toProductReferenceObject.clear();
        toProductReferenceObject.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SrvcOrdProdRefObject</b> entities. This corresponds to the OData
     * navigation property <b>to_ProductReferenceObject</b>.
     * <p>
     * If the navigation property <b>to_ProductReferenceObject</b> of a queried <b>ServiceOrder</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SrvcOrdProdRefObject</b> entities.
     */
    public void addProductReferenceObject( SrvcOrdProdRefObject... entity )
    {
        if( toProductReferenceObject == null ) {
            toProductReferenceObject = Lists.newArrayList();
        }
        toProductReferenceObject.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>ServiceOrderRefObject</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_ReferenceObject</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ServiceOrderRefObject</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ServiceOrderRefObject> fetchReferenceObject()
    {
        return fetchFieldAsList("to_ReferenceObject", ServiceOrderRefObject.class);
    }

    /**
     * Retrieval of associated <b>ServiceOrderRefObject</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ReferenceObject</b>.
     * <p>
     * If the navigation property <b>to_ReferenceObject</b> of a queried <b>ServiceOrder</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ServiceOrderRefObject</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ServiceOrderRefObject> getReferenceObjectOrFetch()
    {
        if( toReferenceObject == null ) {
            toReferenceObject = fetchReferenceObject();
        }
        return toReferenceObject;
    }

    /**
     * Retrieval of associated <b>ServiceOrderRefObject</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ReferenceObject</b>.
     * <p>
     * If the navigation property for an entity <b>ServiceOrder</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ReferenceObject</b> is already loaded, the result will
     *         contain the <b>ServiceOrderRefObject</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ServiceOrderRefObject>> getReferenceObjectIfPresent()
    {
        return Option.of(toReferenceObject);
    }

    /**
     * Overwrites the list of associated <b>ServiceOrderRefObject</b> entities for the loaded navigation property
     * <b>to_ReferenceObject</b>.
     * <p>
     * If the navigation property <b>to_ReferenceObject</b> of a queried <b>ServiceOrder</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ServiceOrderRefObject</b> entities.
     */
    public void setReferenceObject( @Nonnull final List<ServiceOrderRefObject> value )
    {
        if( toReferenceObject == null ) {
            toReferenceObject = Lists.newArrayList();
        }
        toReferenceObject.clear();
        toReferenceObject.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ServiceOrderRefObject</b> entities. This corresponds to the OData
     * navigation property <b>to_ReferenceObject</b>.
     * <p>
     * If the navigation property <b>to_ReferenceObject</b> of a queried <b>ServiceOrder</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ServiceOrderRefObject</b> entities.
     */
    public void addReferenceObject( ServiceOrderRefObject... entity )
    {
        if( toReferenceObject == null ) {
            toReferenceObject = Lists.newArrayList();
        }
        toReferenceObject.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>SrvcOrdRefServiceContract</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_ReferenceServiceContract</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SrvcOrdRefServiceContract</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SrvcOrdRefServiceContract> fetchReferenceServiceContract()
    {
        return fetchFieldAsList("to_ReferenceServiceContract", SrvcOrdRefServiceContract.class);
    }

    /**
     * Retrieval of associated <b>SrvcOrdRefServiceContract</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ReferenceServiceContract</b>.
     * <p>
     * If the navigation property <b>to_ReferenceServiceContract</b> of a queried <b>ServiceOrder</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SrvcOrdRefServiceContract</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SrvcOrdRefServiceContract> getReferenceServiceContractOrFetch()
    {
        if( toReferenceServiceContract == null ) {
            toReferenceServiceContract = fetchReferenceServiceContract();
        }
        return toReferenceServiceContract;
    }

    /**
     * Retrieval of associated <b>SrvcOrdRefServiceContract</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ReferenceServiceContract</b>.
     * <p>
     * If the navigation property for an entity <b>ServiceOrder</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ReferenceServiceContract</b> is already loaded, the
     *         result will contain the <b>SrvcOrdRefServiceContract</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SrvcOrdRefServiceContract>> getReferenceServiceContractIfPresent()
    {
        return Option.of(toReferenceServiceContract);
    }

    /**
     * Overwrites the list of associated <b>SrvcOrdRefServiceContract</b> entities for the loaded navigation property
     * <b>to_ReferenceServiceContract</b>.
     * <p>
     * If the navigation property <b>to_ReferenceServiceContract</b> of a queried <b>ServiceOrder</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SrvcOrdRefServiceContract</b> entities.
     */
    public void setReferenceServiceContract( @Nonnull final List<SrvcOrdRefServiceContract> value )
    {
        if( toReferenceServiceContract == null ) {
            toReferenceServiceContract = Lists.newArrayList();
        }
        toReferenceServiceContract.clear();
        toReferenceServiceContract.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SrvcOrdRefServiceContract</b> entities. This corresponds to the OData
     * navigation property <b>to_ReferenceServiceContract</b>.
     * <p>
     * If the navigation property <b>to_ReferenceServiceContract</b> of a queried <b>ServiceOrder</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SrvcOrdRefServiceContract</b> entities.
     */
    public void addReferenceServiceContract( SrvcOrdRefServiceContract... entity )
    {
        if( toReferenceServiceContract == null ) {
            toReferenceServiceContract = Lists.newArrayList();
        }
        toReferenceServiceContract.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>ServiceOrdUserStatus</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_ServiceOrdUserStatus</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ServiceOrdUserStatus</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ServiceOrdUserStatus> fetchServiceOrdUserStatus()
    {
        return fetchFieldAsList("to_ServiceOrdUserStatus", ServiceOrdUserStatus.class);
    }

    /**
     * Retrieval of associated <b>ServiceOrdUserStatus</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ServiceOrdUserStatus</b>.
     * <p>
     * If the navigation property <b>to_ServiceOrdUserStatus</b> of a queried <b>ServiceOrder</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ServiceOrdUserStatus</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ServiceOrdUserStatus> getServiceOrdUserStatusOrFetch()
    {
        if( toServiceOrdUserStatus == null ) {
            toServiceOrdUserStatus = fetchServiceOrdUserStatus();
        }
        return toServiceOrdUserStatus;
    }

    /**
     * Retrieval of associated <b>ServiceOrdUserStatus</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ServiceOrdUserStatus</b>.
     * <p>
     * If the navigation property for an entity <b>ServiceOrder</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ServiceOrdUserStatus</b> is already loaded, the result
     *         will contain the <b>ServiceOrdUserStatus</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ServiceOrdUserStatus>> getServiceOrdUserStatusIfPresent()
    {
        return Option.of(toServiceOrdUserStatus);
    }

    /**
     * Overwrites the list of associated <b>ServiceOrdUserStatus</b> entities for the loaded navigation property
     * <b>to_ServiceOrdUserStatus</b>.
     * <p>
     * If the navigation property <b>to_ServiceOrdUserStatus</b> of a queried <b>ServiceOrder</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ServiceOrdUserStatus</b> entities.
     */
    public void setServiceOrdUserStatus( @Nonnull final List<ServiceOrdUserStatus> value )
    {
        if( toServiceOrdUserStatus == null ) {
            toServiceOrdUserStatus = Lists.newArrayList();
        }
        toServiceOrdUserStatus.clear();
        toServiceOrdUserStatus.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ServiceOrdUserStatus</b> entities. This corresponds to the OData
     * navigation property <b>to_ServiceOrdUserStatus</b>.
     * <p>
     * If the navigation property <b>to_ServiceOrdUserStatus</b> of a queried <b>ServiceOrder</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ServiceOrdUserStatus</b> entities.
     */
    public void addServiceOrdUserStatus( ServiceOrdUserStatus... entity )
    {
        if( toServiceOrdUserStatus == null ) {
            toServiceOrdUserStatus = Lists.newArrayList();
        }
        toServiceOrdUserStatus.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>ServiceOrderText</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_Text</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ServiceOrderText</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ServiceOrderText> fetchText()
    {
        return fetchFieldAsList("to_Text", ServiceOrderText.class);
    }

    /**
     * Retrieval of associated <b>ServiceOrderText</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_Text</b>.
     * <p>
     * If the navigation property <b>to_Text</b> of a queried <b>ServiceOrder</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ServiceOrderText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ServiceOrderText> getTextOrFetch()
    {
        if( toText == null ) {
            toText = fetchText();
        }
        return toText;
    }

    /**
     * Retrieval of associated <b>ServiceOrderText</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_Text</b>.
     * <p>
     * If the navigation property for an entity <b>ServiceOrder</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Text</b> is already loaded, the result will contain the
     *         <b>ServiceOrderText</b> entities. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<List<ServiceOrderText>> getTextIfPresent()
    {
        return Option.of(toText);
    }

    /**
     * Overwrites the list of associated <b>ServiceOrderText</b> entities for the loaded navigation property
     * <b>to_Text</b>.
     * <p>
     * If the navigation property <b>to_Text</b> of a queried <b>ServiceOrder</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ServiceOrderText</b> entities.
     */
    public void setText( @Nonnull final List<ServiceOrderText> value )
    {
        if( toText == null ) {
            toText = Lists.newArrayList();
        }
        toText.clear();
        toText.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ServiceOrderText</b> entities. This corresponds to the OData
     * navigation property <b>to_Text</b>.
     * <p>
     * If the navigation property <b>to_Text</b> of a queried <b>ServiceOrder</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ServiceOrderText</b> entities.
     */
    public void addText( ServiceOrderText... entity )
    {
        if( toText == null ) {
            toText = Lists.newArrayList();
        }
        toText.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of ServiceOrder instances.
     *
     */
    public final static class ServiceOrderBuilder
    {

        private List<SrvcOrdAppointment> toAppointment = Lists.newArrayList();
        private List<ServiceOrderConfirmation> toConfirmation = Lists.newArrayList();
        private List<ServiceOrderDefect> toDefect = Lists.newArrayList();
        private List<SrvcOrdDuration> toDuration = Lists.newArrayList();
        private List<ServiceOrderItem> toItem = Lists.newArrayList();
        private List<SrvcOrdPartner> toPartner = Lists.newArrayList();
        private List<ServiceOrderPersonResp> toPersonResponsible = Lists.newArrayList();
        private List<ServiceOrderPriceElement> toPricingElement = Lists.newArrayList();
        private List<SrvcOrdProdRefObject> toProductReferenceObject = Lists.newArrayList();
        private List<ServiceOrderRefObject> toReferenceObject = Lists.newArrayList();
        private List<SrvcOrdRefServiceContract> toReferenceServiceContract = Lists.newArrayList();
        private String referenceServiceContract = null;
        private List<ServiceOrdUserStatus> toServiceOrdUserStatus = Lists.newArrayList();
        private List<ServiceOrderText> toText = Lists.newArrayList();

        private ServiceOrder.ServiceOrderBuilder toAppointment( final List<SrvcOrdAppointment> value )
        {
            toAppointment.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_Appointment</b> for <b>ServiceOrder</b> to multiple <b>SrvcOrdAppointment</b>.
         *
         * @param value
         *            The SrvcOrdAppointments to build this ServiceOrder with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ServiceOrder.ServiceOrderBuilder appointment( SrvcOrdAppointment... value )
        {
            return toAppointment(Lists.newArrayList(value));
        }

        private ServiceOrder.ServiceOrderBuilder toConfirmation( final List<ServiceOrderConfirmation> value )
        {
            toConfirmation.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_Confirmation</b> for <b>ServiceOrder</b> to multiple
         * <b>ServiceOrderConfirmation</b>.
         *
         * @param value
         *            The ServiceOrderConfirmations to build this ServiceOrder with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ServiceOrder.ServiceOrderBuilder confirmation( ServiceOrderConfirmation... value )
        {
            return toConfirmation(Lists.newArrayList(value));
        }

        private ServiceOrder.ServiceOrderBuilder toDefect( final List<ServiceOrderDefect> value )
        {
            toDefect.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_Defect</b> for <b>ServiceOrder</b> to multiple <b>ServiceOrderDefect</b>.
         *
         * @param value
         *            The ServiceOrderDefects to build this ServiceOrder with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ServiceOrder.ServiceOrderBuilder defect( ServiceOrderDefect... value )
        {
            return toDefect(Lists.newArrayList(value));
        }

        private ServiceOrder.ServiceOrderBuilder toDuration( final List<SrvcOrdDuration> value )
        {
            toDuration.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_Duration</b> for <b>ServiceOrder</b> to multiple <b>SrvcOrdDuration</b>.
         *
         * @param value
         *            The SrvcOrdDurations to build this ServiceOrder with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ServiceOrder.ServiceOrderBuilder duration( SrvcOrdDuration... value )
        {
            return toDuration(Lists.newArrayList(value));
        }

        private ServiceOrder.ServiceOrderBuilder toItem( final List<ServiceOrderItem> value )
        {
            toItem.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_Item</b> for <b>ServiceOrder</b> to multiple <b>ServiceOrderItem</b>.
         *
         * @param value
         *            The ServiceOrderItems to build this ServiceOrder with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ServiceOrder.ServiceOrderBuilder item( ServiceOrderItem... value )
        {
            return toItem(Lists.newArrayList(value));
        }

        private ServiceOrder.ServiceOrderBuilder toPartner( final List<SrvcOrdPartner> value )
        {
            toPartner.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_Partner</b> for <b>ServiceOrder</b> to multiple <b>SrvcOrdPartner</b>.
         *
         * @param value
         *            The SrvcOrdPartners to build this ServiceOrder with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ServiceOrder.ServiceOrderBuilder partner( SrvcOrdPartner... value )
        {
            return toPartner(Lists.newArrayList(value));
        }

        private ServiceOrder.ServiceOrderBuilder toPersonResponsible( final List<ServiceOrderPersonResp> value )
        {
            toPersonResponsible.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_PersonResponsible</b> for <b>ServiceOrder</b> to multiple
         * <b>ServiceOrderPersonResp</b>.
         *
         * @param value
         *            The ServiceOrderPersonResps to build this ServiceOrder with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ServiceOrder.ServiceOrderBuilder personResponsible( ServiceOrderPersonResp... value )
        {
            return toPersonResponsible(Lists.newArrayList(value));
        }

        private ServiceOrder.ServiceOrderBuilder toPricingElement( final List<ServiceOrderPriceElement> value )
        {
            toPricingElement.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_PricingElement</b> for <b>ServiceOrder</b> to multiple
         * <b>ServiceOrderPriceElement</b>.
         *
         * @param value
         *            The ServiceOrderPriceElements to build this ServiceOrder with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ServiceOrder.ServiceOrderBuilder pricingElement( ServiceOrderPriceElement... value )
        {
            return toPricingElement(Lists.newArrayList(value));
        }

        private ServiceOrder.ServiceOrderBuilder toProductReferenceObject( final List<SrvcOrdProdRefObject> value )
        {
            toProductReferenceObject.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_ProductReferenceObject</b> for <b>ServiceOrder</b> to multiple
         * <b>SrvcOrdProdRefObject</b>.
         *
         * @param value
         *            The SrvcOrdProdRefObjects to build this ServiceOrder with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ServiceOrder.ServiceOrderBuilder productReferenceObject( SrvcOrdProdRefObject... value )
        {
            return toProductReferenceObject(Lists.newArrayList(value));
        }

        private ServiceOrder.ServiceOrderBuilder toReferenceObject( final List<ServiceOrderRefObject> value )
        {
            toReferenceObject.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_ReferenceObject</b> for <b>ServiceOrder</b> to multiple
         * <b>ServiceOrderRefObject</b>.
         *
         * @param value
         *            The ServiceOrderRefObjects to build this ServiceOrder with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ServiceOrder.ServiceOrderBuilder referenceObject( ServiceOrderRefObject... value )
        {
            return toReferenceObject(Lists.newArrayList(value));
        }

        private ServiceOrder.ServiceOrderBuilder toReferenceServiceContract(
            final List<SrvcOrdRefServiceContract> value )
        {
            toReferenceServiceContract.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_ReferenceServiceContract</b> for <b>ServiceOrder</b> to multiple
         * <b>SrvcOrdRefServiceContract</b>.
         *
         * @param value
         *            The SrvcOrdRefServiceContracts to build this ServiceOrder with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ServiceOrder.ServiceOrderBuilder referenceServiceContract( SrvcOrdRefServiceContract... value )
        {
            return toReferenceServiceContract(Lists.newArrayList(value));
        }

        /**
         * Constraints: Not nullable, Maximum length: 10
         * <p>
         * Original property name from the Odata EDM: <b>ReferenceServiceContract</b>
         * </p>
         *
         * @param value
         *            The referenceServiceContract to build this ServiceOrder with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ServiceOrder.ServiceOrderBuilder referenceServiceContract( final String value )
        {
            referenceServiceContract = value;
            return this;
        }

        private ServiceOrder.ServiceOrderBuilder toServiceOrdUserStatus( final List<ServiceOrdUserStatus> value )
        {
            toServiceOrdUserStatus.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_ServiceOrdUserStatus</b> for <b>ServiceOrder</b> to multiple
         * <b>ServiceOrdUserStatus</b>.
         *
         * @param value
         *            The ServiceOrdUserStatuss to build this ServiceOrder with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ServiceOrder.ServiceOrderBuilder serviceOrdUserStatus( ServiceOrdUserStatus... value )
        {
            return toServiceOrdUserStatus(Lists.newArrayList(value));
        }

        private ServiceOrder.ServiceOrderBuilder toText( final List<ServiceOrderText> value )
        {
            toText.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_Text</b> for <b>ServiceOrder</b> to multiple <b>ServiceOrderText</b>.
         *
         * @param value
         *            The ServiceOrderTexts to build this ServiceOrder with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ServiceOrder.ServiceOrderBuilder text( ServiceOrderText... value )
        {
            return toText(Lists.newArrayList(value));
        }

    }

}
