/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.field.ServiceOrderDefectField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.selectable.ServiceOrderDefectSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Defect Data Within Service Order
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_ServiceOrderDefectType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ServiceOrderDefect extends VdmEntity<ServiceOrderDefect>
{

    /**
     * Selector for all available fields of ServiceOrderDefect.
     *
     */
    public final static ServiceOrderDefectSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServiceOrder</b>
     * </p>
     *
     * @return Transaction ID
     */
    @Key
    @SerializedName( "ServiceOrder" )
    @JsonProperty( "ServiceOrder" )
    @Nullable
    @ODataField( odataName = "ServiceOrder" )
    private String serviceOrder;
    /**
     * Use with available fluent helpers to apply the <b>ServiceOrder</b> field to query operations.
     *
     */
    public final static ServiceOrderDefectField<String> SERVICE_ORDER =
        new ServiceOrderDefectField<String>("ServiceOrder");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SrvcDocTypeDefectCodeProfType</b>
     * </p>
     *
     * @return Subject Profile Category
     */
    @Key
    @SerializedName( "SrvcDocTypeDefectCodeProfType" )
    @JsonProperty( "SrvcDocTypeDefectCodeProfType" )
    @Nullable
    @ODataField( odataName = "SrvcDocTypeDefectCodeProfType" )
    private String srvcDocTypeDefectCodeProfType;
    /**
     * Use with available fluent helpers to apply the <b>SrvcDocTypeDefectCodeProfType</b> field to query operations.
     *
     */
    public final static ServiceOrderDefectField<String> SRVC_DOC_TYPE_DEFECT_CODE_PROF_TYPE =
        new ServiceOrderDefectField<String>("SrvcDocTypeDefectCodeProfType");
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDefectSequence</b>
     * </p>
     *
     * @return Sort Field
     */
    @Key
    @SerializedName( "ServiceDefectSequence" )
    @JsonProperty( "ServiceDefectSequence" )
    @Nullable
    @ODataField( odataName = "ServiceDefectSequence" )
    private Short serviceDefectSequence;
    /**
     * Use with available fluent helpers to apply the <b>ServiceDefectSequence</b> field to query operations.
     *
     */
    public final static ServiceOrderDefectField<Short> SERVICE_DEFECT_SEQUENCE =
        new ServiceOrderDefectField<Short>("ServiceDefectSequence");
    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>SrvcDocTypeDefectCodeProfile</b>
     * </p>
     *
     * @return Subject Profile
     */
    @SerializedName( "SrvcDocTypeDefectCodeProfile" )
    @JsonProperty( "SrvcDocTypeDefectCodeProfile" )
    @Nullable
    @ODataField( odataName = "SrvcDocTypeDefectCodeProfile" )
    private String srvcDocTypeDefectCodeProfile;
    /**
     * Use with available fluent helpers to apply the <b>SrvcDocTypeDefectCodeProfile</b> field to query operations.
     *
     */
    public final static ServiceOrderDefectField<String> SRVC_DOC_TYPE_DEFECT_CODE_PROFILE =
        new ServiceOrderDefectField<String>("SrvcDocTypeDefectCodeProfile");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDefectCodeCatalog</b>
     * </p>
     *
     * @return Catalog
     */
    @SerializedName( "ServiceDefectCodeCatalog" )
    @JsonProperty( "ServiceDefectCodeCatalog" )
    @Nullable
    @ODataField( odataName = "ServiceDefectCodeCatalog" )
    private String serviceDefectCodeCatalog;
    /**
     * Use with available fluent helpers to apply the <b>ServiceDefectCodeCatalog</b> field to query operations.
     *
     */
    public final static ServiceOrderDefectField<String> SERVICE_DEFECT_CODE_CATALOG =
        new ServiceOrderDefectField<String>("ServiceDefectCodeCatalog");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDefectCodeGroup</b>
     * </p>
     *
     * @return Code Group
     */
    @SerializedName( "ServiceDefectCodeGroup" )
    @JsonProperty( "ServiceDefectCodeGroup" )
    @Nullable
    @ODataField( odataName = "ServiceDefectCodeGroup" )
    private String serviceDefectCodeGroup;
    /**
     * Use with available fluent helpers to apply the <b>ServiceDefectCodeGroup</b> field to query operations.
     *
     */
    public final static ServiceOrderDefectField<String> SERVICE_DEFECT_CODE_GROUP =
        new ServiceOrderDefectField<String>("ServiceDefectCodeGroup");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDefectCode</b>
     * </p>
     *
     * @return Code
     */
    @SerializedName( "ServiceDefectCode" )
    @JsonProperty( "ServiceDefectCode" )
    @Nullable
    @ODataField( odataName = "ServiceDefectCode" )
    private String serviceDefectCode;
    /**
     * Use with available fluent helpers to apply the <b>ServiceDefectCode</b> field to query operations.
     *
     */
    public final static ServiceOrderDefectField<String> SERVICE_DEFECT_CODE =
        new ServiceOrderDefectField<String>("ServiceDefectCode");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDefectSchema</b>
     * </p>
     *
     * @return Coherent Cat. - Aspect ID
     */
    @SerializedName( "ServiceDefectSchema" )
    @JsonProperty( "ServiceDefectSchema" )
    @Nullable
    @ODataField( odataName = "ServiceDefectSchema" )
    private String serviceDefectSchema;
    /**
     * Use with available fluent helpers to apply the <b>ServiceDefectSchema</b> field to query operations.
     *
     */
    public final static ServiceOrderDefectField<String> SERVICE_DEFECT_SCHEMA =
        new ServiceOrderDefectField<String>("ServiceDefectSchema");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDefectCategory</b>
     * </p>
     *
     * @return Coherent Cat. - Aspect ID
     */
    @SerializedName( "ServiceDefectCategory" )
    @JsonProperty( "ServiceDefectCategory" )
    @Nullable
    @ODataField( odataName = "ServiceDefectCategory" )
    private String serviceDefectCategory;
    /**
     * Use with available fluent helpers to apply the <b>ServiceDefectCategory</b> field to query operations.
     *
     */
    public final static ServiceOrderDefectField<String> SERVICE_DEFECT_CATEGORY =
        new ServiceOrderDefectField<String>("ServiceDefectCategory");

    @Nonnull
    @Override
    public Class<ServiceOrderDefect> getType()
    {
        return ServiceOrderDefect.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServiceOrder</b>
     * </p>
     *
     * @param serviceOrder
     *            Transaction ID
     */
    public void setServiceOrder( @Nullable final String serviceOrder )
    {
        rememberChangedField("ServiceOrder", this.serviceOrder);
        this.serviceOrder = serviceOrder;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SrvcDocTypeDefectCodeProfType</b>
     * </p>
     *
     * @param srvcDocTypeDefectCodeProfType
     *            Subject Profile Category
     */
    public void setSrvcDocTypeDefectCodeProfType( @Nullable final String srvcDocTypeDefectCodeProfType )
    {
        rememberChangedField("SrvcDocTypeDefectCodeProfType", this.srvcDocTypeDefectCodeProfType);
        this.srvcDocTypeDefectCodeProfType = srvcDocTypeDefectCodeProfType;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDefectSequence</b>
     * </p>
     *
     * @param serviceDefectSequence
     *            Sort Field
     */
    public void setServiceDefectSequence( @Nullable final Short serviceDefectSequence )
    {
        rememberChangedField("ServiceDefectSequence", this.serviceDefectSequence);
        this.serviceDefectSequence = serviceDefectSequence;
    }

    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>SrvcDocTypeDefectCodeProfile</b>
     * </p>
     *
     * @param srvcDocTypeDefectCodeProfile
     *            Subject Profile
     */
    public void setSrvcDocTypeDefectCodeProfile( @Nullable final String srvcDocTypeDefectCodeProfile )
    {
        rememberChangedField("SrvcDocTypeDefectCodeProfile", this.srvcDocTypeDefectCodeProfile);
        this.srvcDocTypeDefectCodeProfile = srvcDocTypeDefectCodeProfile;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDefectCodeCatalog</b>
     * </p>
     *
     * @param serviceDefectCodeCatalog
     *            Catalog
     */
    public void setServiceDefectCodeCatalog( @Nullable final String serviceDefectCodeCatalog )
    {
        rememberChangedField("ServiceDefectCodeCatalog", this.serviceDefectCodeCatalog);
        this.serviceDefectCodeCatalog = serviceDefectCodeCatalog;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDefectCodeGroup</b>
     * </p>
     *
     * @param serviceDefectCodeGroup
     *            Code Group
     */
    public void setServiceDefectCodeGroup( @Nullable final String serviceDefectCodeGroup )
    {
        rememberChangedField("ServiceDefectCodeGroup", this.serviceDefectCodeGroup);
        this.serviceDefectCodeGroup = serviceDefectCodeGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDefectCode</b>
     * </p>
     *
     * @param serviceDefectCode
     *            Code
     */
    public void setServiceDefectCode( @Nullable final String serviceDefectCode )
    {
        rememberChangedField("ServiceDefectCode", this.serviceDefectCode);
        this.serviceDefectCode = serviceDefectCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDefectSchema</b>
     * </p>
     *
     * @param serviceDefectSchema
     *            Coherent Cat. - Aspect ID
     */
    public void setServiceDefectSchema( @Nullable final String serviceDefectSchema )
    {
        rememberChangedField("ServiceDefectSchema", this.serviceDefectSchema);
        this.serviceDefectSchema = serviceDefectSchema;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDefectCategory</b>
     * </p>
     *
     * @param serviceDefectCategory
     *            Coherent Cat. - Aspect ID
     */
    public void setServiceDefectCategory( @Nullable final String serviceDefectCategory )
    {
        rememberChangedField("ServiceDefectCategory", this.serviceDefectCategory);
        this.serviceDefectCategory = serviceDefectCategory;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_ServiceOrderDefect";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ServiceOrder", getServiceOrder());
        result.put("SrvcDocTypeDefectCodeProfType", getSrvcDocTypeDefectCodeProfType());
        result.put("ServiceDefectSequence", getServiceDefectSequence());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ServiceOrder", getServiceOrder());
        values.put("SrvcDocTypeDefectCodeProfType", getSrvcDocTypeDefectCodeProfType());
        values.put("ServiceDefectSequence", getServiceDefectSequence());
        values.put("SrvcDocTypeDefectCodeProfile", getSrvcDocTypeDefectCodeProfile());
        values.put("ServiceDefectCodeCatalog", getServiceDefectCodeCatalog());
        values.put("ServiceDefectCodeGroup", getServiceDefectCodeGroup());
        values.put("ServiceDefectCode", getServiceDefectCode());
        values.put("ServiceDefectSchema", getServiceDefectSchema());
        values.put("ServiceDefectCategory", getServiceDefectCategory());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ServiceOrder") ) {
                final Object value = values.remove("ServiceOrder");
                if( (value == null) || (!value.equals(getServiceOrder())) ) {
                    setServiceOrder(((String) value));
                }
            }
            if( values.containsKey("SrvcDocTypeDefectCodeProfType") ) {
                final Object value = values.remove("SrvcDocTypeDefectCodeProfType");
                if( (value == null) || (!value.equals(getSrvcDocTypeDefectCodeProfType())) ) {
                    setSrvcDocTypeDefectCodeProfType(((String) value));
                }
            }
            if( values.containsKey("ServiceDefectSequence") ) {
                final Object value = values.remove("ServiceDefectSequence");
                if( (value == null) || (!value.equals(getServiceDefectSequence())) ) {
                    setServiceDefectSequence(((Short) value));
                }
            }
            if( values.containsKey("SrvcDocTypeDefectCodeProfile") ) {
                final Object value = values.remove("SrvcDocTypeDefectCodeProfile");
                if( (value == null) || (!value.equals(getSrvcDocTypeDefectCodeProfile())) ) {
                    setSrvcDocTypeDefectCodeProfile(((String) value));
                }
            }
            if( values.containsKey("ServiceDefectCodeCatalog") ) {
                final Object value = values.remove("ServiceDefectCodeCatalog");
                if( (value == null) || (!value.equals(getServiceDefectCodeCatalog())) ) {
                    setServiceDefectCodeCatalog(((String) value));
                }
            }
            if( values.containsKey("ServiceDefectCodeGroup") ) {
                final Object value = values.remove("ServiceDefectCodeGroup");
                if( (value == null) || (!value.equals(getServiceDefectCodeGroup())) ) {
                    setServiceDefectCodeGroup(((String) value));
                }
            }
            if( values.containsKey("ServiceDefectCode") ) {
                final Object value = values.remove("ServiceDefectCode");
                if( (value == null) || (!value.equals(getServiceDefectCode())) ) {
                    setServiceDefectCode(((String) value));
                }
            }
            if( values.containsKey("ServiceDefectSchema") ) {
                final Object value = values.remove("ServiceDefectSchema");
                if( (value == null) || (!value.equals(getServiceDefectSchema())) ) {
                    setServiceDefectSchema(((String) value));
                }
            }
            if( values.containsKey("ServiceDefectCategory") ) {
                final Object value = values.remove("ServiceDefectCategory");
                if( (value == null) || (!value.equals(getServiceDefectCategory())) ) {
                    setServiceDefectCategory(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> ServiceOrderDefectField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ServiceOrderDefectField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ServiceOrderDefectField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ServiceOrderDefectField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ServiceOrderService.DEFAULT_SERVICE_PATH);
    }

}
