/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder;

import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.field.ServiceOrderItemField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.link.ServiceOrderItemLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.link.ServiceOrderItemOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.selectable.ServiceOrderItemSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Service Order Items
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_ServiceOrderItemType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ServiceOrderItem extends VdmEntity<ServiceOrderItem>
{

    /**
     * Selector for all available fields of ServiceOrderItem.
     *
     */
    public final static ServiceOrderItemSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServiceOrder</b>
     * </p>
     *
     * @return Transaction ID
     */
    @Key
    @SerializedName( "ServiceOrder" )
    @JsonProperty( "ServiceOrder" )
    @Nullable
    @ODataField( odataName = "ServiceOrder" )
    private String serviceOrder;
    /**
     * Use with available fluent helpers to apply the <b>ServiceOrder</b> field to query operations.
     *
     */
    public final static ServiceOrderItemField<String> SERVICE_ORDER = new ServiceOrderItemField<String>("ServiceOrder");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ServiceOrderItem</b>
     * </p>
     *
     * @return Shortened Item Number in Document
     */
    @Key
    @SerializedName( "ServiceOrderItem" )
    @JsonProperty( "ServiceOrderItem" )
    @Nullable
    @ODataField( odataName = "ServiceOrderItem" )
    private String serviceOrderItem;
    /**
     * Use with available fluent helpers to apply the <b>ServiceOrderItem</b> field to query operations.
     *
     */
    public final static ServiceOrderItemField<String> SERVICE_ORDER_ITEM =
        new ServiceOrderItemField<String>("ServiceOrderItem");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ServiceOrderItemUUID</b>
     * </p>
     *
     * @return GUID of a CRM Order Object
     */
    @SerializedName( "ServiceOrderItemUUID" )
    @JsonProperty( "ServiceOrderItemUUID" )
    @Nullable
    @ODataField( odataName = "ServiceOrderItemUUID" )
    private UUID serviceOrderItemUUID;
    /**
     * Use with available fluent helpers to apply the <b>ServiceOrderItemUUID</b> field to query operations.
     *
     */
    public final static ServiceOrderItemField<UUID> SERVICE_ORDER_ITEM_UUID =
        new ServiceOrderItemField<UUID>("ServiceOrderItemUUID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocumentItemCharUUID</b>
     * </p>
     *
     * @return 32 Character CRM Object GUID (Converted)
     */
    @SerializedName( "ServiceDocumentItemCharUUID" )
    @JsonProperty( "ServiceDocumentItemCharUUID" )
    @Nullable
    @ODataField( odataName = "ServiceDocumentItemCharUUID" )
    private UUID serviceDocumentItemCharUUID;
    /**
     * Use with available fluent helpers to apply the <b>ServiceDocumentItemCharUUID</b> field to query operations.
     *
     */
    public final static ServiceOrderItemField<UUID> SERVICE_DOCUMENT_ITEM_CHAR_UUID =
        new ServiceOrderItemField<UUID>("ServiceDocumentItemCharUUID");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ServiceOrderItemDescription</b>
     * </p>
     *
     * @return Product Description
     */
    @SerializedName( "ServiceOrderItemDescription" )
    @JsonProperty( "ServiceOrderItemDescription" )
    @Nullable
    @ODataField( odataName = "ServiceOrderItemDescription" )
    private String serviceOrderItemDescription;
    /**
     * Use with available fluent helpers to apply the <b>ServiceOrderItemDescription</b> field to query operations.
     *
     */
    public final static ServiceOrderItemField<String> SERVICE_ORDER_ITEM_DESCRIPTION =
        new ServiceOrderItemField<String>("ServiceOrderItemDescription");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServiceObjectType</b>
     * </p>
     *
     * @return Business Trans. Cat.
     */
    @SerializedName( "ServiceObjectType" )
    @JsonProperty( "ServiceObjectType" )
    @Nullable
    @ODataField( odataName = "ServiceObjectType" )
    private String serviceObjectType;
    /**
     * Use with available fluent helpers to apply the <b>ServiceObjectType</b> field to query operations.
     *
     */
    public final static ServiceOrderItemField<String> SERVICE_OBJECT_TYPE =
        new ServiceOrderItemField<String>("ServiceObjectType");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocumentItemObjectType</b>
     * </p>
     *
     * @return CRM Item Object Type
     */
    @SerializedName( "ServiceDocumentItemObjectType" )
    @JsonProperty( "ServiceDocumentItemObjectType" )
    @Nullable
    @ODataField( odataName = "ServiceDocumentItemObjectType" )
    private String serviceDocumentItemObjectType;
    /**
     * Use with available fluent helpers to apply the <b>ServiceDocumentItemObjectType</b> field to query operations.
     *
     */
    public final static ServiceOrderItemField<String> SERVICE_DOCUMENT_ITEM_OBJECT_TYPE =
        new ServiceOrderItemField<String>("ServiceDocumentItemObjectType");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Short Text Language for an Item
     */
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static ServiceOrderItemField<String> LANGUAGE = new ServiceOrderItemField<String>("Language");
    /**
     * Constraints: Not nullable, Maximum length: 54
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     *
     * @return Product Name Entered
     */
    @SerializedName( "Product" )
    @JsonProperty( "Product" )
    @Nullable
    @ODataField( odataName = "Product" )
    private String product;
    /**
     * Use with available fluent helpers to apply the <b>Product</b> field to query operations.
     *
     */
    public final static ServiceOrderItemField<String> PRODUCT = new ServiceOrderItemField<String>("Product");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>Quantity</b>
     * </p>
     *
     * @return CRM: Order Quantity
     */
    @SerializedName( "Quantity" )
    @JsonProperty( "Quantity" )
    @Nullable
    @ODataField( odataName = "Quantity" )
    private BigDecimal quantity;
    /**
     * Use with available fluent helpers to apply the <b>Quantity</b> field to query operations.
     *
     */
    public final static ServiceOrderItemField<BigDecimal> QUANTITY = new ServiceOrderItemField<BigDecimal>("Quantity");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>QuantityUnit</b>
     * </p>
     *
     * @return Unit of Measure in Which the Product Is Sold
     */
    @SerializedName( "QuantityUnit" )
    @JsonProperty( "QuantityUnit" )
    @Nullable
    @ODataField( odataName = "QuantityUnit" )
    private String quantityUnit;
    /**
     * Use with available fluent helpers to apply the <b>QuantityUnit</b> field to query operations.
     *
     */
    public final static ServiceOrderItemField<String> QUANTITY_UNIT = new ServiceOrderItemField<String>("QuantityUnit");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SrvcOrdItmResvnIsExisting</b>
     * </p>
     *
     * @return The srvcOrdItmResvnIsExisting contained in this entity.
     */
    @SerializedName( "SrvcOrdItmResvnIsExisting" )
    @JsonProperty( "SrvcOrdItmResvnIsExisting" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "SrvcOrdItmResvnIsExisting" )
    private Boolean srvcOrdItmResvnIsExisting;
    /**
     * Use with available fluent helpers to apply the <b>SrvcOrdItmResvnIsExisting</b> field to query operations.
     *
     */
    public final static ServiceOrderItemField<Boolean> SRVC_ORD_ITM_RESVN_IS_EXISTING =
        new ServiceOrderItemField<Boolean>("SrvcOrdItmResvnIsExisting");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>SrvcOrdItemReservedQuantity</b>
     * </p>
     *
     * @return CRM: Confirmed Quantity
     */
    @SerializedName( "SrvcOrdItemReservedQuantity" )
    @JsonProperty( "SrvcOrdItemReservedQuantity" )
    @Nullable
    @ODataField( odataName = "SrvcOrdItemReservedQuantity" )
    private BigDecimal srvcOrdItemReservedQuantity;
    /**
     * Use with available fluent helpers to apply the <b>SrvcOrdItemReservedQuantity</b> field to query operations.
     *
     */
    public final static ServiceOrderItemField<BigDecimal> SRVC_ORD_ITEM_RESERVED_QUANTITY =
        new ServiceOrderItemField<BigDecimal>("SrvcOrdItemReservedQuantity");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDuration</b>
     * </p>
     *
     * @return Duration
     */
    @SerializedName( "ServiceDuration" )
    @JsonProperty( "ServiceDuration" )
    @Nullable
    @ODataField( odataName = "ServiceDuration" )
    private BigDecimal serviceDuration;
    /**
     * Use with available fluent helpers to apply the <b>ServiceDuration</b> field to query operations.
     *
     */
    public final static ServiceOrderItemField<BigDecimal> SERVICE_DURATION =
        new ServiceOrderItemField<BigDecimal>("ServiceDuration");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDurationUnit</b>
     * </p>
     *
     * @return Unit for Duration of Work
     */
    @SerializedName( "ServiceDurationUnit" )
    @JsonProperty( "ServiceDurationUnit" )
    @Nullable
    @ODataField( odataName = "ServiceDurationUnit" )
    private String serviceDurationUnit;
    /**
     * Use with available fluent helpers to apply the <b>ServiceDurationUnit</b> field to query operations.
     *
     */
    public final static ServiceOrderItemField<String> SERVICE_DURATION_UNIT =
        new ServiceOrderItemField<String>("ServiceDurationUnit");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ServiceOrderItemCategory</b>
     * </p>
     *
     * @return Item Category
     */
    @SerializedName( "ServiceOrderItemCategory" )
    @JsonProperty( "ServiceOrderItemCategory" )
    @Nullable
    @ODataField( odataName = "ServiceOrderItemCategory" )
    private String serviceOrderItemCategory;
    /**
     * Use with available fluent helpers to apply the <b>ServiceOrderItemCategory</b> field to query operations.
     *
     */
    public final static ServiceOrderItemField<String> SERVICE_ORDER_ITEM_CATEGORY =
        new ServiceOrderItemField<String>("ServiceOrderItemCategory");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ServiceOrdItemRejectionReason</b>
     * </p>
     *
     * @return Cancellation Reason Code
     */
    @SerializedName( "ServiceOrdItemRejectionReason" )
    @JsonProperty( "ServiceOrdItemRejectionReason" )
    @Nullable
    @ODataField( odataName = "ServiceOrdItemRejectionReason" )
    private String serviceOrdItemRejectionReason;
    /**
     * Use with available fluent helpers to apply the <b>ServiceOrdItemRejectionReason</b> field to query operations.
     *
     */
    public final static ServiceOrderItemField<String> SERVICE_ORD_ITEM_REJECTION_REASON =
        new ServiceOrderItemField<String>("ServiceOrdItemRejectionReason");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BillableControl</b>
     * </p>
     *
     * @return Accounting Indicator
     */
    @SerializedName( "BillableControl" )
    @JsonProperty( "BillableControl" )
    @Nullable
    @ODataField( odataName = "BillableControl" )
    private String billableControl;
    /**
     * Use with available fluent helpers to apply the <b>BillableControl</b> field to query operations.
     *
     */
    public final static ServiceOrderItemField<String> BILLABLE_CONTROL =
        new ServiceOrderItemField<String>("BillableControl");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SoldToParty</b>
     * </p>
     *
     * @return Sold-To Party
     */
    @SerializedName( "SoldToParty" )
    @JsonProperty( "SoldToParty" )
    @Nullable
    @ODataField( odataName = "SoldToParty" )
    private String soldToParty;
    /**
     * Use with available fluent helpers to apply the <b>SoldToParty</b> field to query operations.
     *
     */
    public final static ServiceOrderItemField<String> SOLD_TO_PARTY = new ServiceOrderItemField<String>("SoldToParty");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ShipToParty</b>
     * </p>
     *
     * @return Ship-To Party
     */
    @SerializedName( "ShipToParty" )
    @JsonProperty( "ShipToParty" )
    @Nullable
    @ODataField( odataName = "ShipToParty" )
    private String shipToParty;
    /**
     * Use with available fluent helpers to apply the <b>ShipToParty</b> field to query operations.
     *
     */
    public final static ServiceOrderItemField<String> SHIP_TO_PARTY = new ServiceOrderItemField<String>("ShipToParty");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BillToParty</b>
     * </p>
     *
     * @return Bill-To Party
     */
    @SerializedName( "BillToParty" )
    @JsonProperty( "BillToParty" )
    @Nullable
    @ODataField( odataName = "BillToParty" )
    private String billToParty;
    /**
     * Use with available fluent helpers to apply the <b>BillToParty</b> field to query operations.
     *
     */
    public final static ServiceOrderItemField<String> BILL_TO_PARTY = new ServiceOrderItemField<String>("BillToParty");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PayerParty</b>
     * </p>
     *
     * @return Payer
     */
    @SerializedName( "PayerParty" )
    @JsonProperty( "PayerParty" )
    @Nullable
    @ODataField( odataName = "PayerParty" )
    private String payerParty;
    /**
     * Use with available fluent helpers to apply the <b>PayerParty</b> field to query operations.
     *
     */
    public final static ServiceOrderItemField<String> PAYER_PARTY = new ServiceOrderItemField<String>("PayerParty");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ContactPersonBusinessPartnerId</b>
     * </p>
     *
     * @return Customer Contact Person
     */
    @SerializedName( "ContactPersonBusinessPartnerId" )
    @JsonProperty( "ContactPersonBusinessPartnerId" )
    @Nullable
    @ODataField( odataName = "ContactPersonBusinessPartnerId" )
    private String contactPersonBusinessPartnerId;
    /**
     * Use with available fluent helpers to apply the <b>ContactPersonBusinessPartnerId</b> field to query operations.
     *
     */
    public final static ServiceOrderItemField<String> CONTACT_PERSON_BUSINESS_PARTNER_ID =
        new ServiceOrderItemField<String>("ContactPersonBusinessPartnerId");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PersonResponsible</b>
     * </p>
     *
     * @return Employee Responsible
     */
    @SerializedName( "PersonResponsible" )
    @JsonProperty( "PersonResponsible" )
    @Nullable
    @ODataField( odataName = "PersonResponsible" )
    private String personResponsible;
    /**
     * Use with available fluent helpers to apply the <b>PersonResponsible</b> field to query operations.
     *
     */
    public final static ServiceOrderItemField<String> PERSON_RESPONSIBLE =
        new ServiceOrderItemField<String>("PersonResponsible");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ExecutingServiceEmployee</b>
     * </p>
     *
     * @return Executing Service Employee
     */
    @SerializedName( "ExecutingServiceEmployee" )
    @JsonProperty( "ExecutingServiceEmployee" )
    @Nullable
    @ODataField( odataName = "ExecutingServiceEmployee" )
    private String executingServiceEmployee;
    /**
     * Use with available fluent helpers to apply the <b>ExecutingServiceEmployee</b> field to query operations.
     *
     */
    public final static ServiceOrderItemField<String> EXECUTING_SERVICE_EMPLOYEE =
        new ServiceOrderItemField<String>("ExecutingServiceEmployee");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServicePerformer</b>
     * </p>
     *
     * @return Business Partner Number
     */
    @SerializedName( "ServicePerformer" )
    @JsonProperty( "ServicePerformer" )
    @Nullable
    @ODataField( odataName = "ServicePerformer" )
    private String servicePerformer;
    /**
     * Use with available fluent helpers to apply the <b>ServicePerformer</b> field to query operations.
     *
     */
    public final static ServiceOrderItemField<String> SERVICE_PERFORMER =
        new ServiceOrderItemField<String>("ServicePerformer");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ServiceOrderItemIsReleased</b>
     * </p>
     *
     * @return Release Status
     */
    @SerializedName( "ServiceOrderItemIsReleased" )
    @JsonProperty( "ServiceOrderItemIsReleased" )
    @Nullable
    @ODataField( odataName = "ServiceOrderItemIsReleased" )
    private String serviceOrderItemIsReleased;
    /**
     * Use with available fluent helpers to apply the <b>ServiceOrderItemIsReleased</b> field to query operations.
     *
     */
    public final static ServiceOrderItemField<String> SERVICE_ORDER_ITEM_IS_RELEASED =
        new ServiceOrderItemField<String>("ServiceOrderItemIsReleased");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ServiceOrderItemIsCompleted</b>
     * </p>
     *
     * @return The serviceOrderItemIsCompleted contained in this entity.
     */
    @SerializedName( "ServiceOrderItemIsCompleted" )
    @JsonProperty( "ServiceOrderItemIsCompleted" )
    @Nullable
    @ODataField( odataName = "ServiceOrderItemIsCompleted" )
    private String serviceOrderItemIsCompleted;
    /**
     * Use with available fluent helpers to apply the <b>ServiceOrderItemIsCompleted</b> field to query operations.
     *
     */
    public final static ServiceOrderItemField<String> SERVICE_ORDER_ITEM_IS_COMPLETED =
        new ServiceOrderItemField<String>("ServiceOrderItemIsCompleted");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ServiceOrderItemIsRejected</b>
     * </p>
     *
     * @return Cancellation Status
     */
    @SerializedName( "ServiceOrderItemIsRejected" )
    @JsonProperty( "ServiceOrderItemIsRejected" )
    @Nullable
    @ODataField( odataName = "ServiceOrderItemIsRejected" )
    private String serviceOrderItemIsRejected;
    /**
     * Use with available fluent helpers to apply the <b>ServiceOrderItemIsRejected</b> field to query operations.
     *
     */
    public final static ServiceOrderItemField<String> SERVICE_ORDER_ITEM_IS_REJECTED =
        new ServiceOrderItemField<String>("ServiceOrderItemIsRejected");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceServiceContract</b>
     * </p>
     *
     * @return Transaction ID
     */
    @SerializedName( "ReferenceServiceContract" )
    @JsonProperty( "ReferenceServiceContract" )
    @Nullable
    @ODataField( odataName = "ReferenceServiceContract" )
    private String referenceServiceContract;
    /**
     * Use with available fluent helpers to apply the <b>ReferenceServiceContract</b> field to query operations.
     *
     */
    public final static ServiceOrderItemField<String> REFERENCE_SERVICE_CONTRACT =
        new ServiceOrderItemField<String>("ReferenceServiceContract");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceServiceContractItem</b>
     * </p>
     *
     * @return Shortened Item Number in Document
     */
    @SerializedName( "ReferenceServiceContractItem" )
    @JsonProperty( "ReferenceServiceContractItem" )
    @Nullable
    @ODataField( odataName = "ReferenceServiceContractItem" )
    private String referenceServiceContractItem;
    /**
     * Use with available fluent helpers to apply the <b>ReferenceServiceContractItem</b> field to query operations.
     *
     */
    public final static ServiceOrderItemField<String> REFERENCE_SERVICE_CONTRACT_ITEM =
        new ServiceOrderItemField<String>("ReferenceServiceContractItem");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RefServiceOrderTemplate</b>
     * </p>
     *
     * @return Transaction ID
     */
    @SerializedName( "RefServiceOrderTemplate" )
    @JsonProperty( "RefServiceOrderTemplate" )
    @Nullable
    @ODataField( odataName = "RefServiceOrderTemplate" )
    private String refServiceOrderTemplate;
    /**
     * Use with available fluent helpers to apply the <b>RefServiceOrderTemplate</b> field to query operations.
     *
     */
    public final static ServiceOrderItemField<String> REF_SERVICE_ORDER_TEMPLATE =
        new ServiceOrderItemField<String>("RefServiceOrderTemplate");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>RefServiceOrderTemplateItem</b>
     * </p>
     *
     * @return Shortened Item Number in Document
     */
    @SerializedName( "RefServiceOrderTemplateItem" )
    @JsonProperty( "RefServiceOrderTemplateItem" )
    @Nullable
    @ODataField( odataName = "RefServiceOrderTemplateItem" )
    private String refServiceOrderTemplateItem;
    /**
     * Use with available fluent helpers to apply the <b>RefServiceOrderTemplateItem</b> field to query operations.
     *
     */
    public final static ServiceOrderItemField<String> REF_SERVICE_ORDER_TEMPLATE_ITEM =
        new ServiceOrderItemField<String>("RefServiceOrderTemplateItem");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceServiceRequest</b>
     * </p>
     *
     * @return Transaction ID
     */
    @SerializedName( "ReferenceServiceRequest" )
    @JsonProperty( "ReferenceServiceRequest" )
    @Nullable
    @ODataField( odataName = "ReferenceServiceRequest" )
    private String referenceServiceRequest;
    /**
     * Use with available fluent helpers to apply the <b>ReferenceServiceRequest</b> field to query operations.
     *
     */
    public final static ServiceOrderItemField<String> REFERENCE_SERVICE_REQUEST =
        new ServiceOrderItemField<String>("ReferenceServiceRequest");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceServiceRequestItem</b>
     * </p>
     *
     * @return Shortened Item Number in Document
     */
    @SerializedName( "ReferenceServiceRequestItem" )
    @JsonProperty( "ReferenceServiceRequestItem" )
    @Nullable
    @ODataField( odataName = "ReferenceServiceRequestItem" )
    private String referenceServiceRequestItem;
    /**
     * Use with available fluent helpers to apply the <b>ReferenceServiceRequestItem</b> field to query operations.
     *
     */
    public final static ServiceOrderItemField<String> REFERENCE_SERVICE_REQUEST_ITEM =
        new ServiceOrderItemField<String>("ReferenceServiceRequestItem");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ParentServiceOrderItem</b>
     * </p>
     *
     * @return Shortened Item Number in Document
     */
    @SerializedName( "ParentServiceOrderItem" )
    @JsonProperty( "ParentServiceOrderItem" )
    @Nullable
    @ODataField( odataName = "ParentServiceOrderItem" )
    private String parentServiceOrderItem;
    /**
     * Use with available fluent helpers to apply the <b>ParentServiceOrderItem</b> field to query operations.
     *
     */
    public final static ServiceOrderItemField<String> PARENT_SERVICE_ORDER_ITEM =
        new ServiceOrderItemField<String>("ParentServiceOrderItem");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PlannedServiceStartDateTime</b>
     * </p>
     *
     * @return Service Planned From Date
     */
    @SerializedName( "PlannedServiceStartDateTime" )
    @JsonProperty( "PlannedServiceStartDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "PlannedServiceStartDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime plannedServiceStartDateTime;
    /**
     * Use with available fluent helpers to apply the <b>PlannedServiceStartDateTime</b> field to query operations.
     *
     */
    public final static ServiceOrderItemField<ZonedDateTime> PLANNED_SERVICE_START_DATE_TIME =
        new ServiceOrderItemField<ZonedDateTime>("PlannedServiceStartDateTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PlannedServiceEndDateTime</b>
     * </p>
     *
     * @return Service Planned To Date
     */
    @SerializedName( "PlannedServiceEndDateTime" )
    @JsonProperty( "PlannedServiceEndDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "PlannedServiceEndDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime plannedServiceEndDateTime;
    /**
     * Use with available fluent helpers to apply the <b>PlannedServiceEndDateTime</b> field to query operations.
     *
     */
    public final static ServiceOrderItemField<ZonedDateTime> PLANNED_SERVICE_END_DATE_TIME =
        new ServiceOrderItemField<ZonedDateTime>("PlannedServiceEndDateTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>RequestedServiceStartDateTime</b>
     * </p>
     *
     * @return Service Request Start Date
     */
    @SerializedName( "RequestedServiceStartDateTime" )
    @JsonProperty( "RequestedServiceStartDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "RequestedServiceStartDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime requestedServiceStartDateTime;
    /**
     * Use with available fluent helpers to apply the <b>RequestedServiceStartDateTime</b> field to query operations.
     *
     */
    public final static ServiceOrderItemField<ZonedDateTime> REQUESTED_SERVICE_START_DATE_TIME =
        new ServiceOrderItemField<ZonedDateTime>("RequestedServiceStartDateTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>RequestedServiceEndDateTime</b>
     * </p>
     *
     * @return Service Request Due Date
     */
    @SerializedName( "RequestedServiceEndDateTime" )
    @JsonProperty( "RequestedServiceEndDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "RequestedServiceEndDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime requestedServiceEndDateTime;
    /**
     * Use with available fluent helpers to apply the <b>RequestedServiceEndDateTime</b> field to query operations.
     *
     */
    public final static ServiceOrderItemField<ZonedDateTime> REQUESTED_SERVICE_END_DATE_TIME =
        new ServiceOrderItemField<ZonedDateTime>("RequestedServiceEndDateTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>SrvcDocItemSLADueByDateTime</b>
     * </p>
     *
     * @return Due By
     */
    @SerializedName( "SrvcDocItemSLADueByDateTime" )
    @JsonProperty( "SrvcDocItemSLADueByDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "SrvcDocItemSLADueByDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime srvcDocItemSLADueByDateTime;
    /**
     * Use with available fluent helpers to apply the <b>SrvcDocItemSLADueByDateTime</b> field to query operations.
     *
     */
    public final static ServiceOrderItemField<ZonedDateTime> SRVC_DOC_ITEM_SLA_DUE_BY_DATE_TIME =
        new ServiceOrderItemField<ZonedDateTime>("SrvcDocItemSLADueByDateTime");
    /**
     * Constraints: Not nullable, Precision: 7, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>ActualServiceDuration</b>
     * </p>
     *
     * @return Confirmed Duration
     */
    @SerializedName( "ActualServiceDuration" )
    @JsonProperty( "ActualServiceDuration" )
    @Nullable
    @ODataField( odataName = "ActualServiceDuration" )
    private BigDecimal actualServiceDuration;
    /**
     * Use with available fluent helpers to apply the <b>ActualServiceDuration</b> field to query operations.
     *
     */
    public final static ServiceOrderItemField<BigDecimal> ACTUAL_SERVICE_DURATION =
        new ServiceOrderItemField<BigDecimal>("ActualServiceDuration");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ActualServiceDurationUnit</b>
     * </p>
     *
     * @return Time Unit for Confirmed Duration
     */
    @SerializedName( "ActualServiceDurationUnit" )
    @JsonProperty( "ActualServiceDurationUnit" )
    @Nullable
    @ODataField( odataName = "ActualServiceDurationUnit" )
    private String actualServiceDurationUnit;
    /**
     * Use with available fluent helpers to apply the <b>ActualServiceDurationUnit</b> field to query operations.
     *
     */
    public final static ServiceOrderItemField<String> ACTUAL_SERVICE_DURATION_UNIT =
        new ServiceOrderItemField<String>("ActualServiceDurationUnit");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SrvcContrDetnIsSpprsd</b>
     * </p>
     *
     * @return Status Is Active
     */
    @SerializedName( "SrvcContrDetnIsSpprsd" )
    @JsonProperty( "SrvcContrDetnIsSpprsd" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "SrvcContrDetnIsSpprsd" )
    private Boolean srvcContrDetnIsSpprsd;
    /**
     * Use with available fluent helpers to apply the <b>SrvcContrDetnIsSpprsd</b> field to query operations.
     *
     */
    public final static ServiceOrderItemField<Boolean> SRVC_CONTR_DETN_IS_SPPRSD =
        new ServiceOrderItemField<Boolean>("SrvcContrDetnIsSpprsd");
    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceServiceOrderItem</b>
     * </p>
     *
     * @return External Reference Number
     */
    @SerializedName( "ReferenceServiceOrderItem" )
    @JsonProperty( "ReferenceServiceOrderItem" )
    @Nullable
    @ODataField( odataName = "ReferenceServiceOrderItem" )
    private String referenceServiceOrderItem;
    /**
     * Use with available fluent helpers to apply the <b>ReferenceServiceOrderItem</b> field to query operations.
     *
     */
    public final static ServiceOrderItemField<String> REFERENCE_SERVICE_ORDER_ITEM =
        new ServiceOrderItemField<String>("ReferenceServiceOrderItem");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ShippingCondition</b>
     * </p>
     *
     * @return Shipping Conditions
     */
    @SerializedName( "ShippingCondition" )
    @JsonProperty( "ShippingCondition" )
    @Nullable
    @ODataField( odataName = "ShippingCondition" )
    private String shippingCondition;
    /**
     * Use with available fluent helpers to apply the <b>ShippingCondition</b> field to query operations.
     *
     */
    public final static ServiceOrderItemField<String> SHIPPING_CONDITION =
        new ServiceOrderItemField<String>("ShippingCondition");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SrvcDocItmPartReferenceItem</b>
     * </p>
     *
     * @return Shortened Item Number in Document
     */
    @SerializedName( "SrvcDocItmPartReferenceItem" )
    @JsonProperty( "SrvcDocItmPartReferenceItem" )
    @Nullable
    @ODataField( odataName = "SrvcDocItmPartReferenceItem" )
    private String srvcDocItmPartReferenceItem;
    /**
     * Use with available fluent helpers to apply the <b>SrvcDocItmPartReferenceItem</b> field to query operations.
     *
     */
    public final static ServiceOrderItemField<String> SRVC_DOC_ITM_PART_REFERENCE_ITEM =
        new ServiceOrderItemField<String>("SrvcDocItmPartReferenceItem");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SrvcDocItmApptReferenceItem</b>
     * </p>
     *
     * @return Shortened Item Number in Document
     */
    @SerializedName( "SrvcDocItmApptReferenceItem" )
    @JsonProperty( "SrvcDocItmApptReferenceItem" )
    @Nullable
    @ODataField( odataName = "SrvcDocItmApptReferenceItem" )
    private String srvcDocItmApptReferenceItem;
    /**
     * Use with available fluent helpers to apply the <b>SrvcDocItmApptReferenceItem</b> field to query operations.
     *
     */
    public final static ServiceOrderItemField<String> SRVC_DOC_ITM_APPT_REFERENCE_ITEM =
        new ServiceOrderItemField<String>("SrvcDocItmApptReferenceItem");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SrvcDocItmApptRefObjectUUID</b>
     * </p>
     *
     * @return GUID of a CRM Order Object
     */
    @SerializedName( "SrvcDocItmApptRefObjectUUID" )
    @JsonProperty( "SrvcDocItmApptRefObjectUUID" )
    @Nullable
    @ODataField( odataName = "SrvcDocItmApptRefObjectUUID" )
    private UUID srvcDocItmApptRefObjectUUID;
    /**
     * Use with available fluent helpers to apply the <b>SrvcDocItmApptRefObjectUUID</b> field to query operations.
     *
     */
    public final static ServiceOrderItemField<UUID> SRVC_DOC_ITM_APPT_REF_OBJECT_UUID =
        new ServiceOrderItemField<UUID>("SrvcDocItmApptRefObjectUUID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SrvcOrdItemIsUnplanned</b>
     * </p>
     *
     * @return Unplanned Item
     */
    @SerializedName( "SrvcOrdItemIsUnplanned" )
    @JsonProperty( "SrvcOrdItemIsUnplanned" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "SrvcOrdItemIsUnplanned" )
    private Boolean srvcOrdItemIsUnplanned;
    /**
     * Use with available fluent helpers to apply the <b>SrvcOrdItemIsUnplanned</b> field to query operations.
     *
     */
    public final static ServiceOrderItemField<Boolean> SRVC_ORD_ITEM_IS_UNPLANNED =
        new ServiceOrderItemField<Boolean>("SrvcOrdItemIsUnplanned");
    /**
     * Constraints: Not nullable, Maximum length: 32
     * <p>
     * Original property name from the Odata EDM: <b>FSMServiceActivity</b>
     * </p>
     *
     * @return Identification of a Reference Object for Items
     */
    @SerializedName( "FSMServiceActivity" )
    @JsonProperty( "FSMServiceActivity" )
    @Nullable
    @ODataField( odataName = "FSMServiceActivity" )
    private String fSMServiceActivity;
    /**
     * Use with available fluent helpers to apply the <b>FSMServiceActivity</b> field to query operations.
     *
     */
    public final static ServiceOrderItemField<String> FSM_SERVICE_ACTIVITY =
        new ServiceOrderItemField<String>("FSMServiceActivity");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>TimeSheetOvertimeCategory</b>
     * </p>
     *
     * @return Overtime Category
     */
    @SerializedName( "TimeSheetOvertimeCategory" )
    @JsonProperty( "TimeSheetOvertimeCategory" )
    @Nullable
    @ODataField( odataName = "TimeSheetOvertimeCategory" )
    private String timeSheetOvertimeCategory;
    /**
     * Use with available fluent helpers to apply the <b>TimeSheetOvertimeCategory</b> field to query operations.
     *
     */
    public final static ServiceOrderItemField<String> TIME_SHEET_OVERTIME_CATEGORY =
        new ServiceOrderItemField<String>("TimeSheetOvertimeCategory");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>RespyMgmtServiceTeam</b>
     * </p>
     *
     * @return Service Team (Responsibility Management)
     */
    @SerializedName( "RespyMgmtServiceTeam" )
    @JsonProperty( "RespyMgmtServiceTeam" )
    @Nullable
    @ODataField( odataName = "RespyMgmtServiceTeam" )
    private String respyMgmtServiceTeam;
    /**
     * Use with available fluent helpers to apply the <b>RespyMgmtServiceTeam</b> field to query operations.
     *
     */
    public final static ServiceOrderItemField<String> RESPY_MGMT_SERVICE_TEAM =
        new ServiceOrderItemField<String>("RespyMgmtServiceTeam");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>RespyMgmtServiceTeamName</b>
     * </p>
     *
     * @return Name
     */
    @SerializedName( "RespyMgmtServiceTeamName" )
    @JsonProperty( "RespyMgmtServiceTeamName" )
    @Nullable
    @ODataField( odataName = "RespyMgmtServiceTeamName" )
    private String respyMgmtServiceTeamName;
    /**
     * Use with available fluent helpers to apply the <b>RespyMgmtServiceTeamName</b> field to query operations.
     *
     */
    public final static ServiceOrderItemField<String> RESPY_MGMT_SERVICE_TEAM_NAME =
        new ServiceOrderItemField<String>("RespyMgmtServiceTeamName");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>RespyMgmtGlobalTeamID</b>
     * </p>
     *
     * @return Global Team ID in Responsibility Mgmt.
     */
    @SerializedName( "RespyMgmtGlobalTeamID" )
    @JsonProperty( "RespyMgmtGlobalTeamID" )
    @Nullable
    @ODataField( odataName = "RespyMgmtGlobalTeamID" )
    private String respyMgmtGlobalTeamID;
    /**
     * Use with available fluent helpers to apply the <b>RespyMgmtGlobalTeamID</b> field to query operations.
     *
     */
    public final static ServiceOrderItemField<String> RESPY_MGMT_GLOBAL_TEAM_ID =
        new ServiceOrderItemField<String>("RespyMgmtGlobalTeamID");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenter</b>
     * </p>
     *
     * @return Profit Center
     */
    @SerializedName( "ProfitCenter" )
    @JsonProperty( "ProfitCenter" )
    @Nullable
    @ODataField( odataName = "ProfitCenter" )
    private String profitCenter;
    /**
     * Use with available fluent helpers to apply the <b>ProfitCenter</b> field to query operations.
     *
     */
    public final static ServiceOrderItemField<String> PROFIT_CENTER = new ServiceOrderItemField<String>("ProfitCenter");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SrvcOrdItemCreditStatus</b>
     * </p>
     *
     * @return Credit Status of Item
     */
    @SerializedName( "SrvcOrdItemCreditStatus" )
    @JsonProperty( "SrvcOrdItemCreditStatus" )
    @Nullable
    @ODataField( odataName = "SrvcOrdItemCreditStatus" )
    private String srvcOrdItemCreditStatus;
    /**
     * Use with available fluent helpers to apply the <b>SrvcOrdItemCreditStatus</b> field to query operations.
     *
     */
    public final static ServiceOrderItemField<String> SRVC_ORD_ITEM_CREDIT_STATUS =
        new ServiceOrderItemField<String>("SrvcOrdItemCreditStatus");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SrvcOrdItemExecutionStatus</b>
     * </p>
     *
     * @return Execution Status
     */
    @SerializedName( "SrvcOrdItemExecutionStatus" )
    @JsonProperty( "SrvcOrdItemExecutionStatus" )
    @Nullable
    @ODataField( odataName = "SrvcOrdItemExecutionStatus" )
    private String srvcOrdItemExecutionStatus;
    /**
     * Use with available fluent helpers to apply the <b>SrvcOrdItemExecutionStatus</b> field to query operations.
     *
     */
    public final static ServiceOrderItemField<String> SRVC_ORD_ITEM_EXECUTION_STATUS =
        new ServiceOrderItemField<String>("SrvcOrdItemExecutionStatus");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PaymentTerms</b>
     * </p>
     *
     * @return Terms of Payment
     */
    @SerializedName( "PaymentTerms" )
    @JsonProperty( "PaymentTerms" )
    @Nullable
    @ODataField( odataName = "PaymentTerms" )
    private String paymentTerms;
    /**
     * Use with available fluent helpers to apply the <b>PaymentTerms</b> field to query operations.
     *
     */
    public final static ServiceOrderItemField<String> PAYMENT_TERMS = new ServiceOrderItemField<String>("PaymentTerms");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PaymentMethod</b>
     * </p>
     *
     * @return Payment Method
     */
    @SerializedName( "PaymentMethod" )
    @JsonProperty( "PaymentMethod" )
    @Nullable
    @ODataField( odataName = "PaymentMethod" )
    private String paymentMethod;
    /**
     * Use with available fluent helpers to apply the <b>PaymentMethod</b> field to query operations.
     *
     */
    public final static ServiceOrderItemField<String> PAYMENT_METHOD =
        new ServiceOrderItemField<String>("PaymentMethod");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>SEPAMandate</b>
     * </p>
     *
     * @return Unique Reference to Mandate per Payment Recipient
     */
    @SerializedName( "SEPAMandate" )
    @JsonProperty( "SEPAMandate" )
    @Nullable
    @ODataField( odataName = "SEPAMandate" )
    private String sEPAMandate;
    /**
     * Use with available fluent helpers to apply the <b>SEPAMandate</b> field to query operations.
     *
     */
    public final static ServiceOrderItemField<String> SEPA_MANDATE = new ServiceOrderItemField<String>("SEPAMandate");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SrvcSEPAMandateRelevance</b>
     * </p>
     *
     * @return Indicator for SEPA-Relevant Transactions
     */
    @SerializedName( "SrvcSEPAMandateRelevance" )
    @JsonProperty( "SrvcSEPAMandateRelevance" )
    @Nullable
    @ODataField( odataName = "SrvcSEPAMandateRelevance" )
    private String srvcSEPAMandateRelevance;
    /**
     * Use with available fluent helpers to apply the <b>SrvcSEPAMandateRelevance</b> field to query operations.
     *
     */
    public final static ServiceOrderItemField<String> SRVC_SEPA_MANDATE_RELEVANCE =
        new ServiceOrderItemField<String>("SrvcSEPAMandateRelevance");
    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>WBSElementExternalID</b>
     * </p>
     *
     * @return Work Breakdown Structure Element (WBS Element) Edited
     */
    @SerializedName( "WBSElementExternalID" )
    @JsonProperty( "WBSElementExternalID" )
    @Nullable
    @ODataField( odataName = "WBSElementExternalID" )
    private String wBSElementExternalID;
    /**
     * Use with available fluent helpers to apply the <b>WBSElementExternalID</b> field to query operations.
     *
     */
    public final static ServiceOrderItemField<String> WBS_ELEMENT_EXTERNAL_ID =
        new ServiceOrderItemField<String>("WBSElementExternalID");
    /**
     * Navigation property <b>to_Appointment</b> for <b>ServiceOrderItem</b> to multiple <b>SrvcOrdItemAppointment</b>.
     *
     */
    @SerializedName( "to_Appointment" )
    @JsonProperty( "to_Appointment" )
    @ODataField( odataName = "to_Appointment" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SrvcOrdItemAppointment> toAppointment;
    /**
     * Navigation property <b>to_Confirmation</b> for <b>ServiceOrderItem</b> to multiple
     * <b>ServiceOrderItemConfirmation</b>.
     *
     */
    @SerializedName( "to_Confirmation" )
    @JsonProperty( "to_Confirmation" )
    @ODataField( odataName = "to_Confirmation" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ServiceOrderItemConfirmation> toConfirmation;
    /**
     * Navigation property <b>to_Duration</b> for <b>ServiceOrderItem</b> to multiple <b>SrvcOrdItemDuration</b>.
     *
     */
    @SerializedName( "to_Duration" )
    @JsonProperty( "to_Duration" )
    @ODataField( odataName = "to_Duration" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SrvcOrdItemDuration> toDuration;
    /**
     * Navigation property <b>to_Partner</b> for <b>ServiceOrderItem</b> to multiple <b>SrvcOrdItmPartner</b>.
     *
     */
    @SerializedName( "to_Partner" )
    @JsonProperty( "to_Partner" )
    @ODataField( odataName = "to_Partner" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SrvcOrdItmPartner> toPartner;
    /**
     * Navigation property <b>to_PricingElement</b> for <b>ServiceOrderItem</b> to multiple
     * <b>ServiceOrderItemPriceElement</b>.
     *
     */
    @SerializedName( "to_PricingElement" )
    @JsonProperty( "to_PricingElement" )
    @ODataField( odataName = "to_PricingElement" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ServiceOrderItemPriceElement> toPricingElement;
    /**
     * Navigation property <b>to_ProductReferenceObject</b> for <b>ServiceOrderItem</b> to multiple
     * <b>SrvcOrdItmProdRefObject</b>.
     *
     */
    @SerializedName( "to_ProductReferenceObject" )
    @JsonProperty( "to_ProductReferenceObject" )
    @ODataField( odataName = "to_ProductReferenceObject" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SrvcOrdItmProdRefObject> toProductReferenceObject;
    /**
     * Navigation property <b>to_ReferenceObject</b> for <b>ServiceOrderItem</b> to multiple
     * <b>ServiceOrderItemRefObject</b>.
     *
     */
    @SerializedName( "to_ReferenceObject" )
    @JsonProperty( "to_ReferenceObject" )
    @ODataField( odataName = "to_ReferenceObject" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ServiceOrderItemRefObject> toReferenceObject;
    /**
     * Navigation property <b>to_ServiceOrder</b> for <b>ServiceOrderItem</b> to single <b>ServiceOrder</b>.
     *
     */
    @SerializedName( "to_ServiceOrder" )
    @JsonProperty( "to_ServiceOrder" )
    @ODataField( odataName = "to_ServiceOrder" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private ServiceOrder toServiceOrder;
    /**
     * Navigation property <b>to_SrvcOrdItemUserStatus</b> for <b>ServiceOrderItem</b> to multiple
     * <b>ServiceOrdItemUserStatus</b>.
     *
     */
    @SerializedName( "to_SrvcOrdItemUserStatus" )
    @JsonProperty( "to_SrvcOrdItemUserStatus" )
    @ODataField( odataName = "to_SrvcOrdItemUserStatus" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ServiceOrdItemUserStatus> toSrvcOrdItemUserStatus;
    /**
     * Navigation property <b>to_Text</b> for <b>ServiceOrderItem</b> to multiple <b>ServiceOrderItemText</b>.
     *
     */
    @SerializedName( "to_Text" )
    @JsonProperty( "to_Text" )
    @ODataField( odataName = "to_Text" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ServiceOrderItemText> toText;
    /**
     * Use with available fluent helpers to apply the <b>to_Appointment</b> navigation property to query operations.
     *
     */
    public final static ServiceOrderItemLink<SrvcOrdItemAppointment> TO_APPOINTMENT =
        new ServiceOrderItemLink<SrvcOrdItemAppointment>("to_Appointment");
    /**
     * Use with available fluent helpers to apply the <b>to_Confirmation</b> navigation property to query operations.
     *
     */
    public final static ServiceOrderItemLink<ServiceOrderItemConfirmation> TO_CONFIRMATION =
        new ServiceOrderItemLink<ServiceOrderItemConfirmation>("to_Confirmation");
    /**
     * Use with available fluent helpers to apply the <b>to_Duration</b> navigation property to query operations.
     *
     */
    public final static ServiceOrderItemLink<SrvcOrdItemDuration> TO_DURATION =
        new ServiceOrderItemLink<SrvcOrdItemDuration>("to_Duration");
    /**
     * Use with available fluent helpers to apply the <b>to_Partner</b> navigation property to query operations.
     *
     */
    public final static ServiceOrderItemLink<SrvcOrdItmPartner> TO_PARTNER =
        new ServiceOrderItemLink<SrvcOrdItmPartner>("to_Partner");
    /**
     * Use with available fluent helpers to apply the <b>to_PricingElement</b> navigation property to query operations.
     *
     */
    public final static ServiceOrderItemLink<ServiceOrderItemPriceElement> TO_PRICING_ELEMENT =
        new ServiceOrderItemLink<ServiceOrderItemPriceElement>("to_PricingElement");
    /**
     * Use with available fluent helpers to apply the <b>to_ProductReferenceObject</b> navigation property to query
     * operations.
     *
     */
    public final static ServiceOrderItemLink<SrvcOrdItmProdRefObject> TO_PRODUCT_REFERENCE_OBJECT =
        new ServiceOrderItemLink<SrvcOrdItmProdRefObject>("to_ProductReferenceObject");
    /**
     * Use with available fluent helpers to apply the <b>to_ReferenceObject</b> navigation property to query operations.
     *
     */
    public final static ServiceOrderItemLink<ServiceOrderItemRefObject> TO_REFERENCE_OBJECT =
        new ServiceOrderItemLink<ServiceOrderItemRefObject>("to_ReferenceObject");
    /**
     * Use with available fluent helpers to apply the <b>to_ServiceOrder</b> navigation property to query operations.
     *
     */
    public final static ServiceOrderItemOneToOneLink<ServiceOrder> TO_SERVICE_ORDER =
        new ServiceOrderItemOneToOneLink<ServiceOrder>("to_ServiceOrder");
    /**
     * Use with available fluent helpers to apply the <b>to_SrvcOrdItemUserStatus</b> navigation property to query
     * operations.
     *
     */
    public final static ServiceOrderItemLink<ServiceOrdItemUserStatus> TO_SRVC_ORD_ITEM_USER_STATUS =
        new ServiceOrderItemLink<ServiceOrdItemUserStatus>("to_SrvcOrdItemUserStatus");
    /**
     * Use with available fluent helpers to apply the <b>to_Text</b> navigation property to query operations.
     *
     */
    public final static ServiceOrderItemLink<ServiceOrderItemText> TO_TEXT =
        new ServiceOrderItemLink<ServiceOrderItemText>("to_Text");

    @Nonnull
    @Override
    public Class<ServiceOrderItem> getType()
    {
        return ServiceOrderItem.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServiceOrder</b>
     * </p>
     *
     * @param serviceOrder
     *            Transaction ID
     */
    public void setServiceOrder( @Nullable final String serviceOrder )
    {
        rememberChangedField("ServiceOrder", this.serviceOrder);
        this.serviceOrder = serviceOrder;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ServiceOrderItem</b>
     * </p>
     *
     * @param serviceOrderItem
     *            Shortened Item Number in Document
     */
    public void setServiceOrderItem( @Nullable final String serviceOrderItem )
    {
        rememberChangedField("ServiceOrderItem", this.serviceOrderItem);
        this.serviceOrderItem = serviceOrderItem;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ServiceOrderItemUUID</b>
     * </p>
     *
     * @param serviceOrderItemUUID
     *            GUID of a CRM Order Object
     */
    public void setServiceOrderItemUUID( @Nullable final UUID serviceOrderItemUUID )
    {
        rememberChangedField("ServiceOrderItemUUID", this.serviceOrderItemUUID);
        this.serviceOrderItemUUID = serviceOrderItemUUID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocumentItemCharUUID</b>
     * </p>
     *
     * @param serviceDocumentItemCharUUID
     *            32 Character CRM Object GUID (Converted)
     */
    public void setServiceDocumentItemCharUUID( @Nullable final UUID serviceDocumentItemCharUUID )
    {
        rememberChangedField("ServiceDocumentItemCharUUID", this.serviceDocumentItemCharUUID);
        this.serviceDocumentItemCharUUID = serviceDocumentItemCharUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ServiceOrderItemDescription</b>
     * </p>
     *
     * @param serviceOrderItemDescription
     *            Product Description
     */
    public void setServiceOrderItemDescription( @Nullable final String serviceOrderItemDescription )
    {
        rememberChangedField("ServiceOrderItemDescription", this.serviceOrderItemDescription);
        this.serviceOrderItemDescription = serviceOrderItemDescription;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServiceObjectType</b>
     * </p>
     *
     * @param serviceObjectType
     *            Business Trans. Cat.
     */
    public void setServiceObjectType( @Nullable final String serviceObjectType )
    {
        rememberChangedField("ServiceObjectType", this.serviceObjectType);
        this.serviceObjectType = serviceObjectType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocumentItemObjectType</b>
     * </p>
     *
     * @param serviceDocumentItemObjectType
     *            CRM Item Object Type
     */
    public void setServiceDocumentItemObjectType( @Nullable final String serviceDocumentItemObjectType )
    {
        rememberChangedField("ServiceDocumentItemObjectType", this.serviceDocumentItemObjectType);
        this.serviceDocumentItemObjectType = serviceDocumentItemObjectType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Short Text Language for an Item
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * Constraints: Not nullable, Maximum length: 54
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     *
     * @param product
     *            Product Name Entered
     */
    public void setProduct( @Nullable final String product )
    {
        rememberChangedField("Product", this.product);
        this.product = product;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>Quantity</b>
     * </p>
     *
     * @param quantity
     *            CRM: Order Quantity
     */
    public void setQuantity( @Nullable final BigDecimal quantity )
    {
        rememberChangedField("Quantity", this.quantity);
        this.quantity = quantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>QuantityUnit</b>
     * </p>
     *
     * @param quantityUnit
     *            Unit of Measure in Which the Product Is Sold
     */
    public void setQuantityUnit( @Nullable final String quantityUnit )
    {
        rememberChangedField("QuantityUnit", this.quantityUnit);
        this.quantityUnit = quantityUnit;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SrvcOrdItmResvnIsExisting</b>
     * </p>
     *
     * @param srvcOrdItmResvnIsExisting
     *            The srvcOrdItmResvnIsExisting to set.
     */
    public void setSrvcOrdItmResvnIsExisting( @Nullable final Boolean srvcOrdItmResvnIsExisting )
    {
        rememberChangedField("SrvcOrdItmResvnIsExisting", this.srvcOrdItmResvnIsExisting);
        this.srvcOrdItmResvnIsExisting = srvcOrdItmResvnIsExisting;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>SrvcOrdItemReservedQuantity</b>
     * </p>
     *
     * @param srvcOrdItemReservedQuantity
     *            CRM: Confirmed Quantity
     */
    public void setSrvcOrdItemReservedQuantity( @Nullable final BigDecimal srvcOrdItemReservedQuantity )
    {
        rememberChangedField("SrvcOrdItemReservedQuantity", this.srvcOrdItemReservedQuantity);
        this.srvcOrdItemReservedQuantity = srvcOrdItemReservedQuantity;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDuration</b>
     * </p>
     *
     * @param serviceDuration
     *            Duration
     */
    public void setServiceDuration( @Nullable final BigDecimal serviceDuration )
    {
        rememberChangedField("ServiceDuration", this.serviceDuration);
        this.serviceDuration = serviceDuration;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDurationUnit</b>
     * </p>
     *
     * @param serviceDurationUnit
     *            Unit for Duration of Work
     */
    public void setServiceDurationUnit( @Nullable final String serviceDurationUnit )
    {
        rememberChangedField("ServiceDurationUnit", this.serviceDurationUnit);
        this.serviceDurationUnit = serviceDurationUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ServiceOrderItemCategory</b>
     * </p>
     *
     * @param serviceOrderItemCategory
     *            Item Category
     */
    public void setServiceOrderItemCategory( @Nullable final String serviceOrderItemCategory )
    {
        rememberChangedField("ServiceOrderItemCategory", this.serviceOrderItemCategory);
        this.serviceOrderItemCategory = serviceOrderItemCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ServiceOrdItemRejectionReason</b>
     * </p>
     *
     * @param serviceOrdItemRejectionReason
     *            Cancellation Reason Code
     */
    public void setServiceOrdItemRejectionReason( @Nullable final String serviceOrdItemRejectionReason )
    {
        rememberChangedField("ServiceOrdItemRejectionReason", this.serviceOrdItemRejectionReason);
        this.serviceOrdItemRejectionReason = serviceOrdItemRejectionReason;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BillableControl</b>
     * </p>
     *
     * @param billableControl
     *            Accounting Indicator
     */
    public void setBillableControl( @Nullable final String billableControl )
    {
        rememberChangedField("BillableControl", this.billableControl);
        this.billableControl = billableControl;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SoldToParty</b>
     * </p>
     *
     * @param soldToParty
     *            Sold-To Party
     */
    public void setSoldToParty( @Nullable final String soldToParty )
    {
        rememberChangedField("SoldToParty", this.soldToParty);
        this.soldToParty = soldToParty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ShipToParty</b>
     * </p>
     *
     * @param shipToParty
     *            Ship-To Party
     */
    public void setShipToParty( @Nullable final String shipToParty )
    {
        rememberChangedField("ShipToParty", this.shipToParty);
        this.shipToParty = shipToParty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BillToParty</b>
     * </p>
     *
     * @param billToParty
     *            Bill-To Party
     */
    public void setBillToParty( @Nullable final String billToParty )
    {
        rememberChangedField("BillToParty", this.billToParty);
        this.billToParty = billToParty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PayerParty</b>
     * </p>
     *
     * @param payerParty
     *            Payer
     */
    public void setPayerParty( @Nullable final String payerParty )
    {
        rememberChangedField("PayerParty", this.payerParty);
        this.payerParty = payerParty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ContactPersonBusinessPartnerId</b>
     * </p>
     *
     * @param contactPersonBusinessPartnerId
     *            Customer Contact Person
     */
    public void setContactPersonBusinessPartnerId( @Nullable final String contactPersonBusinessPartnerId )
    {
        rememberChangedField("ContactPersonBusinessPartnerId", this.contactPersonBusinessPartnerId);
        this.contactPersonBusinessPartnerId = contactPersonBusinessPartnerId;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PersonResponsible</b>
     * </p>
     *
     * @param personResponsible
     *            Employee Responsible
     */
    public void setPersonResponsible( @Nullable final String personResponsible )
    {
        rememberChangedField("PersonResponsible", this.personResponsible);
        this.personResponsible = personResponsible;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ExecutingServiceEmployee</b>
     * </p>
     *
     * @param executingServiceEmployee
     *            Executing Service Employee
     */
    public void setExecutingServiceEmployee( @Nullable final String executingServiceEmployee )
    {
        rememberChangedField("ExecutingServiceEmployee", this.executingServiceEmployee);
        this.executingServiceEmployee = executingServiceEmployee;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServicePerformer</b>
     * </p>
     *
     * @param servicePerformer
     *            Business Partner Number
     */
    public void setServicePerformer( @Nullable final String servicePerformer )
    {
        rememberChangedField("ServicePerformer", this.servicePerformer);
        this.servicePerformer = servicePerformer;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ServiceOrderItemIsReleased</b>
     * </p>
     *
     * @param serviceOrderItemIsReleased
     *            Release Status
     */
    public void setServiceOrderItemIsReleased( @Nullable final String serviceOrderItemIsReleased )
    {
        rememberChangedField("ServiceOrderItemIsReleased", this.serviceOrderItemIsReleased);
        this.serviceOrderItemIsReleased = serviceOrderItemIsReleased;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ServiceOrderItemIsCompleted</b>
     * </p>
     *
     * @param serviceOrderItemIsCompleted
     *            The serviceOrderItemIsCompleted to set.
     */
    public void setServiceOrderItemIsCompleted( @Nullable final String serviceOrderItemIsCompleted )
    {
        rememberChangedField("ServiceOrderItemIsCompleted", this.serviceOrderItemIsCompleted);
        this.serviceOrderItemIsCompleted = serviceOrderItemIsCompleted;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ServiceOrderItemIsRejected</b>
     * </p>
     *
     * @param serviceOrderItemIsRejected
     *            Cancellation Status
     */
    public void setServiceOrderItemIsRejected( @Nullable final String serviceOrderItemIsRejected )
    {
        rememberChangedField("ServiceOrderItemIsRejected", this.serviceOrderItemIsRejected);
        this.serviceOrderItemIsRejected = serviceOrderItemIsRejected;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceServiceContract</b>
     * </p>
     *
     * @param referenceServiceContract
     *            Transaction ID
     */
    public void setReferenceServiceContract( @Nullable final String referenceServiceContract )
    {
        rememberChangedField("ReferenceServiceContract", this.referenceServiceContract);
        this.referenceServiceContract = referenceServiceContract;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceServiceContractItem</b>
     * </p>
     *
     * @param referenceServiceContractItem
     *            Shortened Item Number in Document
     */
    public void setReferenceServiceContractItem( @Nullable final String referenceServiceContractItem )
    {
        rememberChangedField("ReferenceServiceContractItem", this.referenceServiceContractItem);
        this.referenceServiceContractItem = referenceServiceContractItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RefServiceOrderTemplate</b>
     * </p>
     *
     * @param refServiceOrderTemplate
     *            Transaction ID
     */
    public void setRefServiceOrderTemplate( @Nullable final String refServiceOrderTemplate )
    {
        rememberChangedField("RefServiceOrderTemplate", this.refServiceOrderTemplate);
        this.refServiceOrderTemplate = refServiceOrderTemplate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>RefServiceOrderTemplateItem</b>
     * </p>
     *
     * @param refServiceOrderTemplateItem
     *            Shortened Item Number in Document
     */
    public void setRefServiceOrderTemplateItem( @Nullable final String refServiceOrderTemplateItem )
    {
        rememberChangedField("RefServiceOrderTemplateItem", this.refServiceOrderTemplateItem);
        this.refServiceOrderTemplateItem = refServiceOrderTemplateItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceServiceRequest</b>
     * </p>
     *
     * @param referenceServiceRequest
     *            Transaction ID
     */
    public void setReferenceServiceRequest( @Nullable final String referenceServiceRequest )
    {
        rememberChangedField("ReferenceServiceRequest", this.referenceServiceRequest);
        this.referenceServiceRequest = referenceServiceRequest;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceServiceRequestItem</b>
     * </p>
     *
     * @param referenceServiceRequestItem
     *            Shortened Item Number in Document
     */
    public void setReferenceServiceRequestItem( @Nullable final String referenceServiceRequestItem )
    {
        rememberChangedField("ReferenceServiceRequestItem", this.referenceServiceRequestItem);
        this.referenceServiceRequestItem = referenceServiceRequestItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ParentServiceOrderItem</b>
     * </p>
     *
     * @param parentServiceOrderItem
     *            Shortened Item Number in Document
     */
    public void setParentServiceOrderItem( @Nullable final String parentServiceOrderItem )
    {
        rememberChangedField("ParentServiceOrderItem", this.parentServiceOrderItem);
        this.parentServiceOrderItem = parentServiceOrderItem;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PlannedServiceStartDateTime</b>
     * </p>
     *
     * @param plannedServiceStartDateTime
     *            Service Planned From Date
     */
    public void setPlannedServiceStartDateTime( @Nullable final ZonedDateTime plannedServiceStartDateTime )
    {
        rememberChangedField("PlannedServiceStartDateTime", this.plannedServiceStartDateTime);
        this.plannedServiceStartDateTime = plannedServiceStartDateTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PlannedServiceEndDateTime</b>
     * </p>
     *
     * @param plannedServiceEndDateTime
     *            Service Planned To Date
     */
    public void setPlannedServiceEndDateTime( @Nullable final ZonedDateTime plannedServiceEndDateTime )
    {
        rememberChangedField("PlannedServiceEndDateTime", this.plannedServiceEndDateTime);
        this.plannedServiceEndDateTime = plannedServiceEndDateTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>RequestedServiceStartDateTime</b>
     * </p>
     *
     * @param requestedServiceStartDateTime
     *            Service Request Start Date
     */
    public void setRequestedServiceStartDateTime( @Nullable final ZonedDateTime requestedServiceStartDateTime )
    {
        rememberChangedField("RequestedServiceStartDateTime", this.requestedServiceStartDateTime);
        this.requestedServiceStartDateTime = requestedServiceStartDateTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>RequestedServiceEndDateTime</b>
     * </p>
     *
     * @param requestedServiceEndDateTime
     *            Service Request Due Date
     */
    public void setRequestedServiceEndDateTime( @Nullable final ZonedDateTime requestedServiceEndDateTime )
    {
        rememberChangedField("RequestedServiceEndDateTime", this.requestedServiceEndDateTime);
        this.requestedServiceEndDateTime = requestedServiceEndDateTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>SrvcDocItemSLADueByDateTime</b>
     * </p>
     *
     * @param srvcDocItemSLADueByDateTime
     *            Due By
     */
    public void setSrvcDocItemSLADueByDateTime( @Nullable final ZonedDateTime srvcDocItemSLADueByDateTime )
    {
        rememberChangedField("SrvcDocItemSLADueByDateTime", this.srvcDocItemSLADueByDateTime);
        this.srvcDocItemSLADueByDateTime = srvcDocItemSLADueByDateTime;
    }

    /**
     * Constraints: Not nullable, Precision: 7, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>ActualServiceDuration</b>
     * </p>
     *
     * @param actualServiceDuration
     *            Confirmed Duration
     */
    public void setActualServiceDuration( @Nullable final BigDecimal actualServiceDuration )
    {
        rememberChangedField("ActualServiceDuration", this.actualServiceDuration);
        this.actualServiceDuration = actualServiceDuration;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ActualServiceDurationUnit</b>
     * </p>
     *
     * @param actualServiceDurationUnit
     *            Time Unit for Confirmed Duration
     */
    public void setActualServiceDurationUnit( @Nullable final String actualServiceDurationUnit )
    {
        rememberChangedField("ActualServiceDurationUnit", this.actualServiceDurationUnit);
        this.actualServiceDurationUnit = actualServiceDurationUnit;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SrvcContrDetnIsSpprsd</b>
     * </p>
     *
     * @param srvcContrDetnIsSpprsd
     *            Status Is Active
     */
    public void setSrvcContrDetnIsSpprsd( @Nullable final Boolean srvcContrDetnIsSpprsd )
    {
        rememberChangedField("SrvcContrDetnIsSpprsd", this.srvcContrDetnIsSpprsd);
        this.srvcContrDetnIsSpprsd = srvcContrDetnIsSpprsd;
    }

    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceServiceOrderItem</b>
     * </p>
     *
     * @param referenceServiceOrderItem
     *            External Reference Number
     */
    public void setReferenceServiceOrderItem( @Nullable final String referenceServiceOrderItem )
    {
        rememberChangedField("ReferenceServiceOrderItem", this.referenceServiceOrderItem);
        this.referenceServiceOrderItem = referenceServiceOrderItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ShippingCondition</b>
     * </p>
     *
     * @param shippingCondition
     *            Shipping Conditions
     */
    public void setShippingCondition( @Nullable final String shippingCondition )
    {
        rememberChangedField("ShippingCondition", this.shippingCondition);
        this.shippingCondition = shippingCondition;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SrvcDocItmPartReferenceItem</b>
     * </p>
     *
     * @param srvcDocItmPartReferenceItem
     *            Shortened Item Number in Document
     */
    public void setSrvcDocItmPartReferenceItem( @Nullable final String srvcDocItmPartReferenceItem )
    {
        rememberChangedField("SrvcDocItmPartReferenceItem", this.srvcDocItmPartReferenceItem);
        this.srvcDocItmPartReferenceItem = srvcDocItmPartReferenceItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SrvcDocItmApptReferenceItem</b>
     * </p>
     *
     * @param srvcDocItmApptReferenceItem
     *            Shortened Item Number in Document
     */
    public void setSrvcDocItmApptReferenceItem( @Nullable final String srvcDocItmApptReferenceItem )
    {
        rememberChangedField("SrvcDocItmApptReferenceItem", this.srvcDocItmApptReferenceItem);
        this.srvcDocItmApptReferenceItem = srvcDocItmApptReferenceItem;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SrvcDocItmApptRefObjectUUID</b>
     * </p>
     *
     * @param srvcDocItmApptRefObjectUUID
     *            GUID of a CRM Order Object
     */
    public void setSrvcDocItmApptRefObjectUUID( @Nullable final UUID srvcDocItmApptRefObjectUUID )
    {
        rememberChangedField("SrvcDocItmApptRefObjectUUID", this.srvcDocItmApptRefObjectUUID);
        this.srvcDocItmApptRefObjectUUID = srvcDocItmApptRefObjectUUID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SrvcOrdItemIsUnplanned</b>
     * </p>
     *
     * @param srvcOrdItemIsUnplanned
     *            Unplanned Item
     */
    public void setSrvcOrdItemIsUnplanned( @Nullable final Boolean srvcOrdItemIsUnplanned )
    {
        rememberChangedField("SrvcOrdItemIsUnplanned", this.srvcOrdItemIsUnplanned);
        this.srvcOrdItemIsUnplanned = srvcOrdItemIsUnplanned;
    }

    /**
     * Constraints: Not nullable, Maximum length: 32
     * <p>
     * Original property name from the Odata EDM: <b>FSMServiceActivity</b>
     * </p>
     *
     * @param fSMServiceActivity
     *            Identification of a Reference Object for Items
     */
    public void setFSMServiceActivity( @Nullable final String fSMServiceActivity )
    {
        rememberChangedField("FSMServiceActivity", this.fSMServiceActivity);
        this.fSMServiceActivity = fSMServiceActivity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>TimeSheetOvertimeCategory</b>
     * </p>
     *
     * @param timeSheetOvertimeCategory
     *            Overtime Category
     */
    public void setTimeSheetOvertimeCategory( @Nullable final String timeSheetOvertimeCategory )
    {
        rememberChangedField("TimeSheetOvertimeCategory", this.timeSheetOvertimeCategory);
        this.timeSheetOvertimeCategory = timeSheetOvertimeCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>RespyMgmtServiceTeam</b>
     * </p>
     *
     * @param respyMgmtServiceTeam
     *            Service Team (Responsibility Management)
     */
    public void setRespyMgmtServiceTeam( @Nullable final String respyMgmtServiceTeam )
    {
        rememberChangedField("RespyMgmtServiceTeam", this.respyMgmtServiceTeam);
        this.respyMgmtServiceTeam = respyMgmtServiceTeam;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>RespyMgmtServiceTeamName</b>
     * </p>
     *
     * @param respyMgmtServiceTeamName
     *            Name
     */
    public void setRespyMgmtServiceTeamName( @Nullable final String respyMgmtServiceTeamName )
    {
        rememberChangedField("RespyMgmtServiceTeamName", this.respyMgmtServiceTeamName);
        this.respyMgmtServiceTeamName = respyMgmtServiceTeamName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>RespyMgmtGlobalTeamID</b>
     * </p>
     *
     * @param respyMgmtGlobalTeamID
     *            Global Team ID in Responsibility Mgmt.
     */
    public void setRespyMgmtGlobalTeamID( @Nullable final String respyMgmtGlobalTeamID )
    {
        rememberChangedField("RespyMgmtGlobalTeamID", this.respyMgmtGlobalTeamID);
        this.respyMgmtGlobalTeamID = respyMgmtGlobalTeamID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenter</b>
     * </p>
     *
     * @param profitCenter
     *            Profit Center
     */
    public void setProfitCenter( @Nullable final String profitCenter )
    {
        rememberChangedField("ProfitCenter", this.profitCenter);
        this.profitCenter = profitCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SrvcOrdItemCreditStatus</b>
     * </p>
     *
     * @param srvcOrdItemCreditStatus
     *            Credit Status of Item
     */
    public void setSrvcOrdItemCreditStatus( @Nullable final String srvcOrdItemCreditStatus )
    {
        rememberChangedField("SrvcOrdItemCreditStatus", this.srvcOrdItemCreditStatus);
        this.srvcOrdItemCreditStatus = srvcOrdItemCreditStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SrvcOrdItemExecutionStatus</b>
     * </p>
     *
     * @param srvcOrdItemExecutionStatus
     *            Execution Status
     */
    public void setSrvcOrdItemExecutionStatus( @Nullable final String srvcOrdItemExecutionStatus )
    {
        rememberChangedField("SrvcOrdItemExecutionStatus", this.srvcOrdItemExecutionStatus);
        this.srvcOrdItemExecutionStatus = srvcOrdItemExecutionStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PaymentTerms</b>
     * </p>
     *
     * @param paymentTerms
     *            Terms of Payment
     */
    public void setPaymentTerms( @Nullable final String paymentTerms )
    {
        rememberChangedField("PaymentTerms", this.paymentTerms);
        this.paymentTerms = paymentTerms;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PaymentMethod</b>
     * </p>
     *
     * @param paymentMethod
     *            Payment Method
     */
    public void setPaymentMethod( @Nullable final String paymentMethod )
    {
        rememberChangedField("PaymentMethod", this.paymentMethod);
        this.paymentMethod = paymentMethod;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>SEPAMandate</b>
     * </p>
     *
     * @param sEPAMandate
     *            Unique Reference to Mandate per Payment Recipient
     */
    public void setSEPAMandate( @Nullable final String sEPAMandate )
    {
        rememberChangedField("SEPAMandate", this.sEPAMandate);
        this.sEPAMandate = sEPAMandate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SrvcSEPAMandateRelevance</b>
     * </p>
     *
     * @param srvcSEPAMandateRelevance
     *            Indicator for SEPA-Relevant Transactions
     */
    public void setSrvcSEPAMandateRelevance( @Nullable final String srvcSEPAMandateRelevance )
    {
        rememberChangedField("SrvcSEPAMandateRelevance", this.srvcSEPAMandateRelevance);
        this.srvcSEPAMandateRelevance = srvcSEPAMandateRelevance;
    }

    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>WBSElementExternalID</b>
     * </p>
     *
     * @param wBSElementExternalID
     *            Work Breakdown Structure Element (WBS Element) Edited
     */
    public void setWBSElementExternalID( @Nullable final String wBSElementExternalID )
    {
        rememberChangedField("WBSElementExternalID", this.wBSElementExternalID);
        this.wBSElementExternalID = wBSElementExternalID;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_ServiceOrderItem";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ServiceOrder", getServiceOrder());
        result.put("ServiceOrderItem", getServiceOrderItem());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ServiceOrder", getServiceOrder());
        values.put("ServiceOrderItem", getServiceOrderItem());
        values.put("ServiceOrderItemUUID", getServiceOrderItemUUID());
        values.put("ServiceDocumentItemCharUUID", getServiceDocumentItemCharUUID());
        values.put("ServiceOrderItemDescription", getServiceOrderItemDescription());
        values.put("ServiceObjectType", getServiceObjectType());
        values.put("ServiceDocumentItemObjectType", getServiceDocumentItemObjectType());
        values.put("Language", getLanguage());
        values.put("Product", getProduct());
        values.put("Quantity", getQuantity());
        values.put("QuantityUnit", getQuantityUnit());
        values.put("SrvcOrdItmResvnIsExisting", getSrvcOrdItmResvnIsExisting());
        values.put("SrvcOrdItemReservedQuantity", getSrvcOrdItemReservedQuantity());
        values.put("ServiceDuration", getServiceDuration());
        values.put("ServiceDurationUnit", getServiceDurationUnit());
        values.put("ServiceOrderItemCategory", getServiceOrderItemCategory());
        values.put("ServiceOrdItemRejectionReason", getServiceOrdItemRejectionReason());
        values.put("BillableControl", getBillableControl());
        values.put("SoldToParty", getSoldToParty());
        values.put("ShipToParty", getShipToParty());
        values.put("BillToParty", getBillToParty());
        values.put("PayerParty", getPayerParty());
        values.put("ContactPersonBusinessPartnerId", getContactPersonBusinessPartnerId());
        values.put("PersonResponsible", getPersonResponsible());
        values.put("ExecutingServiceEmployee", getExecutingServiceEmployee());
        values.put("ServicePerformer", getServicePerformer());
        values.put("ServiceOrderItemIsReleased", getServiceOrderItemIsReleased());
        values.put("ServiceOrderItemIsCompleted", getServiceOrderItemIsCompleted());
        values.put("ServiceOrderItemIsRejected", getServiceOrderItemIsRejected());
        values.put("ReferenceServiceContract", getReferenceServiceContract());
        values.put("ReferenceServiceContractItem", getReferenceServiceContractItem());
        values.put("RefServiceOrderTemplate", getRefServiceOrderTemplate());
        values.put("RefServiceOrderTemplateItem", getRefServiceOrderTemplateItem());
        values.put("ReferenceServiceRequest", getReferenceServiceRequest());
        values.put("ReferenceServiceRequestItem", getReferenceServiceRequestItem());
        values.put("ParentServiceOrderItem", getParentServiceOrderItem());
        values.put("PlannedServiceStartDateTime", getPlannedServiceStartDateTime());
        values.put("PlannedServiceEndDateTime", getPlannedServiceEndDateTime());
        values.put("RequestedServiceStartDateTime", getRequestedServiceStartDateTime());
        values.put("RequestedServiceEndDateTime", getRequestedServiceEndDateTime());
        values.put("SrvcDocItemSLADueByDateTime", getSrvcDocItemSLADueByDateTime());
        values.put("ActualServiceDuration", getActualServiceDuration());
        values.put("ActualServiceDurationUnit", getActualServiceDurationUnit());
        values.put("SrvcContrDetnIsSpprsd", getSrvcContrDetnIsSpprsd());
        values.put("ReferenceServiceOrderItem", getReferenceServiceOrderItem());
        values.put("ShippingCondition", getShippingCondition());
        values.put("SrvcDocItmPartReferenceItem", getSrvcDocItmPartReferenceItem());
        values.put("SrvcDocItmApptReferenceItem", getSrvcDocItmApptReferenceItem());
        values.put("SrvcDocItmApptRefObjectUUID", getSrvcDocItmApptRefObjectUUID());
        values.put("SrvcOrdItemIsUnplanned", getSrvcOrdItemIsUnplanned());
        values.put("FSMServiceActivity", getFSMServiceActivity());
        values.put("TimeSheetOvertimeCategory", getTimeSheetOvertimeCategory());
        values.put("RespyMgmtServiceTeam", getRespyMgmtServiceTeam());
        values.put("RespyMgmtServiceTeamName", getRespyMgmtServiceTeamName());
        values.put("RespyMgmtGlobalTeamID", getRespyMgmtGlobalTeamID());
        values.put("ProfitCenter", getProfitCenter());
        values.put("SrvcOrdItemCreditStatus", getSrvcOrdItemCreditStatus());
        values.put("SrvcOrdItemExecutionStatus", getSrvcOrdItemExecutionStatus());
        values.put("PaymentTerms", getPaymentTerms());
        values.put("PaymentMethod", getPaymentMethod());
        values.put("SEPAMandate", getSEPAMandate());
        values.put("SrvcSEPAMandateRelevance", getSrvcSEPAMandateRelevance());
        values.put("WBSElementExternalID", getWBSElementExternalID());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ServiceOrder") ) {
                final Object value = values.remove("ServiceOrder");
                if( (value == null) || (!value.equals(getServiceOrder())) ) {
                    setServiceOrder(((String) value));
                }
            }
            if( values.containsKey("ServiceOrderItem") ) {
                final Object value = values.remove("ServiceOrderItem");
                if( (value == null) || (!value.equals(getServiceOrderItem())) ) {
                    setServiceOrderItem(((String) value));
                }
            }
            if( values.containsKey("ServiceOrderItemUUID") ) {
                final Object value = values.remove("ServiceOrderItemUUID");
                if( (value == null) || (!value.equals(getServiceOrderItemUUID())) ) {
                    setServiceOrderItemUUID(((UUID) value));
                }
            }
            if( values.containsKey("ServiceDocumentItemCharUUID") ) {
                final Object value = values.remove("ServiceDocumentItemCharUUID");
                if( (value == null) || (!value.equals(getServiceDocumentItemCharUUID())) ) {
                    setServiceDocumentItemCharUUID(((UUID) value));
                }
            }
            if( values.containsKey("ServiceOrderItemDescription") ) {
                final Object value = values.remove("ServiceOrderItemDescription");
                if( (value == null) || (!value.equals(getServiceOrderItemDescription())) ) {
                    setServiceOrderItemDescription(((String) value));
                }
            }
            if( values.containsKey("ServiceObjectType") ) {
                final Object value = values.remove("ServiceObjectType");
                if( (value == null) || (!value.equals(getServiceObjectType())) ) {
                    setServiceObjectType(((String) value));
                }
            }
            if( values.containsKey("ServiceDocumentItemObjectType") ) {
                final Object value = values.remove("ServiceDocumentItemObjectType");
                if( (value == null) || (!value.equals(getServiceDocumentItemObjectType())) ) {
                    setServiceDocumentItemObjectType(((String) value));
                }
            }
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("Product") ) {
                final Object value = values.remove("Product");
                if( (value == null) || (!value.equals(getProduct())) ) {
                    setProduct(((String) value));
                }
            }
            if( values.containsKey("Quantity") ) {
                final Object value = values.remove("Quantity");
                if( (value == null) || (!value.equals(getQuantity())) ) {
                    setQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("QuantityUnit") ) {
                final Object value = values.remove("QuantityUnit");
                if( (value == null) || (!value.equals(getQuantityUnit())) ) {
                    setQuantityUnit(((String) value));
                }
            }
            if( values.containsKey("SrvcOrdItmResvnIsExisting") ) {
                final Object value = values.remove("SrvcOrdItmResvnIsExisting");
                if( (value == null) || (!value.equals(getSrvcOrdItmResvnIsExisting())) ) {
                    setSrvcOrdItmResvnIsExisting(((Boolean) value));
                }
            }
            if( values.containsKey("SrvcOrdItemReservedQuantity") ) {
                final Object value = values.remove("SrvcOrdItemReservedQuantity");
                if( (value == null) || (!value.equals(getSrvcOrdItemReservedQuantity())) ) {
                    setSrvcOrdItemReservedQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("ServiceDuration") ) {
                final Object value = values.remove("ServiceDuration");
                if( (value == null) || (!value.equals(getServiceDuration())) ) {
                    setServiceDuration(((BigDecimal) value));
                }
            }
            if( values.containsKey("ServiceDurationUnit") ) {
                final Object value = values.remove("ServiceDurationUnit");
                if( (value == null) || (!value.equals(getServiceDurationUnit())) ) {
                    setServiceDurationUnit(((String) value));
                }
            }
            if( values.containsKey("ServiceOrderItemCategory") ) {
                final Object value = values.remove("ServiceOrderItemCategory");
                if( (value == null) || (!value.equals(getServiceOrderItemCategory())) ) {
                    setServiceOrderItemCategory(((String) value));
                }
            }
            if( values.containsKey("ServiceOrdItemRejectionReason") ) {
                final Object value = values.remove("ServiceOrdItemRejectionReason");
                if( (value == null) || (!value.equals(getServiceOrdItemRejectionReason())) ) {
                    setServiceOrdItemRejectionReason(((String) value));
                }
            }
            if( values.containsKey("BillableControl") ) {
                final Object value = values.remove("BillableControl");
                if( (value == null) || (!value.equals(getBillableControl())) ) {
                    setBillableControl(((String) value));
                }
            }
            if( values.containsKey("SoldToParty") ) {
                final Object value = values.remove("SoldToParty");
                if( (value == null) || (!value.equals(getSoldToParty())) ) {
                    setSoldToParty(((String) value));
                }
            }
            if( values.containsKey("ShipToParty") ) {
                final Object value = values.remove("ShipToParty");
                if( (value == null) || (!value.equals(getShipToParty())) ) {
                    setShipToParty(((String) value));
                }
            }
            if( values.containsKey("BillToParty") ) {
                final Object value = values.remove("BillToParty");
                if( (value == null) || (!value.equals(getBillToParty())) ) {
                    setBillToParty(((String) value));
                }
            }
            if( values.containsKey("PayerParty") ) {
                final Object value = values.remove("PayerParty");
                if( (value == null) || (!value.equals(getPayerParty())) ) {
                    setPayerParty(((String) value));
                }
            }
            if( values.containsKey("ContactPersonBusinessPartnerId") ) {
                final Object value = values.remove("ContactPersonBusinessPartnerId");
                if( (value == null) || (!value.equals(getContactPersonBusinessPartnerId())) ) {
                    setContactPersonBusinessPartnerId(((String) value));
                }
            }
            if( values.containsKey("PersonResponsible") ) {
                final Object value = values.remove("PersonResponsible");
                if( (value == null) || (!value.equals(getPersonResponsible())) ) {
                    setPersonResponsible(((String) value));
                }
            }
            if( values.containsKey("ExecutingServiceEmployee") ) {
                final Object value = values.remove("ExecutingServiceEmployee");
                if( (value == null) || (!value.equals(getExecutingServiceEmployee())) ) {
                    setExecutingServiceEmployee(((String) value));
                }
            }
            if( values.containsKey("ServicePerformer") ) {
                final Object value = values.remove("ServicePerformer");
                if( (value == null) || (!value.equals(getServicePerformer())) ) {
                    setServicePerformer(((String) value));
                }
            }
            if( values.containsKey("ServiceOrderItemIsReleased") ) {
                final Object value = values.remove("ServiceOrderItemIsReleased");
                if( (value == null) || (!value.equals(getServiceOrderItemIsReleased())) ) {
                    setServiceOrderItemIsReleased(((String) value));
                }
            }
            if( values.containsKey("ServiceOrderItemIsCompleted") ) {
                final Object value = values.remove("ServiceOrderItemIsCompleted");
                if( (value == null) || (!value.equals(getServiceOrderItemIsCompleted())) ) {
                    setServiceOrderItemIsCompleted(((String) value));
                }
            }
            if( values.containsKey("ServiceOrderItemIsRejected") ) {
                final Object value = values.remove("ServiceOrderItemIsRejected");
                if( (value == null) || (!value.equals(getServiceOrderItemIsRejected())) ) {
                    setServiceOrderItemIsRejected(((String) value));
                }
            }
            if( values.containsKey("ReferenceServiceContract") ) {
                final Object value = values.remove("ReferenceServiceContract");
                if( (value == null) || (!value.equals(getReferenceServiceContract())) ) {
                    setReferenceServiceContract(((String) value));
                }
            }
            if( values.containsKey("ReferenceServiceContractItem") ) {
                final Object value = values.remove("ReferenceServiceContractItem");
                if( (value == null) || (!value.equals(getReferenceServiceContractItem())) ) {
                    setReferenceServiceContractItem(((String) value));
                }
            }
            if( values.containsKey("RefServiceOrderTemplate") ) {
                final Object value = values.remove("RefServiceOrderTemplate");
                if( (value == null) || (!value.equals(getRefServiceOrderTemplate())) ) {
                    setRefServiceOrderTemplate(((String) value));
                }
            }
            if( values.containsKey("RefServiceOrderTemplateItem") ) {
                final Object value = values.remove("RefServiceOrderTemplateItem");
                if( (value == null) || (!value.equals(getRefServiceOrderTemplateItem())) ) {
                    setRefServiceOrderTemplateItem(((String) value));
                }
            }
            if( values.containsKey("ReferenceServiceRequest") ) {
                final Object value = values.remove("ReferenceServiceRequest");
                if( (value == null) || (!value.equals(getReferenceServiceRequest())) ) {
                    setReferenceServiceRequest(((String) value));
                }
            }
            if( values.containsKey("ReferenceServiceRequestItem") ) {
                final Object value = values.remove("ReferenceServiceRequestItem");
                if( (value == null) || (!value.equals(getReferenceServiceRequestItem())) ) {
                    setReferenceServiceRequestItem(((String) value));
                }
            }
            if( values.containsKey("ParentServiceOrderItem") ) {
                final Object value = values.remove("ParentServiceOrderItem");
                if( (value == null) || (!value.equals(getParentServiceOrderItem())) ) {
                    setParentServiceOrderItem(((String) value));
                }
            }
            if( values.containsKey("PlannedServiceStartDateTime") ) {
                final Object value = values.remove("PlannedServiceStartDateTime");
                if( (value == null) || (!value.equals(getPlannedServiceStartDateTime())) ) {
                    setPlannedServiceStartDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("PlannedServiceEndDateTime") ) {
                final Object value = values.remove("PlannedServiceEndDateTime");
                if( (value == null) || (!value.equals(getPlannedServiceEndDateTime())) ) {
                    setPlannedServiceEndDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("RequestedServiceStartDateTime") ) {
                final Object value = values.remove("RequestedServiceStartDateTime");
                if( (value == null) || (!value.equals(getRequestedServiceStartDateTime())) ) {
                    setRequestedServiceStartDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("RequestedServiceEndDateTime") ) {
                final Object value = values.remove("RequestedServiceEndDateTime");
                if( (value == null) || (!value.equals(getRequestedServiceEndDateTime())) ) {
                    setRequestedServiceEndDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("SrvcDocItemSLADueByDateTime") ) {
                final Object value = values.remove("SrvcDocItemSLADueByDateTime");
                if( (value == null) || (!value.equals(getSrvcDocItemSLADueByDateTime())) ) {
                    setSrvcDocItemSLADueByDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("ActualServiceDuration") ) {
                final Object value = values.remove("ActualServiceDuration");
                if( (value == null) || (!value.equals(getActualServiceDuration())) ) {
                    setActualServiceDuration(((BigDecimal) value));
                }
            }
            if( values.containsKey("ActualServiceDurationUnit") ) {
                final Object value = values.remove("ActualServiceDurationUnit");
                if( (value == null) || (!value.equals(getActualServiceDurationUnit())) ) {
                    setActualServiceDurationUnit(((String) value));
                }
            }
            if( values.containsKey("SrvcContrDetnIsSpprsd") ) {
                final Object value = values.remove("SrvcContrDetnIsSpprsd");
                if( (value == null) || (!value.equals(getSrvcContrDetnIsSpprsd())) ) {
                    setSrvcContrDetnIsSpprsd(((Boolean) value));
                }
            }
            if( values.containsKey("ReferenceServiceOrderItem") ) {
                final Object value = values.remove("ReferenceServiceOrderItem");
                if( (value == null) || (!value.equals(getReferenceServiceOrderItem())) ) {
                    setReferenceServiceOrderItem(((String) value));
                }
            }
            if( values.containsKey("ShippingCondition") ) {
                final Object value = values.remove("ShippingCondition");
                if( (value == null) || (!value.equals(getShippingCondition())) ) {
                    setShippingCondition(((String) value));
                }
            }
            if( values.containsKey("SrvcDocItmPartReferenceItem") ) {
                final Object value = values.remove("SrvcDocItmPartReferenceItem");
                if( (value == null) || (!value.equals(getSrvcDocItmPartReferenceItem())) ) {
                    setSrvcDocItmPartReferenceItem(((String) value));
                }
            }
            if( values.containsKey("SrvcDocItmApptReferenceItem") ) {
                final Object value = values.remove("SrvcDocItmApptReferenceItem");
                if( (value == null) || (!value.equals(getSrvcDocItmApptReferenceItem())) ) {
                    setSrvcDocItmApptReferenceItem(((String) value));
                }
            }
            if( values.containsKey("SrvcDocItmApptRefObjectUUID") ) {
                final Object value = values.remove("SrvcDocItmApptRefObjectUUID");
                if( (value == null) || (!value.equals(getSrvcDocItmApptRefObjectUUID())) ) {
                    setSrvcDocItmApptRefObjectUUID(((UUID) value));
                }
            }
            if( values.containsKey("SrvcOrdItemIsUnplanned") ) {
                final Object value = values.remove("SrvcOrdItemIsUnplanned");
                if( (value == null) || (!value.equals(getSrvcOrdItemIsUnplanned())) ) {
                    setSrvcOrdItemIsUnplanned(((Boolean) value));
                }
            }
            if( values.containsKey("FSMServiceActivity") ) {
                final Object value = values.remove("FSMServiceActivity");
                if( (value == null) || (!value.equals(getFSMServiceActivity())) ) {
                    setFSMServiceActivity(((String) value));
                }
            }
            if( values.containsKey("TimeSheetOvertimeCategory") ) {
                final Object value = values.remove("TimeSheetOvertimeCategory");
                if( (value == null) || (!value.equals(getTimeSheetOvertimeCategory())) ) {
                    setTimeSheetOvertimeCategory(((String) value));
                }
            }
            if( values.containsKey("RespyMgmtServiceTeam") ) {
                final Object value = values.remove("RespyMgmtServiceTeam");
                if( (value == null) || (!value.equals(getRespyMgmtServiceTeam())) ) {
                    setRespyMgmtServiceTeam(((String) value));
                }
            }
            if( values.containsKey("RespyMgmtServiceTeamName") ) {
                final Object value = values.remove("RespyMgmtServiceTeamName");
                if( (value == null) || (!value.equals(getRespyMgmtServiceTeamName())) ) {
                    setRespyMgmtServiceTeamName(((String) value));
                }
            }
            if( values.containsKey("RespyMgmtGlobalTeamID") ) {
                final Object value = values.remove("RespyMgmtGlobalTeamID");
                if( (value == null) || (!value.equals(getRespyMgmtGlobalTeamID())) ) {
                    setRespyMgmtGlobalTeamID(((String) value));
                }
            }
            if( values.containsKey("ProfitCenter") ) {
                final Object value = values.remove("ProfitCenter");
                if( (value == null) || (!value.equals(getProfitCenter())) ) {
                    setProfitCenter(((String) value));
                }
            }
            if( values.containsKey("SrvcOrdItemCreditStatus") ) {
                final Object value = values.remove("SrvcOrdItemCreditStatus");
                if( (value == null) || (!value.equals(getSrvcOrdItemCreditStatus())) ) {
                    setSrvcOrdItemCreditStatus(((String) value));
                }
            }
            if( values.containsKey("SrvcOrdItemExecutionStatus") ) {
                final Object value = values.remove("SrvcOrdItemExecutionStatus");
                if( (value == null) || (!value.equals(getSrvcOrdItemExecutionStatus())) ) {
                    setSrvcOrdItemExecutionStatus(((String) value));
                }
            }
            if( values.containsKey("PaymentTerms") ) {
                final Object value = values.remove("PaymentTerms");
                if( (value == null) || (!value.equals(getPaymentTerms())) ) {
                    setPaymentTerms(((String) value));
                }
            }
            if( values.containsKey("PaymentMethod") ) {
                final Object value = values.remove("PaymentMethod");
                if( (value == null) || (!value.equals(getPaymentMethod())) ) {
                    setPaymentMethod(((String) value));
                }
            }
            if( values.containsKey("SEPAMandate") ) {
                final Object value = values.remove("SEPAMandate");
                if( (value == null) || (!value.equals(getSEPAMandate())) ) {
                    setSEPAMandate(((String) value));
                }
            }
            if( values.containsKey("SrvcSEPAMandateRelevance") ) {
                final Object value = values.remove("SrvcSEPAMandateRelevance");
                if( (value == null) || (!value.equals(getSrvcSEPAMandateRelevance())) ) {
                    setSrvcSEPAMandateRelevance(((String) value));
                }
            }
            if( values.containsKey("WBSElementExternalID") ) {
                final Object value = values.remove("WBSElementExternalID");
                if( (value == null) || (!value.equals(getWBSElementExternalID())) ) {
                    setWBSElementExternalID(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_Appointment") ) {
                final Object value = (values).remove("to_Appointment");
                if( value instanceof Iterable ) {
                    if( toAppointment == null ) {
                        toAppointment = Lists.newArrayList();
                    } else {
                        toAppointment = Lists.newArrayList(toAppointment);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SrvcOrdItemAppointment entity;
                        if( toAppointment.size() > i ) {
                            entity = toAppointment.get(i);
                        } else {
                            entity = new SrvcOrdItemAppointment();
                            toAppointment.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_Confirmation") ) {
                final Object value = (values).remove("to_Confirmation");
                if( value instanceof Iterable ) {
                    if( toConfirmation == null ) {
                        toConfirmation = Lists.newArrayList();
                    } else {
                        toConfirmation = Lists.newArrayList(toConfirmation);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ServiceOrderItemConfirmation entity;
                        if( toConfirmation.size() > i ) {
                            entity = toConfirmation.get(i);
                        } else {
                            entity = new ServiceOrderItemConfirmation();
                            toConfirmation.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_Duration") ) {
                final Object value = (values).remove("to_Duration");
                if( value instanceof Iterable ) {
                    if( toDuration == null ) {
                        toDuration = Lists.newArrayList();
                    } else {
                        toDuration = Lists.newArrayList(toDuration);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SrvcOrdItemDuration entity;
                        if( toDuration.size() > i ) {
                            entity = toDuration.get(i);
                        } else {
                            entity = new SrvcOrdItemDuration();
                            toDuration.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_Partner") ) {
                final Object value = (values).remove("to_Partner");
                if( value instanceof Iterable ) {
                    if( toPartner == null ) {
                        toPartner = Lists.newArrayList();
                    } else {
                        toPartner = Lists.newArrayList(toPartner);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SrvcOrdItmPartner entity;
                        if( toPartner.size() > i ) {
                            entity = toPartner.get(i);
                        } else {
                            entity = new SrvcOrdItmPartner();
                            toPartner.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_PricingElement") ) {
                final Object value = (values).remove("to_PricingElement");
                if( value instanceof Iterable ) {
                    if( toPricingElement == null ) {
                        toPricingElement = Lists.newArrayList();
                    } else {
                        toPricingElement = Lists.newArrayList(toPricingElement);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ServiceOrderItemPriceElement entity;
                        if( toPricingElement.size() > i ) {
                            entity = toPricingElement.get(i);
                        } else {
                            entity = new ServiceOrderItemPriceElement();
                            toPricingElement.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_ProductReferenceObject") ) {
                final Object value = (values).remove("to_ProductReferenceObject");
                if( value instanceof Iterable ) {
                    if( toProductReferenceObject == null ) {
                        toProductReferenceObject = Lists.newArrayList();
                    } else {
                        toProductReferenceObject = Lists.newArrayList(toProductReferenceObject);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SrvcOrdItmProdRefObject entity;
                        if( toProductReferenceObject.size() > i ) {
                            entity = toProductReferenceObject.get(i);
                        } else {
                            entity = new SrvcOrdItmProdRefObject();
                            toProductReferenceObject.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_ReferenceObject") ) {
                final Object value = (values).remove("to_ReferenceObject");
                if( value instanceof Iterable ) {
                    if( toReferenceObject == null ) {
                        toReferenceObject = Lists.newArrayList();
                    } else {
                        toReferenceObject = Lists.newArrayList(toReferenceObject);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ServiceOrderItemRefObject entity;
                        if( toReferenceObject.size() > i ) {
                            entity = toReferenceObject.get(i);
                        } else {
                            entity = new ServiceOrderItemRefObject();
                            toReferenceObject.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_ServiceOrder") ) {
                final Object value = (values).remove("to_ServiceOrder");
                if( value instanceof Map ) {
                    if( toServiceOrder == null ) {
                        toServiceOrder = new ServiceOrder();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toServiceOrder.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_SrvcOrdItemUserStatus") ) {
                final Object value = (values).remove("to_SrvcOrdItemUserStatus");
                if( value instanceof Iterable ) {
                    if( toSrvcOrdItemUserStatus == null ) {
                        toSrvcOrdItemUserStatus = Lists.newArrayList();
                    } else {
                        toSrvcOrdItemUserStatus = Lists.newArrayList(toSrvcOrdItemUserStatus);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ServiceOrdItemUserStatus entity;
                        if( toSrvcOrdItemUserStatus.size() > i ) {
                            entity = toSrvcOrdItemUserStatus.get(i);
                        } else {
                            entity = new ServiceOrdItemUserStatus();
                            toSrvcOrdItemUserStatus.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_Text") ) {
                final Object value = (values).remove("to_Text");
                if( value instanceof Iterable ) {
                    if( toText == null ) {
                        toText = Lists.newArrayList();
                    } else {
                        toText = Lists.newArrayList(toText);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ServiceOrderItemText entity;
                        if( toText.size() > i ) {
                            entity = toText.get(i);
                        } else {
                            entity = new ServiceOrderItemText();
                            toText.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> ServiceOrderItemField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ServiceOrderItemField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ServiceOrderItemField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ServiceOrderItemField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ServiceOrderService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toAppointment != null ) {
            (values).put("to_Appointment", toAppointment);
        }
        if( toConfirmation != null ) {
            (values).put("to_Confirmation", toConfirmation);
        }
        if( toDuration != null ) {
            (values).put("to_Duration", toDuration);
        }
        if( toPartner != null ) {
            (values).put("to_Partner", toPartner);
        }
        if( toPricingElement != null ) {
            (values).put("to_PricingElement", toPricingElement);
        }
        if( toProductReferenceObject != null ) {
            (values).put("to_ProductReferenceObject", toProductReferenceObject);
        }
        if( toReferenceObject != null ) {
            (values).put("to_ReferenceObject", toReferenceObject);
        }
        if( toServiceOrder != null ) {
            (values).put("to_ServiceOrder", toServiceOrder);
        }
        if( toSrvcOrdItemUserStatus != null ) {
            (values).put("to_SrvcOrdItemUserStatus", toSrvcOrdItemUserStatus);
        }
        if( toText != null ) {
            (values).put("to_Text", toText);
        }
        return values;
    }

    /**
     * Fetches the <b>SrvcOrdItemAppointment</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_Appointment</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SrvcOrdItemAppointment</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SrvcOrdItemAppointment> fetchAppointment()
    {
        return fetchFieldAsList("to_Appointment", SrvcOrdItemAppointment.class);
    }

    /**
     * Retrieval of associated <b>SrvcOrdItemAppointment</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Appointment</b>.
     * <p>
     * If the navigation property <b>to_Appointment</b> of a queried <b>ServiceOrderItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SrvcOrdItemAppointment</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SrvcOrdItemAppointment> getAppointmentOrFetch()
    {
        if( toAppointment == null ) {
            toAppointment = fetchAppointment();
        }
        return toAppointment;
    }

    /**
     * Retrieval of associated <b>SrvcOrdItemAppointment</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Appointment</b>.
     * <p>
     * If the navigation property for an entity <b>ServiceOrderItem</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Appointment</b> is already loaded, the result will
     *         contain the <b>SrvcOrdItemAppointment</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SrvcOrdItemAppointment>> getAppointmentIfPresent()
    {
        return Option.of(toAppointment);
    }

    /**
     * Overwrites the list of associated <b>SrvcOrdItemAppointment</b> entities for the loaded navigation property
     * <b>to_Appointment</b>.
     * <p>
     * If the navigation property <b>to_Appointment</b> of a queried <b>ServiceOrderItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SrvcOrdItemAppointment</b> entities.
     */
    public void setAppointment( @Nonnull final List<SrvcOrdItemAppointment> value )
    {
        if( toAppointment == null ) {
            toAppointment = Lists.newArrayList();
        }
        toAppointment.clear();
        toAppointment.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SrvcOrdItemAppointment</b> entities. This corresponds to the OData
     * navigation property <b>to_Appointment</b>.
     * <p>
     * If the navigation property <b>to_Appointment</b> of a queried <b>ServiceOrderItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SrvcOrdItemAppointment</b> entities.
     */
    public void addAppointment( SrvcOrdItemAppointment... entity )
    {
        if( toAppointment == null ) {
            toAppointment = Lists.newArrayList();
        }
        toAppointment.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>ServiceOrderItemConfirmation</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_Confirmation</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ServiceOrderItemConfirmation</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ServiceOrderItemConfirmation> fetchConfirmation()
    {
        return fetchFieldAsList("to_Confirmation", ServiceOrderItemConfirmation.class);
    }

    /**
     * Retrieval of associated <b>ServiceOrderItemConfirmation</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Confirmation</b>.
     * <p>
     * If the navigation property <b>to_Confirmation</b> of a queried <b>ServiceOrderItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ServiceOrderItemConfirmation</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ServiceOrderItemConfirmation> getConfirmationOrFetch()
    {
        if( toConfirmation == null ) {
            toConfirmation = fetchConfirmation();
        }
        return toConfirmation;
    }

    /**
     * Retrieval of associated <b>ServiceOrderItemConfirmation</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Confirmation</b>.
     * <p>
     * If the navigation property for an entity <b>ServiceOrderItem</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Confirmation</b> is already loaded, the result will
     *         contain the <b>ServiceOrderItemConfirmation</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ServiceOrderItemConfirmation>> getConfirmationIfPresent()
    {
        return Option.of(toConfirmation);
    }

    /**
     * Overwrites the list of associated <b>ServiceOrderItemConfirmation</b> entities for the loaded navigation property
     * <b>to_Confirmation</b>.
     * <p>
     * If the navigation property <b>to_Confirmation</b> of a queried <b>ServiceOrderItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ServiceOrderItemConfirmation</b> entities.
     */
    public void setConfirmation( @Nonnull final List<ServiceOrderItemConfirmation> value )
    {
        if( toConfirmation == null ) {
            toConfirmation = Lists.newArrayList();
        }
        toConfirmation.clear();
        toConfirmation.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ServiceOrderItemConfirmation</b> entities. This corresponds to the
     * OData navigation property <b>to_Confirmation</b>.
     * <p>
     * If the navigation property <b>to_Confirmation</b> of a queried <b>ServiceOrderItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ServiceOrderItemConfirmation</b> entities.
     */
    public void addConfirmation( ServiceOrderItemConfirmation... entity )
    {
        if( toConfirmation == null ) {
            toConfirmation = Lists.newArrayList();
        }
        toConfirmation.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>SrvcOrdItemDuration</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_Duration</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SrvcOrdItemDuration</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SrvcOrdItemDuration> fetchDuration()
    {
        return fetchFieldAsList("to_Duration", SrvcOrdItemDuration.class);
    }

    /**
     * Retrieval of associated <b>SrvcOrdItemDuration</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Duration</b>.
     * <p>
     * If the navigation property <b>to_Duration</b> of a queried <b>ServiceOrderItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SrvcOrdItemDuration</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SrvcOrdItemDuration> getDurationOrFetch()
    {
        if( toDuration == null ) {
            toDuration = fetchDuration();
        }
        return toDuration;
    }

    /**
     * Retrieval of associated <b>SrvcOrdItemDuration</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Duration</b>.
     * <p>
     * If the navigation property for an entity <b>ServiceOrderItem</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Duration</b> is already loaded, the result will contain
     *         the <b>SrvcOrdItemDuration</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SrvcOrdItemDuration>> getDurationIfPresent()
    {
        return Option.of(toDuration);
    }

    /**
     * Overwrites the list of associated <b>SrvcOrdItemDuration</b> entities for the loaded navigation property
     * <b>to_Duration</b>.
     * <p>
     * If the navigation property <b>to_Duration</b> of a queried <b>ServiceOrderItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SrvcOrdItemDuration</b> entities.
     */
    public void setDuration( @Nonnull final List<SrvcOrdItemDuration> value )
    {
        if( toDuration == null ) {
            toDuration = Lists.newArrayList();
        }
        toDuration.clear();
        toDuration.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SrvcOrdItemDuration</b> entities. This corresponds to the OData
     * navigation property <b>to_Duration</b>.
     * <p>
     * If the navigation property <b>to_Duration</b> of a queried <b>ServiceOrderItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SrvcOrdItemDuration</b> entities.
     */
    public void addDuration( SrvcOrdItemDuration... entity )
    {
        if( toDuration == null ) {
            toDuration = Lists.newArrayList();
        }
        toDuration.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>SrvcOrdItmPartner</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_Partner</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SrvcOrdItmPartner</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SrvcOrdItmPartner> fetchPartner()
    {
        return fetchFieldAsList("to_Partner", SrvcOrdItmPartner.class);
    }

    /**
     * Retrieval of associated <b>SrvcOrdItmPartner</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_Partner</b>.
     * <p>
     * If the navigation property <b>to_Partner</b> of a queried <b>ServiceOrderItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SrvcOrdItmPartner</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SrvcOrdItmPartner> getPartnerOrFetch()
    {
        if( toPartner == null ) {
            toPartner = fetchPartner();
        }
        return toPartner;
    }

    /**
     * Retrieval of associated <b>SrvcOrdItmPartner</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_Partner</b>.
     * <p>
     * If the navigation property for an entity <b>ServiceOrderItem</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Partner</b> is already loaded, the result will contain
     *         the <b>SrvcOrdItmPartner</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SrvcOrdItmPartner>> getPartnerIfPresent()
    {
        return Option.of(toPartner);
    }

    /**
     * Overwrites the list of associated <b>SrvcOrdItmPartner</b> entities for the loaded navigation property
     * <b>to_Partner</b>.
     * <p>
     * If the navigation property <b>to_Partner</b> of a queried <b>ServiceOrderItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SrvcOrdItmPartner</b> entities.
     */
    public void setPartner( @Nonnull final List<SrvcOrdItmPartner> value )
    {
        if( toPartner == null ) {
            toPartner = Lists.newArrayList();
        }
        toPartner.clear();
        toPartner.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SrvcOrdItmPartner</b> entities. This corresponds to the OData
     * navigation property <b>to_Partner</b>.
     * <p>
     * If the navigation property <b>to_Partner</b> of a queried <b>ServiceOrderItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SrvcOrdItmPartner</b> entities.
     */
    public void addPartner( SrvcOrdItmPartner... entity )
    {
        if( toPartner == null ) {
            toPartner = Lists.newArrayList();
        }
        toPartner.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>ServiceOrderItemPriceElement</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_PricingElement</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ServiceOrderItemPriceElement</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ServiceOrderItemPriceElement> fetchPricingElement()
    {
        return fetchFieldAsList("to_PricingElement", ServiceOrderItemPriceElement.class);
    }

    /**
     * Retrieval of associated <b>ServiceOrderItemPriceElement</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_PricingElement</b>.
     * <p>
     * If the navigation property <b>to_PricingElement</b> of a queried <b>ServiceOrderItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ServiceOrderItemPriceElement</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ServiceOrderItemPriceElement> getPricingElementOrFetch()
    {
        if( toPricingElement == null ) {
            toPricingElement = fetchPricingElement();
        }
        return toPricingElement;
    }

    /**
     * Retrieval of associated <b>ServiceOrderItemPriceElement</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_PricingElement</b>.
     * <p>
     * If the navigation property for an entity <b>ServiceOrderItem</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_PricingElement</b> is already loaded, the result will
     *         contain the <b>ServiceOrderItemPriceElement</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ServiceOrderItemPriceElement>> getPricingElementIfPresent()
    {
        return Option.of(toPricingElement);
    }

    /**
     * Overwrites the list of associated <b>ServiceOrderItemPriceElement</b> entities for the loaded navigation property
     * <b>to_PricingElement</b>.
     * <p>
     * If the navigation property <b>to_PricingElement</b> of a queried <b>ServiceOrderItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ServiceOrderItemPriceElement</b> entities.
     */
    public void setPricingElement( @Nonnull final List<ServiceOrderItemPriceElement> value )
    {
        if( toPricingElement == null ) {
            toPricingElement = Lists.newArrayList();
        }
        toPricingElement.clear();
        toPricingElement.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ServiceOrderItemPriceElement</b> entities. This corresponds to the
     * OData navigation property <b>to_PricingElement</b>.
     * <p>
     * If the navigation property <b>to_PricingElement</b> of a queried <b>ServiceOrderItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ServiceOrderItemPriceElement</b> entities.
     */
    public void addPricingElement( ServiceOrderItemPriceElement... entity )
    {
        if( toPricingElement == null ) {
            toPricingElement = Lists.newArrayList();
        }
        toPricingElement.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>SrvcOrdItmProdRefObject</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_ProductReferenceObject</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SrvcOrdItmProdRefObject</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SrvcOrdItmProdRefObject> fetchProductReferenceObject()
    {
        return fetchFieldAsList("to_ProductReferenceObject", SrvcOrdItmProdRefObject.class);
    }

    /**
     * Retrieval of associated <b>SrvcOrdItmProdRefObject</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ProductReferenceObject</b>.
     * <p>
     * If the navigation property <b>to_ProductReferenceObject</b> of a queried <b>ServiceOrderItem</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SrvcOrdItmProdRefObject</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SrvcOrdItmProdRefObject> getProductReferenceObjectOrFetch()
    {
        if( toProductReferenceObject == null ) {
            toProductReferenceObject = fetchProductReferenceObject();
        }
        return toProductReferenceObject;
    }

    /**
     * Retrieval of associated <b>SrvcOrdItmProdRefObject</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ProductReferenceObject</b>.
     * <p>
     * If the navigation property for an entity <b>ServiceOrderItem</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ProductReferenceObject</b> is already loaded, the result
     *         will contain the <b>SrvcOrdItmProdRefObject</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SrvcOrdItmProdRefObject>> getProductReferenceObjectIfPresent()
    {
        return Option.of(toProductReferenceObject);
    }

    /**
     * Overwrites the list of associated <b>SrvcOrdItmProdRefObject</b> entities for the loaded navigation property
     * <b>to_ProductReferenceObject</b>.
     * <p>
     * If the navigation property <b>to_ProductReferenceObject</b> of a queried <b>ServiceOrderItem</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SrvcOrdItmProdRefObject</b> entities.
     */
    public void setProductReferenceObject( @Nonnull final List<SrvcOrdItmProdRefObject> value )
    {
        if( toProductReferenceObject == null ) {
            toProductReferenceObject = Lists.newArrayList();
        }
        toProductReferenceObject.clear();
        toProductReferenceObject.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SrvcOrdItmProdRefObject</b> entities. This corresponds to the OData
     * navigation property <b>to_ProductReferenceObject</b>.
     * <p>
     * If the navigation property <b>to_ProductReferenceObject</b> of a queried <b>ServiceOrderItem</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SrvcOrdItmProdRefObject</b> entities.
     */
    public void addProductReferenceObject( SrvcOrdItmProdRefObject... entity )
    {
        if( toProductReferenceObject == null ) {
            toProductReferenceObject = Lists.newArrayList();
        }
        toProductReferenceObject.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>ServiceOrderItemRefObject</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_ReferenceObject</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ServiceOrderItemRefObject</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ServiceOrderItemRefObject> fetchReferenceObject()
    {
        return fetchFieldAsList("to_ReferenceObject", ServiceOrderItemRefObject.class);
    }

    /**
     * Retrieval of associated <b>ServiceOrderItemRefObject</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ReferenceObject</b>.
     * <p>
     * If the navigation property <b>to_ReferenceObject</b> of a queried <b>ServiceOrderItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ServiceOrderItemRefObject</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ServiceOrderItemRefObject> getReferenceObjectOrFetch()
    {
        if( toReferenceObject == null ) {
            toReferenceObject = fetchReferenceObject();
        }
        return toReferenceObject;
    }

    /**
     * Retrieval of associated <b>ServiceOrderItemRefObject</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ReferenceObject</b>.
     * <p>
     * If the navigation property for an entity <b>ServiceOrderItem</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ReferenceObject</b> is already loaded, the result will
     *         contain the <b>ServiceOrderItemRefObject</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ServiceOrderItemRefObject>> getReferenceObjectIfPresent()
    {
        return Option.of(toReferenceObject);
    }

    /**
     * Overwrites the list of associated <b>ServiceOrderItemRefObject</b> entities for the loaded navigation property
     * <b>to_ReferenceObject</b>.
     * <p>
     * If the navigation property <b>to_ReferenceObject</b> of a queried <b>ServiceOrderItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ServiceOrderItemRefObject</b> entities.
     */
    public void setReferenceObject( @Nonnull final List<ServiceOrderItemRefObject> value )
    {
        if( toReferenceObject == null ) {
            toReferenceObject = Lists.newArrayList();
        }
        toReferenceObject.clear();
        toReferenceObject.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ServiceOrderItemRefObject</b> entities. This corresponds to the OData
     * navigation property <b>to_ReferenceObject</b>.
     * <p>
     * If the navigation property <b>to_ReferenceObject</b> of a queried <b>ServiceOrderItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ServiceOrderItemRefObject</b> entities.
     */
    public void addReferenceObject( ServiceOrderItemRefObject... entity )
    {
        if( toReferenceObject == null ) {
            toReferenceObject = Lists.newArrayList();
        }
        toReferenceObject.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>ServiceOrder</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_ServiceOrder</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>ServiceOrder</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ServiceOrder fetchServiceOrder()
    {
        return fetchFieldAsSingle("to_ServiceOrder", ServiceOrder.class);
    }

    /**
     * Retrieval of associated <b>ServiceOrder</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_ServiceOrder</b>.
     * <p>
     * If the navigation property <b>to_ServiceOrder</b> of a queried <b>ServiceOrderItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ServiceOrder</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ServiceOrder getServiceOrderOrFetch()
    {
        if( toServiceOrder == null ) {
            toServiceOrder = fetchServiceOrder();
        }
        return toServiceOrder;
    }

    /**
     * Retrieval of associated <b>ServiceOrder</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_ServiceOrder</b>.
     * <p>
     * If the navigation property for an entity <b>ServiceOrderItem</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ServiceOrder</b> is already loaded, the result will
     *         contain the <b>ServiceOrder</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<ServiceOrder> getServiceOrderIfPresent()
    {
        return Option.of(toServiceOrder);
    }

    /**
     * Overwrites the associated <b>ServiceOrder</b> entity for the loaded navigation property <b>to_ServiceOrder</b>.
     *
     * @param value
     *            New <b>ServiceOrder</b> entity.
     */
    public void setServiceOrder( final ServiceOrder value )
    {
        toServiceOrder = value;
    }

    /**
     * Fetches the <b>ServiceOrdItemUserStatus</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_SrvcOrdItemUserStatus</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ServiceOrdItemUserStatus</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ServiceOrdItemUserStatus> fetchSrvcOrdItemUserStatus()
    {
        return fetchFieldAsList("to_SrvcOrdItemUserStatus", ServiceOrdItemUserStatus.class);
    }

    /**
     * Retrieval of associated <b>ServiceOrdItemUserStatus</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_SrvcOrdItemUserStatus</b>.
     * <p>
     * If the navigation property <b>to_SrvcOrdItemUserStatus</b> of a queried <b>ServiceOrderItem</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ServiceOrdItemUserStatus</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ServiceOrdItemUserStatus> getSrvcOrdItemUserStatusOrFetch()
    {
        if( toSrvcOrdItemUserStatus == null ) {
            toSrvcOrdItemUserStatus = fetchSrvcOrdItemUserStatus();
        }
        return toSrvcOrdItemUserStatus;
    }

    /**
     * Retrieval of associated <b>ServiceOrdItemUserStatus</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_SrvcOrdItemUserStatus</b>.
     * <p>
     * If the navigation property for an entity <b>ServiceOrderItem</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SrvcOrdItemUserStatus</b> is already loaded, the result
     *         will contain the <b>ServiceOrdItemUserStatus</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ServiceOrdItemUserStatus>> getSrvcOrdItemUserStatusIfPresent()
    {
        return Option.of(toSrvcOrdItemUserStatus);
    }

    /**
     * Overwrites the list of associated <b>ServiceOrdItemUserStatus</b> entities for the loaded navigation property
     * <b>to_SrvcOrdItemUserStatus</b>.
     * <p>
     * If the navigation property <b>to_SrvcOrdItemUserStatus</b> of a queried <b>ServiceOrderItem</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ServiceOrdItemUserStatus</b> entities.
     */
    public void setSrvcOrdItemUserStatus( @Nonnull final List<ServiceOrdItemUserStatus> value )
    {
        if( toSrvcOrdItemUserStatus == null ) {
            toSrvcOrdItemUserStatus = Lists.newArrayList();
        }
        toSrvcOrdItemUserStatus.clear();
        toSrvcOrdItemUserStatus.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ServiceOrdItemUserStatus</b> entities. This corresponds to the OData
     * navigation property <b>to_SrvcOrdItemUserStatus</b>.
     * <p>
     * If the navigation property <b>to_SrvcOrdItemUserStatus</b> of a queried <b>ServiceOrderItem</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ServiceOrdItemUserStatus</b> entities.
     */
    public void addSrvcOrdItemUserStatus( ServiceOrdItemUserStatus... entity )
    {
        if( toSrvcOrdItemUserStatus == null ) {
            toSrvcOrdItemUserStatus = Lists.newArrayList();
        }
        toSrvcOrdItemUserStatus.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>ServiceOrderItemText</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_Text</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ServiceOrderItemText</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ServiceOrderItemText> fetchText()
    {
        return fetchFieldAsList("to_Text", ServiceOrderItemText.class);
    }

    /**
     * Retrieval of associated <b>ServiceOrderItemText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Text</b>.
     * <p>
     * If the navigation property <b>to_Text</b> of a queried <b>ServiceOrderItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ServiceOrderItemText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ServiceOrderItemText> getTextOrFetch()
    {
        if( toText == null ) {
            toText = fetchText();
        }
        return toText;
    }

    /**
     * Retrieval of associated <b>ServiceOrderItemText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Text</b>.
     * <p>
     * If the navigation property for an entity <b>ServiceOrderItem</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Text</b> is already loaded, the result will contain the
     *         <b>ServiceOrderItemText</b> entities. If not, an <code>Option</code> with result state <code>empty</code>
     *         is returned.
     */
    @Nonnull
    public Option<List<ServiceOrderItemText>> getTextIfPresent()
    {
        return Option.of(toText);
    }

    /**
     * Overwrites the list of associated <b>ServiceOrderItemText</b> entities for the loaded navigation property
     * <b>to_Text</b>.
     * <p>
     * If the navigation property <b>to_Text</b> of a queried <b>ServiceOrderItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ServiceOrderItemText</b> entities.
     */
    public void setText( @Nonnull final List<ServiceOrderItemText> value )
    {
        if( toText == null ) {
            toText = Lists.newArrayList();
        }
        toText.clear();
        toText.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ServiceOrderItemText</b> entities. This corresponds to the OData
     * navigation property <b>to_Text</b>.
     * <p>
     * If the navigation property <b>to_Text</b> of a queried <b>ServiceOrderItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ServiceOrderItemText</b> entities.
     */
    public void addText( ServiceOrderItemText... entity )
    {
        if( toText == null ) {
            toText = Lists.newArrayList();
        }
        toText.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of ServiceOrderItem instances.
     *
     */
    public final static class ServiceOrderItemBuilder
    {

        private List<SrvcOrdItemAppointment> toAppointment = Lists.newArrayList();
        private List<ServiceOrderItemConfirmation> toConfirmation = Lists.newArrayList();
        private List<SrvcOrdItemDuration> toDuration = Lists.newArrayList();
        private List<SrvcOrdItmPartner> toPartner = Lists.newArrayList();
        private List<ServiceOrderItemPriceElement> toPricingElement = Lists.newArrayList();
        private List<SrvcOrdItmProdRefObject> toProductReferenceObject = Lists.newArrayList();
        private List<ServiceOrderItemRefObject> toReferenceObject = Lists.newArrayList();
        private ServiceOrder toServiceOrder;
        private String serviceOrder = null;
        private List<ServiceOrdItemUserStatus> toSrvcOrdItemUserStatus = Lists.newArrayList();
        private List<ServiceOrderItemText> toText = Lists.newArrayList();

        private ServiceOrderItem.ServiceOrderItemBuilder toAppointment( final List<SrvcOrdItemAppointment> value )
        {
            toAppointment.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_Appointment</b> for <b>ServiceOrderItem</b> to multiple
         * <b>SrvcOrdItemAppointment</b>.
         *
         * @param value
         *            The SrvcOrdItemAppointments to build this ServiceOrderItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ServiceOrderItem.ServiceOrderItemBuilder appointment( SrvcOrdItemAppointment... value )
        {
            return toAppointment(Lists.newArrayList(value));
        }

        private ServiceOrderItem.ServiceOrderItemBuilder toConfirmation(
            final List<ServiceOrderItemConfirmation> value )
        {
            toConfirmation.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_Confirmation</b> for <b>ServiceOrderItem</b> to multiple
         * <b>ServiceOrderItemConfirmation</b>.
         *
         * @param value
         *            The ServiceOrderItemConfirmations to build this ServiceOrderItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ServiceOrderItem.ServiceOrderItemBuilder confirmation( ServiceOrderItemConfirmation... value )
        {
            return toConfirmation(Lists.newArrayList(value));
        }

        private ServiceOrderItem.ServiceOrderItemBuilder toDuration( final List<SrvcOrdItemDuration> value )
        {
            toDuration.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_Duration</b> for <b>ServiceOrderItem</b> to multiple <b>SrvcOrdItemDuration</b>.
         *
         * @param value
         *            The SrvcOrdItemDurations to build this ServiceOrderItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ServiceOrderItem.ServiceOrderItemBuilder duration( SrvcOrdItemDuration... value )
        {
            return toDuration(Lists.newArrayList(value));
        }

        private ServiceOrderItem.ServiceOrderItemBuilder toPartner( final List<SrvcOrdItmPartner> value )
        {
            toPartner.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_Partner</b> for <b>ServiceOrderItem</b> to multiple <b>SrvcOrdItmPartner</b>.
         *
         * @param value
         *            The SrvcOrdItmPartners to build this ServiceOrderItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ServiceOrderItem.ServiceOrderItemBuilder partner( SrvcOrdItmPartner... value )
        {
            return toPartner(Lists.newArrayList(value));
        }

        private ServiceOrderItem.ServiceOrderItemBuilder toPricingElement(
            final List<ServiceOrderItemPriceElement> value )
        {
            toPricingElement.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_PricingElement</b> for <b>ServiceOrderItem</b> to multiple
         * <b>ServiceOrderItemPriceElement</b>.
         *
         * @param value
         *            The ServiceOrderItemPriceElements to build this ServiceOrderItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ServiceOrderItem.ServiceOrderItemBuilder pricingElement( ServiceOrderItemPriceElement... value )
        {
            return toPricingElement(Lists.newArrayList(value));
        }

        private ServiceOrderItem.ServiceOrderItemBuilder toProductReferenceObject(
            final List<SrvcOrdItmProdRefObject> value )
        {
            toProductReferenceObject.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_ProductReferenceObject</b> for <b>ServiceOrderItem</b> to multiple
         * <b>SrvcOrdItmProdRefObject</b>.
         *
         * @param value
         *            The SrvcOrdItmProdRefObjects to build this ServiceOrderItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ServiceOrderItem.ServiceOrderItemBuilder productReferenceObject( SrvcOrdItmProdRefObject... value )
        {
            return toProductReferenceObject(Lists.newArrayList(value));
        }

        private ServiceOrderItem.ServiceOrderItemBuilder toReferenceObject(
            final List<ServiceOrderItemRefObject> value )
        {
            toReferenceObject.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_ReferenceObject</b> for <b>ServiceOrderItem</b> to multiple
         * <b>ServiceOrderItemRefObject</b>.
         *
         * @param value
         *            The ServiceOrderItemRefObjects to build this ServiceOrderItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ServiceOrderItem.ServiceOrderItemBuilder referenceObject( ServiceOrderItemRefObject... value )
        {
            return toReferenceObject(Lists.newArrayList(value));
        }

        private ServiceOrderItem.ServiceOrderItemBuilder toServiceOrder( final ServiceOrder value )
        {
            toServiceOrder = value;
            return this;
        }

        /**
         * Navigation property <b>to_ServiceOrder</b> for <b>ServiceOrderItem</b> to single <b>ServiceOrder</b>.
         *
         * @param value
         *            The ServiceOrder to build this ServiceOrderItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ServiceOrderItem.ServiceOrderItemBuilder serviceOrder( final ServiceOrder value )
        {
            return toServiceOrder(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 10
         * <p>
         * Original property name from the Odata EDM: <b>ServiceOrder</b>
         * </p>
         *
         * @param value
         *            The serviceOrder to build this ServiceOrderItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ServiceOrderItem.ServiceOrderItemBuilder serviceOrder( final String value )
        {
            serviceOrder = value;
            return this;
        }

        private ServiceOrderItem.ServiceOrderItemBuilder toSrvcOrdItemUserStatus(
            final List<ServiceOrdItemUserStatus> value )
        {
            toSrvcOrdItemUserStatus.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_SrvcOrdItemUserStatus</b> for <b>ServiceOrderItem</b> to multiple
         * <b>ServiceOrdItemUserStatus</b>.
         *
         * @param value
         *            The ServiceOrdItemUserStatuss to build this ServiceOrderItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ServiceOrderItem.ServiceOrderItemBuilder srvcOrdItemUserStatus( ServiceOrdItemUserStatus... value )
        {
            return toSrvcOrdItemUserStatus(Lists.newArrayList(value));
        }

        private ServiceOrderItem.ServiceOrderItemBuilder toText( final List<ServiceOrderItemText> value )
        {
            toText.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_Text</b> for <b>ServiceOrderItem</b> to multiple <b>ServiceOrderItemText</b>.
         *
         * @param value
         *            The ServiceOrderItemTexts to build this ServiceOrderItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ServiceOrderItem.ServiceOrderItemBuilder text( ServiceOrderItemText... value )
        {
            return toText(Lists.newArrayList(value));
        }

    }

}
