/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.selectable.ServiceOrderItemConfirmationSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemConfirmation
 * ServiceOrderItemConfirmation} entity using key fields. This fluent helper allows methods which modify the underlying
 * query to be called before executing the query itself.
 *
 */
public class ServiceOrderItemConfirmationByKeyFluentHelper
    extends
    FluentHelperByKey<ServiceOrderItemConfirmationByKeyFluentHelper, ServiceOrderItemConfirmation, ServiceOrderItemConfirmationSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemConfirmation
     * ServiceOrderItemConfirmation} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code ServiceOrderItemConfirmation}
     * @param serviceConfirmationItem
     *            Shortened Item Number in Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param serviceOrderItem
     *            Shortened Item Number in Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param serviceConfirmation
     *            Transaction ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code ServiceOrderItemConfirmation}
     * @param serviceOrder
     *            Transaction ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     */
    public ServiceOrderItemConfirmationByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String serviceOrder,
        final String serviceOrderItem,
        final String serviceConfirmation,
        final String serviceConfirmationItem )
    {
        super(servicePath, entityCollection);
        this.key.put("ServiceOrder", serviceOrder);
        this.key.put("ServiceOrderItem", serviceOrderItem);
        this.key.put("ServiceConfirmation", serviceConfirmation);
        this.key.put("ServiceConfirmationItem", serviceConfirmationItem);
    }

    @Override
    @Nonnull
    protected Class<ServiceOrderItemConfirmation> getEntityClass()
    {
        return ServiceOrderItemConfirmation.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
