/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.field.ServiceOrderItemRefObjectField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.selectable.ServiceOrderItemRefObjectSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Reference Objects of Service Order Item
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_ServiceOrderItemRefObjectType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ServiceOrderItemRefObject extends VdmEntity<ServiceOrderItemRefObject>
{

    /**
     * Selector for all available fields of ServiceOrderItemRefObject.
     *
     */
    public final static ServiceOrderItemRefObjectSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServiceOrder</b>
     * </p>
     *
     * @return Transaction ID
     */
    @Key
    @SerializedName( "ServiceOrder" )
    @JsonProperty( "ServiceOrder" )
    @Nullable
    @ODataField( odataName = "ServiceOrder" )
    private String serviceOrder;
    /**
     * Use with available fluent helpers to apply the <b>ServiceOrder</b> field to query operations.
     *
     */
    public final static ServiceOrderItemRefObjectField<String> SERVICE_ORDER =
        new ServiceOrderItemRefObjectField<String>("ServiceOrder");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ServiceOrderItem</b>
     * </p>
     *
     * @return Shortened Item Number in Document
     */
    @Key
    @SerializedName( "ServiceOrderItem" )
    @JsonProperty( "ServiceOrderItem" )
    @Nullable
    @ODataField( odataName = "ServiceOrderItem" )
    private String serviceOrderItem;
    /**
     * Use with available fluent helpers to apply the <b>ServiceOrderItem</b> field to query operations.
     *
     */
    public final static ServiceOrderItemRefObjectField<String> SERVICE_ORDER_ITEM =
        new ServiceOrderItemRefObjectField<String>("ServiceOrderItem");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>ServiceReferenceEquipment</b>
     * </p>
     *
     * @return Equipment Number
     */
    @Key
    @SerializedName( "ServiceReferenceEquipment" )
    @JsonProperty( "ServiceReferenceEquipment" )
    @Nullable
    @ODataField( odataName = "ServiceReferenceEquipment" )
    private String serviceReferenceEquipment;
    /**
     * Use with available fluent helpers to apply the <b>ServiceReferenceEquipment</b> field to query operations.
     *
     */
    public final static ServiceOrderItemRefObjectField<String> SERVICE_REFERENCE_EQUIPMENT =
        new ServiceOrderItemRefObjectField<String>("ServiceReferenceEquipment");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ServiceRefFunctionalLocation</b>
     * </p>
     *
     * @return Functional Location
     */
    @Key
    @SerializedName( "ServiceRefFunctionalLocation" )
    @JsonProperty( "ServiceRefFunctionalLocation" )
    @Nullable
    @ODataField( odataName = "ServiceRefFunctionalLocation" )
    private String serviceRefFunctionalLocation;
    /**
     * Use with available fluent helpers to apply the <b>ServiceRefFunctionalLocation</b> field to query operations.
     *
     */
    public final static ServiceOrderItemRefObjectField<String> SERVICE_REF_FUNCTIONAL_LOCATION =
        new ServiceOrderItemRefObjectField<String>("ServiceRefFunctionalLocation");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SrvcRefObjIsMainObject</b>
     * </p>
     *
     * @return Main Reference Object
     */
    @SerializedName( "SrvcRefObjIsMainObject" )
    @JsonProperty( "SrvcRefObjIsMainObject" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "SrvcRefObjIsMainObject" )
    private Boolean srvcRefObjIsMainObject;
    /**
     * Use with available fluent helpers to apply the <b>SrvcRefObjIsMainObject</b> field to query operations.
     *
     */
    public final static ServiceOrderItemRefObjectField<Boolean> SRVC_REF_OBJ_IS_MAIN_OBJECT =
        new ServiceOrderItemRefObjectField<Boolean>("SrvcRefObjIsMainObject");

    @Nonnull
    @Override
    public Class<ServiceOrderItemRefObject> getType()
    {
        return ServiceOrderItemRefObject.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServiceOrder</b>
     * </p>
     *
     * @param serviceOrder
     *            Transaction ID
     */
    public void setServiceOrder( @Nullable final String serviceOrder )
    {
        rememberChangedField("ServiceOrder", this.serviceOrder);
        this.serviceOrder = serviceOrder;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ServiceOrderItem</b>
     * </p>
     *
     * @param serviceOrderItem
     *            Shortened Item Number in Document
     */
    public void setServiceOrderItem( @Nullable final String serviceOrderItem )
    {
        rememberChangedField("ServiceOrderItem", this.serviceOrderItem);
        this.serviceOrderItem = serviceOrderItem;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>ServiceReferenceEquipment</b>
     * </p>
     *
     * @param serviceReferenceEquipment
     *            Equipment Number
     */
    public void setServiceReferenceEquipment( @Nullable final String serviceReferenceEquipment )
    {
        rememberChangedField("ServiceReferenceEquipment", this.serviceReferenceEquipment);
        this.serviceReferenceEquipment = serviceReferenceEquipment;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ServiceRefFunctionalLocation</b>
     * </p>
     *
     * @param serviceRefFunctionalLocation
     *            Functional Location
     */
    public void setServiceRefFunctionalLocation( @Nullable final String serviceRefFunctionalLocation )
    {
        rememberChangedField("ServiceRefFunctionalLocation", this.serviceRefFunctionalLocation);
        this.serviceRefFunctionalLocation = serviceRefFunctionalLocation;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SrvcRefObjIsMainObject</b>
     * </p>
     *
     * @param srvcRefObjIsMainObject
     *            Main Reference Object
     */
    public void setSrvcRefObjIsMainObject( @Nullable final Boolean srvcRefObjIsMainObject )
    {
        rememberChangedField("SrvcRefObjIsMainObject", this.srvcRefObjIsMainObject);
        this.srvcRefObjIsMainObject = srvcRefObjIsMainObject;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_ServiceOrderItemRefObject";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ServiceOrder", getServiceOrder());
        result.put("ServiceOrderItem", getServiceOrderItem());
        result.put("ServiceReferenceEquipment", getServiceReferenceEquipment());
        result.put("ServiceRefFunctionalLocation", getServiceRefFunctionalLocation());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ServiceOrder", getServiceOrder());
        values.put("ServiceOrderItem", getServiceOrderItem());
        values.put("ServiceReferenceEquipment", getServiceReferenceEquipment());
        values.put("ServiceRefFunctionalLocation", getServiceRefFunctionalLocation());
        values.put("SrvcRefObjIsMainObject", getSrvcRefObjIsMainObject());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ServiceOrder") ) {
                final Object value = values.remove("ServiceOrder");
                if( (value == null) || (!value.equals(getServiceOrder())) ) {
                    setServiceOrder(((String) value));
                }
            }
            if( values.containsKey("ServiceOrderItem") ) {
                final Object value = values.remove("ServiceOrderItem");
                if( (value == null) || (!value.equals(getServiceOrderItem())) ) {
                    setServiceOrderItem(((String) value));
                }
            }
            if( values.containsKey("ServiceReferenceEquipment") ) {
                final Object value = values.remove("ServiceReferenceEquipment");
                if( (value == null) || (!value.equals(getServiceReferenceEquipment())) ) {
                    setServiceReferenceEquipment(((String) value));
                }
            }
            if( values.containsKey("ServiceRefFunctionalLocation") ) {
                final Object value = values.remove("ServiceRefFunctionalLocation");
                if( (value == null) || (!value.equals(getServiceRefFunctionalLocation())) ) {
                    setServiceRefFunctionalLocation(((String) value));
                }
            }
            if( values.containsKey("SrvcRefObjIsMainObject") ) {
                final Object value = values.remove("SrvcRefObjIsMainObject");
                if( (value == null) || (!value.equals(getSrvcRefObjIsMainObject())) ) {
                    setSrvcRefObjIsMainObject(((Boolean) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> ServiceOrderItemRefObjectField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ServiceOrderItemRefObjectField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ServiceOrderItemRefObjectField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ServiceOrderItemRefObjectField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ServiceOrderService.DEFAULT_SERVICE_PATH);
    }

}
