/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperUpdate;

/**
 * Fluent helper to update an existing
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItem ServiceOrderItem} entity and
 * save it to the S/4HANA system.
 * <p>
 * To perform execution, call the {@link #executeRequest executeRequest} method on the fluent helper object.
 *
 */
public class ServiceOrderItemUpdateFluentHelper
    extends
    FluentHelperUpdate<ServiceOrderItemUpdateFluentHelper, ServiceOrderItem>
{

    /**
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItem ServiceOrderItem} entity
     * object that will be updated in the S/4HANA system.
     *
     */
    private final ServiceOrderItem entity;

    /**
     * Creates a fluent helper object that will update a
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItem ServiceOrderItem} entity
     * on the OData endpoint. To perform execution, call the {@link #executeRequest executeRequest} method on the fluent
     * helper object.
     *
     * @param servicePath
     *            The service path to direct the update requests to.
     * @param entity
     *            The ServiceOrderItem to take the updated values from.
     */
    public ServiceOrderItemUpdateFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final ServiceOrderItem entity,
        @Nonnull final String entityCollection )
    {
        super(servicePath, entityCollection);
        this.entity = entity;
    }

    @Override
    @Nonnull
    protected ServiceOrderItem getEntity()
    {
        return entity;
    }

}
