/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder;

import java.math.BigDecimal;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.field.SrvcOrdDurationField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.selectable.SrvcOrdDurationSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Service Order Duration
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_SrvcOrdDurationType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SrvcOrdDuration extends VdmEntity<SrvcOrdDuration>
{

    /**
     * Selector for all available fields of SrvcOrdDuration.
     *
     */
    public final static SrvcOrdDurationSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServiceOrder</b>
     * </p>
     *
     * @return Transaction ID
     */
    @Key
    @SerializedName( "ServiceOrder" )
    @JsonProperty( "ServiceOrder" )
    @Nullable
    @ODataField( odataName = "ServiceOrder" )
    private String serviceOrder;
    /**
     * Use with available fluent helpers to apply the <b>ServiceOrder</b> field to query operations.
     *
     */
    public final static SrvcOrdDurationField<String> SERVICE_ORDER = new SrvcOrdDurationField<String>("ServiceOrder");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>SrvcDocDurationType</b>
     * </p>
     *
     * @return Name for Type of Time Duration
     */
    @Key
    @SerializedName( "SrvcDocDurationType" )
    @JsonProperty( "SrvcDocDurationType" )
    @Nullable
    @ODataField( odataName = "SrvcDocDurationType" )
    private String srvcDocDurationType;
    /**
     * Use with available fluent helpers to apply the <b>SrvcDocDurationType</b> field to query operations.
     *
     */
    public final static SrvcOrdDurationField<String> SRVC_DOC_DURATION_TYPE =
        new SrvcOrdDurationField<String>("SrvcDocDurationType");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>SrvcDocDurationValue</b>
     * </p>
     *
     * @return Numerical Value of Duration
     */
    @SerializedName( "SrvcDocDurationValue" )
    @JsonProperty( "SrvcDocDurationValue" )
    @Nullable
    @ODataField( odataName = "SrvcDocDurationValue" )
    private BigDecimal srvcDocDurationValue;
    /**
     * Use with available fluent helpers to apply the <b>SrvcDocDurationValue</b> field to query operations.
     *
     */
    public final static SrvcOrdDurationField<BigDecimal> SRVC_DOC_DURATION_VALUE =
        new SrvcOrdDurationField<BigDecimal>("SrvcDocDurationValue");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>SrvcDocDurationUnit</b>
     * </p>
     *
     * @return Default Value for Time Unit
     */
    @SerializedName( "SrvcDocDurationUnit" )
    @JsonProperty( "SrvcDocDurationUnit" )
    @Nullable
    @ODataField( odataName = "SrvcDocDurationUnit" )
    private String srvcDocDurationUnit;
    /**
     * Use with available fluent helpers to apply the <b>SrvcDocDurationUnit</b> field to query operations.
     *
     */
    public final static SrvcOrdDurationField<String> SRVC_DOC_DURATION_UNIT =
        new SrvcOrdDurationField<String>("SrvcDocDurationUnit");

    @Nonnull
    @Override
    public Class<SrvcOrdDuration> getType()
    {
        return SrvcOrdDuration.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServiceOrder</b>
     * </p>
     *
     * @param serviceOrder
     *            Transaction ID
     */
    public void setServiceOrder( @Nullable final String serviceOrder )
    {
        rememberChangedField("ServiceOrder", this.serviceOrder);
        this.serviceOrder = serviceOrder;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>SrvcDocDurationType</b>
     * </p>
     *
     * @param srvcDocDurationType
     *            Name for Type of Time Duration
     */
    public void setSrvcDocDurationType( @Nullable final String srvcDocDurationType )
    {
        rememberChangedField("SrvcDocDurationType", this.srvcDocDurationType);
        this.srvcDocDurationType = srvcDocDurationType;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>SrvcDocDurationValue</b>
     * </p>
     *
     * @param srvcDocDurationValue
     *            Numerical Value of Duration
     */
    public void setSrvcDocDurationValue( @Nullable final BigDecimal srvcDocDurationValue )
    {
        rememberChangedField("SrvcDocDurationValue", this.srvcDocDurationValue);
        this.srvcDocDurationValue = srvcDocDurationValue;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>SrvcDocDurationUnit</b>
     * </p>
     *
     * @param srvcDocDurationUnit
     *            Default Value for Time Unit
     */
    public void setSrvcDocDurationUnit( @Nullable final String srvcDocDurationUnit )
    {
        rememberChangedField("SrvcDocDurationUnit", this.srvcDocDurationUnit);
        this.srvcDocDurationUnit = srvcDocDurationUnit;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_SrvcOrdDuration";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ServiceOrder", getServiceOrder());
        result.put("SrvcDocDurationType", getSrvcDocDurationType());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ServiceOrder", getServiceOrder());
        values.put("SrvcDocDurationType", getSrvcDocDurationType());
        values.put("SrvcDocDurationValue", getSrvcDocDurationValue());
        values.put("SrvcDocDurationUnit", getSrvcDocDurationUnit());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ServiceOrder") ) {
                final Object value = values.remove("ServiceOrder");
                if( (value == null) || (!value.equals(getServiceOrder())) ) {
                    setServiceOrder(((String) value));
                }
            }
            if( values.containsKey("SrvcDocDurationType") ) {
                final Object value = values.remove("SrvcDocDurationType");
                if( (value == null) || (!value.equals(getSrvcDocDurationType())) ) {
                    setSrvcDocDurationType(((String) value));
                }
            }
            if( values.containsKey("SrvcDocDurationValue") ) {
                final Object value = values.remove("SrvcDocDurationValue");
                if( (value == null) || (!value.equals(getSrvcDocDurationValue())) ) {
                    setSrvcDocDurationValue(((BigDecimal) value));
                }
            }
            if( values.containsKey("SrvcDocDurationUnit") ) {
                final Object value = values.remove("SrvcDocDurationUnit");
                if( (value == null) || (!value.equals(getSrvcDocDurationUnit())) ) {
                    setSrvcDocDurationUnit(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> SrvcOrdDurationField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SrvcOrdDurationField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SrvcOrdDurationField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SrvcOrdDurationField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ServiceOrderService.DEFAULT_SERVICE_PATH);
    }

}
