/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder;

import java.time.ZonedDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.field.SrvcOrdItemAppointmentField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.selectable.SrvcOrdItemAppointmentSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Service Order Item Appointment
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_SrvcOrdItemAppointmentType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SrvcOrdItemAppointment extends VdmEntity<SrvcOrdItemAppointment>
{

    /**
     * Selector for all available fields of SrvcOrdItemAppointment.
     *
     */
    public final static SrvcOrdItemAppointmentSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServiceOrder</b>
     * </p>
     *
     * @return Transaction ID
     */
    @Key
    @SerializedName( "ServiceOrder" )
    @JsonProperty( "ServiceOrder" )
    @Nullable
    @ODataField( odataName = "ServiceOrder" )
    private String serviceOrder;
    /**
     * Use with available fluent helpers to apply the <b>ServiceOrder</b> field to query operations.
     *
     */
    public final static SrvcOrdItemAppointmentField<String> SERVICE_ORDER =
        new SrvcOrdItemAppointmentField<String>("ServiceOrder");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ServiceOrderItem</b>
     * </p>
     *
     * @return Shortened Item Number in Document
     */
    @Key
    @SerializedName( "ServiceOrderItem" )
    @JsonProperty( "ServiceOrderItem" )
    @Nullable
    @ODataField( odataName = "ServiceOrderItem" )
    private String serviceOrderItem;
    /**
     * Use with available fluent helpers to apply the <b>ServiceOrderItem</b> field to query operations.
     *
     */
    public final static SrvcOrdItemAppointmentField<String> SERVICE_ORDER_ITEM =
        new SrvcOrdItemAppointmentField<String>("ServiceOrderItem");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>SrvcDocAppointmentType</b>
     * </p>
     *
     * @return Technical Date Type Name
     */
    @Key
    @SerializedName( "SrvcDocAppointmentType" )
    @JsonProperty( "SrvcDocAppointmentType" )
    @Nullable
    @ODataField( odataName = "SrvcDocAppointmentType" )
    private String srvcDocAppointmentType;
    /**
     * Use with available fluent helpers to apply the <b>SrvcDocAppointmentType</b> field to query operations.
     *
     */
    public final static SrvcOrdItemAppointmentField<String> SRVC_DOC_APPOINTMENT_TYPE =
        new SrvcOrdItemAppointmentField<String>("SrvcDocAppointmentType");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>SrvcDocApptStartDateTime</b>
     * </p>
     *
     * @return Time Stamp (UTC) of Start Time of Appointment
     */
    @SerializedName( "SrvcDocApptStartDateTime" )
    @JsonProperty( "SrvcDocApptStartDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "SrvcDocApptStartDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime srvcDocApptStartDateTime;
    /**
     * Use with available fluent helpers to apply the <b>SrvcDocApptStartDateTime</b> field to query operations.
     *
     */
    public final static SrvcOrdItemAppointmentField<ZonedDateTime> SRVC_DOC_APPT_START_DATE_TIME =
        new SrvcOrdItemAppointmentField<ZonedDateTime>("SrvcDocApptStartDateTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>SrvcDocApptEndDateTime</b>
     * </p>
     *
     * @return Time stamp of end of appointment
     */
    @SerializedName( "SrvcDocApptEndDateTime" )
    @JsonProperty( "SrvcDocApptEndDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "SrvcDocApptEndDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime srvcDocApptEndDateTime;
    /**
     * Use with available fluent helpers to apply the <b>SrvcDocApptEndDateTime</b> field to query operations.
     *
     */
    public final static SrvcOrdItemAppointmentField<ZonedDateTime> SRVC_DOC_APPT_END_DATE_TIME =
        new SrvcOrdItemAppointmentField<ZonedDateTime>("SrvcDocApptEndDateTime");

    @Nonnull
    @Override
    public Class<SrvcOrdItemAppointment> getType()
    {
        return SrvcOrdItemAppointment.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServiceOrder</b>
     * </p>
     *
     * @param serviceOrder
     *            Transaction ID
     */
    public void setServiceOrder( @Nullable final String serviceOrder )
    {
        rememberChangedField("ServiceOrder", this.serviceOrder);
        this.serviceOrder = serviceOrder;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ServiceOrderItem</b>
     * </p>
     *
     * @param serviceOrderItem
     *            Shortened Item Number in Document
     */
    public void setServiceOrderItem( @Nullable final String serviceOrderItem )
    {
        rememberChangedField("ServiceOrderItem", this.serviceOrderItem);
        this.serviceOrderItem = serviceOrderItem;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>SrvcDocAppointmentType</b>
     * </p>
     *
     * @param srvcDocAppointmentType
     *            Technical Date Type Name
     */
    public void setSrvcDocAppointmentType( @Nullable final String srvcDocAppointmentType )
    {
        rememberChangedField("SrvcDocAppointmentType", this.srvcDocAppointmentType);
        this.srvcDocAppointmentType = srvcDocAppointmentType;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>SrvcDocApptStartDateTime</b>
     * </p>
     *
     * @param srvcDocApptStartDateTime
     *            Time Stamp (UTC) of Start Time of Appointment
     */
    public void setSrvcDocApptStartDateTime( @Nullable final ZonedDateTime srvcDocApptStartDateTime )
    {
        rememberChangedField("SrvcDocApptStartDateTime", this.srvcDocApptStartDateTime);
        this.srvcDocApptStartDateTime = srvcDocApptStartDateTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>SrvcDocApptEndDateTime</b>
     * </p>
     *
     * @param srvcDocApptEndDateTime
     *            Time stamp of end of appointment
     */
    public void setSrvcDocApptEndDateTime( @Nullable final ZonedDateTime srvcDocApptEndDateTime )
    {
        rememberChangedField("SrvcDocApptEndDateTime", this.srvcDocApptEndDateTime);
        this.srvcDocApptEndDateTime = srvcDocApptEndDateTime;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_SrvcOrdItemAppointment";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ServiceOrder", getServiceOrder());
        result.put("ServiceOrderItem", getServiceOrderItem());
        result.put("SrvcDocAppointmentType", getSrvcDocAppointmentType());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ServiceOrder", getServiceOrder());
        values.put("ServiceOrderItem", getServiceOrderItem());
        values.put("SrvcDocAppointmentType", getSrvcDocAppointmentType());
        values.put("SrvcDocApptStartDateTime", getSrvcDocApptStartDateTime());
        values.put("SrvcDocApptEndDateTime", getSrvcDocApptEndDateTime());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ServiceOrder") ) {
                final Object value = values.remove("ServiceOrder");
                if( (value == null) || (!value.equals(getServiceOrder())) ) {
                    setServiceOrder(((String) value));
                }
            }
            if( values.containsKey("ServiceOrderItem") ) {
                final Object value = values.remove("ServiceOrderItem");
                if( (value == null) || (!value.equals(getServiceOrderItem())) ) {
                    setServiceOrderItem(((String) value));
                }
            }
            if( values.containsKey("SrvcDocAppointmentType") ) {
                final Object value = values.remove("SrvcDocAppointmentType");
                if( (value == null) || (!value.equals(getSrvcDocAppointmentType())) ) {
                    setSrvcDocAppointmentType(((String) value));
                }
            }
            if( values.containsKey("SrvcDocApptStartDateTime") ) {
                final Object value = values.remove("SrvcDocApptStartDateTime");
                if( (value == null) || (!value.equals(getSrvcDocApptStartDateTime())) ) {
                    setSrvcDocApptStartDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("SrvcDocApptEndDateTime") ) {
                final Object value = values.remove("SrvcDocApptEndDateTime");
                if( (value == null) || (!value.equals(getSrvcDocApptEndDateTime())) ) {
                    setSrvcDocApptEndDateTime(((ZonedDateTime) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> SrvcOrdItemAppointmentField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SrvcOrdItemAppointmentField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SrvcOrdItemAppointmentField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SrvcOrdItemAppointmentField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ServiceOrderService.DEFAULT_SERVICE_PATH);
    }

}
