/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.field.SrvcOrdItmPartnerField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.link.SrvcOrdItmPartnerOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.selectable.SrvcOrdItmPartnerSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Service Order Item Partner
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_SrvcOrdItmPartnerType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SrvcOrdItmPartner extends VdmEntity<SrvcOrdItmPartner>
{

    /**
     * Selector for all available fields of SrvcOrdItmPartner.
     *
     */
    public final static SrvcOrdItmPartnerSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServiceOrder</b>
     * </p>
     *
     * @return Transaction ID
     */
    @Key
    @SerializedName( "ServiceOrder" )
    @JsonProperty( "ServiceOrder" )
    @Nullable
    @ODataField( odataName = "ServiceOrder" )
    private String serviceOrder;
    /**
     * Use with available fluent helpers to apply the <b>ServiceOrder</b> field to query operations.
     *
     */
    public final static SrvcOrdItmPartnerField<String> SERVICE_ORDER =
        new SrvcOrdItmPartnerField<String>("ServiceOrder");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ServiceOrderItem</b>
     * </p>
     *
     * @return Shortened Item Number in Document
     */
    @Key
    @SerializedName( "ServiceOrderItem" )
    @JsonProperty( "ServiceOrderItem" )
    @Nullable
    @ODataField( odataName = "ServiceOrderItem" )
    private String serviceOrderItem;
    /**
     * Use with available fluent helpers to apply the <b>ServiceOrderItem</b> field to query operations.
     *
     */
    public final static SrvcOrdItmPartnerField<String> SERVICE_ORDER_ITEM =
        new SrvcOrdItmPartnerField<String>("ServiceOrderItem");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>CustMgmtPartnerFunction</b>
     * </p>
     *
     * @return The custMgmtPartnerFunction contained in this entity.
     */
    @Key
    @SerializedName( "CustMgmtPartnerFunction" )
    @JsonProperty( "CustMgmtPartnerFunction" )
    @Nullable
    @ODataField( odataName = "CustMgmtPartnerFunction" )
    private String custMgmtPartnerFunction;
    /**
     * Use with available fluent helpers to apply the <b>CustMgmtPartnerFunction</b> field to query operations.
     *
     */
    public final static SrvcOrdItmPartnerField<String> CUST_MGMT_PARTNER_FUNCTION =
        new SrvcOrdItmPartnerField<String>("CustMgmtPartnerFunction");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CustMgmtBusinessPartner</b>
     * </p>
     *
     * @return Business Partner Number
     */
    @Key
    @SerializedName( "CustMgmtBusinessPartner" )
    @JsonProperty( "CustMgmtBusinessPartner" )
    @Nullable
    @ODataField( odataName = "CustMgmtBusinessPartner" )
    private String custMgmtBusinessPartner;
    /**
     * Use with available fluent helpers to apply the <b>CustMgmtBusinessPartner</b> field to query operations.
     *
     */
    public final static SrvcOrdItmPartnerField<String> CUST_MGMT_BUSINESS_PARTNER =
        new SrvcOrdItmPartnerField<String>("CustMgmtBusinessPartner");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CustMgmtPartnerIsMainPartner</b>
     * </p>
     *
     * @return Main Partner (For Ambiguous Partner Functions)
     */
    @SerializedName( "CustMgmtPartnerIsMainPartner" )
    @JsonProperty( "CustMgmtPartnerIsMainPartner" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "CustMgmtPartnerIsMainPartner" )
    private Boolean custMgmtPartnerIsMainPartner;
    /**
     * Use with available fluent helpers to apply the <b>CustMgmtPartnerIsMainPartner</b> field to query operations.
     *
     */
    public final static SrvcOrdItmPartnerField<Boolean> CUST_MGMT_PARTNER_IS_MAIN_PARTNER =
        new SrvcOrdItmPartnerField<Boolean>("CustMgmtPartnerIsMainPartner");
    /**
     * Navigation property <b>to_Address</b> for <b>SrvcOrdItmPartner</b> to single <b>SrvcOrdItmPartnerAddress</b>.
     *
     */
    @SerializedName( "to_Address" )
    @JsonProperty( "to_Address" )
    @ODataField( odataName = "to_Address" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private SrvcOrdItmPartnerAddress toAddress;
    /**
     * Use with available fluent helpers to apply the <b>to_Address</b> navigation property to query operations.
     *
     */
    public final static SrvcOrdItmPartnerOneToOneLink<SrvcOrdItmPartnerAddress> TO_ADDRESS =
        new SrvcOrdItmPartnerOneToOneLink<SrvcOrdItmPartnerAddress>("to_Address");

    @Nonnull
    @Override
    public Class<SrvcOrdItmPartner> getType()
    {
        return SrvcOrdItmPartner.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServiceOrder</b>
     * </p>
     *
     * @param serviceOrder
     *            Transaction ID
     */
    public void setServiceOrder( @Nullable final String serviceOrder )
    {
        rememberChangedField("ServiceOrder", this.serviceOrder);
        this.serviceOrder = serviceOrder;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ServiceOrderItem</b>
     * </p>
     *
     * @param serviceOrderItem
     *            Shortened Item Number in Document
     */
    public void setServiceOrderItem( @Nullable final String serviceOrderItem )
    {
        rememberChangedField("ServiceOrderItem", this.serviceOrderItem);
        this.serviceOrderItem = serviceOrderItem;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>CustMgmtPartnerFunction</b>
     * </p>
     *
     * @param custMgmtPartnerFunction
     *            The custMgmtPartnerFunction to set.
     */
    public void setCustMgmtPartnerFunction( @Nullable final String custMgmtPartnerFunction )
    {
        rememberChangedField("CustMgmtPartnerFunction", this.custMgmtPartnerFunction);
        this.custMgmtPartnerFunction = custMgmtPartnerFunction;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CustMgmtBusinessPartner</b>
     * </p>
     *
     * @param custMgmtBusinessPartner
     *            Business Partner Number
     */
    public void setCustMgmtBusinessPartner( @Nullable final String custMgmtBusinessPartner )
    {
        rememberChangedField("CustMgmtBusinessPartner", this.custMgmtBusinessPartner);
        this.custMgmtBusinessPartner = custMgmtBusinessPartner;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CustMgmtPartnerIsMainPartner</b>
     * </p>
     *
     * @param custMgmtPartnerIsMainPartner
     *            Main Partner (For Ambiguous Partner Functions)
     */
    public void setCustMgmtPartnerIsMainPartner( @Nullable final Boolean custMgmtPartnerIsMainPartner )
    {
        rememberChangedField("CustMgmtPartnerIsMainPartner", this.custMgmtPartnerIsMainPartner);
        this.custMgmtPartnerIsMainPartner = custMgmtPartnerIsMainPartner;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_SrvcOrdItmPartner";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ServiceOrder", getServiceOrder());
        result.put("ServiceOrderItem", getServiceOrderItem());
        result.put("CustMgmtPartnerFunction", getCustMgmtPartnerFunction());
        result.put("CustMgmtBusinessPartner", getCustMgmtBusinessPartner());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ServiceOrder", getServiceOrder());
        values.put("ServiceOrderItem", getServiceOrderItem());
        values.put("CustMgmtPartnerFunction", getCustMgmtPartnerFunction());
        values.put("CustMgmtBusinessPartner", getCustMgmtBusinessPartner());
        values.put("CustMgmtPartnerIsMainPartner", getCustMgmtPartnerIsMainPartner());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ServiceOrder") ) {
                final Object value = values.remove("ServiceOrder");
                if( (value == null) || (!value.equals(getServiceOrder())) ) {
                    setServiceOrder(((String) value));
                }
            }
            if( values.containsKey("ServiceOrderItem") ) {
                final Object value = values.remove("ServiceOrderItem");
                if( (value == null) || (!value.equals(getServiceOrderItem())) ) {
                    setServiceOrderItem(((String) value));
                }
            }
            if( values.containsKey("CustMgmtPartnerFunction") ) {
                final Object value = values.remove("CustMgmtPartnerFunction");
                if( (value == null) || (!value.equals(getCustMgmtPartnerFunction())) ) {
                    setCustMgmtPartnerFunction(((String) value));
                }
            }
            if( values.containsKey("CustMgmtBusinessPartner") ) {
                final Object value = values.remove("CustMgmtBusinessPartner");
                if( (value == null) || (!value.equals(getCustMgmtBusinessPartner())) ) {
                    setCustMgmtBusinessPartner(((String) value));
                }
            }
            if( values.containsKey("CustMgmtPartnerIsMainPartner") ) {
                final Object value = values.remove("CustMgmtPartnerIsMainPartner");
                if( (value == null) || (!value.equals(getCustMgmtPartnerIsMainPartner())) ) {
                    setCustMgmtPartnerIsMainPartner(((Boolean) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_Address") ) {
                final Object value = (values).remove("to_Address");
                if( value instanceof Map ) {
                    if( toAddress == null ) {
                        toAddress = new SrvcOrdItmPartnerAddress();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toAddress.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> SrvcOrdItmPartnerField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SrvcOrdItmPartnerField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SrvcOrdItmPartnerField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SrvcOrdItmPartnerField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ServiceOrderService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toAddress != null ) {
            (values).put("to_Address", toAddress);
        }
        return values;
    }

    /**
     * Fetches the <b>SrvcOrdItmPartnerAddress</b> entity (one to one) associated with this entity. This corresponds to
     * the OData navigation property <b>to_Address</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>SrvcOrdItmPartnerAddress</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SrvcOrdItmPartnerAddress fetchAddress()
    {
        return fetchFieldAsSingle("to_Address", SrvcOrdItmPartnerAddress.class);
    }

    /**
     * Retrieval of associated <b>SrvcOrdItmPartnerAddress</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_Address</b>.
     * <p>
     * If the navigation property <b>to_Address</b> of a queried <b>SrvcOrdItmPartner</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SrvcOrdItmPartnerAddress</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SrvcOrdItmPartnerAddress getAddressOrFetch()
    {
        if( toAddress == null ) {
            toAddress = fetchAddress();
        }
        return toAddress;
    }

    /**
     * Retrieval of associated <b>SrvcOrdItmPartnerAddress</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_Address</b>.
     * <p>
     * If the navigation property for an entity <b>SrvcOrdItmPartner</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Address</b> is already loaded, the result will contain
     *         the <b>SrvcOrdItmPartnerAddress</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<SrvcOrdItmPartnerAddress> getAddressIfPresent()
    {
        return Option.of(toAddress);
    }

    /**
     * Overwrites the associated <b>SrvcOrdItmPartnerAddress</b> entity for the loaded navigation property
     * <b>to_Address</b>.
     *
     * @param value
     *            New <b>SrvcOrdItmPartnerAddress</b> entity.
     */
    public void setAddress( final SrvcOrdItmPartnerAddress value )
    {
        toAddress = value;
    }

    /**
     * Helper class to allow for fluent creation of SrvcOrdItmPartner instances.
     *
     */
    public final static class SrvcOrdItmPartnerBuilder
    {

        private SrvcOrdItmPartnerAddress toAddress;

        private SrvcOrdItmPartner.SrvcOrdItmPartnerBuilder toAddress( final SrvcOrdItmPartnerAddress value )
        {
            toAddress = value;
            return this;
        }

        /**
         * Navigation property <b>to_Address</b> for <b>SrvcOrdItmPartner</b> to single <b>SrvcOrdItmPartnerAddress</b>.
         *
         * @param value
         *            The SrvcOrdItmPartnerAddress to build this SrvcOrdItmPartner with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SrvcOrdItmPartner.SrvcOrdItmPartnerBuilder address( final SrvcOrdItmPartnerAddress value )
        {
            return toAddress(value);
        }

    }

}
