/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.selectable.SrvcOrdPartnerAddressSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdPartnerAddress SrvcOrdPartnerAddress}
 * entity using key fields. This fluent helper allows methods which modify the underlying query to be called before
 * executing the query itself.
 *
 */
public class SrvcOrdPartnerAddressByKeyFluentHelper
    extends
    FluentHelperByKey<SrvcOrdPartnerAddressByKeyFluentHelper, SrvcOrdPartnerAddress, SrvcOrdPartnerAddressSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdPartnerAddress
     * SrvcOrdPartnerAddress} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code SrvcOrdPartnerAddress}
     * @param custMgmtBusinessPartner
     *            Business Partner Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param custMgmtPartnerFunction
     *
     * @param servicePath
     *            Service path to be used to fetch a single {@code SrvcOrdPartnerAddress}
     * @param serviceOrder
     *            Transaction ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     */
    public SrvcOrdPartnerAddressByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String serviceOrder,
        final String custMgmtPartnerFunction,
        final String custMgmtBusinessPartner )
    {
        super(servicePath, entityCollection);
        this.key.put("ServiceOrder", serviceOrder);
        this.key.put("CustMgmtPartnerFunction", custMgmtPartnerFunction);
        this.key.put("CustMgmtBusinessPartner", custMgmtBusinessPartner);
    }

    @Override
    @Nonnull
    protected Class<SrvcOrdPartnerAddress> getEntityClass()
    {
        return SrvcOrdPartnerAddress.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
