/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link ServiceOrderServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.ServiceOrderService ServiceOrderService}, allowing you to
 * create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultServiceOrderServiceBatch
    extends
    BatchFluentHelperBasic<ServiceOrderServiceBatch, ServiceOrderServiceBatchChangeSet>
    implements
    ServiceOrderServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ServiceOrderService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultServiceOrderServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultServiceOrderServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ServiceOrderService service )
    {
        this(service, com.sap.cloud.sdk.s4hana.datamodel.odata.services.ServiceOrderService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultServiceOrderServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultServiceOrderServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ServiceOrderService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultServiceOrderServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public ServiceOrderServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultServiceOrderServiceBatchChangeSet(this, service);
    }

}
