/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrdItemUserStatus;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrdUserStatus;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrder;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderDefect;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemPriceElement;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemRefObject;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderPersonResp;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderPriceElement;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderRefObject;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdAppointment;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdDuration;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItemAppointment;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItemDuration;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItmPartner;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItmPartnerAddress;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItmProdRefObject;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdPartner;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdPartnerAddress;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdProdRefObject;

/**
 * Implementation of the {@link ServiceOrderServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.ServiceOrderService ServiceOrderService}.
 *
 */
public class DefaultServiceOrderServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<ServiceOrderServiceBatch, ServiceOrderServiceBatchChangeSet>
    implements
    ServiceOrderServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ServiceOrderService service;

    @SuppressWarnings( "deprecation" )
    DefaultServiceOrderServiceBatchChangeSet(
        @Nonnull final DefaultServiceOrderServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ServiceOrderService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultServiceOrderServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public ServiceOrderServiceBatchChangeSet createServiceOrder( @Nonnull final ServiceOrder serviceOrder )
    {
        return addRequestCreate(service::createServiceOrder, serviceOrder);
    }

    @Nonnull
    @Override
    public ServiceOrderServiceBatchChangeSet updateServiceOrder( @Nonnull final ServiceOrder serviceOrder )
    {
        return addRequestUpdate(service::updateServiceOrder, serviceOrder);
    }

    @Nonnull
    @Override
    public ServiceOrderServiceBatchChangeSet createServiceOrderDefect(
        @Nonnull final ServiceOrderDefect serviceOrderDefect )
    {
        return addRequestCreate(service::createServiceOrderDefect, serviceOrderDefect);
    }

    @Nonnull
    @Override
    public ServiceOrderServiceBatchChangeSet updateServiceOrderDefect(
        @Nonnull final ServiceOrderDefect serviceOrderDefect )
    {
        return addRequestUpdate(service::updateServiceOrderDefect, serviceOrderDefect);
    }

    @Nonnull
    @Override
    public ServiceOrderServiceBatchChangeSet deleteServiceOrderDefect(
        @Nonnull final ServiceOrderDefect serviceOrderDefect )
    {
        return addRequestDelete(service::deleteServiceOrderDefect, serviceOrderDefect);
    }

    @Nonnull
    @Override
    public ServiceOrderServiceBatchChangeSet createServiceOrderItem( @Nonnull final ServiceOrderItem serviceOrderItem )
    {
        return addRequestCreate(service::createServiceOrderItem, serviceOrderItem);
    }

    @Nonnull
    @Override
    public ServiceOrderServiceBatchChangeSet updateServiceOrderItem( @Nonnull final ServiceOrderItem serviceOrderItem )
    {
        return addRequestUpdate(service::updateServiceOrderItem, serviceOrderItem);
    }

    @Nonnull
    @Override
    public ServiceOrderServiceBatchChangeSet deleteServiceOrderItem( @Nonnull final ServiceOrderItem serviceOrderItem )
    {
        return addRequestDelete(service::deleteServiceOrderItem, serviceOrderItem);
    }

    @Nonnull
    @Override
    public ServiceOrderServiceBatchChangeSet createServiceOrderItemPriceElement(
        @Nonnull final ServiceOrderItemPriceElement serviceOrderItemPriceElement )
    {
        return addRequestCreate(service::createServiceOrderItemPriceElement, serviceOrderItemPriceElement);
    }

    @Nonnull
    @Override
    public ServiceOrderServiceBatchChangeSet updateServiceOrderItemPriceElement(
        @Nonnull final ServiceOrderItemPriceElement serviceOrderItemPriceElement )
    {
        return addRequestUpdate(service::updateServiceOrderItemPriceElement, serviceOrderItemPriceElement);
    }

    @Nonnull
    @Override
    public ServiceOrderServiceBatchChangeSet createServiceOrderItemRefObject(
        @Nonnull final ServiceOrderItemRefObject serviceOrderItemRefObject )
    {
        return addRequestCreate(service::createServiceOrderItemRefObject, serviceOrderItemRefObject);
    }

    @Nonnull
    @Override
    public ServiceOrderServiceBatchChangeSet deleteServiceOrderItemRefObject(
        @Nonnull final ServiceOrderItemRefObject serviceOrderItemRefObject )
    {
        return addRequestDelete(service::deleteServiceOrderItemRefObject, serviceOrderItemRefObject);
    }

    @Nonnull
    @Override
    public ServiceOrderServiceBatchChangeSet createServiceOrderItemText(
        @Nonnull final ServiceOrderItemText serviceOrderItemText )
    {
        return addRequestCreate(service::createServiceOrderItemText, serviceOrderItemText);
    }

    @Nonnull
    @Override
    public ServiceOrderServiceBatchChangeSet updateServiceOrderItemText(
        @Nonnull final ServiceOrderItemText serviceOrderItemText )
    {
        return addRequestUpdate(service::updateServiceOrderItemText, serviceOrderItemText);
    }

    @Nonnull
    @Override
    public ServiceOrderServiceBatchChangeSet deleteServiceOrderItemText(
        @Nonnull final ServiceOrderItemText serviceOrderItemText )
    {
        return addRequestDelete(service::deleteServiceOrderItemText, serviceOrderItemText);
    }

    @Nonnull
    @Override
    public ServiceOrderServiceBatchChangeSet createServiceOrderPersonResp(
        @Nonnull final ServiceOrderPersonResp serviceOrderPersonResp )
    {
        return addRequestCreate(service::createServiceOrderPersonResp, serviceOrderPersonResp);
    }

    @Nonnull
    @Override
    public ServiceOrderServiceBatchChangeSet updateServiceOrderPersonResp(
        @Nonnull final ServiceOrderPersonResp serviceOrderPersonResp )
    {
        return addRequestUpdate(service::updateServiceOrderPersonResp, serviceOrderPersonResp);
    }

    @Nonnull
    @Override
    public ServiceOrderServiceBatchChangeSet deleteServiceOrderPersonResp(
        @Nonnull final ServiceOrderPersonResp serviceOrderPersonResp )
    {
        return addRequestDelete(service::deleteServiceOrderPersonResp, serviceOrderPersonResp);
    }

    @Nonnull
    @Override
    public ServiceOrderServiceBatchChangeSet createServiceOrderPriceElement(
        @Nonnull final ServiceOrderPriceElement serviceOrderPriceElement )
    {
        return addRequestCreate(service::createServiceOrderPriceElement, serviceOrderPriceElement);
    }

    @Nonnull
    @Override
    public ServiceOrderServiceBatchChangeSet updateServiceOrderPriceElement(
        @Nonnull final ServiceOrderPriceElement serviceOrderPriceElement )
    {
        return addRequestUpdate(service::updateServiceOrderPriceElement, serviceOrderPriceElement);
    }

    @Nonnull
    @Override
    public ServiceOrderServiceBatchChangeSet createServiceOrderRefObject(
        @Nonnull final ServiceOrderRefObject serviceOrderRefObject )
    {
        return addRequestCreate(service::createServiceOrderRefObject, serviceOrderRefObject);
    }

    @Nonnull
    @Override
    public ServiceOrderServiceBatchChangeSet deleteServiceOrderRefObject(
        @Nonnull final ServiceOrderRefObject serviceOrderRefObject )
    {
        return addRequestDelete(service::deleteServiceOrderRefObject, serviceOrderRefObject);
    }

    @Nonnull
    @Override
    public ServiceOrderServiceBatchChangeSet createServiceOrderText( @Nonnull final ServiceOrderText serviceOrderText )
    {
        return addRequestCreate(service::createServiceOrderText, serviceOrderText);
    }

    @Nonnull
    @Override
    public ServiceOrderServiceBatchChangeSet updateServiceOrderText( @Nonnull final ServiceOrderText serviceOrderText )
    {
        return addRequestUpdate(service::updateServiceOrderText, serviceOrderText);
    }

    @Nonnull
    @Override
    public ServiceOrderServiceBatchChangeSet deleteServiceOrderText( @Nonnull final ServiceOrderText serviceOrderText )
    {
        return addRequestDelete(service::deleteServiceOrderText, serviceOrderText);
    }

    @Nonnull
    @Override
    public ServiceOrderServiceBatchChangeSet createServiceOrdItemUserStatus(
        @Nonnull final ServiceOrdItemUserStatus serviceOrdItemUserStatus )
    {
        return addRequestCreate(service::createServiceOrdItemUserStatus, serviceOrdItemUserStatus);
    }

    @Nonnull
    @Override
    public ServiceOrderServiceBatchChangeSet deleteServiceOrdItemUserStatus(
        @Nonnull final ServiceOrdItemUserStatus serviceOrdItemUserStatus )
    {
        return addRequestDelete(service::deleteServiceOrdItemUserStatus, serviceOrdItemUserStatus);
    }

    @Nonnull
    @Override
    public ServiceOrderServiceBatchChangeSet createServiceOrdUserStatus(
        @Nonnull final ServiceOrdUserStatus serviceOrdUserStatus )
    {
        return addRequestCreate(service::createServiceOrdUserStatus, serviceOrdUserStatus);
    }

    @Nonnull
    @Override
    public ServiceOrderServiceBatchChangeSet deleteServiceOrdUserStatus(
        @Nonnull final ServiceOrdUserStatus serviceOrdUserStatus )
    {
        return addRequestDelete(service::deleteServiceOrdUserStatus, serviceOrdUserStatus);
    }

    @Nonnull
    @Override
    public ServiceOrderServiceBatchChangeSet createSrvcOrdAppointment(
        @Nonnull final SrvcOrdAppointment srvcOrdAppointment )
    {
        return addRequestCreate(service::createSrvcOrdAppointment, srvcOrdAppointment);
    }

    @Nonnull
    @Override
    public ServiceOrderServiceBatchChangeSet updateSrvcOrdAppointment(
        @Nonnull final SrvcOrdAppointment srvcOrdAppointment )
    {
        return addRequestUpdate(service::updateSrvcOrdAppointment, srvcOrdAppointment);
    }

    @Nonnull
    @Override
    public ServiceOrderServiceBatchChangeSet createSrvcOrdDuration( @Nonnull final SrvcOrdDuration srvcOrdDuration )
    {
        return addRequestCreate(service::createSrvcOrdDuration, srvcOrdDuration);
    }

    @Nonnull
    @Override
    public ServiceOrderServiceBatchChangeSet updateSrvcOrdDuration( @Nonnull final SrvcOrdDuration srvcOrdDuration )
    {
        return addRequestUpdate(service::updateSrvcOrdDuration, srvcOrdDuration);
    }

    @Nonnull
    @Override
    public ServiceOrderServiceBatchChangeSet createSrvcOrdItemAppointment(
        @Nonnull final SrvcOrdItemAppointment srvcOrdItemAppointment )
    {
        return addRequestCreate(service::createSrvcOrdItemAppointment, srvcOrdItemAppointment);
    }

    @Nonnull
    @Override
    public ServiceOrderServiceBatchChangeSet updateSrvcOrdItemAppointment(
        @Nonnull final SrvcOrdItemAppointment srvcOrdItemAppointment )
    {
        return addRequestUpdate(service::updateSrvcOrdItemAppointment, srvcOrdItemAppointment);
    }

    @Nonnull
    @Override
    public ServiceOrderServiceBatchChangeSet createSrvcOrdItemDuration(
        @Nonnull final SrvcOrdItemDuration srvcOrdItemDuration )
    {
        return addRequestCreate(service::createSrvcOrdItemDuration, srvcOrdItemDuration);
    }

    @Nonnull
    @Override
    public ServiceOrderServiceBatchChangeSet updateSrvcOrdItemDuration(
        @Nonnull final SrvcOrdItemDuration srvcOrdItemDuration )
    {
        return addRequestUpdate(service::updateSrvcOrdItemDuration, srvcOrdItemDuration);
    }

    @Nonnull
    @Override
    public ServiceOrderServiceBatchChangeSet createSrvcOrdItmPartner(
        @Nonnull final SrvcOrdItmPartner srvcOrdItmPartner )
    {
        return addRequestCreate(service::createSrvcOrdItmPartner, srvcOrdItmPartner);
    }

    @Nonnull
    @Override
    public ServiceOrderServiceBatchChangeSet updateSrvcOrdItmPartner(
        @Nonnull final SrvcOrdItmPartner srvcOrdItmPartner )
    {
        return addRequestUpdate(service::updateSrvcOrdItmPartner, srvcOrdItmPartner);
    }

    @Nonnull
    @Override
    public ServiceOrderServiceBatchChangeSet deleteSrvcOrdItmPartner(
        @Nonnull final SrvcOrdItmPartner srvcOrdItmPartner )
    {
        return addRequestDelete(service::deleteSrvcOrdItmPartner, srvcOrdItmPartner);
    }

    @Nonnull
    @Override
    public ServiceOrderServiceBatchChangeSet updateSrvcOrdItmPartnerAddress(
        @Nonnull final SrvcOrdItmPartnerAddress srvcOrdItmPartnerAddress )
    {
        return addRequestUpdate(service::updateSrvcOrdItmPartnerAddress, srvcOrdItmPartnerAddress);
    }

    @Nonnull
    @Override
    public ServiceOrderServiceBatchChangeSet createSrvcOrdItmProdRefObject(
        @Nonnull final SrvcOrdItmProdRefObject srvcOrdItmProdRefObject )
    {
        return addRequestCreate(service::createSrvcOrdItmProdRefObject, srvcOrdItmProdRefObject);
    }

    @Nonnull
    @Override
    public ServiceOrderServiceBatchChangeSet deleteSrvcOrdItmProdRefObject(
        @Nonnull final SrvcOrdItmProdRefObject srvcOrdItmProdRefObject )
    {
        return addRequestDelete(service::deleteSrvcOrdItmProdRefObject, srvcOrdItmProdRefObject);
    }

    @Nonnull
    @Override
    public ServiceOrderServiceBatchChangeSet createSrvcOrdPartner( @Nonnull final SrvcOrdPartner srvcOrdPartner )
    {
        return addRequestCreate(service::createSrvcOrdPartner, srvcOrdPartner);
    }

    @Nonnull
    @Override
    public ServiceOrderServiceBatchChangeSet updateSrvcOrdPartner( @Nonnull final SrvcOrdPartner srvcOrdPartner )
    {
        return addRequestUpdate(service::updateSrvcOrdPartner, srvcOrdPartner);
    }

    @Nonnull
    @Override
    public ServiceOrderServiceBatchChangeSet deleteSrvcOrdPartner( @Nonnull final SrvcOrdPartner srvcOrdPartner )
    {
        return addRequestDelete(service::deleteSrvcOrdPartner, srvcOrdPartner);
    }

    @Nonnull
    @Override
    public ServiceOrderServiceBatchChangeSet updateSrvcOrdPartnerAddress(
        @Nonnull final SrvcOrdPartnerAddress srvcOrdPartnerAddress )
    {
        return addRequestUpdate(service::updateSrvcOrdPartnerAddress, srvcOrdPartnerAddress);
    }

    @Nonnull
    @Override
    public ServiceOrderServiceBatchChangeSet createSrvcOrdProdRefObject(
        @Nonnull final SrvcOrdProdRefObject srvcOrdProdRefObject )
    {
        return addRequestCreate(service::createSrvcOrdProdRefObject, srvcOrdProdRefObject);
    }

    @Nonnull
    @Override
    public ServiceOrderServiceBatchChangeSet deleteSrvcOrdProdRefObject(
        @Nonnull final SrvcOrdProdRefObject srvcOrdProdRefObject )
    {
        return addRequestDelete(service::deleteSrvcOrdProdRefObject, srvcOrdProdRefObject);
    }

}
