/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchChangeSet;
import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchEndChangeSet;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrdItemUserStatus;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrdUserStatus;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrder;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderDefect;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemPriceElement;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemRefObject;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderPersonResp;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderPriceElement;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderRefObject;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdAppointment;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdDuration;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItemAppointment;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItemDuration;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItmPartner;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItmPartnerAddress;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItmProdRefObject;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdPartner;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdPartnerAddress;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdProdRefObject;

/**
 * This interface enables you to combine multiple operations into one change set. For further information have a look
 * into the {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.ServiceOrderService ServiceOrderService}.
 *
 */
public interface ServiceOrderServiceBatchChangeSet
    extends
    FluentHelperBatchChangeSet<ServiceOrderServiceBatchChangeSet>,
    FluentHelperBatchEndChangeSet<ServiceOrderServiceBatch>
{

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrder ServiceOrder}
     * entity and save it to the S/4HANA system.
     *
     * @param serviceOrder
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrder ServiceOrder}
     *            entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceOrderServiceBatchChangeSet createServiceOrder( @Nonnull final ServiceOrder serviceOrder );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrder
     * ServiceOrder} entity and save it to the S/4HANA system.
     *
     * @param serviceOrder
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrder ServiceOrder}
     *            entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceOrderServiceBatchChangeSet updateServiceOrder( @Nonnull final ServiceOrder serviceOrder );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderDefect
     * ServiceOrderDefect} entity and save it to the S/4HANA system.
     *
     * @param serviceOrderDefect
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderDefect
     *            ServiceOrderDefect} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceOrderServiceBatchChangeSet createServiceOrderDefect( @Nonnull final ServiceOrderDefect serviceOrderDefect );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderDefect
     * ServiceOrderDefect} entity and save it to the S/4HANA system.
     *
     * @param serviceOrderDefect
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderDefect
     *            ServiceOrderDefect} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceOrderServiceBatchChangeSet updateServiceOrderDefect( @Nonnull final ServiceOrderDefect serviceOrderDefect );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderDefect
     * ServiceOrderDefect} entity in the S/4HANA system.
     *
     * @param serviceOrderDefect
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderDefect
     *            ServiceOrderDefect} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceOrderServiceBatchChangeSet deleteServiceOrderDefect( @Nonnull final ServiceOrderDefect serviceOrderDefect );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItem
     * ServiceOrderItem} entity and save it to the S/4HANA system.
     *
     * @param serviceOrderItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItem
     *            ServiceOrderItem} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceOrderServiceBatchChangeSet createServiceOrderItem( @Nonnull final ServiceOrderItem serviceOrderItem );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItem
     * ServiceOrderItem} entity and save it to the S/4HANA system.
     *
     * @param serviceOrderItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItem
     *            ServiceOrderItem} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceOrderServiceBatchChangeSet updateServiceOrderItem( @Nonnull final ServiceOrderItem serviceOrderItem );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItem
     * ServiceOrderItem} entity in the S/4HANA system.
     *
     * @param serviceOrderItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItem
     *            ServiceOrderItem} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceOrderServiceBatchChangeSet deleteServiceOrderItem( @Nonnull final ServiceOrderItem serviceOrderItem );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemPriceElement
     * ServiceOrderItemPriceElement} entity and save it to the S/4HANA system.
     *
     * @param serviceOrderItemPriceElement
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemPriceElement
     *            ServiceOrderItemPriceElement} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceOrderServiceBatchChangeSet
        createServiceOrderItemPriceElement( @Nonnull final ServiceOrderItemPriceElement serviceOrderItemPriceElement );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemPriceElement
     * ServiceOrderItemPriceElement} entity and save it to the S/4HANA system.
     *
     * @param serviceOrderItemPriceElement
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemPriceElement
     *            ServiceOrderItemPriceElement} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceOrderServiceBatchChangeSet
        updateServiceOrderItemPriceElement( @Nonnull final ServiceOrderItemPriceElement serviceOrderItemPriceElement );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemRefObject
     * ServiceOrderItemRefObject} entity and save it to the S/4HANA system.
     *
     * @param serviceOrderItemRefObject
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemRefObject
     *            ServiceOrderItemRefObject} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceOrderServiceBatchChangeSet
        createServiceOrderItemRefObject( @Nonnull final ServiceOrderItemRefObject serviceOrderItemRefObject );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemRefObject
     * ServiceOrderItemRefObject} entity in the S/4HANA system.
     *
     * @param serviceOrderItemRefObject
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemRefObject
     *            ServiceOrderItemRefObject} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceOrderServiceBatchChangeSet
        deleteServiceOrderItemRefObject( @Nonnull final ServiceOrderItemRefObject serviceOrderItemRefObject );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemText
     * ServiceOrderItemText} entity and save it to the S/4HANA system.
     *
     * @param serviceOrderItemText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemText
     *            ServiceOrderItemText} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceOrderServiceBatchChangeSet
        createServiceOrderItemText( @Nonnull final ServiceOrderItemText serviceOrderItemText );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemText
     * ServiceOrderItemText} entity and save it to the S/4HANA system.
     *
     * @param serviceOrderItemText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemText
     *            ServiceOrderItemText} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceOrderServiceBatchChangeSet
        updateServiceOrderItemText( @Nonnull final ServiceOrderItemText serviceOrderItemText );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemText
     * ServiceOrderItemText} entity in the S/4HANA system.
     *
     * @param serviceOrderItemText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemText
     *            ServiceOrderItemText} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceOrderServiceBatchChangeSet
        deleteServiceOrderItemText( @Nonnull final ServiceOrderItemText serviceOrderItemText );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderPersonResp
     * ServiceOrderPersonResp} entity and save it to the S/4HANA system.
     *
     * @param serviceOrderPersonResp
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderPersonResp
     *            ServiceOrderPersonResp} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceOrderServiceBatchChangeSet
        createServiceOrderPersonResp( @Nonnull final ServiceOrderPersonResp serviceOrderPersonResp );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderPersonResp
     * ServiceOrderPersonResp} entity and save it to the S/4HANA system.
     *
     * @param serviceOrderPersonResp
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderPersonResp
     *            ServiceOrderPersonResp} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceOrderServiceBatchChangeSet
        updateServiceOrderPersonResp( @Nonnull final ServiceOrderPersonResp serviceOrderPersonResp );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderPersonResp
     * ServiceOrderPersonResp} entity in the S/4HANA system.
     *
     * @param serviceOrderPersonResp
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderPersonResp
     *            ServiceOrderPersonResp} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceOrderServiceBatchChangeSet
        deleteServiceOrderPersonResp( @Nonnull final ServiceOrderPersonResp serviceOrderPersonResp );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderPriceElement
     * ServiceOrderPriceElement} entity and save it to the S/4HANA system.
     *
     * @param serviceOrderPriceElement
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderPriceElement
     *            ServiceOrderPriceElement} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceOrderServiceBatchChangeSet
        createServiceOrderPriceElement( @Nonnull final ServiceOrderPriceElement serviceOrderPriceElement );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderPriceElement
     * ServiceOrderPriceElement} entity and save it to the S/4HANA system.
     *
     * @param serviceOrderPriceElement
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderPriceElement
     *            ServiceOrderPriceElement} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceOrderServiceBatchChangeSet
        updateServiceOrderPriceElement( @Nonnull final ServiceOrderPriceElement serviceOrderPriceElement );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderRefObject
     * ServiceOrderRefObject} entity and save it to the S/4HANA system.
     *
     * @param serviceOrderRefObject
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderRefObject
     *            ServiceOrderRefObject} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceOrderServiceBatchChangeSet
        createServiceOrderRefObject( @Nonnull final ServiceOrderRefObject serviceOrderRefObject );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderRefObject
     * ServiceOrderRefObject} entity in the S/4HANA system.
     *
     * @param serviceOrderRefObject
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderRefObject
     *            ServiceOrderRefObject} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceOrderServiceBatchChangeSet
        deleteServiceOrderRefObject( @Nonnull final ServiceOrderRefObject serviceOrderRefObject );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderText
     * ServiceOrderText} entity and save it to the S/4HANA system.
     *
     * @param serviceOrderText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderText
     *            ServiceOrderText} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceOrderServiceBatchChangeSet createServiceOrderText( @Nonnull final ServiceOrderText serviceOrderText );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderText
     * ServiceOrderText} entity and save it to the S/4HANA system.
     *
     * @param serviceOrderText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderText
     *            ServiceOrderText} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceOrderServiceBatchChangeSet updateServiceOrderText( @Nonnull final ServiceOrderText serviceOrderText );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderText
     * ServiceOrderText} entity in the S/4HANA system.
     *
     * @param serviceOrderText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderText
     *            ServiceOrderText} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceOrderServiceBatchChangeSet deleteServiceOrderText( @Nonnull final ServiceOrderText serviceOrderText );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrdItemUserStatus
     * ServiceOrdItemUserStatus} entity and save it to the S/4HANA system.
     *
     * @param serviceOrdItemUserStatus
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrdItemUserStatus
     *            ServiceOrdItemUserStatus} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceOrderServiceBatchChangeSet
        createServiceOrdItemUserStatus( @Nonnull final ServiceOrdItemUserStatus serviceOrdItemUserStatus );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrdItemUserStatus
     * ServiceOrdItemUserStatus} entity in the S/4HANA system.
     *
     * @param serviceOrdItemUserStatus
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrdItemUserStatus
     *            ServiceOrdItemUserStatus} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceOrderServiceBatchChangeSet
        deleteServiceOrdItemUserStatus( @Nonnull final ServiceOrdItemUserStatus serviceOrdItemUserStatus );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrdUserStatus
     * ServiceOrdUserStatus} entity and save it to the S/4HANA system.
     *
     * @param serviceOrdUserStatus
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrdUserStatus
     *            ServiceOrdUserStatus} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceOrderServiceBatchChangeSet
        createServiceOrdUserStatus( @Nonnull final ServiceOrdUserStatus serviceOrdUserStatus );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrdUserStatus
     * ServiceOrdUserStatus} entity in the S/4HANA system.
     *
     * @param serviceOrdUserStatus
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrdUserStatus
     *            ServiceOrdUserStatus} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceOrderServiceBatchChangeSet
        deleteServiceOrdUserStatus( @Nonnull final ServiceOrdUserStatus serviceOrdUserStatus );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdAppointment
     * SrvcOrdAppointment} entity and save it to the S/4HANA system.
     *
     * @param srvcOrdAppointment
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdAppointment
     *            SrvcOrdAppointment} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceOrderServiceBatchChangeSet createSrvcOrdAppointment( @Nonnull final SrvcOrdAppointment srvcOrdAppointment );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdAppointment
     * SrvcOrdAppointment} entity and save it to the S/4HANA system.
     *
     * @param srvcOrdAppointment
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdAppointment
     *            SrvcOrdAppointment} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceOrderServiceBatchChangeSet updateSrvcOrdAppointment( @Nonnull final SrvcOrdAppointment srvcOrdAppointment );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdDuration
     * SrvcOrdDuration} entity and save it to the S/4HANA system.
     *
     * @param srvcOrdDuration
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdDuration
     *            SrvcOrdDuration} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceOrderServiceBatchChangeSet createSrvcOrdDuration( @Nonnull final SrvcOrdDuration srvcOrdDuration );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdDuration
     * SrvcOrdDuration} entity and save it to the S/4HANA system.
     *
     * @param srvcOrdDuration
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdDuration
     *            SrvcOrdDuration} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceOrderServiceBatchChangeSet updateSrvcOrdDuration( @Nonnull final SrvcOrdDuration srvcOrdDuration );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItemAppointment
     * SrvcOrdItemAppointment} entity and save it to the S/4HANA system.
     *
     * @param srvcOrdItemAppointment
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItemAppointment
     *            SrvcOrdItemAppointment} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceOrderServiceBatchChangeSet
        createSrvcOrdItemAppointment( @Nonnull final SrvcOrdItemAppointment srvcOrdItemAppointment );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItemAppointment
     * SrvcOrdItemAppointment} entity and save it to the S/4HANA system.
     *
     * @param srvcOrdItemAppointment
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItemAppointment
     *            SrvcOrdItemAppointment} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceOrderServiceBatchChangeSet
        updateSrvcOrdItemAppointment( @Nonnull final SrvcOrdItemAppointment srvcOrdItemAppointment );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItemDuration
     * SrvcOrdItemDuration} entity and save it to the S/4HANA system.
     *
     * @param srvcOrdItemDuration
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItemDuration
     *            SrvcOrdItemDuration} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceOrderServiceBatchChangeSet
        createSrvcOrdItemDuration( @Nonnull final SrvcOrdItemDuration srvcOrdItemDuration );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItemDuration
     * SrvcOrdItemDuration} entity and save it to the S/4HANA system.
     *
     * @param srvcOrdItemDuration
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItemDuration
     *            SrvcOrdItemDuration} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceOrderServiceBatchChangeSet
        updateSrvcOrdItemDuration( @Nonnull final SrvcOrdItemDuration srvcOrdItemDuration );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItmPartner
     * SrvcOrdItmPartner} entity and save it to the S/4HANA system.
     *
     * @param srvcOrdItmPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItmPartner
     *            SrvcOrdItmPartner} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceOrderServiceBatchChangeSet createSrvcOrdItmPartner( @Nonnull final SrvcOrdItmPartner srvcOrdItmPartner );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItmPartner
     * SrvcOrdItmPartner} entity and save it to the S/4HANA system.
     *
     * @param srvcOrdItmPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItmPartner
     *            SrvcOrdItmPartner} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceOrderServiceBatchChangeSet updateSrvcOrdItmPartner( @Nonnull final SrvcOrdItmPartner srvcOrdItmPartner );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItmPartner
     * SrvcOrdItmPartner} entity in the S/4HANA system.
     *
     * @param srvcOrdItmPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItmPartner
     *            SrvcOrdItmPartner} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceOrderServiceBatchChangeSet deleteSrvcOrdItmPartner( @Nonnull final SrvcOrdItmPartner srvcOrdItmPartner );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItmPartnerAddress
     * SrvcOrdItmPartnerAddress} entity and save it to the S/4HANA system.
     *
     * @param srvcOrdItmPartnerAddress
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItmPartnerAddress
     *            SrvcOrdItmPartnerAddress} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceOrderServiceBatchChangeSet
        updateSrvcOrdItmPartnerAddress( @Nonnull final SrvcOrdItmPartnerAddress srvcOrdItmPartnerAddress );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItmProdRefObject
     * SrvcOrdItmProdRefObject} entity and save it to the S/4HANA system.
     *
     * @param srvcOrdItmProdRefObject
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItmProdRefObject
     *            SrvcOrdItmProdRefObject} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceOrderServiceBatchChangeSet
        createSrvcOrdItmProdRefObject( @Nonnull final SrvcOrdItmProdRefObject srvcOrdItmProdRefObject );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItmProdRefObject
     * SrvcOrdItmProdRefObject} entity in the S/4HANA system.
     *
     * @param srvcOrdItmProdRefObject
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItmProdRefObject
     *            SrvcOrdItmProdRefObject} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceOrderServiceBatchChangeSet
        deleteSrvcOrdItmProdRefObject( @Nonnull final SrvcOrdItmProdRefObject srvcOrdItmProdRefObject );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdPartner
     * SrvcOrdPartner} entity and save it to the S/4HANA system.
     *
     * @param srvcOrdPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdPartner SrvcOrdPartner}
     *            entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceOrderServiceBatchChangeSet createSrvcOrdPartner( @Nonnull final SrvcOrdPartner srvcOrdPartner );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdPartner
     * SrvcOrdPartner} entity and save it to the S/4HANA system.
     *
     * @param srvcOrdPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdPartner SrvcOrdPartner}
     *            entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceOrderServiceBatchChangeSet updateSrvcOrdPartner( @Nonnull final SrvcOrdPartner srvcOrdPartner );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdPartner
     * SrvcOrdPartner} entity in the S/4HANA system.
     *
     * @param srvcOrdPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdPartner SrvcOrdPartner}
     *            entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceOrderServiceBatchChangeSet deleteSrvcOrdPartner( @Nonnull final SrvcOrdPartner srvcOrdPartner );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdPartnerAddress
     * SrvcOrdPartnerAddress} entity and save it to the S/4HANA system.
     *
     * @param srvcOrdPartnerAddress
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdPartnerAddress
     *            SrvcOrdPartnerAddress} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceOrderServiceBatchChangeSet
        updateSrvcOrdPartnerAddress( @Nonnull final SrvcOrdPartnerAddress srvcOrdPartnerAddress );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdProdRefObject
     * SrvcOrdProdRefObject} entity and save it to the S/4HANA system.
     *
     * @param srvcOrdProdRefObject
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdProdRefObject
     *            SrvcOrdProdRefObject} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceOrderServiceBatchChangeSet
        createSrvcOrdProdRefObject( @Nonnull final SrvcOrdProdRefObject srvcOrdProdRefObject );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdProdRefObject
     * SrvcOrdProdRefObject} entity in the S/4HANA system.
     *
     * @param srvcOrdProdRefObject
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdProdRefObject
     *            SrvcOrdProdRefObject} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceOrderServiceBatchChangeSet
        deleteSrvcOrdProdRefObject( @Nonnull final SrvcOrdProdRefObject srvcOrdProdRefObject );

}
