/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrdItemUserStatus;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrdItemUserStatus
 * ServiceOrdItemUserStatus}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.field.ServiceOrdItemUserStatusField
 * ServiceOrdItemUserStatusField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.link.ServiceOrdItemUserStatusLink
 * ServiceOrdItemUserStatusLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrdItemUserStatus#SERVICE_ORDER
 * SERVICE_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrdItemUserStatus#SERVICE_ORDER_ITEM
 * SERVICE_ORDER_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrdItemUserStatus#SRVC_ORD_ITEM_USER_STATUS
 * SRVC_ORD_ITEM_USER_STATUS}</li>
 * </ul>
 *
 */
public interface ServiceOrdItemUserStatusSelectable extends EntitySelectable<ServiceOrdItemUserStatus>
{

}
