/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrdUserStatus;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrdUserStatus ServiceOrdUserStatus}.
 * This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.field.ServiceOrdUserStatusField
 * ServiceOrdUserStatusField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.link.ServiceOrdUserStatusLink
 * ServiceOrdUserStatusLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrdUserStatus#SERVICE_ORDER
 * SERVICE_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrdUserStatus#SRVC_ORD_USER_STATUS
 * SRVC_ORD_USER_STATUS}</li>
 * </ul>
 *
 */
public interface ServiceOrdUserStatusSelectable extends EntitySelectable<ServiceOrdUserStatus>
{

}
