/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderDefect;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderDefect ServiceOrderDefect}. This
 * interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.field.ServiceOrderDefectField
 * ServiceOrderDefectField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.link.ServiceOrderDefectLink
 * ServiceOrderDefectLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderDefect#SERVICE_ORDER
 * SERVICE_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderDefect#SRVC_DOC_TYPE_DEFECT_CODE_PROF_TYPE
 * SRVC_DOC_TYPE_DEFECT_CODE_PROF_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderDefect#SERVICE_DEFECT_SEQUENCE
 * SERVICE_DEFECT_SEQUENCE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderDefect#SRVC_DOC_TYPE_DEFECT_CODE_PROFILE
 * SRVC_DOC_TYPE_DEFECT_CODE_PROFILE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderDefect#SERVICE_DEFECT_CODE_CATALOG
 * SERVICE_DEFECT_CODE_CATALOG}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderDefect#SERVICE_DEFECT_CODE_GROUP
 * SERVICE_DEFECT_CODE_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderDefect#SERVICE_DEFECT_CODE
 * SERVICE_DEFECT_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderDefect#SERVICE_DEFECT_SCHEMA
 * SERVICE_DEFECT_SCHEMA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderDefect#SERVICE_DEFECT_CATEGORY
 * SERVICE_DEFECT_CATEGORY}</li>
 * </ul>
 *
 */
public interface ServiceOrderDefectSelectable extends EntitySelectable<ServiceOrderDefect>
{

}
