/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItem;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItem ServiceOrderItem}. This
 * interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.field.ServiceOrderItemField
 * ServiceOrderItemField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.link.ServiceOrderItemLink
 * ServiceOrderItemLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItem#SERVICE_ORDER
 * SERVICE_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItem#SERVICE_ORDER_ITEM
 * SERVICE_ORDER_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItem#SERVICE_ORDER_ITEM_UUID
 * SERVICE_ORDER_ITEM_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItem#SERVICE_DOCUMENT_ITEM_CHAR_UUID
 * SERVICE_DOCUMENT_ITEM_CHAR_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItem#SERVICE_ORDER_ITEM_DESCRIPTION
 * SERVICE_ORDER_ITEM_DESCRIPTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItem#SERVICE_OBJECT_TYPE
 * SERVICE_OBJECT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItem#SERVICE_DOCUMENT_ITEM_OBJECT_TYPE
 * SERVICE_DOCUMENT_ITEM_OBJECT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItem#LANGUAGE LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItem#PRODUCT PRODUCT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItem#QUANTITY QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItem#QUANTITY_UNIT
 * QUANTITY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItem#SRVC_ORD_ITM_RESVN_IS_EXISTING
 * SRVC_ORD_ITM_RESVN_IS_EXISTING}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItem#SRVC_ORD_ITEM_RESERVED_QUANTITY
 * SRVC_ORD_ITEM_RESERVED_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItem#SERVICE_DURATION
 * SERVICE_DURATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItem#SERVICE_DURATION_UNIT
 * SERVICE_DURATION_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItem#SERVICE_ORDER_ITEM_CATEGORY
 * SERVICE_ORDER_ITEM_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItem#SERVICE_ORD_ITEM_REJECTION_REASON
 * SERVICE_ORD_ITEM_REJECTION_REASON}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItem#BILLABLE_CONTROL
 * BILLABLE_CONTROL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItem#SOLD_TO_PARTY
 * SOLD_TO_PARTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItem#SHIP_TO_PARTY
 * SHIP_TO_PARTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItem#BILL_TO_PARTY
 * BILL_TO_PARTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItem#PAYER_PARTY
 * PAYER_PARTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItem#CONTACT_PERSON_BUSINESS_PARTNER_ID
 * CONTACT_PERSON_BUSINESS_PARTNER_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItem#PERSON_RESPONSIBLE
 * PERSON_RESPONSIBLE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItem#EXECUTING_SERVICE_EMPLOYEE
 * EXECUTING_SERVICE_EMPLOYEE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItem#SERVICE_PERFORMER
 * SERVICE_PERFORMER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItem#SERVICE_ORDER_ITEM_IS_RELEASED
 * SERVICE_ORDER_ITEM_IS_RELEASED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItem#SERVICE_ORDER_ITEM_IS_COMPLETED
 * SERVICE_ORDER_ITEM_IS_COMPLETED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItem#SERVICE_ORDER_ITEM_IS_REJECTED
 * SERVICE_ORDER_ITEM_IS_REJECTED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItem#REFERENCE_SERVICE_CONTRACT
 * REFERENCE_SERVICE_CONTRACT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItem#REFERENCE_SERVICE_CONTRACT_ITEM
 * REFERENCE_SERVICE_CONTRACT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItem#REF_SERVICE_ORDER_TEMPLATE
 * REF_SERVICE_ORDER_TEMPLATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItem#REF_SERVICE_ORDER_TEMPLATE_ITEM
 * REF_SERVICE_ORDER_TEMPLATE_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItem#REFERENCE_SERVICE_REQUEST
 * REFERENCE_SERVICE_REQUEST}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItem#REFERENCE_SERVICE_REQUEST_ITEM
 * REFERENCE_SERVICE_REQUEST_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItem#PARENT_SERVICE_ORDER_ITEM
 * PARENT_SERVICE_ORDER_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItem#PLANNED_SERVICE_START_DATE_TIME
 * PLANNED_SERVICE_START_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItem#PLANNED_SERVICE_END_DATE_TIME
 * PLANNED_SERVICE_END_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItem#REQUESTED_SERVICE_START_DATE_TIME
 * REQUESTED_SERVICE_START_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItem#REQUESTED_SERVICE_END_DATE_TIME
 * REQUESTED_SERVICE_END_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItem#SRVC_DOC_ITEM_SLA_DUE_BY_DATE_TIME
 * SRVC_DOC_ITEM_SLA_DUE_BY_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItem#ACTUAL_SERVICE_DURATION
 * ACTUAL_SERVICE_DURATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItem#ACTUAL_SERVICE_DURATION_UNIT
 * ACTUAL_SERVICE_DURATION_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItem#SRVC_CONTR_DETN_IS_SPPRSD
 * SRVC_CONTR_DETN_IS_SPPRSD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItem#REFERENCE_SERVICE_ORDER_ITEM
 * REFERENCE_SERVICE_ORDER_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItem#SHIPPING_CONDITION
 * SHIPPING_CONDITION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItem#SRVC_DOC_ITM_PART_REFERENCE_ITEM
 * SRVC_DOC_ITM_PART_REFERENCE_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItem#SRVC_DOC_ITM_APPT_REFERENCE_ITEM
 * SRVC_DOC_ITM_APPT_REFERENCE_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItem#SRVC_DOC_ITM_APPT_REF_OBJECT_UUID
 * SRVC_DOC_ITM_APPT_REF_OBJECT_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItem#SRVC_ORD_ITEM_IS_UNPLANNED
 * SRVC_ORD_ITEM_IS_UNPLANNED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItem#FSM_SERVICE_ACTIVITY
 * FSM_SERVICE_ACTIVITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItem#TIME_SHEET_OVERTIME_CATEGORY
 * TIME_SHEET_OVERTIME_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItem#RESPY_MGMT_SERVICE_TEAM
 * RESPY_MGMT_SERVICE_TEAM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItem#RESPY_MGMT_SERVICE_TEAM_NAME
 * RESPY_MGMT_SERVICE_TEAM_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItem#RESPY_MGMT_GLOBAL_TEAM_ID
 * RESPY_MGMT_GLOBAL_TEAM_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItem#PROFIT_CENTER
 * PROFIT_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItem#SRVC_ORD_ITEM_CREDIT_STATUS
 * SRVC_ORD_ITEM_CREDIT_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItem#SRVC_ORD_ITEM_EXECUTION_STATUS
 * SRVC_ORD_ITEM_EXECUTION_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItem#PAYMENT_TERMS
 * PAYMENT_TERMS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItem#PAYMENT_METHOD
 * PAYMENT_METHOD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItem#SEPA_MANDATE
 * SEPA_MANDATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItem#SRVC_SEPA_MANDATE_RELEVANCE
 * SRVC_SEPA_MANDATE_RELEVANCE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItem#WBS_ELEMENT_EXTERNAL_ID
 * WBS_ELEMENT_EXTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItem#TO_APPOINTMENT
 * TO_APPOINTMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItem#TO_CONFIRMATION
 * TO_CONFIRMATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItem#TO_DURATION
 * TO_DURATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItem#TO_PARTNER
 * TO_PARTNER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItem#TO_PRICING_ELEMENT
 * TO_PRICING_ELEMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItem#TO_PRODUCT_REFERENCE_OBJECT
 * TO_PRODUCT_REFERENCE_OBJECT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItem#TO_REFERENCE_OBJECT
 * TO_REFERENCE_OBJECT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItem#TO_SERVICE_ORDER
 * TO_SERVICE_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItem#TO_SRVC_ORD_ITEM_USER_STATUS
 * TO_SRVC_ORD_ITEM_USER_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItem#TO_TEXT TO_TEXT}</li>
 * </ul>
 *
 */
public interface ServiceOrderItemSelectable extends EntitySelectable<ServiceOrderItem>
{

}
