/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemText;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemText ServiceOrderItemText}.
 * This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.field.ServiceOrderItemTextField
 * ServiceOrderItemTextField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.link.ServiceOrderItemTextLink
 * ServiceOrderItemTextLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemText#SERVICE_ORDER
 * SERVICE_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemText#SERVICE_ORDER_ITEM
 * SERVICE_ORDER_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemText#LANGUAGE
 * LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemText#LONG_TEXT_ID
 * LONG_TEXT_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderItemText#LONG_TEXT
 * LONG_TEXT}</li>
 * </ul>
 *
 */
public interface ServiceOrderItemTextSelectable extends EntitySelectable<ServiceOrderItemText>
{

}
