/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderPersonResp;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderPersonResp
 * ServiceOrderPersonResp}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.field.ServiceOrderPersonRespField
 * ServiceOrderPersonRespField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.link.ServiceOrderPersonRespLink
 * ServiceOrderPersonRespLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderPersonResp#SERVICE_ORDER
 * SERVICE_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderPersonResp#PERSON_RESPONSIBLE
 * PERSON_RESPONSIBLE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.ServiceOrderPersonResp#CUST_MGMT_PARTNER_IS_MAIN_PARTNER
 * CUST_MGMT_PARTNER_IS_MAIN_PARTNER}</li>
 * </ul>
 *
 */
public interface ServiceOrderPersonRespSelectable extends EntitySelectable<ServiceOrderPersonResp>
{

}
