/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdAppointment;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdAppointment SrvcOrdAppointment}. This
 * interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.field.SrvcOrdAppointmentField
 * SrvcOrdAppointmentField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.link.SrvcOrdAppointmentLink
 * SrvcOrdAppointmentLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdAppointment#SERVICE_ORDER
 * SERVICE_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdAppointment#SRVC_DOC_APPOINTMENT_TYPE
 * SRVC_DOC_APPOINTMENT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdAppointment#SRVC_DOC_APPT_START_DATE_TIME
 * SRVC_DOC_APPT_START_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdAppointment#SRVC_DOC_APPT_END_DATE_TIME
 * SRVC_DOC_APPT_END_DATE_TIME}</li>
 * </ul>
 *
 */
public interface SrvcOrdAppointmentSelectable extends EntitySelectable<SrvcOrdAppointment>
{

}
