/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItmPartner;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItmPartner SrvcOrdItmPartner}. This
 * interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.field.SrvcOrdItmPartnerField
 * SrvcOrdItmPartnerField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.link.SrvcOrdItmPartnerLink
 * SrvcOrdItmPartnerLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItmPartner#SERVICE_ORDER
 * SERVICE_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItmPartner#SERVICE_ORDER_ITEM
 * SERVICE_ORDER_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItmPartner#CUST_MGMT_PARTNER_FUNCTION
 * CUST_MGMT_PARTNER_FUNCTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItmPartner#CUST_MGMT_BUSINESS_PARTNER
 * CUST_MGMT_BUSINESS_PARTNER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItmPartner#CUST_MGMT_PARTNER_IS_MAIN_PARTNER
 * CUST_MGMT_PARTNER_IS_MAIN_PARTNER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdItmPartner#TO_ADDRESS
 * TO_ADDRESS}</li>
 * </ul>
 *
 */
public interface SrvcOrdItmPartnerSelectable extends EntitySelectable<SrvcOrdItmPartner>
{

}
