/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdPartnerAddress;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdPartnerAddress SrvcOrdPartnerAddress}.
 * This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.field.SrvcOrdPartnerAddressField
 * SrvcOrdPartnerAddressField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.link.SrvcOrdPartnerAddressLink
 * SrvcOrdPartnerAddressLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdPartnerAddress#SERVICE_ORDER
 * SERVICE_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdPartnerAddress#CUST_MGMT_PARTNER_FUNCTION
 * CUST_MGMT_PARTNER_FUNCTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdPartnerAddress#CUST_MGMT_BUSINESS_PARTNER
 * CUST_MGMT_BUSINESS_PARTNER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdPartnerAddress#ADDRESSEE_FULL_NAME
 * ADDRESSEE_FULL_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdPartnerAddress#CITY_NAME
 * CITY_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdPartnerAddress#CORRESPONDENCE_LANGUAGE
 * CORRESPONDENCE_LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdPartnerAddress#COUNTRY
 * COUNTRY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdPartnerAddress#DISTRICT_NAME
 * DISTRICT_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdPartnerAddress#EMAIL_ADDRESS
 * EMAIL_ADDRESS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdPartnerAddress#FAX_AREA_CODE_SUBSCRIBER_NUMBER
 * FAX_AREA_CODE_SUBSCRIBER_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdPartnerAddress#FAX_EXTENSION_NUMBER
 * FAX_EXTENSION_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdPartnerAddress#FAX_NUMBER_COUNTRY
 * FAX_NUMBER_COUNTRY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdPartnerAddress#FORM_OF_ADDRESS
 * FORM_OF_ADDRESS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdPartnerAddress#HOUSE_NUMBER
 * HOUSE_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdPartnerAddress#MOBILE_NUMBER
 * MOBILE_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdPartnerAddress#MOBILE_PHONE_COUNTRY
 * MOBILE_PHONE_COUNTRY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdPartnerAddress#ORGANIZATION_NAME1
 * ORGANIZATION_NAME1}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdPartnerAddress#ORGANIZATION_NAME2
 * ORGANIZATION_NAME2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdPartnerAddress#ORGANIZATION_NAME3
 * ORGANIZATION_NAME3}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdPartnerAddress#ORGANIZATION_NAME4
 * ORGANIZATION_NAME4}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdPartnerAddress#PERSON_FAMILY_NAME
 * PERSON_FAMILY_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdPartnerAddress#PERSON_GIVEN_NAME
 * PERSON_GIVEN_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdPartnerAddress#PHONE_EXTENSION_NUMBER
 * PHONE_EXTENSION_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdPartnerAddress#PHONE_NUMBER
 * PHONE_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdPartnerAddress#PHONE_NUMBER_COUNTRY
 * PHONE_NUMBER_COUNTRY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdPartnerAddress#PO_BOX PO_BOX}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdPartnerAddress#PO_BOX_POSTAL_CODE
 * PO_BOX_POSTAL_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdPartnerAddress#POSTAL_CODE
 * POSTAL_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdPartnerAddress#REGION REGION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdPartnerAddress#STREET_NAME
 * STREET_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdPartnerAddress#STREET_PREFIX_NAME1
 * STREET_PREFIX_NAME1}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdPartnerAddress#STREET_PREFIX_NAME2
 * STREET_PREFIX_NAME2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdPartnerAddress#STREET_SUFFIX_NAME1
 * STREET_SUFFIX_NAME1}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdPartnerAddress#STREET_SUFFIX_NAME2
 * STREET_SUFFIX_NAME2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdPartnerAddress#TAX_JURISDICTION
 * TAX_JURISDICTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdPartnerAddress#TRANSPORT_ZONE
 * TRANSPORT_ZONE}</li>
 * </ul>
 *
 */
public interface SrvcOrdPartnerAddressSelectable extends EntitySelectable<SrvcOrdPartnerAddress>
{

}
