/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdRefServiceContract;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdRefServiceContract
 * SrvcOrdRefServiceContract}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.field.SrvcOrdRefServiceContractField
 * SrvcOrdRefServiceContractField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.link.SrvcOrdRefServiceContractLink
 * SrvcOrdRefServiceContractLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdRefServiceContract#SERVICE_ORDER
 * SERVICE_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceorder.SrvcOrdRefServiceContract#REFERENCE_SERVICE_CONTRACT
 * REFERENCE_SERVICE_CONTRACT}</li>
 * </ul>
 *
 */
public interface SrvcOrdRefServiceContractSelectable extends EntitySelectable<SrvcOrdRefServiceContract>
{

}
