/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate;

import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.field.ServiceOrderTemplateField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.link.ServiceOrderTemplateLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.selectable.ServiceOrderTemplateSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Service Order Template
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_ServiceOrderTemplateType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ServiceOrderTemplate extends VdmEntity<ServiceOrderTemplate>
{

    /**
     * Selector for all available fields of ServiceOrderTemplate.
     *
     */
    public final static ServiceOrderTemplateSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServiceOrderTemplate</b>
     * </p>
     *
     * @return Transaction ID
     */
    @Key
    @SerializedName( "ServiceOrderTemplate" )
    @JsonProperty( "ServiceOrderTemplate" )
    @Nullable
    @ODataField( odataName = "ServiceOrderTemplate" )
    private String serviceOrderTemplate;
    /**
     * Use with available fluent helpers to apply the <b>ServiceOrderTemplate</b> field to query operations.
     *
     */
    public final static ServiceOrderTemplateField<String> SERVICE_ORDER_TEMPLATE =
        new ServiceOrderTemplateField<String>("ServiceOrderTemplate");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ServiceOrderTemplateUUID</b>
     * </p>
     *
     * @return GUID of a CRM Order Object
     */
    @SerializedName( "ServiceOrderTemplateUUID" )
    @JsonProperty( "ServiceOrderTemplateUUID" )
    @Nullable
    @ODataField( odataName = "ServiceOrderTemplateUUID" )
    private UUID serviceOrderTemplateUUID;
    /**
     * Use with available fluent helpers to apply the <b>ServiceOrderTemplateUUID</b> field to query operations.
     *
     */
    public final static ServiceOrderTemplateField<UUID> SERVICE_ORDER_TEMPLATE_UUID =
        new ServiceOrderTemplateField<UUID>("ServiceOrderTemplateUUID");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ServiceOrderTemplateType</b>
     * </p>
     *
     * @return Business Transaction Type
     */
    @SerializedName( "ServiceOrderTemplateType" )
    @JsonProperty( "ServiceOrderTemplateType" )
    @Nullable
    @ODataField( odataName = "ServiceOrderTemplateType" )
    private String serviceOrderTemplateType;
    /**
     * Use with available fluent helpers to apply the <b>ServiceOrderTemplateType</b> field to query operations.
     *
     */
    public final static ServiceOrderTemplateField<String> SERVICE_ORDER_TEMPLATE_TYPE =
        new ServiceOrderTemplateField<String>("ServiceOrderTemplateType");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServiceObjectType</b>
     * </p>
     *
     * @return Business Trans. Cat.
     */
    @SerializedName( "ServiceObjectType" )
    @JsonProperty( "ServiceObjectType" )
    @Nullable
    @ODataField( odataName = "ServiceObjectType" )
    private String serviceObjectType;
    /**
     * Use with available fluent helpers to apply the <b>ServiceObjectType</b> field to query operations.
     *
     */
    public final static ServiceOrderTemplateField<String> SERVICE_OBJECT_TYPE =
        new ServiceOrderTemplateField<String>("ServiceObjectType");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>SrvcOrdTmplDescription</b>
     * </p>
     *
     * @return Transaction Description
     */
    @SerializedName( "SrvcOrdTmplDescription" )
    @JsonProperty( "SrvcOrdTmplDescription" )
    @Nullable
    @ODataField( odataName = "SrvcOrdTmplDescription" )
    private String srvcOrdTmplDescription;
    /**
     * Use with available fluent helpers to apply the <b>SrvcOrdTmplDescription</b> field to query operations.
     *
     */
    public final static ServiceOrderTemplateField<String> SRVC_ORD_TMPL_DESCRIPTION =
        new ServiceOrderTemplateField<String>("SrvcOrdTmplDescription");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocumentTemplateType</b>
     * </p>
     *
     * @return Template Type of CRM Transaction
     */
    @SerializedName( "ServiceDocumentTemplateType" )
    @JsonProperty( "ServiceDocumentTemplateType" )
    @Nullable
    @ODataField( odataName = "ServiceDocumentTemplateType" )
    private String serviceDocumentTemplateType;
    /**
     * Use with available fluent helpers to apply the <b>ServiceDocumentTemplateType</b> field to query operations.
     *
     */
    public final static ServiceOrderTemplateField<String> SERVICE_DOCUMENT_TEMPLATE_TYPE =
        new ServiceOrderTemplateField<String>("ServiceDocumentTemplateType");
    /**
     * Constraints: Not nullable, Maximum length: 54
     * <p>
     * Original property name from the Odata EDM: <b>SrvcDocTemplateSearchTermText</b>
     * </p>
     *
     * @return Template Search Term
     */
    @SerializedName( "SrvcDocTemplateSearchTermText" )
    @JsonProperty( "SrvcDocTemplateSearchTermText" )
    @Nullable
    @ODataField( odataName = "SrvcDocTemplateSearchTermText" )
    private String srvcDocTemplateSearchTermText;
    /**
     * Use with available fluent helpers to apply the <b>SrvcDocTemplateSearchTermText</b> field to query operations.
     *
     */
    public final static ServiceOrderTemplateField<String> SRVC_DOC_TEMPLATE_SEARCH_TERM_TEXT =
        new ServiceOrderTemplateField<String>("SrvcDocTemplateSearchTermText");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key of Description
     */
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static ServiceOrderTemplateField<String> LANGUAGE = new ServiceOrderTemplateField<String>("Language");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocumentPriority</b>
     * </p>
     *
     * @return Activity Priority
     */
    @SerializedName( "ServiceDocumentPriority" )
    @JsonProperty( "ServiceDocumentPriority" )
    @Nullable
    @ODataField( odataName = "ServiceDocumentPriority" )
    private String serviceDocumentPriority;
    /**
     * Use with available fluent helpers to apply the <b>ServiceDocumentPriority</b> field to query operations.
     *
     */
    public final static ServiceOrderTemplateField<String> SERVICE_DOCUMENT_PRIORITY =
        new ServiceOrderTemplateField<String>("ServiceDocumentPriority");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>SrvcDocTmplValdtyStartDateTime</b>
     * </p>
     *
     * @return Template Start Date
     */
    @SerializedName( "SrvcDocTmplValdtyStartDateTime" )
    @JsonProperty( "SrvcDocTmplValdtyStartDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "SrvcDocTmplValdtyStartDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime srvcDocTmplValdtyStartDateTime;
    /**
     * Use with available fluent helpers to apply the <b>SrvcDocTmplValdtyStartDateTime</b> field to query operations.
     *
     */
    public final static ServiceOrderTemplateField<ZonedDateTime> SRVC_DOC_TMPL_VALDTY_START_DATE_TIME =
        new ServiceOrderTemplateField<ZonedDateTime>("SrvcDocTmplValdtyStartDateTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>SrvcDocTmplValdtyEndDateTime</b>
     * </p>
     *
     * @return Template End Date
     */
    @SerializedName( "SrvcDocTmplValdtyEndDateTime" )
    @JsonProperty( "SrvcDocTmplValdtyEndDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "SrvcDocTmplValdtyEndDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime srvcDocTmplValdtyEndDateTime;
    /**
     * Use with available fluent helpers to apply the <b>SrvcDocTmplValdtyEndDateTime</b> field to query operations.
     *
     */
    public final static ServiceOrderTemplateField<ZonedDateTime> SRVC_DOC_TMPL_VALDTY_END_DATE_TIME =
        new ServiceOrderTemplateField<ZonedDateTime>("SrvcDocTmplValdtyEndDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SrvcOrdTmplIsReleased</b>
     * </p>
     *
     * @return Release Status
     */
    @SerializedName( "SrvcOrdTmplIsReleased" )
    @JsonProperty( "SrvcOrdTmplIsReleased" )
    @Nullable
    @ODataField( odataName = "SrvcOrdTmplIsReleased" )
    private String srvcOrdTmplIsReleased;
    /**
     * Use with available fluent helpers to apply the <b>SrvcOrdTmplIsReleased</b> field to query operations.
     *
     */
    public final static ServiceOrderTemplateField<String> SRVC_ORD_TMPL_IS_RELEASED =
        new ServiceOrderTemplateField<String>("SrvcOrdTmplIsReleased");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SrvcOrdTmplIsCompleted</b>
     * </p>
     *
     * @return The srvcOrdTmplIsCompleted contained in this entity.
     */
    @SerializedName( "SrvcOrdTmplIsCompleted" )
    @JsonProperty( "SrvcOrdTmplIsCompleted" )
    @Nullable
    @ODataField( odataName = "SrvcOrdTmplIsCompleted" )
    private String srvcOrdTmplIsCompleted;
    /**
     * Use with available fluent helpers to apply the <b>SrvcOrdTmplIsCompleted</b> field to query operations.
     *
     */
    public final static ServiceOrderTemplateField<String> SRVC_ORD_TMPL_IS_COMPLETED =
        new ServiceOrderTemplateField<String>("SrvcOrdTmplIsCompleted");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServiceOrderType</b>
     * </p>
     *
     * @return Business Trans. Cat.
     */
    @SerializedName( "ServiceOrderType" )
    @JsonProperty( "ServiceOrderType" )
    @Nullable
    @ODataField( odataName = "ServiceOrderType" )
    private String serviceOrderType;
    /**
     * Use with available fluent helpers to apply the <b>ServiceOrderType</b> field to query operations.
     *
     */
    public final static ServiceOrderTemplateField<String> SERVICE_ORDER_TYPE =
        new ServiceOrderTemplateField<String>("ServiceOrderType");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocumentType</b>
     * </p>
     *
     * @return Business Transaction Type
     */
    @SerializedName( "ServiceDocumentType" )
    @JsonProperty( "ServiceDocumentType" )
    @Nullable
    @ODataField( odataName = "ServiceDocumentType" )
    private String serviceDocumentType;
    /**
     * Use with available fluent helpers to apply the <b>ServiceDocumentType</b> field to query operations.
     *
     */
    public final static ServiceOrderTemplateField<String> SERVICE_DOCUMENT_TYPE =
        new ServiceOrderTemplateField<String>("ServiceDocumentType");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrganization</b>
     * </p>
     *
     * @return Sales Organization
     */
    @SerializedName( "SalesOrganization" )
    @JsonProperty( "SalesOrganization" )
    @Nullable
    @ODataField( odataName = "SalesOrganization" )
    private String salesOrganization;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrganization</b> field to query operations.
     *
     */
    public final static ServiceOrderTemplateField<String> SALES_ORGANIZATION =
        new ServiceOrderTemplateField<String>("SalesOrganization");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DistributionChannel</b>
     * </p>
     *
     * @return Distribution Channel
     */
    @SerializedName( "DistributionChannel" )
    @JsonProperty( "DistributionChannel" )
    @Nullable
    @ODataField( odataName = "DistributionChannel" )
    private String distributionChannel;
    /**
     * Use with available fluent helpers to apply the <b>DistributionChannel</b> field to query operations.
     *
     */
    public final static ServiceOrderTemplateField<String> DISTRIBUTION_CHANNEL =
        new ServiceOrderTemplateField<String>("DistributionChannel");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Division</b>
     * </p>
     *
     * @return Division
     */
    @SerializedName( "Division" )
    @JsonProperty( "Division" )
    @Nullable
    @ODataField( odataName = "Division" )
    private String division;
    /**
     * Use with available fluent helpers to apply the <b>Division</b> field to query operations.
     *
     */
    public final static ServiceOrderTemplateField<String> DIVISION = new ServiceOrderTemplateField<String>("Division");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOffice</b>
     * </p>
     *
     * @return Sales Office
     */
    @SerializedName( "SalesOffice" )
    @JsonProperty( "SalesOffice" )
    @Nullable
    @ODataField( odataName = "SalesOffice" )
    private String salesOffice;
    /**
     * Use with available fluent helpers to apply the <b>SalesOffice</b> field to query operations.
     *
     */
    public final static ServiceOrderTemplateField<String> SALES_OFFICE =
        new ServiceOrderTemplateField<String>("SalesOffice");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SalesGroup</b>
     * </p>
     *
     * @return Sales Group
     */
    @SerializedName( "SalesGroup" )
    @JsonProperty( "SalesGroup" )
    @Nullable
    @ODataField( odataName = "SalesGroup" )
    private String salesGroup;
    /**
     * Use with available fluent helpers to apply the <b>SalesGroup</b> field to query operations.
     *
     */
    public final static ServiceOrderTemplateField<String> SALES_GROUP =
        new ServiceOrderTemplateField<String>("SalesGroup");
    /**
     * Navigation property <b>to_Appointment</b> for <b>ServiceOrderTemplate</b> to multiple
     * <b>SrvcOrdTmplAppointment</b>.
     *
     */
    @SerializedName( "to_Appointment" )
    @JsonProperty( "to_Appointment" )
    @ODataField( odataName = "to_Appointment" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SrvcOrdTmplAppointment> toAppointment;
    /**
     * Navigation property <b>to_Duration</b> for <b>ServiceOrderTemplate</b> to multiple <b>SrvcOrdTmplDuration</b>.
     *
     */
    @SerializedName( "to_Duration" )
    @JsonProperty( "to_Duration" )
    @ODataField( odataName = "to_Duration" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SrvcOrdTmplDuration> toDuration;
    /**
     * Navigation property <b>to_Item</b> for <b>ServiceOrderTemplate</b> to multiple <b>ServiceOrderTemplateItem</b>.
     *
     */
    @SerializedName( "to_Item" )
    @JsonProperty( "to_Item" )
    @ODataField( odataName = "to_Item" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ServiceOrderTemplateItem> toItem;
    /**
     * Navigation property <b>to_Partner</b> for <b>ServiceOrderTemplate</b> to multiple <b>SrvcOrdTmplPartner</b>.
     *
     */
    @SerializedName( "to_Partner" )
    @JsonProperty( "to_Partner" )
    @ODataField( odataName = "to_Partner" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SrvcOrdTmplPartner> toPartner;
    /**
     * Navigation property <b>to_PersonResponsible</b> for <b>ServiceOrderTemplate</b> to multiple
     * <b>ServiceOrderTmplPersonResp</b>.
     *
     */
    @SerializedName( "to_PersonResponsible" )
    @JsonProperty( "to_PersonResponsible" )
    @ODataField( odataName = "to_PersonResponsible" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ServiceOrderTmplPersonResp> toPersonResponsible;
    /**
     * Navigation property <b>to_ReferenceObject</b> for <b>ServiceOrderTemplate</b> to multiple
     * <b>ServiceOrderTmplRefObject</b>.
     *
     */
    @SerializedName( "to_ReferenceObject" )
    @JsonProperty( "to_ReferenceObject" )
    @ODataField( odataName = "to_ReferenceObject" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ServiceOrderTmplRefObject> toReferenceObject;
    /**
     * Navigation property <b>to_SrvcOrdTmplUserStatus</b> for <b>ServiceOrderTemplate</b> to multiple
     * <b>SrvcOrdTmplUserStatus</b>.
     *
     */
    @SerializedName( "to_SrvcOrdTmplUserStatus" )
    @JsonProperty( "to_SrvcOrdTmplUserStatus" )
    @ODataField( odataName = "to_SrvcOrdTmplUserStatus" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SrvcOrdTmplUserStatus> toSrvcOrdTmplUserStatus;
    /**
     * Navigation property <b>to_Text</b> for <b>ServiceOrderTemplate</b> to multiple <b>ServiceOrderTmplText</b>.
     *
     */
    @SerializedName( "to_Text" )
    @JsonProperty( "to_Text" )
    @ODataField( odataName = "to_Text" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ServiceOrderTmplText> toText;
    /**
     * Use with available fluent helpers to apply the <b>to_Appointment</b> navigation property to query operations.
     *
     */
    public final static ServiceOrderTemplateLink<SrvcOrdTmplAppointment> TO_APPOINTMENT =
        new ServiceOrderTemplateLink<SrvcOrdTmplAppointment>("to_Appointment");
    /**
     * Use with available fluent helpers to apply the <b>to_Duration</b> navigation property to query operations.
     *
     */
    public final static ServiceOrderTemplateLink<SrvcOrdTmplDuration> TO_DURATION =
        new ServiceOrderTemplateLink<SrvcOrdTmplDuration>("to_Duration");
    /**
     * Use with available fluent helpers to apply the <b>to_Item</b> navigation property to query operations.
     *
     */
    public final static ServiceOrderTemplateLink<ServiceOrderTemplateItem> TO_ITEM =
        new ServiceOrderTemplateLink<ServiceOrderTemplateItem>("to_Item");
    /**
     * Use with available fluent helpers to apply the <b>to_Partner</b> navigation property to query operations.
     *
     */
    public final static ServiceOrderTemplateLink<SrvcOrdTmplPartner> TO_PARTNER =
        new ServiceOrderTemplateLink<SrvcOrdTmplPartner>("to_Partner");
    /**
     * Use with available fluent helpers to apply the <b>to_PersonResponsible</b> navigation property to query
     * operations.
     *
     */
    public final static ServiceOrderTemplateLink<ServiceOrderTmplPersonResp> TO_PERSON_RESPONSIBLE =
        new ServiceOrderTemplateLink<ServiceOrderTmplPersonResp>("to_PersonResponsible");
    /**
     * Use with available fluent helpers to apply the <b>to_ReferenceObject</b> navigation property to query operations.
     *
     */
    public final static ServiceOrderTemplateLink<ServiceOrderTmplRefObject> TO_REFERENCE_OBJECT =
        new ServiceOrderTemplateLink<ServiceOrderTmplRefObject>("to_ReferenceObject");
    /**
     * Use with available fluent helpers to apply the <b>to_SrvcOrdTmplUserStatus</b> navigation property to query
     * operations.
     *
     */
    public final static ServiceOrderTemplateLink<SrvcOrdTmplUserStatus> TO_SRVC_ORD_TMPL_USER_STATUS =
        new ServiceOrderTemplateLink<SrvcOrdTmplUserStatus>("to_SrvcOrdTmplUserStatus");
    /**
     * Use with available fluent helpers to apply the <b>to_Text</b> navigation property to query operations.
     *
     */
    public final static ServiceOrderTemplateLink<ServiceOrderTmplText> TO_TEXT =
        new ServiceOrderTemplateLink<ServiceOrderTmplText>("to_Text");

    @Nonnull
    @Override
    public Class<ServiceOrderTemplate> getType()
    {
        return ServiceOrderTemplate.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServiceOrderTemplate</b>
     * </p>
     *
     * @param serviceOrderTemplate
     *            Transaction ID
     */
    public void setServiceOrderTemplate( @Nullable final String serviceOrderTemplate )
    {
        rememberChangedField("ServiceOrderTemplate", this.serviceOrderTemplate);
        this.serviceOrderTemplate = serviceOrderTemplate;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ServiceOrderTemplateUUID</b>
     * </p>
     *
     * @param serviceOrderTemplateUUID
     *            GUID of a CRM Order Object
     */
    public void setServiceOrderTemplateUUID( @Nullable final UUID serviceOrderTemplateUUID )
    {
        rememberChangedField("ServiceOrderTemplateUUID", this.serviceOrderTemplateUUID);
        this.serviceOrderTemplateUUID = serviceOrderTemplateUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ServiceOrderTemplateType</b>
     * </p>
     *
     * @param serviceOrderTemplateType
     *            Business Transaction Type
     */
    public void setServiceOrderTemplateType( @Nullable final String serviceOrderTemplateType )
    {
        rememberChangedField("ServiceOrderTemplateType", this.serviceOrderTemplateType);
        this.serviceOrderTemplateType = serviceOrderTemplateType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServiceObjectType</b>
     * </p>
     *
     * @param serviceObjectType
     *            Business Trans. Cat.
     */
    public void setServiceObjectType( @Nullable final String serviceObjectType )
    {
        rememberChangedField("ServiceObjectType", this.serviceObjectType);
        this.serviceObjectType = serviceObjectType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>SrvcOrdTmplDescription</b>
     * </p>
     *
     * @param srvcOrdTmplDescription
     *            Transaction Description
     */
    public void setSrvcOrdTmplDescription( @Nullable final String srvcOrdTmplDescription )
    {
        rememberChangedField("SrvcOrdTmplDescription", this.srvcOrdTmplDescription);
        this.srvcOrdTmplDescription = srvcOrdTmplDescription;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocumentTemplateType</b>
     * </p>
     *
     * @param serviceDocumentTemplateType
     *            Template Type of CRM Transaction
     */
    public void setServiceDocumentTemplateType( @Nullable final String serviceDocumentTemplateType )
    {
        rememberChangedField("ServiceDocumentTemplateType", this.serviceDocumentTemplateType);
        this.serviceDocumentTemplateType = serviceDocumentTemplateType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 54
     * <p>
     * Original property name from the Odata EDM: <b>SrvcDocTemplateSearchTermText</b>
     * </p>
     *
     * @param srvcDocTemplateSearchTermText
     *            Template Search Term
     */
    public void setSrvcDocTemplateSearchTermText( @Nullable final String srvcDocTemplateSearchTermText )
    {
        rememberChangedField("SrvcDocTemplateSearchTermText", this.srvcDocTemplateSearchTermText);
        this.srvcDocTemplateSearchTermText = srvcDocTemplateSearchTermText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key of Description
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocumentPriority</b>
     * </p>
     *
     * @param serviceDocumentPriority
     *            Activity Priority
     */
    public void setServiceDocumentPriority( @Nullable final String serviceDocumentPriority )
    {
        rememberChangedField("ServiceDocumentPriority", this.serviceDocumentPriority);
        this.serviceDocumentPriority = serviceDocumentPriority;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>SrvcDocTmplValdtyStartDateTime</b>
     * </p>
     *
     * @param srvcDocTmplValdtyStartDateTime
     *            Template Start Date
     */
    public void setSrvcDocTmplValdtyStartDateTime( @Nullable final ZonedDateTime srvcDocTmplValdtyStartDateTime )
    {
        rememberChangedField("SrvcDocTmplValdtyStartDateTime", this.srvcDocTmplValdtyStartDateTime);
        this.srvcDocTmplValdtyStartDateTime = srvcDocTmplValdtyStartDateTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>SrvcDocTmplValdtyEndDateTime</b>
     * </p>
     *
     * @param srvcDocTmplValdtyEndDateTime
     *            Template End Date
     */
    public void setSrvcDocTmplValdtyEndDateTime( @Nullable final ZonedDateTime srvcDocTmplValdtyEndDateTime )
    {
        rememberChangedField("SrvcDocTmplValdtyEndDateTime", this.srvcDocTmplValdtyEndDateTime);
        this.srvcDocTmplValdtyEndDateTime = srvcDocTmplValdtyEndDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SrvcOrdTmplIsReleased</b>
     * </p>
     *
     * @param srvcOrdTmplIsReleased
     *            Release Status
     */
    public void setSrvcOrdTmplIsReleased( @Nullable final String srvcOrdTmplIsReleased )
    {
        rememberChangedField("SrvcOrdTmplIsReleased", this.srvcOrdTmplIsReleased);
        this.srvcOrdTmplIsReleased = srvcOrdTmplIsReleased;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SrvcOrdTmplIsCompleted</b>
     * </p>
     *
     * @param srvcOrdTmplIsCompleted
     *            The srvcOrdTmplIsCompleted to set.
     */
    public void setSrvcOrdTmplIsCompleted( @Nullable final String srvcOrdTmplIsCompleted )
    {
        rememberChangedField("SrvcOrdTmplIsCompleted", this.srvcOrdTmplIsCompleted);
        this.srvcOrdTmplIsCompleted = srvcOrdTmplIsCompleted;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServiceOrderType</b>
     * </p>
     *
     * @param serviceOrderType
     *            Business Trans. Cat.
     */
    public void setServiceOrderType( @Nullable final String serviceOrderType )
    {
        rememberChangedField("ServiceOrderType", this.serviceOrderType);
        this.serviceOrderType = serviceOrderType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocumentType</b>
     * </p>
     *
     * @param serviceDocumentType
     *            Business Transaction Type
     */
    public void setServiceDocumentType( @Nullable final String serviceDocumentType )
    {
        rememberChangedField("ServiceDocumentType", this.serviceDocumentType);
        this.serviceDocumentType = serviceDocumentType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrganization</b>
     * </p>
     *
     * @param salesOrganization
     *            Sales Organization
     */
    public void setSalesOrganization( @Nullable final String salesOrganization )
    {
        rememberChangedField("SalesOrganization", this.salesOrganization);
        this.salesOrganization = salesOrganization;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DistributionChannel</b>
     * </p>
     *
     * @param distributionChannel
     *            Distribution Channel
     */
    public void setDistributionChannel( @Nullable final String distributionChannel )
    {
        rememberChangedField("DistributionChannel", this.distributionChannel);
        this.distributionChannel = distributionChannel;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Division</b>
     * </p>
     *
     * @param division
     *            Division
     */
    public void setDivision( @Nullable final String division )
    {
        rememberChangedField("Division", this.division);
        this.division = division;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOffice</b>
     * </p>
     *
     * @param salesOffice
     *            Sales Office
     */
    public void setSalesOffice( @Nullable final String salesOffice )
    {
        rememberChangedField("SalesOffice", this.salesOffice);
        this.salesOffice = salesOffice;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SalesGroup</b>
     * </p>
     *
     * @param salesGroup
     *            Sales Group
     */
    public void setSalesGroup( @Nullable final String salesGroup )
    {
        rememberChangedField("SalesGroup", this.salesGroup);
        this.salesGroup = salesGroup;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_ServiceOrderTemplate";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ServiceOrderTemplate", getServiceOrderTemplate());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ServiceOrderTemplate", getServiceOrderTemplate());
        values.put("ServiceOrderTemplateUUID", getServiceOrderTemplateUUID());
        values.put("ServiceOrderTemplateType", getServiceOrderTemplateType());
        values.put("ServiceObjectType", getServiceObjectType());
        values.put("SrvcOrdTmplDescription", getSrvcOrdTmplDescription());
        values.put("ServiceDocumentTemplateType", getServiceDocumentTemplateType());
        values.put("SrvcDocTemplateSearchTermText", getSrvcDocTemplateSearchTermText());
        values.put("Language", getLanguage());
        values.put("ServiceDocumentPriority", getServiceDocumentPriority());
        values.put("SrvcDocTmplValdtyStartDateTime", getSrvcDocTmplValdtyStartDateTime());
        values.put("SrvcDocTmplValdtyEndDateTime", getSrvcDocTmplValdtyEndDateTime());
        values.put("SrvcOrdTmplIsReleased", getSrvcOrdTmplIsReleased());
        values.put("SrvcOrdTmplIsCompleted", getSrvcOrdTmplIsCompleted());
        values.put("ServiceOrderType", getServiceOrderType());
        values.put("ServiceDocumentType", getServiceDocumentType());
        values.put("SalesOrganization", getSalesOrganization());
        values.put("DistributionChannel", getDistributionChannel());
        values.put("Division", getDivision());
        values.put("SalesOffice", getSalesOffice());
        values.put("SalesGroup", getSalesGroup());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ServiceOrderTemplate") ) {
                final Object value = values.remove("ServiceOrderTemplate");
                if( (value == null) || (!value.equals(getServiceOrderTemplate())) ) {
                    setServiceOrderTemplate(((String) value));
                }
            }
            if( values.containsKey("ServiceOrderTemplateUUID") ) {
                final Object value = values.remove("ServiceOrderTemplateUUID");
                if( (value == null) || (!value.equals(getServiceOrderTemplateUUID())) ) {
                    setServiceOrderTemplateUUID(((UUID) value));
                }
            }
            if( values.containsKey("ServiceOrderTemplateType") ) {
                final Object value = values.remove("ServiceOrderTemplateType");
                if( (value == null) || (!value.equals(getServiceOrderTemplateType())) ) {
                    setServiceOrderTemplateType(((String) value));
                }
            }
            if( values.containsKey("ServiceObjectType") ) {
                final Object value = values.remove("ServiceObjectType");
                if( (value == null) || (!value.equals(getServiceObjectType())) ) {
                    setServiceObjectType(((String) value));
                }
            }
            if( values.containsKey("SrvcOrdTmplDescription") ) {
                final Object value = values.remove("SrvcOrdTmplDescription");
                if( (value == null) || (!value.equals(getSrvcOrdTmplDescription())) ) {
                    setSrvcOrdTmplDescription(((String) value));
                }
            }
            if( values.containsKey("ServiceDocumentTemplateType") ) {
                final Object value = values.remove("ServiceDocumentTemplateType");
                if( (value == null) || (!value.equals(getServiceDocumentTemplateType())) ) {
                    setServiceDocumentTemplateType(((String) value));
                }
            }
            if( values.containsKey("SrvcDocTemplateSearchTermText") ) {
                final Object value = values.remove("SrvcDocTemplateSearchTermText");
                if( (value == null) || (!value.equals(getSrvcDocTemplateSearchTermText())) ) {
                    setSrvcDocTemplateSearchTermText(((String) value));
                }
            }
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("ServiceDocumentPriority") ) {
                final Object value = values.remove("ServiceDocumentPriority");
                if( (value == null) || (!value.equals(getServiceDocumentPriority())) ) {
                    setServiceDocumentPriority(((String) value));
                }
            }
            if( values.containsKey("SrvcDocTmplValdtyStartDateTime") ) {
                final Object value = values.remove("SrvcDocTmplValdtyStartDateTime");
                if( (value == null) || (!value.equals(getSrvcDocTmplValdtyStartDateTime())) ) {
                    setSrvcDocTmplValdtyStartDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("SrvcDocTmplValdtyEndDateTime") ) {
                final Object value = values.remove("SrvcDocTmplValdtyEndDateTime");
                if( (value == null) || (!value.equals(getSrvcDocTmplValdtyEndDateTime())) ) {
                    setSrvcDocTmplValdtyEndDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("SrvcOrdTmplIsReleased") ) {
                final Object value = values.remove("SrvcOrdTmplIsReleased");
                if( (value == null) || (!value.equals(getSrvcOrdTmplIsReleased())) ) {
                    setSrvcOrdTmplIsReleased(((String) value));
                }
            }
            if( values.containsKey("SrvcOrdTmplIsCompleted") ) {
                final Object value = values.remove("SrvcOrdTmplIsCompleted");
                if( (value == null) || (!value.equals(getSrvcOrdTmplIsCompleted())) ) {
                    setSrvcOrdTmplIsCompleted(((String) value));
                }
            }
            if( values.containsKey("ServiceOrderType") ) {
                final Object value = values.remove("ServiceOrderType");
                if( (value == null) || (!value.equals(getServiceOrderType())) ) {
                    setServiceOrderType(((String) value));
                }
            }
            if( values.containsKey("ServiceDocumentType") ) {
                final Object value = values.remove("ServiceDocumentType");
                if( (value == null) || (!value.equals(getServiceDocumentType())) ) {
                    setServiceDocumentType(((String) value));
                }
            }
            if( values.containsKey("SalesOrganization") ) {
                final Object value = values.remove("SalesOrganization");
                if( (value == null) || (!value.equals(getSalesOrganization())) ) {
                    setSalesOrganization(((String) value));
                }
            }
            if( values.containsKey("DistributionChannel") ) {
                final Object value = values.remove("DistributionChannel");
                if( (value == null) || (!value.equals(getDistributionChannel())) ) {
                    setDistributionChannel(((String) value));
                }
            }
            if( values.containsKey("Division") ) {
                final Object value = values.remove("Division");
                if( (value == null) || (!value.equals(getDivision())) ) {
                    setDivision(((String) value));
                }
            }
            if( values.containsKey("SalesOffice") ) {
                final Object value = values.remove("SalesOffice");
                if( (value == null) || (!value.equals(getSalesOffice())) ) {
                    setSalesOffice(((String) value));
                }
            }
            if( values.containsKey("SalesGroup") ) {
                final Object value = values.remove("SalesGroup");
                if( (value == null) || (!value.equals(getSalesGroup())) ) {
                    setSalesGroup(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_Appointment") ) {
                final Object value = (values).remove("to_Appointment");
                if( value instanceof Iterable ) {
                    if( toAppointment == null ) {
                        toAppointment = Lists.newArrayList();
                    } else {
                        toAppointment = Lists.newArrayList(toAppointment);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SrvcOrdTmplAppointment entity;
                        if( toAppointment.size() > i ) {
                            entity = toAppointment.get(i);
                        } else {
                            entity = new SrvcOrdTmplAppointment();
                            toAppointment.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_Duration") ) {
                final Object value = (values).remove("to_Duration");
                if( value instanceof Iterable ) {
                    if( toDuration == null ) {
                        toDuration = Lists.newArrayList();
                    } else {
                        toDuration = Lists.newArrayList(toDuration);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SrvcOrdTmplDuration entity;
                        if( toDuration.size() > i ) {
                            entity = toDuration.get(i);
                        } else {
                            entity = new SrvcOrdTmplDuration();
                            toDuration.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_Item") ) {
                final Object value = (values).remove("to_Item");
                if( value instanceof Iterable ) {
                    if( toItem == null ) {
                        toItem = Lists.newArrayList();
                    } else {
                        toItem = Lists.newArrayList(toItem);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ServiceOrderTemplateItem entity;
                        if( toItem.size() > i ) {
                            entity = toItem.get(i);
                        } else {
                            entity = new ServiceOrderTemplateItem();
                            toItem.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_Partner") ) {
                final Object value = (values).remove("to_Partner");
                if( value instanceof Iterable ) {
                    if( toPartner == null ) {
                        toPartner = Lists.newArrayList();
                    } else {
                        toPartner = Lists.newArrayList(toPartner);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SrvcOrdTmplPartner entity;
                        if( toPartner.size() > i ) {
                            entity = toPartner.get(i);
                        } else {
                            entity = new SrvcOrdTmplPartner();
                            toPartner.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_PersonResponsible") ) {
                final Object value = (values).remove("to_PersonResponsible");
                if( value instanceof Iterable ) {
                    if( toPersonResponsible == null ) {
                        toPersonResponsible = Lists.newArrayList();
                    } else {
                        toPersonResponsible = Lists.newArrayList(toPersonResponsible);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ServiceOrderTmplPersonResp entity;
                        if( toPersonResponsible.size() > i ) {
                            entity = toPersonResponsible.get(i);
                        } else {
                            entity = new ServiceOrderTmplPersonResp();
                            toPersonResponsible.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_ReferenceObject") ) {
                final Object value = (values).remove("to_ReferenceObject");
                if( value instanceof Iterable ) {
                    if( toReferenceObject == null ) {
                        toReferenceObject = Lists.newArrayList();
                    } else {
                        toReferenceObject = Lists.newArrayList(toReferenceObject);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ServiceOrderTmplRefObject entity;
                        if( toReferenceObject.size() > i ) {
                            entity = toReferenceObject.get(i);
                        } else {
                            entity = new ServiceOrderTmplRefObject();
                            toReferenceObject.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_SrvcOrdTmplUserStatus") ) {
                final Object value = (values).remove("to_SrvcOrdTmplUserStatus");
                if( value instanceof Iterable ) {
                    if( toSrvcOrdTmplUserStatus == null ) {
                        toSrvcOrdTmplUserStatus = Lists.newArrayList();
                    } else {
                        toSrvcOrdTmplUserStatus = Lists.newArrayList(toSrvcOrdTmplUserStatus);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SrvcOrdTmplUserStatus entity;
                        if( toSrvcOrdTmplUserStatus.size() > i ) {
                            entity = toSrvcOrdTmplUserStatus.get(i);
                        } else {
                            entity = new SrvcOrdTmplUserStatus();
                            toSrvcOrdTmplUserStatus.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_Text") ) {
                final Object value = (values).remove("to_Text");
                if( value instanceof Iterable ) {
                    if( toText == null ) {
                        toText = Lists.newArrayList();
                    } else {
                        toText = Lists.newArrayList(toText);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ServiceOrderTmplText entity;
                        if( toText.size() > i ) {
                            entity = toText.get(i);
                        } else {
                            entity = new ServiceOrderTmplText();
                            toText.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> ServiceOrderTemplateField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ServiceOrderTemplateField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ServiceOrderTemplateField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ServiceOrderTemplateField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ServiceOrderTemplateService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toAppointment != null ) {
            (values).put("to_Appointment", toAppointment);
        }
        if( toDuration != null ) {
            (values).put("to_Duration", toDuration);
        }
        if( toItem != null ) {
            (values).put("to_Item", toItem);
        }
        if( toPartner != null ) {
            (values).put("to_Partner", toPartner);
        }
        if( toPersonResponsible != null ) {
            (values).put("to_PersonResponsible", toPersonResponsible);
        }
        if( toReferenceObject != null ) {
            (values).put("to_ReferenceObject", toReferenceObject);
        }
        if( toSrvcOrdTmplUserStatus != null ) {
            (values).put("to_SrvcOrdTmplUserStatus", toSrvcOrdTmplUserStatus);
        }
        if( toText != null ) {
            (values).put("to_Text", toText);
        }
        return values;
    }

    /**
     * Fetches the <b>SrvcOrdTmplAppointment</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_Appointment</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SrvcOrdTmplAppointment</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SrvcOrdTmplAppointment> fetchAppointment()
    {
        return fetchFieldAsList("to_Appointment", SrvcOrdTmplAppointment.class);
    }

    /**
     * Retrieval of associated <b>SrvcOrdTmplAppointment</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Appointment</b>.
     * <p>
     * If the navigation property <b>to_Appointment</b> of a queried <b>ServiceOrderTemplate</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SrvcOrdTmplAppointment</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SrvcOrdTmplAppointment> getAppointmentOrFetch()
    {
        if( toAppointment == null ) {
            toAppointment = fetchAppointment();
        }
        return toAppointment;
    }

    /**
     * Retrieval of associated <b>SrvcOrdTmplAppointment</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Appointment</b>.
     * <p>
     * If the navigation property for an entity <b>ServiceOrderTemplate</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Appointment</b> is already loaded, the result will
     *         contain the <b>SrvcOrdTmplAppointment</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SrvcOrdTmplAppointment>> getAppointmentIfPresent()
    {
        return Option.of(toAppointment);
    }

    /**
     * Overwrites the list of associated <b>SrvcOrdTmplAppointment</b> entities for the loaded navigation property
     * <b>to_Appointment</b>.
     * <p>
     * If the navigation property <b>to_Appointment</b> of a queried <b>ServiceOrderTemplate</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SrvcOrdTmplAppointment</b> entities.
     */
    public void setAppointment( @Nonnull final List<SrvcOrdTmplAppointment> value )
    {
        if( toAppointment == null ) {
            toAppointment = Lists.newArrayList();
        }
        toAppointment.clear();
        toAppointment.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SrvcOrdTmplAppointment</b> entities. This corresponds to the OData
     * navigation property <b>to_Appointment</b>.
     * <p>
     * If the navigation property <b>to_Appointment</b> of a queried <b>ServiceOrderTemplate</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SrvcOrdTmplAppointment</b> entities.
     */
    public void addAppointment( SrvcOrdTmplAppointment... entity )
    {
        if( toAppointment == null ) {
            toAppointment = Lists.newArrayList();
        }
        toAppointment.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>SrvcOrdTmplDuration</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_Duration</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SrvcOrdTmplDuration</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SrvcOrdTmplDuration> fetchDuration()
    {
        return fetchFieldAsList("to_Duration", SrvcOrdTmplDuration.class);
    }

    /**
     * Retrieval of associated <b>SrvcOrdTmplDuration</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Duration</b>.
     * <p>
     * If the navigation property <b>to_Duration</b> of a queried <b>ServiceOrderTemplate</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SrvcOrdTmplDuration</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SrvcOrdTmplDuration> getDurationOrFetch()
    {
        if( toDuration == null ) {
            toDuration = fetchDuration();
        }
        return toDuration;
    }

    /**
     * Retrieval of associated <b>SrvcOrdTmplDuration</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Duration</b>.
     * <p>
     * If the navigation property for an entity <b>ServiceOrderTemplate</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Duration</b> is already loaded, the result will contain
     *         the <b>SrvcOrdTmplDuration</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SrvcOrdTmplDuration>> getDurationIfPresent()
    {
        return Option.of(toDuration);
    }

    /**
     * Overwrites the list of associated <b>SrvcOrdTmplDuration</b> entities for the loaded navigation property
     * <b>to_Duration</b>.
     * <p>
     * If the navigation property <b>to_Duration</b> of a queried <b>ServiceOrderTemplate</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SrvcOrdTmplDuration</b> entities.
     */
    public void setDuration( @Nonnull final List<SrvcOrdTmplDuration> value )
    {
        if( toDuration == null ) {
            toDuration = Lists.newArrayList();
        }
        toDuration.clear();
        toDuration.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SrvcOrdTmplDuration</b> entities. This corresponds to the OData
     * navigation property <b>to_Duration</b>.
     * <p>
     * If the navigation property <b>to_Duration</b> of a queried <b>ServiceOrderTemplate</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SrvcOrdTmplDuration</b> entities.
     */
    public void addDuration( SrvcOrdTmplDuration... entity )
    {
        if( toDuration == null ) {
            toDuration = Lists.newArrayList();
        }
        toDuration.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>ServiceOrderTemplateItem</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_Item</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ServiceOrderTemplateItem</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ServiceOrderTemplateItem> fetchItem()
    {
        return fetchFieldAsList("to_Item", ServiceOrderTemplateItem.class);
    }

    /**
     * Retrieval of associated <b>ServiceOrderTemplateItem</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Item</b>.
     * <p>
     * If the navigation property <b>to_Item</b> of a queried <b>ServiceOrderTemplate</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ServiceOrderTemplateItem</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ServiceOrderTemplateItem> getItemOrFetch()
    {
        if( toItem == null ) {
            toItem = fetchItem();
        }
        return toItem;
    }

    /**
     * Retrieval of associated <b>ServiceOrderTemplateItem</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Item</b>.
     * <p>
     * If the navigation property for an entity <b>ServiceOrderTemplate</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Item</b> is already loaded, the result will contain the
     *         <b>ServiceOrderTemplateItem</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ServiceOrderTemplateItem>> getItemIfPresent()
    {
        return Option.of(toItem);
    }

    /**
     * Overwrites the list of associated <b>ServiceOrderTemplateItem</b> entities for the loaded navigation property
     * <b>to_Item</b>.
     * <p>
     * If the navigation property <b>to_Item</b> of a queried <b>ServiceOrderTemplate</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ServiceOrderTemplateItem</b> entities.
     */
    public void setItem( @Nonnull final List<ServiceOrderTemplateItem> value )
    {
        if( toItem == null ) {
            toItem = Lists.newArrayList();
        }
        toItem.clear();
        toItem.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ServiceOrderTemplateItem</b> entities. This corresponds to the OData
     * navigation property <b>to_Item</b>.
     * <p>
     * If the navigation property <b>to_Item</b> of a queried <b>ServiceOrderTemplate</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ServiceOrderTemplateItem</b> entities.
     */
    public void addItem( ServiceOrderTemplateItem... entity )
    {
        if( toItem == null ) {
            toItem = Lists.newArrayList();
        }
        toItem.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>SrvcOrdTmplPartner</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_Partner</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SrvcOrdTmplPartner</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SrvcOrdTmplPartner> fetchPartner()
    {
        return fetchFieldAsList("to_Partner", SrvcOrdTmplPartner.class);
    }

    /**
     * Retrieval of associated <b>SrvcOrdTmplPartner</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Partner</b>.
     * <p>
     * If the navigation property <b>to_Partner</b> of a queried <b>ServiceOrderTemplate</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SrvcOrdTmplPartner</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SrvcOrdTmplPartner> getPartnerOrFetch()
    {
        if( toPartner == null ) {
            toPartner = fetchPartner();
        }
        return toPartner;
    }

    /**
     * Retrieval of associated <b>SrvcOrdTmplPartner</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Partner</b>.
     * <p>
     * If the navigation property for an entity <b>ServiceOrderTemplate</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Partner</b> is already loaded, the result will contain
     *         the <b>SrvcOrdTmplPartner</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SrvcOrdTmplPartner>> getPartnerIfPresent()
    {
        return Option.of(toPartner);
    }

    /**
     * Overwrites the list of associated <b>SrvcOrdTmplPartner</b> entities for the loaded navigation property
     * <b>to_Partner</b>.
     * <p>
     * If the navigation property <b>to_Partner</b> of a queried <b>ServiceOrderTemplate</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SrvcOrdTmplPartner</b> entities.
     */
    public void setPartner( @Nonnull final List<SrvcOrdTmplPartner> value )
    {
        if( toPartner == null ) {
            toPartner = Lists.newArrayList();
        }
        toPartner.clear();
        toPartner.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SrvcOrdTmplPartner</b> entities. This corresponds to the OData
     * navigation property <b>to_Partner</b>.
     * <p>
     * If the navigation property <b>to_Partner</b> of a queried <b>ServiceOrderTemplate</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SrvcOrdTmplPartner</b> entities.
     */
    public void addPartner( SrvcOrdTmplPartner... entity )
    {
        if( toPartner == null ) {
            toPartner = Lists.newArrayList();
        }
        toPartner.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>ServiceOrderTmplPersonResp</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_PersonResponsible</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ServiceOrderTmplPersonResp</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ServiceOrderTmplPersonResp> fetchPersonResponsible()
    {
        return fetchFieldAsList("to_PersonResponsible", ServiceOrderTmplPersonResp.class);
    }

    /**
     * Retrieval of associated <b>ServiceOrderTmplPersonResp</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_PersonResponsible</b>.
     * <p>
     * If the navigation property <b>to_PersonResponsible</b> of a queried <b>ServiceOrderTemplate</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ServiceOrderTmplPersonResp</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ServiceOrderTmplPersonResp> getPersonResponsibleOrFetch()
    {
        if( toPersonResponsible == null ) {
            toPersonResponsible = fetchPersonResponsible();
        }
        return toPersonResponsible;
    }

    /**
     * Retrieval of associated <b>ServiceOrderTmplPersonResp</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_PersonResponsible</b>.
     * <p>
     * If the navigation property for an entity <b>ServiceOrderTemplate</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_PersonResponsible</b> is already loaded, the result will
     *         contain the <b>ServiceOrderTmplPersonResp</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ServiceOrderTmplPersonResp>> getPersonResponsibleIfPresent()
    {
        return Option.of(toPersonResponsible);
    }

    /**
     * Overwrites the list of associated <b>ServiceOrderTmplPersonResp</b> entities for the loaded navigation property
     * <b>to_PersonResponsible</b>.
     * <p>
     * If the navigation property <b>to_PersonResponsible</b> of a queried <b>ServiceOrderTemplate</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ServiceOrderTmplPersonResp</b> entities.
     */
    public void setPersonResponsible( @Nonnull final List<ServiceOrderTmplPersonResp> value )
    {
        if( toPersonResponsible == null ) {
            toPersonResponsible = Lists.newArrayList();
        }
        toPersonResponsible.clear();
        toPersonResponsible.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ServiceOrderTmplPersonResp</b> entities. This corresponds to the OData
     * navigation property <b>to_PersonResponsible</b>.
     * <p>
     * If the navigation property <b>to_PersonResponsible</b> of a queried <b>ServiceOrderTemplate</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ServiceOrderTmplPersonResp</b> entities.
     */
    public void addPersonResponsible( ServiceOrderTmplPersonResp... entity )
    {
        if( toPersonResponsible == null ) {
            toPersonResponsible = Lists.newArrayList();
        }
        toPersonResponsible.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>ServiceOrderTmplRefObject</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_ReferenceObject</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ServiceOrderTmplRefObject</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ServiceOrderTmplRefObject> fetchReferenceObject()
    {
        return fetchFieldAsList("to_ReferenceObject", ServiceOrderTmplRefObject.class);
    }

    /**
     * Retrieval of associated <b>ServiceOrderTmplRefObject</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ReferenceObject</b>.
     * <p>
     * If the navigation property <b>to_ReferenceObject</b> of a queried <b>ServiceOrderTemplate</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ServiceOrderTmplRefObject</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ServiceOrderTmplRefObject> getReferenceObjectOrFetch()
    {
        if( toReferenceObject == null ) {
            toReferenceObject = fetchReferenceObject();
        }
        return toReferenceObject;
    }

    /**
     * Retrieval of associated <b>ServiceOrderTmplRefObject</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ReferenceObject</b>.
     * <p>
     * If the navigation property for an entity <b>ServiceOrderTemplate</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ReferenceObject</b> is already loaded, the result will
     *         contain the <b>ServiceOrderTmplRefObject</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ServiceOrderTmplRefObject>> getReferenceObjectIfPresent()
    {
        return Option.of(toReferenceObject);
    }

    /**
     * Overwrites the list of associated <b>ServiceOrderTmplRefObject</b> entities for the loaded navigation property
     * <b>to_ReferenceObject</b>.
     * <p>
     * If the navigation property <b>to_ReferenceObject</b> of a queried <b>ServiceOrderTemplate</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ServiceOrderTmplRefObject</b> entities.
     */
    public void setReferenceObject( @Nonnull final List<ServiceOrderTmplRefObject> value )
    {
        if( toReferenceObject == null ) {
            toReferenceObject = Lists.newArrayList();
        }
        toReferenceObject.clear();
        toReferenceObject.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ServiceOrderTmplRefObject</b> entities. This corresponds to the OData
     * navigation property <b>to_ReferenceObject</b>.
     * <p>
     * If the navigation property <b>to_ReferenceObject</b> of a queried <b>ServiceOrderTemplate</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ServiceOrderTmplRefObject</b> entities.
     */
    public void addReferenceObject( ServiceOrderTmplRefObject... entity )
    {
        if( toReferenceObject == null ) {
            toReferenceObject = Lists.newArrayList();
        }
        toReferenceObject.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>SrvcOrdTmplUserStatus</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_SrvcOrdTmplUserStatus</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SrvcOrdTmplUserStatus</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SrvcOrdTmplUserStatus> fetchSrvcOrdTmplUserStatus()
    {
        return fetchFieldAsList("to_SrvcOrdTmplUserStatus", SrvcOrdTmplUserStatus.class);
    }

    /**
     * Retrieval of associated <b>SrvcOrdTmplUserStatus</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_SrvcOrdTmplUserStatus</b>.
     * <p>
     * If the navigation property <b>to_SrvcOrdTmplUserStatus</b> of a queried <b>ServiceOrderTemplate</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SrvcOrdTmplUserStatus</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SrvcOrdTmplUserStatus> getSrvcOrdTmplUserStatusOrFetch()
    {
        if( toSrvcOrdTmplUserStatus == null ) {
            toSrvcOrdTmplUserStatus = fetchSrvcOrdTmplUserStatus();
        }
        return toSrvcOrdTmplUserStatus;
    }

    /**
     * Retrieval of associated <b>SrvcOrdTmplUserStatus</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_SrvcOrdTmplUserStatus</b>.
     * <p>
     * If the navigation property for an entity <b>ServiceOrderTemplate</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SrvcOrdTmplUserStatus</b> is already loaded, the result
     *         will contain the <b>SrvcOrdTmplUserStatus</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SrvcOrdTmplUserStatus>> getSrvcOrdTmplUserStatusIfPresent()
    {
        return Option.of(toSrvcOrdTmplUserStatus);
    }

    /**
     * Overwrites the list of associated <b>SrvcOrdTmplUserStatus</b> entities for the loaded navigation property
     * <b>to_SrvcOrdTmplUserStatus</b>.
     * <p>
     * If the navigation property <b>to_SrvcOrdTmplUserStatus</b> of a queried <b>ServiceOrderTemplate</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SrvcOrdTmplUserStatus</b> entities.
     */
    public void setSrvcOrdTmplUserStatus( @Nonnull final List<SrvcOrdTmplUserStatus> value )
    {
        if( toSrvcOrdTmplUserStatus == null ) {
            toSrvcOrdTmplUserStatus = Lists.newArrayList();
        }
        toSrvcOrdTmplUserStatus.clear();
        toSrvcOrdTmplUserStatus.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SrvcOrdTmplUserStatus</b> entities. This corresponds to the OData
     * navigation property <b>to_SrvcOrdTmplUserStatus</b>.
     * <p>
     * If the navigation property <b>to_SrvcOrdTmplUserStatus</b> of a queried <b>ServiceOrderTemplate</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SrvcOrdTmplUserStatus</b> entities.
     */
    public void addSrvcOrdTmplUserStatus( SrvcOrdTmplUserStatus... entity )
    {
        if( toSrvcOrdTmplUserStatus == null ) {
            toSrvcOrdTmplUserStatus = Lists.newArrayList();
        }
        toSrvcOrdTmplUserStatus.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>ServiceOrderTmplText</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_Text</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ServiceOrderTmplText</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ServiceOrderTmplText> fetchText()
    {
        return fetchFieldAsList("to_Text", ServiceOrderTmplText.class);
    }

    /**
     * Retrieval of associated <b>ServiceOrderTmplText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Text</b>.
     * <p>
     * If the navigation property <b>to_Text</b> of a queried <b>ServiceOrderTemplate</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ServiceOrderTmplText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ServiceOrderTmplText> getTextOrFetch()
    {
        if( toText == null ) {
            toText = fetchText();
        }
        return toText;
    }

    /**
     * Retrieval of associated <b>ServiceOrderTmplText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Text</b>.
     * <p>
     * If the navigation property for an entity <b>ServiceOrderTemplate</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Text</b> is already loaded, the result will contain the
     *         <b>ServiceOrderTmplText</b> entities. If not, an <code>Option</code> with result state <code>empty</code>
     *         is returned.
     */
    @Nonnull
    public Option<List<ServiceOrderTmplText>> getTextIfPresent()
    {
        return Option.of(toText);
    }

    /**
     * Overwrites the list of associated <b>ServiceOrderTmplText</b> entities for the loaded navigation property
     * <b>to_Text</b>.
     * <p>
     * If the navigation property <b>to_Text</b> of a queried <b>ServiceOrderTemplate</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ServiceOrderTmplText</b> entities.
     */
    public void setText( @Nonnull final List<ServiceOrderTmplText> value )
    {
        if( toText == null ) {
            toText = Lists.newArrayList();
        }
        toText.clear();
        toText.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ServiceOrderTmplText</b> entities. This corresponds to the OData
     * navigation property <b>to_Text</b>.
     * <p>
     * If the navigation property <b>to_Text</b> of a queried <b>ServiceOrderTemplate</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ServiceOrderTmplText</b> entities.
     */
    public void addText( ServiceOrderTmplText... entity )
    {
        if( toText == null ) {
            toText = Lists.newArrayList();
        }
        toText.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of ServiceOrderTemplate instances.
     *
     */
    public final static class ServiceOrderTemplateBuilder
    {

        private List<SrvcOrdTmplAppointment> toAppointment = Lists.newArrayList();
        private List<SrvcOrdTmplDuration> toDuration = Lists.newArrayList();
        private List<ServiceOrderTemplateItem> toItem = Lists.newArrayList();
        private List<SrvcOrdTmplPartner> toPartner = Lists.newArrayList();
        private List<ServiceOrderTmplPersonResp> toPersonResponsible = Lists.newArrayList();
        private List<ServiceOrderTmplRefObject> toReferenceObject = Lists.newArrayList();
        private List<SrvcOrdTmplUserStatus> toSrvcOrdTmplUserStatus = Lists.newArrayList();
        private List<ServiceOrderTmplText> toText = Lists.newArrayList();

        private ServiceOrderTemplate.ServiceOrderTemplateBuilder toAppointment(
            final List<SrvcOrdTmplAppointment> value )
        {
            toAppointment.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_Appointment</b> for <b>ServiceOrderTemplate</b> to multiple
         * <b>SrvcOrdTmplAppointment</b>.
         *
         * @param value
         *            The SrvcOrdTmplAppointments to build this ServiceOrderTemplate with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ServiceOrderTemplate.ServiceOrderTemplateBuilder appointment( SrvcOrdTmplAppointment... value )
        {
            return toAppointment(Lists.newArrayList(value));
        }

        private ServiceOrderTemplate.ServiceOrderTemplateBuilder toDuration( final List<SrvcOrdTmplDuration> value )
        {
            toDuration.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_Duration</b> for <b>ServiceOrderTemplate</b> to multiple
         * <b>SrvcOrdTmplDuration</b>.
         *
         * @param value
         *            The SrvcOrdTmplDurations to build this ServiceOrderTemplate with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ServiceOrderTemplate.ServiceOrderTemplateBuilder duration( SrvcOrdTmplDuration... value )
        {
            return toDuration(Lists.newArrayList(value));
        }

        private ServiceOrderTemplate.ServiceOrderTemplateBuilder toItem( final List<ServiceOrderTemplateItem> value )
        {
            toItem.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_Item</b> for <b>ServiceOrderTemplate</b> to multiple
         * <b>ServiceOrderTemplateItem</b>.
         *
         * @param value
         *            The ServiceOrderTemplateItems to build this ServiceOrderTemplate with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ServiceOrderTemplate.ServiceOrderTemplateBuilder item( ServiceOrderTemplateItem... value )
        {
            return toItem(Lists.newArrayList(value));
        }

        private ServiceOrderTemplate.ServiceOrderTemplateBuilder toPartner( final List<SrvcOrdTmplPartner> value )
        {
            toPartner.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_Partner</b> for <b>ServiceOrderTemplate</b> to multiple <b>SrvcOrdTmplPartner</b>.
         *
         * @param value
         *            The SrvcOrdTmplPartners to build this ServiceOrderTemplate with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ServiceOrderTemplate.ServiceOrderTemplateBuilder partner( SrvcOrdTmplPartner... value )
        {
            return toPartner(Lists.newArrayList(value));
        }

        private ServiceOrderTemplate.ServiceOrderTemplateBuilder toPersonResponsible(
            final List<ServiceOrderTmplPersonResp> value )
        {
            toPersonResponsible.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_PersonResponsible</b> for <b>ServiceOrderTemplate</b> to multiple
         * <b>ServiceOrderTmplPersonResp</b>.
         *
         * @param value
         *            The ServiceOrderTmplPersonResps to build this ServiceOrderTemplate with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ServiceOrderTemplate.ServiceOrderTemplateBuilder personResponsible( ServiceOrderTmplPersonResp... value )
        {
            return toPersonResponsible(Lists.newArrayList(value));
        }

        private ServiceOrderTemplate.ServiceOrderTemplateBuilder toReferenceObject(
            final List<ServiceOrderTmplRefObject> value )
        {
            toReferenceObject.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_ReferenceObject</b> for <b>ServiceOrderTemplate</b> to multiple
         * <b>ServiceOrderTmplRefObject</b>.
         *
         * @param value
         *            The ServiceOrderTmplRefObjects to build this ServiceOrderTemplate with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ServiceOrderTemplate.ServiceOrderTemplateBuilder referenceObject( ServiceOrderTmplRefObject... value )
        {
            return toReferenceObject(Lists.newArrayList(value));
        }

        private ServiceOrderTemplate.ServiceOrderTemplateBuilder toSrvcOrdTmplUserStatus(
            final List<SrvcOrdTmplUserStatus> value )
        {
            toSrvcOrdTmplUserStatus.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_SrvcOrdTmplUserStatus</b> for <b>ServiceOrderTemplate</b> to multiple
         * <b>SrvcOrdTmplUserStatus</b>.
         *
         * @param value
         *            The SrvcOrdTmplUserStatuss to build this ServiceOrderTemplate with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ServiceOrderTemplate.ServiceOrderTemplateBuilder srvcOrdTmplUserStatus( SrvcOrdTmplUserStatus... value )
        {
            return toSrvcOrdTmplUserStatus(Lists.newArrayList(value));
        }

        private ServiceOrderTemplate.ServiceOrderTemplateBuilder toText( final List<ServiceOrderTmplText> value )
        {
            toText.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_Text</b> for <b>ServiceOrderTemplate</b> to multiple <b>ServiceOrderTmplText</b>.
         *
         * @param value
         *            The ServiceOrderTmplTexts to build this ServiceOrderTemplate with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ServiceOrderTemplate.ServiceOrderTemplateBuilder text( ServiceOrderTmplText... value )
        {
            return toText(Lists.newArrayList(value));
        }

    }

}
