/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate;

import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.field.ServiceOrderTemplateItemField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.link.ServiceOrderTemplateItemLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.link.ServiceOrderTemplateItemOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.selectable.ServiceOrderTemplateItemSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Service Order Template Items
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_ServiceOrderTemplateItemType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ServiceOrderTemplateItem extends VdmEntity<ServiceOrderTemplateItem>
{

    /**
     * Selector for all available fields of ServiceOrderTemplateItem.
     *
     */
    public final static ServiceOrderTemplateItemSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServiceOrderTemplate</b>
     * </p>
     *
     * @return Transaction ID
     */
    @Key
    @SerializedName( "ServiceOrderTemplate" )
    @JsonProperty( "ServiceOrderTemplate" )
    @Nullable
    @ODataField( odataName = "ServiceOrderTemplate" )
    private String serviceOrderTemplate;
    /**
     * Use with available fluent helpers to apply the <b>ServiceOrderTemplate</b> field to query operations.
     *
     */
    public final static ServiceOrderTemplateItemField<String> SERVICE_ORDER_TEMPLATE =
        new ServiceOrderTemplateItemField<String>("ServiceOrderTemplate");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ServiceOrderTemplateItem</b>
     * </p>
     *
     * @return Shortened Item Number in Document
     */
    @Key
    @SerializedName( "ServiceOrderTemplateItem" )
    @JsonProperty( "ServiceOrderTemplateItem" )
    @Nullable
    @ODataField( odataName = "ServiceOrderTemplateItem" )
    private String serviceOrderTemplateItem;
    /**
     * Use with available fluent helpers to apply the <b>ServiceOrderTemplateItem</b> field to query operations.
     *
     */
    public final static ServiceOrderTemplateItemField<String> SERVICE_ORDER_TEMPLATE_ITEM =
        new ServiceOrderTemplateItemField<String>("ServiceOrderTemplateItem");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ServiceOrderTemplateItemUUID</b>
     * </p>
     *
     * @return GUID of a CRM Order Object
     */
    @SerializedName( "ServiceOrderTemplateItemUUID" )
    @JsonProperty( "ServiceOrderTemplateItemUUID" )
    @Nullable
    @ODataField( odataName = "ServiceOrderTemplateItemUUID" )
    private UUID serviceOrderTemplateItemUUID;
    /**
     * Use with available fluent helpers to apply the <b>ServiceOrderTemplateItemUUID</b> field to query operations.
     *
     */
    public final static ServiceOrderTemplateItemField<UUID> SERVICE_ORDER_TEMPLATE_ITEM_UUID =
        new ServiceOrderTemplateItemField<UUID>("ServiceOrderTemplateItemUUID");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>SrvcOrdTmplItmDescription</b>
     * </p>
     *
     * @return Product Description
     */
    @SerializedName( "SrvcOrdTmplItmDescription" )
    @JsonProperty( "SrvcOrdTmplItmDescription" )
    @Nullable
    @ODataField( odataName = "SrvcOrdTmplItmDescription" )
    private String srvcOrdTmplItmDescription;
    /**
     * Use with available fluent helpers to apply the <b>SrvcOrdTmplItmDescription</b> field to query operations.
     *
     */
    public final static ServiceOrderTemplateItemField<String> SRVC_ORD_TMPL_ITM_DESCRIPTION =
        new ServiceOrderTemplateItemField<String>("SrvcOrdTmplItmDescription");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServiceObjectType</b>
     * </p>
     *
     * @return Business Trans. Cat.
     */
    @SerializedName( "ServiceObjectType" )
    @JsonProperty( "ServiceObjectType" )
    @Nullable
    @ODataField( odataName = "ServiceObjectType" )
    private String serviceObjectType;
    /**
     * Use with available fluent helpers to apply the <b>ServiceObjectType</b> field to query operations.
     *
     */
    public final static ServiceOrderTemplateItemField<String> SERVICE_OBJECT_TYPE =
        new ServiceOrderTemplateItemField<String>("ServiceObjectType");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocumentItemObjectType</b>
     * </p>
     *
     * @return CRM Item Object Type
     */
    @SerializedName( "ServiceDocumentItemObjectType" )
    @JsonProperty( "ServiceDocumentItemObjectType" )
    @Nullable
    @ODataField( odataName = "ServiceDocumentItemObjectType" )
    private String serviceDocumentItemObjectType;
    /**
     * Use with available fluent helpers to apply the <b>ServiceDocumentItemObjectType</b> field to query operations.
     *
     */
    public final static ServiceOrderTemplateItemField<String> SERVICE_DOCUMENT_ITEM_OBJECT_TYPE =
        new ServiceOrderTemplateItemField<String>("ServiceDocumentItemObjectType");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Short Text Language for an Item
     */
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static ServiceOrderTemplateItemField<String> LANGUAGE =
        new ServiceOrderTemplateItemField<String>("Language");
    /**
     * Constraints: Not nullable, Maximum length: 54
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     *
     * @return Product Name Entered
     */
    @SerializedName( "Product" )
    @JsonProperty( "Product" )
    @Nullable
    @ODataField( odataName = "Product" )
    private String product;
    /**
     * Use with available fluent helpers to apply the <b>Product</b> field to query operations.
     *
     */
    public final static ServiceOrderTemplateItemField<String> PRODUCT =
        new ServiceOrderTemplateItemField<String>("Product");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>Quantity</b>
     * </p>
     *
     * @return CRM: Order Quantity
     */
    @SerializedName( "Quantity" )
    @JsonProperty( "Quantity" )
    @Nullable
    @ODataField( odataName = "Quantity" )
    private BigDecimal quantity;
    /**
     * Use with available fluent helpers to apply the <b>Quantity</b> field to query operations.
     *
     */
    public final static ServiceOrderTemplateItemField<BigDecimal> QUANTITY =
        new ServiceOrderTemplateItemField<BigDecimal>("Quantity");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>QuantityUnit</b>
     * </p>
     *
     * @return Unit of Measure in Which the Product Is Sold
     */
    @SerializedName( "QuantityUnit" )
    @JsonProperty( "QuantityUnit" )
    @Nullable
    @ODataField( odataName = "QuantityUnit" )
    private String quantityUnit;
    /**
     * Use with available fluent helpers to apply the <b>QuantityUnit</b> field to query operations.
     *
     */
    public final static ServiceOrderTemplateItemField<String> QUANTITY_UNIT =
        new ServiceOrderTemplateItemField<String>("QuantityUnit");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SrvcOrdTmplItmCategory</b>
     * </p>
     *
     * @return Item Category
     */
    @SerializedName( "SrvcOrdTmplItmCategory" )
    @JsonProperty( "SrvcOrdTmplItmCategory" )
    @Nullable
    @ODataField( odataName = "SrvcOrdTmplItmCategory" )
    private String srvcOrdTmplItmCategory;
    /**
     * Use with available fluent helpers to apply the <b>SrvcOrdTmplItmCategory</b> field to query operations.
     *
     */
    public final static ServiceOrderTemplateItemField<String> SRVC_ORD_TMPL_ITM_CATEGORY =
        new ServiceOrderTemplateItemField<String>("SrvcOrdTmplItmCategory");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>SrvcDocItmValdtyStartDateTime</b>
     * </p>
     *
     * @return Time Dependency: Validity Start Date
     */
    @SerializedName( "SrvcDocItmValdtyStartDateTime" )
    @JsonProperty( "SrvcDocItmValdtyStartDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "SrvcDocItmValdtyStartDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime srvcDocItmValdtyStartDateTime;
    /**
     * Use with available fluent helpers to apply the <b>SrvcDocItmValdtyStartDateTime</b> field to query operations.
     *
     */
    public final static ServiceOrderTemplateItemField<ZonedDateTime> SRVC_DOC_ITM_VALDTY_START_DATE_TIME =
        new ServiceOrderTemplateItemField<ZonedDateTime>("SrvcDocItmValdtyStartDateTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>SrvcDocItmValdtyEndDateTime</b>
     * </p>
     *
     * @return Time Dependency: Validity End Date
     */
    @SerializedName( "SrvcDocItmValdtyEndDateTime" )
    @JsonProperty( "SrvcDocItmValdtyEndDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "SrvcDocItmValdtyEndDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime srvcDocItmValdtyEndDateTime;
    /**
     * Use with available fluent helpers to apply the <b>SrvcDocItmValdtyEndDateTime</b> field to query operations.
     *
     */
    public final static ServiceOrderTemplateItemField<ZonedDateTime> SRVC_DOC_ITM_VALDTY_END_DATE_TIME =
        new ServiceOrderTemplateItemField<ZonedDateTime>("SrvcDocItmValdtyEndDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PersonResponsible</b>
     * </p>
     *
     * @return Employee Responsible
     */
    @SerializedName( "PersonResponsible" )
    @JsonProperty( "PersonResponsible" )
    @Nullable
    @ODataField( odataName = "PersonResponsible" )
    private String personResponsible;
    /**
     * Use with available fluent helpers to apply the <b>PersonResponsible</b> field to query operations.
     *
     */
    public final static ServiceOrderTemplateItemField<String> PERSON_RESPONSIBLE =
        new ServiceOrderTemplateItemField<String>("PersonResponsible");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SrvcOrdTmplItmIsReleased</b>
     * </p>
     *
     * @return Release Status
     */
    @SerializedName( "SrvcOrdTmplItmIsReleased" )
    @JsonProperty( "SrvcOrdTmplItmIsReleased" )
    @Nullable
    @ODataField( odataName = "SrvcOrdTmplItmIsReleased" )
    private String srvcOrdTmplItmIsReleased;
    /**
     * Use with available fluent helpers to apply the <b>SrvcOrdTmplItmIsReleased</b> field to query operations.
     *
     */
    public final static ServiceOrderTemplateItemField<String> SRVC_ORD_TMPL_ITM_IS_RELEASED =
        new ServiceOrderTemplateItemField<String>("SrvcOrdTmplItmIsReleased");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ParentServiceOrderTemplateItem</b>
     * </p>
     *
     * @return Shortened Item Number in Document
     */
    @SerializedName( "ParentServiceOrderTemplateItem" )
    @JsonProperty( "ParentServiceOrderTemplateItem" )
    @Nullable
    @ODataField( odataName = "ParentServiceOrderTemplateItem" )
    private String parentServiceOrderTemplateItem;
    /**
     * Use with available fluent helpers to apply the <b>ParentServiceOrderTemplateItem</b> field to query operations.
     *
     */
    public final static ServiceOrderTemplateItemField<String> PARENT_SERVICE_ORDER_TEMPLATE_ITEM =
        new ServiceOrderTemplateItemField<String>("ParentServiceOrderTemplateItem");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SrvcOrdTmplItmIsCompleted</b>
     * </p>
     *
     * @return The srvcOrdTmplItmIsCompleted contained in this entity.
     */
    @SerializedName( "SrvcOrdTmplItmIsCompleted" )
    @JsonProperty( "SrvcOrdTmplItmIsCompleted" )
    @Nullable
    @ODataField( odataName = "SrvcOrdTmplItmIsCompleted" )
    private String srvcOrdTmplItmIsCompleted;
    /**
     * Use with available fluent helpers to apply the <b>SrvcOrdTmplItmIsCompleted</b> field to query operations.
     *
     */
    public final static ServiceOrderTemplateItemField<String> SRVC_ORD_TMPL_ITM_IS_COMPLETED =
        new ServiceOrderTemplateItemField<String>("SrvcOrdTmplItmIsCompleted");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SrvcDocItmPartReferenceItem</b>
     * </p>
     *
     * @return Shortened Item Number in Document
     */
    @SerializedName( "SrvcDocItmPartReferenceItem" )
    @JsonProperty( "SrvcDocItmPartReferenceItem" )
    @Nullable
    @ODataField( odataName = "SrvcDocItmPartReferenceItem" )
    private String srvcDocItmPartReferenceItem;
    /**
     * Use with available fluent helpers to apply the <b>SrvcDocItmPartReferenceItem</b> field to query operations.
     *
     */
    public final static ServiceOrderTemplateItemField<String> SRVC_DOC_ITM_PART_REFERENCE_ITEM =
        new ServiceOrderTemplateItemField<String>("SrvcDocItmPartReferenceItem");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SrvcDocItmApptReferenceItem</b>
     * </p>
     *
     * @return Shortened Item Number in Document
     */
    @SerializedName( "SrvcDocItmApptReferenceItem" )
    @JsonProperty( "SrvcDocItmApptReferenceItem" )
    @Nullable
    @ODataField( odataName = "SrvcDocItmApptReferenceItem" )
    private String srvcDocItmApptReferenceItem;
    /**
     * Use with available fluent helpers to apply the <b>SrvcDocItmApptReferenceItem</b> field to query operations.
     *
     */
    public final static ServiceOrderTemplateItemField<String> SRVC_DOC_ITM_APPT_REFERENCE_ITEM =
        new ServiceOrderTemplateItemField<String>("SrvcDocItmApptReferenceItem");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SrvcDocItmApptRefObjectUUID</b>
     * </p>
     *
     * @return GUID of a CRM Order Object
     */
    @SerializedName( "SrvcDocItmApptRefObjectUUID" )
    @JsonProperty( "SrvcDocItmApptRefObjectUUID" )
    @Nullable
    @ODataField( odataName = "SrvcDocItmApptRefObjectUUID" )
    private UUID srvcDocItmApptRefObjectUUID;
    /**
     * Use with available fluent helpers to apply the <b>SrvcDocItmApptRefObjectUUID</b> field to query operations.
     *
     */
    public final static ServiceOrderTemplateItemField<UUID> SRVC_DOC_ITM_APPT_REF_OBJECT_UUID =
        new ServiceOrderTemplateItemField<UUID>("SrvcDocItmApptRefObjectUUID");
    /**
     * Navigation property <b>to_Appointment</b> for <b>ServiceOrderTemplateItem</b> to multiple
     * <b>SrvcOrdTmplItemAppointment</b>.
     *
     */
    @SerializedName( "to_Appointment" )
    @JsonProperty( "to_Appointment" )
    @ODataField( odataName = "to_Appointment" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SrvcOrdTmplItemAppointment> toAppointment;
    /**
     * Navigation property <b>to_Duration</b> for <b>ServiceOrderTemplateItem</b> to multiple
     * <b>SrvcOrdTmplItemDuration</b>.
     *
     */
    @SerializedName( "to_Duration" )
    @JsonProperty( "to_Duration" )
    @ODataField( odataName = "to_Duration" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SrvcOrdTmplItemDuration> toDuration;
    /**
     * Navigation property <b>to_Partner</b> for <b>ServiceOrderTemplateItem</b> to multiple
     * <b>SrvcOrdTmplItemPartner</b>.
     *
     */
    @SerializedName( "to_Partner" )
    @JsonProperty( "to_Partner" )
    @ODataField( odataName = "to_Partner" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SrvcOrdTmplItemPartner> toPartner;
    /**
     * Navigation property <b>to_ReferenceObject</b> for <b>ServiceOrderTemplateItem</b> to multiple
     * <b>ServiceOrderTmplItemRefObj</b>.
     *
     */
    @SerializedName( "to_ReferenceObject" )
    @JsonProperty( "to_ReferenceObject" )
    @ODataField( odataName = "to_ReferenceObject" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ServiceOrderTmplItemRefObj> toReferenceObject;
    /**
     * Navigation property <b>to_ServiceOrderTemplate</b> for <b>ServiceOrderTemplateItem</b> to single
     * <b>ServiceOrderTemplate</b>.
     *
     */
    @SerializedName( "to_ServiceOrderTemplate" )
    @JsonProperty( "to_ServiceOrderTemplate" )
    @ODataField( odataName = "to_ServiceOrderTemplate" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private ServiceOrderTemplate toServiceOrderTemplate;
    /**
     * Navigation property <b>to_SrvcOrdTmplItemUserStatus</b> for <b>ServiceOrderTemplateItem</b> to multiple
     * <b>SrvcOrdTmplItemUserStatus</b>.
     *
     */
    @SerializedName( "to_SrvcOrdTmplItemUserStatus" )
    @JsonProperty( "to_SrvcOrdTmplItemUserStatus" )
    @ODataField( odataName = "to_SrvcOrdTmplItemUserStatus" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SrvcOrdTmplItemUserStatus> toSrvcOrdTmplItemUserStatus;
    /**
     * Navigation property <b>to_Text</b> for <b>ServiceOrderTemplateItem</b> to multiple
     * <b>ServiceOrderTmplItemText</b>.
     *
     */
    @SerializedName( "to_Text" )
    @JsonProperty( "to_Text" )
    @ODataField( odataName = "to_Text" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ServiceOrderTmplItemText> toText;
    /**
     * Use with available fluent helpers to apply the <b>to_Appointment</b> navigation property to query operations.
     *
     */
    public final static ServiceOrderTemplateItemLink<SrvcOrdTmplItemAppointment> TO_APPOINTMENT =
        new ServiceOrderTemplateItemLink<SrvcOrdTmplItemAppointment>("to_Appointment");
    /**
     * Use with available fluent helpers to apply the <b>to_Duration</b> navigation property to query operations.
     *
     */
    public final static ServiceOrderTemplateItemLink<SrvcOrdTmplItemDuration> TO_DURATION =
        new ServiceOrderTemplateItemLink<SrvcOrdTmplItemDuration>("to_Duration");
    /**
     * Use with available fluent helpers to apply the <b>to_Partner</b> navigation property to query operations.
     *
     */
    public final static ServiceOrderTemplateItemLink<SrvcOrdTmplItemPartner> TO_PARTNER =
        new ServiceOrderTemplateItemLink<SrvcOrdTmplItemPartner>("to_Partner");
    /**
     * Use with available fluent helpers to apply the <b>to_ReferenceObject</b> navigation property to query operations.
     *
     */
    public final static ServiceOrderTemplateItemLink<ServiceOrderTmplItemRefObj> TO_REFERENCE_OBJECT =
        new ServiceOrderTemplateItemLink<ServiceOrderTmplItemRefObj>("to_ReferenceObject");
    /**
     * Use with available fluent helpers to apply the <b>to_ServiceOrderTemplate</b> navigation property to query
     * operations.
     *
     */
    public final static ServiceOrderTemplateItemOneToOneLink<ServiceOrderTemplate> TO_SERVICE_ORDER_TEMPLATE =
        new ServiceOrderTemplateItemOneToOneLink<ServiceOrderTemplate>("to_ServiceOrderTemplate");
    /**
     * Use with available fluent helpers to apply the <b>to_SrvcOrdTmplItemUserStatus</b> navigation property to query
     * operations.
     *
     */
    public final static ServiceOrderTemplateItemLink<SrvcOrdTmplItemUserStatus> TO_SRVC_ORD_TMPL_ITEM_USER_STATUS =
        new ServiceOrderTemplateItemLink<SrvcOrdTmplItemUserStatus>("to_SrvcOrdTmplItemUserStatus");
    /**
     * Use with available fluent helpers to apply the <b>to_Text</b> navigation property to query operations.
     *
     */
    public final static ServiceOrderTemplateItemLink<ServiceOrderTmplItemText> TO_TEXT =
        new ServiceOrderTemplateItemLink<ServiceOrderTmplItemText>("to_Text");

    @Nonnull
    @Override
    public Class<ServiceOrderTemplateItem> getType()
    {
        return ServiceOrderTemplateItem.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServiceOrderTemplate</b>
     * </p>
     *
     * @param serviceOrderTemplate
     *            Transaction ID
     */
    public void setServiceOrderTemplate( @Nullable final String serviceOrderTemplate )
    {
        rememberChangedField("ServiceOrderTemplate", this.serviceOrderTemplate);
        this.serviceOrderTemplate = serviceOrderTemplate;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ServiceOrderTemplateItem</b>
     * </p>
     *
     * @param serviceOrderTemplateItem
     *            Shortened Item Number in Document
     */
    public void setServiceOrderTemplateItem( @Nullable final String serviceOrderTemplateItem )
    {
        rememberChangedField("ServiceOrderTemplateItem", this.serviceOrderTemplateItem);
        this.serviceOrderTemplateItem = serviceOrderTemplateItem;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ServiceOrderTemplateItemUUID</b>
     * </p>
     *
     * @param serviceOrderTemplateItemUUID
     *            GUID of a CRM Order Object
     */
    public void setServiceOrderTemplateItemUUID( @Nullable final UUID serviceOrderTemplateItemUUID )
    {
        rememberChangedField("ServiceOrderTemplateItemUUID", this.serviceOrderTemplateItemUUID);
        this.serviceOrderTemplateItemUUID = serviceOrderTemplateItemUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>SrvcOrdTmplItmDescription</b>
     * </p>
     *
     * @param srvcOrdTmplItmDescription
     *            Product Description
     */
    public void setSrvcOrdTmplItmDescription( @Nullable final String srvcOrdTmplItmDescription )
    {
        rememberChangedField("SrvcOrdTmplItmDescription", this.srvcOrdTmplItmDescription);
        this.srvcOrdTmplItmDescription = srvcOrdTmplItmDescription;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServiceObjectType</b>
     * </p>
     *
     * @param serviceObjectType
     *            Business Trans. Cat.
     */
    public void setServiceObjectType( @Nullable final String serviceObjectType )
    {
        rememberChangedField("ServiceObjectType", this.serviceObjectType);
        this.serviceObjectType = serviceObjectType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocumentItemObjectType</b>
     * </p>
     *
     * @param serviceDocumentItemObjectType
     *            CRM Item Object Type
     */
    public void setServiceDocumentItemObjectType( @Nullable final String serviceDocumentItemObjectType )
    {
        rememberChangedField("ServiceDocumentItemObjectType", this.serviceDocumentItemObjectType);
        this.serviceDocumentItemObjectType = serviceDocumentItemObjectType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Short Text Language for an Item
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * Constraints: Not nullable, Maximum length: 54
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     *
     * @param product
     *            Product Name Entered
     */
    public void setProduct( @Nullable final String product )
    {
        rememberChangedField("Product", this.product);
        this.product = product;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>Quantity</b>
     * </p>
     *
     * @param quantity
     *            CRM: Order Quantity
     */
    public void setQuantity( @Nullable final BigDecimal quantity )
    {
        rememberChangedField("Quantity", this.quantity);
        this.quantity = quantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>QuantityUnit</b>
     * </p>
     *
     * @param quantityUnit
     *            Unit of Measure in Which the Product Is Sold
     */
    public void setQuantityUnit( @Nullable final String quantityUnit )
    {
        rememberChangedField("QuantityUnit", this.quantityUnit);
        this.quantityUnit = quantityUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SrvcOrdTmplItmCategory</b>
     * </p>
     *
     * @param srvcOrdTmplItmCategory
     *            Item Category
     */
    public void setSrvcOrdTmplItmCategory( @Nullable final String srvcOrdTmplItmCategory )
    {
        rememberChangedField("SrvcOrdTmplItmCategory", this.srvcOrdTmplItmCategory);
        this.srvcOrdTmplItmCategory = srvcOrdTmplItmCategory;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>SrvcDocItmValdtyStartDateTime</b>
     * </p>
     *
     * @param srvcDocItmValdtyStartDateTime
     *            Time Dependency: Validity Start Date
     */
    public void setSrvcDocItmValdtyStartDateTime( @Nullable final ZonedDateTime srvcDocItmValdtyStartDateTime )
    {
        rememberChangedField("SrvcDocItmValdtyStartDateTime", this.srvcDocItmValdtyStartDateTime);
        this.srvcDocItmValdtyStartDateTime = srvcDocItmValdtyStartDateTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>SrvcDocItmValdtyEndDateTime</b>
     * </p>
     *
     * @param srvcDocItmValdtyEndDateTime
     *            Time Dependency: Validity End Date
     */
    public void setSrvcDocItmValdtyEndDateTime( @Nullable final ZonedDateTime srvcDocItmValdtyEndDateTime )
    {
        rememberChangedField("SrvcDocItmValdtyEndDateTime", this.srvcDocItmValdtyEndDateTime);
        this.srvcDocItmValdtyEndDateTime = srvcDocItmValdtyEndDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PersonResponsible</b>
     * </p>
     *
     * @param personResponsible
     *            Employee Responsible
     */
    public void setPersonResponsible( @Nullable final String personResponsible )
    {
        rememberChangedField("PersonResponsible", this.personResponsible);
        this.personResponsible = personResponsible;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SrvcOrdTmplItmIsReleased</b>
     * </p>
     *
     * @param srvcOrdTmplItmIsReleased
     *            Release Status
     */
    public void setSrvcOrdTmplItmIsReleased( @Nullable final String srvcOrdTmplItmIsReleased )
    {
        rememberChangedField("SrvcOrdTmplItmIsReleased", this.srvcOrdTmplItmIsReleased);
        this.srvcOrdTmplItmIsReleased = srvcOrdTmplItmIsReleased;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ParentServiceOrderTemplateItem</b>
     * </p>
     *
     * @param parentServiceOrderTemplateItem
     *            Shortened Item Number in Document
     */
    public void setParentServiceOrderTemplateItem( @Nullable final String parentServiceOrderTemplateItem )
    {
        rememberChangedField("ParentServiceOrderTemplateItem", this.parentServiceOrderTemplateItem);
        this.parentServiceOrderTemplateItem = parentServiceOrderTemplateItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SrvcOrdTmplItmIsCompleted</b>
     * </p>
     *
     * @param srvcOrdTmplItmIsCompleted
     *            The srvcOrdTmplItmIsCompleted to set.
     */
    public void setSrvcOrdTmplItmIsCompleted( @Nullable final String srvcOrdTmplItmIsCompleted )
    {
        rememberChangedField("SrvcOrdTmplItmIsCompleted", this.srvcOrdTmplItmIsCompleted);
        this.srvcOrdTmplItmIsCompleted = srvcOrdTmplItmIsCompleted;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SrvcDocItmPartReferenceItem</b>
     * </p>
     *
     * @param srvcDocItmPartReferenceItem
     *            Shortened Item Number in Document
     */
    public void setSrvcDocItmPartReferenceItem( @Nullable final String srvcDocItmPartReferenceItem )
    {
        rememberChangedField("SrvcDocItmPartReferenceItem", this.srvcDocItmPartReferenceItem);
        this.srvcDocItmPartReferenceItem = srvcDocItmPartReferenceItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SrvcDocItmApptReferenceItem</b>
     * </p>
     *
     * @param srvcDocItmApptReferenceItem
     *            Shortened Item Number in Document
     */
    public void setSrvcDocItmApptReferenceItem( @Nullable final String srvcDocItmApptReferenceItem )
    {
        rememberChangedField("SrvcDocItmApptReferenceItem", this.srvcDocItmApptReferenceItem);
        this.srvcDocItmApptReferenceItem = srvcDocItmApptReferenceItem;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SrvcDocItmApptRefObjectUUID</b>
     * </p>
     *
     * @param srvcDocItmApptRefObjectUUID
     *            GUID of a CRM Order Object
     */
    public void setSrvcDocItmApptRefObjectUUID( @Nullable final UUID srvcDocItmApptRefObjectUUID )
    {
        rememberChangedField("SrvcDocItmApptRefObjectUUID", this.srvcDocItmApptRefObjectUUID);
        this.srvcDocItmApptRefObjectUUID = srvcDocItmApptRefObjectUUID;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_ServiceOrderTemplateItem";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ServiceOrderTemplate", getServiceOrderTemplate());
        result.put("ServiceOrderTemplateItem", getServiceOrderTemplateItem());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ServiceOrderTemplate", getServiceOrderTemplate());
        values.put("ServiceOrderTemplateItem", getServiceOrderTemplateItem());
        values.put("ServiceOrderTemplateItemUUID", getServiceOrderTemplateItemUUID());
        values.put("SrvcOrdTmplItmDescription", getSrvcOrdTmplItmDescription());
        values.put("ServiceObjectType", getServiceObjectType());
        values.put("ServiceDocumentItemObjectType", getServiceDocumentItemObjectType());
        values.put("Language", getLanguage());
        values.put("Product", getProduct());
        values.put("Quantity", getQuantity());
        values.put("QuantityUnit", getQuantityUnit());
        values.put("SrvcOrdTmplItmCategory", getSrvcOrdTmplItmCategory());
        values.put("SrvcDocItmValdtyStartDateTime", getSrvcDocItmValdtyStartDateTime());
        values.put("SrvcDocItmValdtyEndDateTime", getSrvcDocItmValdtyEndDateTime());
        values.put("PersonResponsible", getPersonResponsible());
        values.put("SrvcOrdTmplItmIsReleased", getSrvcOrdTmplItmIsReleased());
        values.put("ParentServiceOrderTemplateItem", getParentServiceOrderTemplateItem());
        values.put("SrvcOrdTmplItmIsCompleted", getSrvcOrdTmplItmIsCompleted());
        values.put("SrvcDocItmPartReferenceItem", getSrvcDocItmPartReferenceItem());
        values.put("SrvcDocItmApptReferenceItem", getSrvcDocItmApptReferenceItem());
        values.put("SrvcDocItmApptRefObjectUUID", getSrvcDocItmApptRefObjectUUID());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ServiceOrderTemplate") ) {
                final Object value = values.remove("ServiceOrderTemplate");
                if( (value == null) || (!value.equals(getServiceOrderTemplate())) ) {
                    setServiceOrderTemplate(((String) value));
                }
            }
            if( values.containsKey("ServiceOrderTemplateItem") ) {
                final Object value = values.remove("ServiceOrderTemplateItem");
                if( (value == null) || (!value.equals(getServiceOrderTemplateItem())) ) {
                    setServiceOrderTemplateItem(((String) value));
                }
            }
            if( values.containsKey("ServiceOrderTemplateItemUUID") ) {
                final Object value = values.remove("ServiceOrderTemplateItemUUID");
                if( (value == null) || (!value.equals(getServiceOrderTemplateItemUUID())) ) {
                    setServiceOrderTemplateItemUUID(((UUID) value));
                }
            }
            if( values.containsKey("SrvcOrdTmplItmDescription") ) {
                final Object value = values.remove("SrvcOrdTmplItmDescription");
                if( (value == null) || (!value.equals(getSrvcOrdTmplItmDescription())) ) {
                    setSrvcOrdTmplItmDescription(((String) value));
                }
            }
            if( values.containsKey("ServiceObjectType") ) {
                final Object value = values.remove("ServiceObjectType");
                if( (value == null) || (!value.equals(getServiceObjectType())) ) {
                    setServiceObjectType(((String) value));
                }
            }
            if( values.containsKey("ServiceDocumentItemObjectType") ) {
                final Object value = values.remove("ServiceDocumentItemObjectType");
                if( (value == null) || (!value.equals(getServiceDocumentItemObjectType())) ) {
                    setServiceDocumentItemObjectType(((String) value));
                }
            }
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("Product") ) {
                final Object value = values.remove("Product");
                if( (value == null) || (!value.equals(getProduct())) ) {
                    setProduct(((String) value));
                }
            }
            if( values.containsKey("Quantity") ) {
                final Object value = values.remove("Quantity");
                if( (value == null) || (!value.equals(getQuantity())) ) {
                    setQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("QuantityUnit") ) {
                final Object value = values.remove("QuantityUnit");
                if( (value == null) || (!value.equals(getQuantityUnit())) ) {
                    setQuantityUnit(((String) value));
                }
            }
            if( values.containsKey("SrvcOrdTmplItmCategory") ) {
                final Object value = values.remove("SrvcOrdTmplItmCategory");
                if( (value == null) || (!value.equals(getSrvcOrdTmplItmCategory())) ) {
                    setSrvcOrdTmplItmCategory(((String) value));
                }
            }
            if( values.containsKey("SrvcDocItmValdtyStartDateTime") ) {
                final Object value = values.remove("SrvcDocItmValdtyStartDateTime");
                if( (value == null) || (!value.equals(getSrvcDocItmValdtyStartDateTime())) ) {
                    setSrvcDocItmValdtyStartDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("SrvcDocItmValdtyEndDateTime") ) {
                final Object value = values.remove("SrvcDocItmValdtyEndDateTime");
                if( (value == null) || (!value.equals(getSrvcDocItmValdtyEndDateTime())) ) {
                    setSrvcDocItmValdtyEndDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("PersonResponsible") ) {
                final Object value = values.remove("PersonResponsible");
                if( (value == null) || (!value.equals(getPersonResponsible())) ) {
                    setPersonResponsible(((String) value));
                }
            }
            if( values.containsKey("SrvcOrdTmplItmIsReleased") ) {
                final Object value = values.remove("SrvcOrdTmplItmIsReleased");
                if( (value == null) || (!value.equals(getSrvcOrdTmplItmIsReleased())) ) {
                    setSrvcOrdTmplItmIsReleased(((String) value));
                }
            }
            if( values.containsKey("ParentServiceOrderTemplateItem") ) {
                final Object value = values.remove("ParentServiceOrderTemplateItem");
                if( (value == null) || (!value.equals(getParentServiceOrderTemplateItem())) ) {
                    setParentServiceOrderTemplateItem(((String) value));
                }
            }
            if( values.containsKey("SrvcOrdTmplItmIsCompleted") ) {
                final Object value = values.remove("SrvcOrdTmplItmIsCompleted");
                if( (value == null) || (!value.equals(getSrvcOrdTmplItmIsCompleted())) ) {
                    setSrvcOrdTmplItmIsCompleted(((String) value));
                }
            }
            if( values.containsKey("SrvcDocItmPartReferenceItem") ) {
                final Object value = values.remove("SrvcDocItmPartReferenceItem");
                if( (value == null) || (!value.equals(getSrvcDocItmPartReferenceItem())) ) {
                    setSrvcDocItmPartReferenceItem(((String) value));
                }
            }
            if( values.containsKey("SrvcDocItmApptReferenceItem") ) {
                final Object value = values.remove("SrvcDocItmApptReferenceItem");
                if( (value == null) || (!value.equals(getSrvcDocItmApptReferenceItem())) ) {
                    setSrvcDocItmApptReferenceItem(((String) value));
                }
            }
            if( values.containsKey("SrvcDocItmApptRefObjectUUID") ) {
                final Object value = values.remove("SrvcDocItmApptRefObjectUUID");
                if( (value == null) || (!value.equals(getSrvcDocItmApptRefObjectUUID())) ) {
                    setSrvcDocItmApptRefObjectUUID(((UUID) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_Appointment") ) {
                final Object value = (values).remove("to_Appointment");
                if( value instanceof Iterable ) {
                    if( toAppointment == null ) {
                        toAppointment = Lists.newArrayList();
                    } else {
                        toAppointment = Lists.newArrayList(toAppointment);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SrvcOrdTmplItemAppointment entity;
                        if( toAppointment.size() > i ) {
                            entity = toAppointment.get(i);
                        } else {
                            entity = new SrvcOrdTmplItemAppointment();
                            toAppointment.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_Duration") ) {
                final Object value = (values).remove("to_Duration");
                if( value instanceof Iterable ) {
                    if( toDuration == null ) {
                        toDuration = Lists.newArrayList();
                    } else {
                        toDuration = Lists.newArrayList(toDuration);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SrvcOrdTmplItemDuration entity;
                        if( toDuration.size() > i ) {
                            entity = toDuration.get(i);
                        } else {
                            entity = new SrvcOrdTmplItemDuration();
                            toDuration.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_Partner") ) {
                final Object value = (values).remove("to_Partner");
                if( value instanceof Iterable ) {
                    if( toPartner == null ) {
                        toPartner = Lists.newArrayList();
                    } else {
                        toPartner = Lists.newArrayList(toPartner);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SrvcOrdTmplItemPartner entity;
                        if( toPartner.size() > i ) {
                            entity = toPartner.get(i);
                        } else {
                            entity = new SrvcOrdTmplItemPartner();
                            toPartner.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_ReferenceObject") ) {
                final Object value = (values).remove("to_ReferenceObject");
                if( value instanceof Iterable ) {
                    if( toReferenceObject == null ) {
                        toReferenceObject = Lists.newArrayList();
                    } else {
                        toReferenceObject = Lists.newArrayList(toReferenceObject);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ServiceOrderTmplItemRefObj entity;
                        if( toReferenceObject.size() > i ) {
                            entity = toReferenceObject.get(i);
                        } else {
                            entity = new ServiceOrderTmplItemRefObj();
                            toReferenceObject.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_ServiceOrderTemplate") ) {
                final Object value = (values).remove("to_ServiceOrderTemplate");
                if( value instanceof Map ) {
                    if( toServiceOrderTemplate == null ) {
                        toServiceOrderTemplate = new ServiceOrderTemplate();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toServiceOrderTemplate.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_SrvcOrdTmplItemUserStatus") ) {
                final Object value = (values).remove("to_SrvcOrdTmplItemUserStatus");
                if( value instanceof Iterable ) {
                    if( toSrvcOrdTmplItemUserStatus == null ) {
                        toSrvcOrdTmplItemUserStatus = Lists.newArrayList();
                    } else {
                        toSrvcOrdTmplItemUserStatus = Lists.newArrayList(toSrvcOrdTmplItemUserStatus);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SrvcOrdTmplItemUserStatus entity;
                        if( toSrvcOrdTmplItemUserStatus.size() > i ) {
                            entity = toSrvcOrdTmplItemUserStatus.get(i);
                        } else {
                            entity = new SrvcOrdTmplItemUserStatus();
                            toSrvcOrdTmplItemUserStatus.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_Text") ) {
                final Object value = (values).remove("to_Text");
                if( value instanceof Iterable ) {
                    if( toText == null ) {
                        toText = Lists.newArrayList();
                    } else {
                        toText = Lists.newArrayList(toText);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ServiceOrderTmplItemText entity;
                        if( toText.size() > i ) {
                            entity = toText.get(i);
                        } else {
                            entity = new ServiceOrderTmplItemText();
                            toText.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> ServiceOrderTemplateItemField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ServiceOrderTemplateItemField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ServiceOrderTemplateItemField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ServiceOrderTemplateItemField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ServiceOrderTemplateService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toAppointment != null ) {
            (values).put("to_Appointment", toAppointment);
        }
        if( toDuration != null ) {
            (values).put("to_Duration", toDuration);
        }
        if( toPartner != null ) {
            (values).put("to_Partner", toPartner);
        }
        if( toReferenceObject != null ) {
            (values).put("to_ReferenceObject", toReferenceObject);
        }
        if( toServiceOrderTemplate != null ) {
            (values).put("to_ServiceOrderTemplate", toServiceOrderTemplate);
        }
        if( toSrvcOrdTmplItemUserStatus != null ) {
            (values).put("to_SrvcOrdTmplItemUserStatus", toSrvcOrdTmplItemUserStatus);
        }
        if( toText != null ) {
            (values).put("to_Text", toText);
        }
        return values;
    }

    /**
     * Fetches the <b>SrvcOrdTmplItemAppointment</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_Appointment</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SrvcOrdTmplItemAppointment</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SrvcOrdTmplItemAppointment> fetchAppointment()
    {
        return fetchFieldAsList("to_Appointment", SrvcOrdTmplItemAppointment.class);
    }

    /**
     * Retrieval of associated <b>SrvcOrdTmplItemAppointment</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Appointment</b>.
     * <p>
     * If the navigation property <b>to_Appointment</b> of a queried <b>ServiceOrderTemplateItem</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SrvcOrdTmplItemAppointment</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SrvcOrdTmplItemAppointment> getAppointmentOrFetch()
    {
        if( toAppointment == null ) {
            toAppointment = fetchAppointment();
        }
        return toAppointment;
    }

    /**
     * Retrieval of associated <b>SrvcOrdTmplItemAppointment</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Appointment</b>.
     * <p>
     * If the navigation property for an entity <b>ServiceOrderTemplateItem</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Appointment</b> is already loaded, the result will
     *         contain the <b>SrvcOrdTmplItemAppointment</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SrvcOrdTmplItemAppointment>> getAppointmentIfPresent()
    {
        return Option.of(toAppointment);
    }

    /**
     * Overwrites the list of associated <b>SrvcOrdTmplItemAppointment</b> entities for the loaded navigation property
     * <b>to_Appointment</b>.
     * <p>
     * If the navigation property <b>to_Appointment</b> of a queried <b>ServiceOrderTemplateItem</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SrvcOrdTmplItemAppointment</b> entities.
     */
    public void setAppointment( @Nonnull final List<SrvcOrdTmplItemAppointment> value )
    {
        if( toAppointment == null ) {
            toAppointment = Lists.newArrayList();
        }
        toAppointment.clear();
        toAppointment.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SrvcOrdTmplItemAppointment</b> entities. This corresponds to the OData
     * navigation property <b>to_Appointment</b>.
     * <p>
     * If the navigation property <b>to_Appointment</b> of a queried <b>ServiceOrderTemplateItem</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SrvcOrdTmplItemAppointment</b> entities.
     */
    public void addAppointment( SrvcOrdTmplItemAppointment... entity )
    {
        if( toAppointment == null ) {
            toAppointment = Lists.newArrayList();
        }
        toAppointment.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>SrvcOrdTmplItemDuration</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_Duration</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SrvcOrdTmplItemDuration</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SrvcOrdTmplItemDuration> fetchDuration()
    {
        return fetchFieldAsList("to_Duration", SrvcOrdTmplItemDuration.class);
    }

    /**
     * Retrieval of associated <b>SrvcOrdTmplItemDuration</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Duration</b>.
     * <p>
     * If the navigation property <b>to_Duration</b> of a queried <b>ServiceOrderTemplateItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SrvcOrdTmplItemDuration</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SrvcOrdTmplItemDuration> getDurationOrFetch()
    {
        if( toDuration == null ) {
            toDuration = fetchDuration();
        }
        return toDuration;
    }

    /**
     * Retrieval of associated <b>SrvcOrdTmplItemDuration</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Duration</b>.
     * <p>
     * If the navigation property for an entity <b>ServiceOrderTemplateItem</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Duration</b> is already loaded, the result will contain
     *         the <b>SrvcOrdTmplItemDuration</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SrvcOrdTmplItemDuration>> getDurationIfPresent()
    {
        return Option.of(toDuration);
    }

    /**
     * Overwrites the list of associated <b>SrvcOrdTmplItemDuration</b> entities for the loaded navigation property
     * <b>to_Duration</b>.
     * <p>
     * If the navigation property <b>to_Duration</b> of a queried <b>ServiceOrderTemplateItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SrvcOrdTmplItemDuration</b> entities.
     */
    public void setDuration( @Nonnull final List<SrvcOrdTmplItemDuration> value )
    {
        if( toDuration == null ) {
            toDuration = Lists.newArrayList();
        }
        toDuration.clear();
        toDuration.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SrvcOrdTmplItemDuration</b> entities. This corresponds to the OData
     * navigation property <b>to_Duration</b>.
     * <p>
     * If the navigation property <b>to_Duration</b> of a queried <b>ServiceOrderTemplateItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SrvcOrdTmplItemDuration</b> entities.
     */
    public void addDuration( SrvcOrdTmplItemDuration... entity )
    {
        if( toDuration == null ) {
            toDuration = Lists.newArrayList();
        }
        toDuration.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>SrvcOrdTmplItemPartner</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_Partner</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SrvcOrdTmplItemPartner</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SrvcOrdTmplItemPartner> fetchPartner()
    {
        return fetchFieldAsList("to_Partner", SrvcOrdTmplItemPartner.class);
    }

    /**
     * Retrieval of associated <b>SrvcOrdTmplItemPartner</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Partner</b>.
     * <p>
     * If the navigation property <b>to_Partner</b> of a queried <b>ServiceOrderTemplateItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SrvcOrdTmplItemPartner</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SrvcOrdTmplItemPartner> getPartnerOrFetch()
    {
        if( toPartner == null ) {
            toPartner = fetchPartner();
        }
        return toPartner;
    }

    /**
     * Retrieval of associated <b>SrvcOrdTmplItemPartner</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Partner</b>.
     * <p>
     * If the navigation property for an entity <b>ServiceOrderTemplateItem</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Partner</b> is already loaded, the result will contain
     *         the <b>SrvcOrdTmplItemPartner</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SrvcOrdTmplItemPartner>> getPartnerIfPresent()
    {
        return Option.of(toPartner);
    }

    /**
     * Overwrites the list of associated <b>SrvcOrdTmplItemPartner</b> entities for the loaded navigation property
     * <b>to_Partner</b>.
     * <p>
     * If the navigation property <b>to_Partner</b> of a queried <b>ServiceOrderTemplateItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SrvcOrdTmplItemPartner</b> entities.
     */
    public void setPartner( @Nonnull final List<SrvcOrdTmplItemPartner> value )
    {
        if( toPartner == null ) {
            toPartner = Lists.newArrayList();
        }
        toPartner.clear();
        toPartner.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SrvcOrdTmplItemPartner</b> entities. This corresponds to the OData
     * navigation property <b>to_Partner</b>.
     * <p>
     * If the navigation property <b>to_Partner</b> of a queried <b>ServiceOrderTemplateItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SrvcOrdTmplItemPartner</b> entities.
     */
    public void addPartner( SrvcOrdTmplItemPartner... entity )
    {
        if( toPartner == null ) {
            toPartner = Lists.newArrayList();
        }
        toPartner.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>ServiceOrderTmplItemRefObj</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_ReferenceObject</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ServiceOrderTmplItemRefObj</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ServiceOrderTmplItemRefObj> fetchReferenceObject()
    {
        return fetchFieldAsList("to_ReferenceObject", ServiceOrderTmplItemRefObj.class);
    }

    /**
     * Retrieval of associated <b>ServiceOrderTmplItemRefObj</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ReferenceObject</b>.
     * <p>
     * If the navigation property <b>to_ReferenceObject</b> of a queried <b>ServiceOrderTemplateItem</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ServiceOrderTmplItemRefObj</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ServiceOrderTmplItemRefObj> getReferenceObjectOrFetch()
    {
        if( toReferenceObject == null ) {
            toReferenceObject = fetchReferenceObject();
        }
        return toReferenceObject;
    }

    /**
     * Retrieval of associated <b>ServiceOrderTmplItemRefObj</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ReferenceObject</b>.
     * <p>
     * If the navigation property for an entity <b>ServiceOrderTemplateItem</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ReferenceObject</b> is already loaded, the result will
     *         contain the <b>ServiceOrderTmplItemRefObj</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ServiceOrderTmplItemRefObj>> getReferenceObjectIfPresent()
    {
        return Option.of(toReferenceObject);
    }

    /**
     * Overwrites the list of associated <b>ServiceOrderTmplItemRefObj</b> entities for the loaded navigation property
     * <b>to_ReferenceObject</b>.
     * <p>
     * If the navigation property <b>to_ReferenceObject</b> of a queried <b>ServiceOrderTemplateItem</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ServiceOrderTmplItemRefObj</b> entities.
     */
    public void setReferenceObject( @Nonnull final List<ServiceOrderTmplItemRefObj> value )
    {
        if( toReferenceObject == null ) {
            toReferenceObject = Lists.newArrayList();
        }
        toReferenceObject.clear();
        toReferenceObject.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ServiceOrderTmplItemRefObj</b> entities. This corresponds to the OData
     * navigation property <b>to_ReferenceObject</b>.
     * <p>
     * If the navigation property <b>to_ReferenceObject</b> of a queried <b>ServiceOrderTemplateItem</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ServiceOrderTmplItemRefObj</b> entities.
     */
    public void addReferenceObject( ServiceOrderTmplItemRefObj... entity )
    {
        if( toReferenceObject == null ) {
            toReferenceObject = Lists.newArrayList();
        }
        toReferenceObject.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>ServiceOrderTemplate</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_ServiceOrderTemplate</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>ServiceOrderTemplate</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ServiceOrderTemplate fetchServiceOrderTemplate()
    {
        return fetchFieldAsSingle("to_ServiceOrderTemplate", ServiceOrderTemplate.class);
    }

    /**
     * Retrieval of associated <b>ServiceOrderTemplate</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_ServiceOrderTemplate</b>.
     * <p>
     * If the navigation property <b>to_ServiceOrderTemplate</b> of a queried <b>ServiceOrderTemplateItem</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ServiceOrderTemplate</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ServiceOrderTemplate getServiceOrderTemplateOrFetch()
    {
        if( toServiceOrderTemplate == null ) {
            toServiceOrderTemplate = fetchServiceOrderTemplate();
        }
        return toServiceOrderTemplate;
    }

    /**
     * Retrieval of associated <b>ServiceOrderTemplate</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_ServiceOrderTemplate</b>.
     * <p>
     * If the navigation property for an entity <b>ServiceOrderTemplateItem</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ServiceOrderTemplate</b> is already loaded, the result
     *         will contain the <b>ServiceOrderTemplate</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<ServiceOrderTemplate> getServiceOrderTemplateIfPresent()
    {
        return Option.of(toServiceOrderTemplate);
    }

    /**
     * Overwrites the associated <b>ServiceOrderTemplate</b> entity for the loaded navigation property
     * <b>to_ServiceOrderTemplate</b>.
     *
     * @param value
     *            New <b>ServiceOrderTemplate</b> entity.
     */
    public void setServiceOrderTemplate( final ServiceOrderTemplate value )
    {
        toServiceOrderTemplate = value;
    }

    /**
     * Fetches the <b>SrvcOrdTmplItemUserStatus</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_SrvcOrdTmplItemUserStatus</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SrvcOrdTmplItemUserStatus</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SrvcOrdTmplItemUserStatus> fetchSrvcOrdTmplItemUserStatus()
    {
        return fetchFieldAsList("to_SrvcOrdTmplItemUserStatus", SrvcOrdTmplItemUserStatus.class);
    }

    /**
     * Retrieval of associated <b>SrvcOrdTmplItemUserStatus</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_SrvcOrdTmplItemUserStatus</b>.
     * <p>
     * If the navigation property <b>to_SrvcOrdTmplItemUserStatus</b> of a queried <b>ServiceOrderTemplateItem</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SrvcOrdTmplItemUserStatus</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SrvcOrdTmplItemUserStatus> getSrvcOrdTmplItemUserStatusOrFetch()
    {
        if( toSrvcOrdTmplItemUserStatus == null ) {
            toSrvcOrdTmplItemUserStatus = fetchSrvcOrdTmplItemUserStatus();
        }
        return toSrvcOrdTmplItemUserStatus;
    }

    /**
     * Retrieval of associated <b>SrvcOrdTmplItemUserStatus</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_SrvcOrdTmplItemUserStatus</b>.
     * <p>
     * If the navigation property for an entity <b>ServiceOrderTemplateItem</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SrvcOrdTmplItemUserStatus</b> is already loaded, the
     *         result will contain the <b>SrvcOrdTmplItemUserStatus</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SrvcOrdTmplItemUserStatus>> getSrvcOrdTmplItemUserStatusIfPresent()
    {
        return Option.of(toSrvcOrdTmplItemUserStatus);
    }

    /**
     * Overwrites the list of associated <b>SrvcOrdTmplItemUserStatus</b> entities for the loaded navigation property
     * <b>to_SrvcOrdTmplItemUserStatus</b>.
     * <p>
     * If the navigation property <b>to_SrvcOrdTmplItemUserStatus</b> of a queried <b>ServiceOrderTemplateItem</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SrvcOrdTmplItemUserStatus</b> entities.
     */
    public void setSrvcOrdTmplItemUserStatus( @Nonnull final List<SrvcOrdTmplItemUserStatus> value )
    {
        if( toSrvcOrdTmplItemUserStatus == null ) {
            toSrvcOrdTmplItemUserStatus = Lists.newArrayList();
        }
        toSrvcOrdTmplItemUserStatus.clear();
        toSrvcOrdTmplItemUserStatus.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SrvcOrdTmplItemUserStatus</b> entities. This corresponds to the OData
     * navigation property <b>to_SrvcOrdTmplItemUserStatus</b>.
     * <p>
     * If the navigation property <b>to_SrvcOrdTmplItemUserStatus</b> of a queried <b>ServiceOrderTemplateItem</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SrvcOrdTmplItemUserStatus</b> entities.
     */
    public void addSrvcOrdTmplItemUserStatus( SrvcOrdTmplItemUserStatus... entity )
    {
        if( toSrvcOrdTmplItemUserStatus == null ) {
            toSrvcOrdTmplItemUserStatus = Lists.newArrayList();
        }
        toSrvcOrdTmplItemUserStatus.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>ServiceOrderTmplItemText</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_Text</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ServiceOrderTmplItemText</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ServiceOrderTmplItemText> fetchText()
    {
        return fetchFieldAsList("to_Text", ServiceOrderTmplItemText.class);
    }

    /**
     * Retrieval of associated <b>ServiceOrderTmplItemText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Text</b>.
     * <p>
     * If the navigation property <b>to_Text</b> of a queried <b>ServiceOrderTemplateItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ServiceOrderTmplItemText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ServiceOrderTmplItemText> getTextOrFetch()
    {
        if( toText == null ) {
            toText = fetchText();
        }
        return toText;
    }

    /**
     * Retrieval of associated <b>ServiceOrderTmplItemText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Text</b>.
     * <p>
     * If the navigation property for an entity <b>ServiceOrderTemplateItem</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Text</b> is already loaded, the result will contain the
     *         <b>ServiceOrderTmplItemText</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ServiceOrderTmplItemText>> getTextIfPresent()
    {
        return Option.of(toText);
    }

    /**
     * Overwrites the list of associated <b>ServiceOrderTmplItemText</b> entities for the loaded navigation property
     * <b>to_Text</b>.
     * <p>
     * If the navigation property <b>to_Text</b> of a queried <b>ServiceOrderTemplateItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ServiceOrderTmplItemText</b> entities.
     */
    public void setText( @Nonnull final List<ServiceOrderTmplItemText> value )
    {
        if( toText == null ) {
            toText = Lists.newArrayList();
        }
        toText.clear();
        toText.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ServiceOrderTmplItemText</b> entities. This corresponds to the OData
     * navigation property <b>to_Text</b>.
     * <p>
     * If the navigation property <b>to_Text</b> of a queried <b>ServiceOrderTemplateItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ServiceOrderTmplItemText</b> entities.
     */
    public void addText( ServiceOrderTmplItemText... entity )
    {
        if( toText == null ) {
            toText = Lists.newArrayList();
        }
        toText.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of ServiceOrderTemplateItem instances.
     *
     */
    public final static class ServiceOrderTemplateItemBuilder
    {

        private List<SrvcOrdTmplItemAppointment> toAppointment = Lists.newArrayList();
        private List<SrvcOrdTmplItemDuration> toDuration = Lists.newArrayList();
        private List<SrvcOrdTmplItemPartner> toPartner = Lists.newArrayList();
        private List<ServiceOrderTmplItemRefObj> toReferenceObject = Lists.newArrayList();
        private ServiceOrderTemplate toServiceOrderTemplate;
        private String serviceOrderTemplate = null;
        private List<SrvcOrdTmplItemUserStatus> toSrvcOrdTmplItemUserStatus = Lists.newArrayList();
        private List<ServiceOrderTmplItemText> toText = Lists.newArrayList();

        private ServiceOrderTemplateItem.ServiceOrderTemplateItemBuilder toAppointment(
            final List<SrvcOrdTmplItemAppointment> value )
        {
            toAppointment.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_Appointment</b> for <b>ServiceOrderTemplateItem</b> to multiple
         * <b>SrvcOrdTmplItemAppointment</b>.
         *
         * @param value
         *            The SrvcOrdTmplItemAppointments to build this ServiceOrderTemplateItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ServiceOrderTemplateItem.ServiceOrderTemplateItemBuilder appointment(
            SrvcOrdTmplItemAppointment... value )
        {
            return toAppointment(Lists.newArrayList(value));
        }

        private ServiceOrderTemplateItem.ServiceOrderTemplateItemBuilder toDuration(
            final List<SrvcOrdTmplItemDuration> value )
        {
            toDuration.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_Duration</b> for <b>ServiceOrderTemplateItem</b> to multiple
         * <b>SrvcOrdTmplItemDuration</b>.
         *
         * @param value
         *            The SrvcOrdTmplItemDurations to build this ServiceOrderTemplateItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ServiceOrderTemplateItem.ServiceOrderTemplateItemBuilder duration( SrvcOrdTmplItemDuration... value )
        {
            return toDuration(Lists.newArrayList(value));
        }

        private ServiceOrderTemplateItem.ServiceOrderTemplateItemBuilder toPartner(
            final List<SrvcOrdTmplItemPartner> value )
        {
            toPartner.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_Partner</b> for <b>ServiceOrderTemplateItem</b> to multiple
         * <b>SrvcOrdTmplItemPartner</b>.
         *
         * @param value
         *            The SrvcOrdTmplItemPartners to build this ServiceOrderTemplateItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ServiceOrderTemplateItem.ServiceOrderTemplateItemBuilder partner( SrvcOrdTmplItemPartner... value )
        {
            return toPartner(Lists.newArrayList(value));
        }

        private ServiceOrderTemplateItem.ServiceOrderTemplateItemBuilder toReferenceObject(
            final List<ServiceOrderTmplItemRefObj> value )
        {
            toReferenceObject.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_ReferenceObject</b> for <b>ServiceOrderTemplateItem</b> to multiple
         * <b>ServiceOrderTmplItemRefObj</b>.
         *
         * @param value
         *            The ServiceOrderTmplItemRefObjs to build this ServiceOrderTemplateItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ServiceOrderTemplateItem.ServiceOrderTemplateItemBuilder referenceObject(
            ServiceOrderTmplItemRefObj... value )
        {
            return toReferenceObject(Lists.newArrayList(value));
        }

        private ServiceOrderTemplateItem.ServiceOrderTemplateItemBuilder toServiceOrderTemplate(
            final ServiceOrderTemplate value )
        {
            toServiceOrderTemplate = value;
            return this;
        }

        /**
         * Navigation property <b>to_ServiceOrderTemplate</b> for <b>ServiceOrderTemplateItem</b> to single
         * <b>ServiceOrderTemplate</b>.
         *
         * @param value
         *            The ServiceOrderTemplate to build this ServiceOrderTemplateItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ServiceOrderTemplateItem.ServiceOrderTemplateItemBuilder serviceOrderTemplate(
            final ServiceOrderTemplate value )
        {
            return toServiceOrderTemplate(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 10
         * <p>
         * Original property name from the Odata EDM: <b>ServiceOrderTemplate</b>
         * </p>
         *
         * @param value
         *            The serviceOrderTemplate to build this ServiceOrderTemplateItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ServiceOrderTemplateItem.ServiceOrderTemplateItemBuilder serviceOrderTemplate( final String value )
        {
            serviceOrderTemplate = value;
            return this;
        }

        private ServiceOrderTemplateItem.ServiceOrderTemplateItemBuilder toSrvcOrdTmplItemUserStatus(
            final List<SrvcOrdTmplItemUserStatus> value )
        {
            toSrvcOrdTmplItemUserStatus.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_SrvcOrdTmplItemUserStatus</b> for <b>ServiceOrderTemplateItem</b> to multiple
         * <b>SrvcOrdTmplItemUserStatus</b>.
         *
         * @param value
         *            The SrvcOrdTmplItemUserStatuss to build this ServiceOrderTemplateItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ServiceOrderTemplateItem.ServiceOrderTemplateItemBuilder srvcOrdTmplItemUserStatus(
            SrvcOrdTmplItemUserStatus... value )
        {
            return toSrvcOrdTmplItemUserStatus(Lists.newArrayList(value));
        }

        private ServiceOrderTemplateItem.ServiceOrderTemplateItemBuilder toText(
            final List<ServiceOrderTmplItemText> value )
        {
            toText.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_Text</b> for <b>ServiceOrderTemplateItem</b> to multiple
         * <b>ServiceOrderTmplItemText</b>.
         *
         * @param value
         *            The ServiceOrderTmplItemTexts to build this ServiceOrderTemplateItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ServiceOrderTemplateItem.ServiceOrderTemplateItemBuilder text( ServiceOrderTmplItemText... value )
        {
            return toText(Lists.newArrayList(value));
        }

    }

}
