/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.selectable.ServiceOrderTmplRefObjectSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTmplRefObject
 * ServiceOrderTmplRefObject} entity using key fields. This fluent helper allows methods which modify the underlying
 * query to be called before executing the query itself.
 *
 */
public class ServiceOrderTmplRefObjectByKeyFluentHelper
    extends
    FluentHelperByKey<ServiceOrderTmplRefObjectByKeyFluentHelper, ServiceOrderTmplRefObject, ServiceOrderTmplRefObjectSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.ServiceOrderTmplRefObject
     * ServiceOrderTmplRefObject} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code ServiceOrderTmplRefObject}
     * @param serviceOrderTemplate
     *            Transaction ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code ServiceOrderTmplRefObject}
     * @param serviceRefFunctionalLocation
     *            Functional Location
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @param serviceReferenceEquipment
     *            Equipment Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 18
     *            </p>
     */
    public ServiceOrderTmplRefObjectByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String serviceOrderTemplate,
        final String serviceReferenceEquipment,
        final String serviceRefFunctionalLocation )
    {
        super(servicePath, entityCollection);
        this.key.put("ServiceOrderTemplate", serviceOrderTemplate);
        this.key.put("ServiceReferenceEquipment", serviceReferenceEquipment);
        this.key.put("ServiceRefFunctionalLocation", serviceRefFunctionalLocation);
    }

    @Override
    @Nonnull
    protected Class<ServiceOrderTmplRefObject> getEntityClass()
    {
        return ServiceOrderTmplRefObject.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
