/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.selectable.SrvcOrdTmplDurationSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplDuration
 * SrvcOrdTmplDuration} entity using key fields. This fluent helper allows methods which modify the underlying query to
 * be called before executing the query itself.
 *
 */
public class SrvcOrdTmplDurationByKeyFluentHelper
    extends
    FluentHelperByKey<SrvcOrdTmplDurationByKeyFluentHelper, SrvcOrdTmplDuration, SrvcOrdTmplDurationSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplDuration
     * SrvcOrdTmplDuration} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code SrvcOrdTmplDuration}
     * @param serviceOrderTemplate
     *            Transaction ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code SrvcOrdTmplDuration}
     * @param srvcDocDurationType
     *            Name for Type of Time Duration
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     */
    public SrvcOrdTmplDurationByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String serviceOrderTemplate,
        final String srvcDocDurationType )
    {
        super(servicePath, entityCollection);
        this.key.put("ServiceOrderTemplate", serviceOrderTemplate);
        this.key.put("SrvcDocDurationType", srvcDocDurationType);
    }

    @Override
    @Nonnull
    protected Class<SrvcOrdTmplDuration> getEntityClass()
    {
        return SrvcOrdTmplDuration.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
