/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.selectable.SrvcOrdTmplItemPartnerSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplItemPartner
 * SrvcOrdTmplItemPartner} entity using key fields. This fluent helper allows methods which modify the underlying query
 * to be called before executing the query itself.
 *
 */
public class SrvcOrdTmplItemPartnerByKeyFluentHelper
    extends
    FluentHelperByKey<SrvcOrdTmplItemPartnerByKeyFluentHelper, SrvcOrdTmplItemPartner, SrvcOrdTmplItemPartnerSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.SrvcOrdTmplItemPartner
     * SrvcOrdTmplItemPartner} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code SrvcOrdTmplItemPartner}
     * @param custMgmtBusinessPartner
     *            Business Partner Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param serviceOrderTemplate
     *            Transaction ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param custMgmtPartnerFunction
     *
     * @param servicePath
     *            Service path to be used to fetch a single {@code SrvcOrdTmplItemPartner}
     * @param serviceOrderTemplateItem
     *            Shortened Item Number in Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     */
    public SrvcOrdTmplItemPartnerByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String serviceOrderTemplate,
        final String serviceOrderTemplateItem,
        final String custMgmtPartnerFunction,
        final String custMgmtBusinessPartner )
    {
        super(servicePath, entityCollection);
        this.key.put("ServiceOrderTemplate", serviceOrderTemplate);
        this.key.put("ServiceOrderTemplateItem", serviceOrderTemplateItem);
        this.key.put("CustMgmtPartnerFunction", custMgmtPartnerFunction);
        this.key.put("CustMgmtBusinessPartner", custMgmtBusinessPartner);
    }

    @Override
    @Nonnull
    protected Class<SrvcOrdTmplItemPartner> getEntityClass()
    {
        return SrvcOrdTmplItemPartner.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
