/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.field.SrvcOrdTmplItemUserStatusField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceordertemplate.selectable.SrvcOrdTmplItemUserStatusSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Service Order Template Item User Status
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_SrvcOrdTmplItemUserStatusType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SrvcOrdTmplItemUserStatus extends VdmEntity<SrvcOrdTmplItemUserStatus>
{

    /**
     * Selector for all available fields of SrvcOrdTmplItemUserStatus.
     *
     */
    public final static SrvcOrdTmplItemUserStatusSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServiceOrderTemplate</b>
     * </p>
     *
     * @return Transaction ID
     */
    @Key
    @SerializedName( "ServiceOrderTemplate" )
    @JsonProperty( "ServiceOrderTemplate" )
    @Nullable
    @ODataField( odataName = "ServiceOrderTemplate" )
    private String serviceOrderTemplate;
    /**
     * Use with available fluent helpers to apply the <b>ServiceOrderTemplate</b> field to query operations.
     *
     */
    public final static SrvcOrdTmplItemUserStatusField<String> SERVICE_ORDER_TEMPLATE =
        new SrvcOrdTmplItemUserStatusField<String>("ServiceOrderTemplate");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ServiceOrderTemplateItem</b>
     * </p>
     *
     * @return Shortened Item Number in Document
     */
    @Key
    @SerializedName( "ServiceOrderTemplateItem" )
    @JsonProperty( "ServiceOrderTemplateItem" )
    @Nullable
    @ODataField( odataName = "ServiceOrderTemplateItem" )
    private String serviceOrderTemplateItem;
    /**
     * Use with available fluent helpers to apply the <b>ServiceOrderTemplateItem</b> field to query operations.
     *
     */
    public final static SrvcOrdTmplItemUserStatusField<String> SERVICE_ORDER_TEMPLATE_ITEM =
        new SrvcOrdTmplItemUserStatusField<String>("ServiceOrderTemplateItem");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>SrvcOrdTmplItmUserStatus</b>
     * </p>
     *
     * @return Object Status
     */
    @Key
    @SerializedName( "SrvcOrdTmplItmUserStatus" )
    @JsonProperty( "SrvcOrdTmplItmUserStatus" )
    @Nullable
    @ODataField( odataName = "SrvcOrdTmplItmUserStatus" )
    private String srvcOrdTmplItmUserStatus;
    /**
     * Use with available fluent helpers to apply the <b>SrvcOrdTmplItmUserStatus</b> field to query operations.
     *
     */
    public final static SrvcOrdTmplItemUserStatusField<String> SRVC_ORD_TMPL_ITM_USER_STATUS =
        new SrvcOrdTmplItemUserStatusField<String>("SrvcOrdTmplItmUserStatus");

    @Nonnull
    @Override
    public Class<SrvcOrdTmplItemUserStatus> getType()
    {
        return SrvcOrdTmplItemUserStatus.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServiceOrderTemplate</b>
     * </p>
     *
     * @param serviceOrderTemplate
     *            Transaction ID
     */
    public void setServiceOrderTemplate( @Nullable final String serviceOrderTemplate )
    {
        rememberChangedField("ServiceOrderTemplate", this.serviceOrderTemplate);
        this.serviceOrderTemplate = serviceOrderTemplate;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ServiceOrderTemplateItem</b>
     * </p>
     *
     * @param serviceOrderTemplateItem
     *            Shortened Item Number in Document
     */
    public void setServiceOrderTemplateItem( @Nullable final String serviceOrderTemplateItem )
    {
        rememberChangedField("ServiceOrderTemplateItem", this.serviceOrderTemplateItem);
        this.serviceOrderTemplateItem = serviceOrderTemplateItem;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>SrvcOrdTmplItmUserStatus</b>
     * </p>
     *
     * @param srvcOrdTmplItmUserStatus
     *            Object Status
     */
    public void setSrvcOrdTmplItmUserStatus( @Nullable final String srvcOrdTmplItmUserStatus )
    {
        rememberChangedField("SrvcOrdTmplItmUserStatus", this.srvcOrdTmplItmUserStatus);
        this.srvcOrdTmplItmUserStatus = srvcOrdTmplItmUserStatus;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_SrvcOrdTmplItemUserStatus";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ServiceOrderTemplate", getServiceOrderTemplate());
        result.put("ServiceOrderTemplateItem", getServiceOrderTemplateItem());
        result.put("SrvcOrdTmplItmUserStatus", getSrvcOrdTmplItmUserStatus());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ServiceOrderTemplate", getServiceOrderTemplate());
        values.put("ServiceOrderTemplateItem", getServiceOrderTemplateItem());
        values.put("SrvcOrdTmplItmUserStatus", getSrvcOrdTmplItmUserStatus());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ServiceOrderTemplate") ) {
                final Object value = values.remove("ServiceOrderTemplate");
                if( (value == null) || (!value.equals(getServiceOrderTemplate())) ) {
                    setServiceOrderTemplate(((String) value));
                }
            }
            if( values.containsKey("ServiceOrderTemplateItem") ) {
                final Object value = values.remove("ServiceOrderTemplateItem");
                if( (value == null) || (!value.equals(getServiceOrderTemplateItem())) ) {
                    setServiceOrderTemplateItem(((String) value));
                }
            }
            if( values.containsKey("SrvcOrdTmplItmUserStatus") ) {
                final Object value = values.remove("SrvcOrdTmplItmUserStatus");
                if( (value == null) || (!value.equals(getSrvcOrdTmplItmUserStatus())) ) {
                    setSrvcOrdTmplItmUserStatus(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> SrvcOrdTmplItemUserStatusField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SrvcOrdTmplItemUserStatusField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SrvcOrdTmplItemUserStatusField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SrvcOrdTmplItemUserStatusField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ServiceOrderTemplateService.DEFAULT_SERVICE_PATH);
    }

}
